;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM06_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   dealloc_pages                                           ;
;                                                                             ;
;      DESCRIPTION:   This function deallocates the logical pages currently   ;
;                     allocated to an EMM handle.  Only after the application ;
;                     deallocates these pages can other applications use      ;
;                     them.  When a handle is deallocated, its name is set to ;
;                     all ASCII nulls (binary zeros).                         ;
;                                                                             ;
;                     Note:                                                   ;
;                     A program must perform this function before it exits to ;
;                     DOS.  If it doesn't, no other programs can use these    ;
;                     pages or the EMM handle.  This means that a program     ;
;                     using expanded memory should trap critical errors and   ;
;                     control-break if there is a chance that the program     ;
;                     will have allocated pages when either of these events   ;
;                     occur.                                                  ;
;                                                                             ;
;           PASSED:   handle:                                                 ;
;                        is an open EMM handle.                               ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = dealloc_pages (handle);                        ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

dealloc_pages		PROC	handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   dealloc all pages allocated to the specified handle;          ;
	;---------------------------------------------------------------------;
	MOVE		AH, dealloc_fcn
	MOVE		DX, handle
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

dealloc_pages		ENDP

END
