;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM14_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_all_handles_pages                                   ;
;                                                                             ;
;      DESCRIPTION:   This function returns an array of structures that       ;
;                     contain open EMM handles and the number of pages        ;
;                     allocated to each one.                                  ;
;                                                                             ;
;           PASSED:   &hp_count:                                              ;
;                        is a far pointer to the number of open EMM handles.  ;
;                                                                             ;
;                     hp:                                                     ;
;                        is a far pointer to an array of structures that      ;
;                        will contain all open EMM handles and the number of  ;
;                        pages allocated to each.                             ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     hp_count:                                               ;
;                        is the number of open EMM handles (including the     ;
;                        operating system handle [0]).  hp_count cannot be    ;
;                        zero because the operating system handle is always   ;
;                        active and cannot be deallocated.  hp_count will     ;
;                        not exceed 255.                                      ;
;                                                                             ;
;                     hp:                                                     ;
;                        is an array of structures containing all open EMM    ;
;                        handles and the number of pages allocated to each.   ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        hp.handle:                                           ;
;                           is the open EMM handle.  The values of the        ;
;                           handles this function returns will be in the      ;
;                           range of 0 to 255 decimal.                        ;
;                                                                             ;
;                        hp.pages_allocated:                                  ;
;                           is the number of pages allocated to the open      ;
;                           EMM handle.                                       ;
;                                                                             ;
; C USE CONVENTION:   unsigned int         status;                            ;
;                     unsigned int         hp_count;                          ;
;                     HANDLES_PAGES_STRUCT hp[MAX_HANDLES];                   ;
;                                                                             ;
;                     status = get_all_handles_pages (&hp_count,              ;
;                                                     hp);                    ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_all_handles_pages	PROC                                                  \
			USES DI,                                              \
                        ptr_handles_pages_count:FAR PTR WORD,                     \
			ptr_handles_pages:FAR PTR BYTE                            

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get a structure of all active handles and the pages           ;
	;   .   allocated to each handle;                                     ;
	;---------------------------------------------------------------------;
	MOVE		AH, get_all_handle_pages_fcn
	MOVE		ES:DI, ptr_handles_pages
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the number of structure entries back to the caller;      ;
	;---------------------------------------------------------------------;
	MOVE		DX, BX
	MOVE		ES:BX, ptr_handles_pages_count
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_all_handles_pages	ENDP

END
