
#include   <edutils.h>
#include   <io.h>
#include   <conio.h>

typedef struct CUST_INFO
{
    char last_name [21];
    char middle_initial [2];
    char first_name [21];
    char address_1 [26];
    char address_2 [26];
    char city [21];
    char state [3];
    char zip_code [10];
} CUST_INFO;

  /* INTERNAL Variables */
ED_PARMS   parms;
char       filename [100];
CUST_INFO  customer;


void main (void)
{
    char  CH;

    printf ("\n");
    printf ("PANEL Version 1.0\n");
    printf ("(c) Copyright 1994  Kenneth J. Macke\n");
    printf ("\n");
    printf ("Press any key to continue...\n");
    CH = getch ();
    if (CH == 0)
        CH = getch ();

    clrscr ();
    textcolor (WHITE);
    textbackground (BLUE);
    window (10, 5, 70, 20);
    clrscr ();
    window (5, 22, 75, 24);
    clrscr ();
    window (1, 1, 80, 25);
    gotoxy (7, 23);
    cprintf ("Use UP, DOWN, TAB, & ENTER to select fields. ESC when done.");

    memset (&customer, 0, sizeof (customer));

    gotoxy (12, 6);
    cprintf ("Last Name");
    gotoxy (34, 6);
    cprintf ("MI");
    gotoxy (37, 6);
    cprintf ("First Name");

    gotoxy (12, 9);
    cprintf ("Address:");
    gotoxy (12, 11);
    cprintf ("City:");
    gotoxy (43, 11);
    cprintf ("State:");
    gotoxy (12, 12);
    cprintf ("Zip:");

        /*  Example of Defaulting strings to be edited  */
    strcpy (customer.state, "OH");
    strcpy (customer.zip_code, "          ");

    textbackground (BROWN);
    textcolor (YELLOW);

        /*  Display the field edit windows and defaults  */
    ed_display_string_xy (12, 7,  customer.last_name, 21, 20);
    ed_display_string_xy (34, 7,  customer.middle_initial, 2, 1);
    ed_display_string_xy (37, 7,  customer.first_name, 21, 20);
    ed_display_string_xy (21, 9,  customer.address_1, 26, 25);
    ed_display_string_xy (21, 10, customer.address_2, 26, 25);
    ed_display_string_xy (21, 11, customer.city, 21, 20);
    ed_display_string_xy (50, 11, customer.state, 3, 2);
    ed_display_string_xy (21, 12, customer.zip_code, 10, 9);

       /*  Perform editing on the specified fields  */
edit_last_name:
    ed_edit_string_xy (12, 7,  customer.last_name, 21, 20);
    if (ed_results.last_char_extended == UP)   goto edit_last_name;
    if (ed_results.last_char_extended == DOWN) goto edit_address_1;
    if (ed_results.last_char == ESC)           goto done;
edit_middle_initial:
    ed_edit_string_xy (34, 7,  customer.middle_initial, 2, 1);
    if (ed_results.last_char_extended == UP)   goto edit_middle_initial;
    if (ed_results.last_char_extended == DOWN) goto edit_address_1;
    if (ed_results.last_char == ESC)           goto done;
edit_first_name:
    ed_edit_string_xy (37, 7,  customer.first_name, 21, 20);
    if (ed_results.last_char_extended == UP)   goto edit_first_name;
    if (ed_results.last_char == ESC)           goto done;

edit_address_1:
    ed_edit_string_xy (21, 9,  customer.address_1, 26, 25);
    if (ed_results.last_char_extended == UP)   goto edit_last_name;
    if (ed_results.last_char == ESC)           goto done;

edit_address_2:
    ed_edit_string_xy (21, 10, customer.address_2, 26, 25);
    if (ed_results.last_char_extended == UP)   goto edit_address_1;
    if (ed_results.last_char == ESC)           goto done;

edit_city:
    ed_edit_string_xy (21, 11, customer.city, 21, 20);
    if (ed_results.last_char_extended == UP)   goto edit_address_2;
    if (ed_results.last_char_extended == DOWN) goto edit_zip_code;
    if (ed_results.last_char == ESC)           goto done;

edit_state:
    ed_edit_string_xy (50, 11, customer.state, 3, 2);
    if (ed_results.last_char_extended == UP)   goto edit_address_2;
    if (ed_results.last_char == ESC)           goto done;

edit_zip_code:
    ed_edit_string_xy (21, 12, customer.zip_code, 10, 9);
    if (ed_results.last_char_extended == UP)   goto edit_city;
    if (ed_results.last_char_extended == DOWN) goto edit_zip_code;
    if (ed_results.last_char == TAB_KEY)       goto edit_last_name;
    if (ed_results.last_char == ENTER_KEY)     goto edit_last_name;

done:
    textcolor (LIGHTGRAY);
    textbackground (BLACK);
    clrscr ();
    printf ("Name    = '%s %s %s'\n", customer.first_name, customer.middle_initial, customer.last_name);
    printf ("Address = '%s'\n", customer.address_1);
    printf ("          '%s'\n", customer.address_2);
    printf ("          '%s, %s  %s'\n", customer.city, customer.state, customer.zip_code);


}  /* main */
