/*
** ED-UTILS Editor Utilities
** (c) Copyright 1994  Kenneth J. Macke
**
** For information write:
**
** Kenneth J. Macke
** P.O. Box 11313
** Cincinnati, OH  45211
*/

#ifndef  EDITOR_SYMBOLS

    #define  EDITOR_SYMBOLS

       /*  Status Type Definitions (Parameters for displaying status)  */
    #define  STATUS_NONE        0
    #define  STATUS_COL         1
    #define  STATUS_LINE        2
    #define  STATUS_ALL         3

       /*  File Load Type Definitions (Parameters for initializing the edit buffer  */
    #define  LOAD_NONE          0     // Do not initalize the edit buffer
    #define  LOAD_ARRAY         1     // Fill the edit buffer with the contents of the passed array
    #define  LOAD_FILE          2     // Fill the edit buffer with the contents of the specified file
    #define  LOAD_BOTH          3     // Load the file if specified, otherwise, load the array

       /*  File Save Type Definitions (Parameters for storing the edit buffer  */
    #define  SAVE_NONE          0     // Do not automatically save the edit buffer
    #define  SAVE_ARRAY         1     // Store the edit buffer in the passed array when done editing
    #define  SAVE_FILE          2     // Store the edit buffer in the specified file
    #define  SAVE_BOTH          3     // Store the edit buffer in the passed array AND the specified file

       /*  Function Type Definitions  */
    #define  FN_INVALID         0
    #define  FN_REGULAR         1
    #define  FN_QUIT            2
    #define  FN_BACKSPACE       3

    #define  FN_LEFT            4
    #define  FN_RIGHT           5
    #define  FN_UP              6
    #define  FN_DOWN            7

    #define  FN_PAGE_UP         8
    #define  FN_PAGE_DOWN       9

    #define  FN_START_OF_LINE   10
    #define  FN_END_OF_LINE     11
    #define  FN_DELETE_CHAR     12
    #define  FN_NEW_LINE_AFTER  13     /* Insert new line after current line */
    #define  FN_NEW_LINE_BEFORE 14     /* Insert new line before current line */

    #define  FN_DELETE_LINE     15

    #define  FN_SAVE_FILE       16
    #define  FN_LOAD_FILE       17
    #define  FN_SAVE_AND_QUIT   18

    #define  FN_INSERT_MODE     19

    #define  FN_MARK_LINES      20
    #define  FN_UNMARK_LINES    21
    #define  FN_COPY_LINES      22
    #define  FN_MOVE_LINES      23
    #define  FN_DELETE_LINES    24

    #define  MODE_OVERTYPE      0      /*  Characters overwrite existing chars */
    #define  MODE_INSERT        1      /*  Characters inserted in the line  */

    #define  CURSOR_LINE        0      /*  Defines the cursor as a line  */
    #define  CURSOR_BLOCK       1      /*  Defines the cursor as a block  */

    #define  BELL     7                /*  ASCII code for BELL signal to console  */

    typedef struct
    {
        int    max_num_lines;           /*  Max Num lines for this buffer  */
        int    min_num_lines;           /*  Min Num lines for this buffer  */
        int    max_line_length;         /*  Max Length of each line in the buffer  */
        int    screen_top;
        int    screen_bottom;
        int    screen_left;
        int    screen_right;
        int    editing_background;      /*  Editing Window Background Color  */
        int    editing_foreground;      /*  Editing Window Foreground Color  */
        int    highlight_background;    /*  Background Color for highlighted text  */
        int    highlight_foreground;    /*  Foreground Color for highlighted text  */
        int    overtype_cursor;         /*  CURSOR_LINE or CURSOR_BLOCK  */
        int    insert_cursor;           /*  CURSOR_LINE or CURSOR_BLOCK  */
        int    wrap_line;               /*  TRUE-words wrap to next line  */
        int    remove_ending_spaces;    /*  TRUE-Spaces removed from ends of lines  */
        int    remove_ending_chars;     /*  TRUE-Chars removed at end if others inserted in middle of line  */

        int    status_allowed;          /*  TRUE-Status will be displayed  */
        int    status_x;                /*  X position of status on screen */
        int    status_y;                /*  Y position of status on screen */
        int    status_type;             /*  STATUS_ALL, STATUS_COL, STATUS_LINE, or STATUS_NONE  */

        int    message_allowed;         /*  TRUE-Message will be displayed in position  */
        int    message_x;               /*  X position of message on screen  */
        int    message_y;               /*  Y position of message on screen  */
        int    message_max_len;         /*  Maximum length of message to be displayed  */

        int    error_on_borders;        /*  TRUE-Displays error msgs at top and bottom of files */
        int    load_automatically;      /*  LOAD_NONE, LOAD_ARRAY, LOAD_FILE, LOAD_BOTH */
        int    save_automatically;      /*  SAVE_NONE, SAVE_ARRAY, SAVE_FILE, SAVE_BOTH */
        int    restore_window;          /*  TRUE-Edit window will be replaced with previous contents on exit  */

        int    vertical_scrolling;      /*  TRUE-Page Up & Down will be active  */
        int    editing_allowed;         /*  TRUE-user will be allowed to modify buffer */
        int    exit_after_display;      /*  TRUE-Function will exit right after window is displayed  */
        char   default_filename [50];   /*  Default File to load if no file specified  */
        char   char_types [256];        /*  Regular Character Types  */
        char   esc_char_types [256];    /*  Escape Character Types   */
    } ED_PARMS;

    typedef struct
    {
        int   num_lines;
        int   cur_line;
        int   line_offset;
        int   num_bytes;
        int   mode;
        int   x;
        int   y;
        int   offset;
        int   pos;
        char  filename [100];        // The name of the file which was edited
        int   rc;                    // Return Code of the last operation.  TRUE = Success, FALSE = Failure
        char  last_char;
        char  last_char_extended;
        char  last_function;
        char  term_reason [100];     // String indicating reason for last termination
        char  last_message [81];     // Last Message that would have been displayed by 'print_message'
    } ED_RESULTS;

#endif



#ifndef  KEY_SYMBOLS

    #define   KEY_SYMBOLS

    #define   FALSE  0
    #define   TRUE   1

    #define   F1         59
    #define   SHIFT_F1   84
    #define   CTRL_F1    94
    #define   ALT_F1     104

    #define   F2         60
    #define   SHIFT_F2   85
    #define   CTRL_F2    95
    #define   ALT_F2     105

    #define   F3         61
    #define   SHIFT_F3   86
    #define   CTRL_F3    96
    #define   ALT_F3     106

    #define   F4         62
    #define   SHIFT_F4   87
    #define   CTRL_F4    97
    #define   ALT_F4     107

    #define   F5         63
    #define   SHIFT_F5   88
    #define   CTRL_F5    98
    #define   ALT_F5     108

    #define   F6         64
    #define   SHIFT_F6   89
    #define   CTRL_F6    99
    #define   ALT_F6     109

    #define   F7         65
    #define   SHIFT_F7   90
    #define   CTRL_F7    100
    #define   ALT_F7     110

    #define   F8         66
    #define   SHIFT_F8   91
    #define   CTRL_F8    101
    #define   ALT_F8     111

    #define   F9         67
    #define   SHIFT_F9   92
    #define   CTRL_F9    102
    #define   ALT_F9     112

    #define   F10        68
    #define   SHIFT_F10  93
    #define   CTRL_F10   103
    #define   ALT_F10    113

    #define   INSERT_KEY  82
    #define   DELETE      83
    #define   PAGE_UP     73
    #define   PAGE_DOWN   81

    #define   LEFT        75
    #define   RIGHT       77
    #define   UP          72
    #define   DOWN        80

    #define   HOME        71
    #define   END_KEY     79
    #define   ESC         27
    #define   ENTER_KEY   13
    #define   BACKSPACE   8
    #define   TAB_KEY     9

    #define   SMALLEST    32
    #define   LARGEST     126

    #define   ALT_KEY     0x08
    #define   CTRL_KEY    0x04
    #define   SHIFT_KEYS  0x03

    #define   ALT_A       30
    #define   ALT_S       31
    #define   ALT_D       32
    #define   ALT_F       33

    #define   ALT_G       34
    #define   ALT_H       35

    #define   ALT_J       36
    #define   ALT_K       37
    #define   ALT_L       38

#endif



#ifndef  ED_FUNCTIONS

    #define   ED_FUNCTIONS

      /*  ED-UTILS External Functions  */
    extern int    ed_display_string (char * str, int screen_len, int max_len);
    extern int    ed_display_string_xy (int x, int y, char * str, int screen_len, int max_len);
    extern int    ed_edit_file_field (ED_PARMS * inparms, char * filename);
    extern int    ed_edit_string (char * str, int screen_len, int max_len);
    extern int    ed_edit_string_xy (int x, int y, char * str, int screen_len, int max_len);
    extern int    ed_edit_text_field (ED_PARMS * inparms, void * store_lines, int max_lines, int max_chars);
    extern int    ed_editor (ED_PARMS * inparms, char * filename, void * store_lines, int max_lines, int max_chars);
    extern void   ed_set_default_parameters (ED_PARMS * inparms);

    extern ED_RESULTS ed_results;

#endif

