#pragma inline
#include "econ.h"
extern unsigned ec_init;
extern unsigned char ec_attr[][8];
int ecputs(char *string)
   {
   unsigned char lattr;
   unsigned char mode;
   unsigned char page;
   unsigned char last_char;
   if (!ec_init)
      ecinit();
   if (*string == '\0')
      return('\0');
   asm	mov ah,0fh;		      /*request video mode	      */
   asm	int 010h;		      /*bios video interrupt	      */
   asm	mov mode,al;		      /*save mode		      */
   asm	mov page,bh;		      /*save page		      */
   lattr = ec_attr[mode][page];
#if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
   asm	push ds;		      /*save ds on stack	      */
   asm	lds si,string;		      /*DS:SI points to String	      */
#else
   asm	mov si,string;		      /*DS:SI points to String	      */
#endif
   switch (mode) {
   /*******************************************************************/
   /*								      */
   /*	40 column - CGA adapter 				      */
   /*								      */
   /*******************************************************************/
   case 0:			      /*B&W 40x25		      */
   case 1:			      /*Color 40x25		      */
      asm  mov ah,3;		      /*request row and column	      */
      asm  mov bh,page; 	      /*retieve page		      */
      asm  int 010h;		      /*bios video interrupt	      */
      asm  mov al,dh;		      /*AL=row			      */
      asm  mov ah,40;		      /*AH=row size		      */
      asm  mul ah;		      /*AX=row offset		      */
      asm  xor dh,dh;		      /*DX=column		      */
      asm  add ax,dx;		      /*AX=(row offset) + column      */
      asm  shl ax,1;		      /*AX=((row offset) + column) * 2*/
      asm  mov di,ax;		      /*DI=AX			      */
      asm  mov al,bh;		      /*AL=page 		      */
      asm  mov ah,128;		      /*AH=(page size)/16	      */
      asm  mul ah;		      /*AX=(page offset)/16	      */
      asm  mov dx,0b800h;	      /*DX=cga adapter base	      */
      asm  add ax,dx;		      /*AX=page base		      */
      asm  mov es,ax;		      /*ES=AX			      */
      asm  mov ah,lattr;	      /*AH=attribute		      */
   cga40a:
      asm  lodsb;		      /*load next char into al	      */
      asm  or al,al;		      /*test for null character       */
      asm  jne cga40b;		      /*not null		      */
      asm  jmp cga40k;		      /*null so all done	      */
   cga40b:
      asm  cmp al,0dh;		      /*carriage return?	      */
      asm  jg cga40i;		      /*too big for control character */
      asm  jne cga40c;		      /*not a cr		      */
      asm  push ax;		      /*save video attribute	      */
      asm  mov ax,di;		      /*get current screen offset     */
      asm  xor dx,dx;		      /*zero out DX		      */
      asm  mov bx,80;		      /*line length in bytes	      */
      asm  div bx;		      /*DX=offset into line in bytes  */
      asm  sub di,dx;		      /*DI=offset to beginning of line*/
      asm  pop ax;		      /*restore video attribute       */
      asm  jmp short cga40a;	      /*get next character	      */
   cga40c:
      asm  cmp al,0ch;		      /*form feed?		      */
      asm  jne cga40d;		      /*not a ff		      */
      asm  mov al,020h; 	      /*' ' to store		      */
      asm  xor di,di;		      /*beginning of screen	      */
      asm  mov cx,1000; 	      /*number words to store	      */
      asm  rep stosw;		      /*store the words 	      */
      asm  xor di,di;		      /*beginning of screen	      */
      asm  jmp short cga40a;	      /*get next character	      */
   cga40d:
      asm  cmp al,0ah;		      /*line feed?		      */
      asm  jne cga40e;		      /*not a lf		      */
      asm  add di,80;		      /*jump one line		      */
      asm  jmp short cga40j;	      /*go check if end of page       */
   cga40e:
      asm  cmp al,09h;		      /*horizontal tab? 	      */
      asm  jne cga40f;		      /*not a lf		      */
      asm  push ax;		      /*save video attribute	      */
      asm  mov ax,di;		      /*AX=((row * 40) + column) * 2  */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,16;		      /*BX=tab size		      */
      asm  div bx;		      /*DX=modulus		      */
      asm  sub bx,dx;		      /*BX=tab jump		      */
      asm  add di,bx;		      /*DI=screen offset incl tab     */
      asm  pop ax;		      /*restore video attribute       */
      asm  jmp short cga40j;	      /*go check if end of page       */
   cga40f:
      asm  cmp al,08h;		      /*backspace?		      */
      asm  jne cga40i;		      /*not a BS		      */
      asm  or di,di;		      /*beginning of page?	      */
      asm  je cga40a;		      /*yes:ignore request	      */
      asm  sub di,2;		      /*decrement one space	      */
      asm  mov al,020h; 	      /*prepare to blank	      */
      asm  mov es:[di],ax;	      /*store new video word	      */
      asm  jmp short cga40a;	      /*get next character	      */
   cga40i:
      asm  stosw;		      /*store icon and attribute      */
   cga40j:
      asm  cmp di,2000; 	      /*end of screen?		      */
      asm  jl cga40a;		      /*no:get next character	      */
      /* scroll the screen 1 line */
      asm  push di;		      /*save screen offset	      */
      asm  push si;		      /*save string offset	      */
      asm  push ds;		      /*save string base	      */
      asm  push ax;		      /*save video attribute	      */
      asm  mov si,80;		      /*point si to line 1	      */
      asm  xor di,di;		      /*point di to line 0	      */
      asm  mov ax,es;		      /*move es...		      */
      asm  mov ds,ax;		      /*...to ds		      */
      asm  mov cx,960;		      /*prepare to move 24 lines      */
      asm  rep movsw;		      /*execute the move	      */
      asm  mov al,020h; 	      /*load ' ' for last line	      */
      asm  mov ah,lattr;	      /*load attribute for last line  */
      asm  mov cx,40;		      /*prepare to blank last line    */
      asm  rep stosw;		      /*execute blank		      */
      asm  pop ax;		      /*restore video attribute       */
      asm  pop ds;		      /*restore string base	      */
      asm  pop si;		      /*restore string offset	      */
      asm  pop di;		      /*restore screen offset	      */
      asm  sub di,80;		      /*move up one line on screen    */
      asm  jmp cga40a;		      /*resume writing to screen      */
   cga40k:
      asm  mov ax,di;		      /*AX=((row * 40) + column) * 2  */
      asm  shr ax,1;		      /*AX=(row * 40) + column	      */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,40;		      /*BX=row size		      */
      asm  div bx;		      /*AX=row,DX=column	      */
      asm  mov dh,al;		      /*DH=row,DL=column	      */
      asm  mov bh,page; 	      /*retrieve video page	      */
      asm  mov ah,02h;		      /*set cursor position	      */
      asm  int 010h;		      /*video bios interrupt	      */
      break;
   /*******************************************************************/
   /*								      */
   /*	80 column - CGA adapter 				      */
   /*								      */
   /*******************************************************************/
   case 2:			      /*B&W 80x25		      */
   case 3:			      /*Color 80x25		      */
      asm  mov ah,3;		      /*request row and column	      */
      asm  mov bh,page; 	      /*retieve page		      */
      asm  int 010h;		      /*bios video interrupt	      */
      asm  mov al,dh;		      /*AL=row			      */
      asm  mov ah,80;		      /*AH=row size		      */
      asm  mul ah;		      /*AX=row offset		      */
      asm  xor dh,dh;		      /*DX=column		      */
      asm  add ax,dx;		      /*AX=(row offset) + column      */
      asm  shl ax,1;		      /*AX=((row offset) + column) * 2*/
      asm  mov di,ax;		      /*DI=AX			      */
      asm  mov al,bh;		      /*AL=page 		      */
      asm  xor ah,ah;		      /*AX=page 		      */
      asm  mov bx,256;		      /*BX=(page size)/16	      */
      asm  mul bx;		      /*BX=(page offset)/16	      */
      asm  mov dx,0b800h;	      /*DX=cga adapter base	      */
      asm  add ax,dx;		      /*AX=page base		      */
      asm  mov es,ax;		      /*ES=AX			      */
      asm  mov ah,lattr;	      /*AH=attribute		      */
      asm  mov dx,03dah;	      /*6845 status port	      */
   cga80a:
      asm  lodsb;		      /*load next char into al	      */
      asm  or al,al;		      /*null?			      */
      asm  jne cga80b;		      /*no:continue processing	      */
      asm  jmp cga80ee; 	      /*yes:go to end of routine      */
   cga80b:
      asm  cmp al,0dh;		      /*carriage return?	      */
      asm  jng cga80c;		      /*possible control character    */
      asm  jmp cga80q;		      /*too big for control character */
   cga80c:
      asm  jne cga80d;		      /*not a cr		      */
      asm  push ax;		      /*save video attribute	      */
      asm  push dx;		      /*save video port 	      */
      asm  mov ax,di;		      /*get current screen offset     */
      asm  xor dx,dx;		      /*zero out DX		      */
      asm  mov bx,160;		      /*line length in bytes	      */
      asm  div bx;		      /*DX=offset into line in bytes  */
      asm  sub di,dx;		      /*DI=offset to beginning of line*/
      asm  pop dx;		      /*restore video port	      */
      asm  pop ax;		      /*restore video attribute       */
      asm  jmp short cga80a;	      /*get next character	      */
   cga80d:
      asm  cmp al,0ch;		      /*form feed?		      */
      asm  jne cga80i;		      /*not a ff		      */
      asm  mov al,020h; 	      /*blanking icon		      */
      asm  xor di,di;		      /*move to beginning of screen   */
      asm  mov cx,ax;		      /*store video word in CX	      */
   cga80e:
      asm  cli; 		      /*no interrupts		      */
   cga80f:
      asm  in al,dx;		      /*get 6845 status 	      */
      asm  test al,8;		      /*vertical retrace?	      */
      asm  jnz cga80h;		      /*long wait-access ok	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jc cga80f;		      /*short wait-wait it out	      */
   cga80g:
      asm  in al,dx;		      /*get 6845 status again	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jnc cga80g;		      /*wait for retrace	      */
   cga80h:
      asm  mov ax,cx;		      /*move word back to AX..	      */
      asm  stosw;		      /*and then to screen	      */
      asm  sti; 		      /*allow interrupts	      */
      asm  cmp di,4000; 	      /*end of screen?		      */
      asm  jl cga80e;		      /*no - go store next character  */
      asm  xor di,di;		      /*move to beginning of screen   */
      asm  jmp short cga80a;	      /*get next character	      */
   cga80i:
      asm  cmp al,0ah;		      /*line feed?		      */
      asm  jne cga80j;		      /*not a LF		      */
      asm  add di,160;		      /*move down one line	      */
      asm  jmp short cga80u;	      /*go check for end of page      */
   cga80j:
      asm  cmp al,09h;		      /*horizontal tab? 	      */
      asm  jne cga80k;		      /*not a HT		      */
      asm  push ax;		      /*save video attribute	      */
      asm  push dx;		      /*save video port 	      */
      asm  mov ax,di;		      /*AX=((row * 80) + column) * 2  */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,16;		      /*BX=tab size		      */
      asm  div bx;		      /*DX=modulus		      */
      asm  sub bx,dx;		      /*BX=tab jump		      */
      asm  add di,bx;		      /*DI=screen offset incl tab     */
      asm  pop dx;		      /*restore video port	      */
      asm  pop ax;		      /*restore video attribute       */
      asm  jmp short cga80u;	      /*go check for end of screen    */
   cga80k:
      asm  cmp al,08h;		      /*backspace?		      */
      asm  jne cga80q;		      /*not a BS		      */
      asm  or di,di;		      /*beginning of screen?	      */
      asm  je cga80a;		      /*yes:ignore request	      */
      asm  sub di,2;		      /*no:decrement screen pointer   */
      asm  mov al,020h; 	      /*prepare to blank	      */
      asm  mov cx,ax;		      /*store video word in CX	      */
      asm  cli; 		      /*no interrupts		      */
   cga80n:
      asm  in al,dx;		      /*get 6845 status 	      */
      asm  test al,8;		      /*vertical retrace?	      */
      asm  jnz cga80p;		      /*long wait-access ok	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jc cga80n;		      /*short wait-wait it out	      */
   cga80o:
      asm  in al,dx;		      /*get 6845 status again	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jnc cga80o;		      /*wait for retrace	      */
   cga80p:
      asm  mov ax,cx;		      /*move word back to AX..	      */
      asm  mov es:[di],ax;	      /*store new video word	      */
      asm  sti; 		      /*allow interrupts	      */
      asm  jmp cga80a;		      /*get next character	      */
   cga80q:
      asm  mov cx,ax;		      /*store video word in CX	      */
      asm  cli; 		      /*no interrupts		      */
   cga80r:
      asm  in al,dx;		      /*get 6845 status 	      */
      asm  test al,8;		      /*vertical retrace?	      */
      asm  jnz cga80t;		      /*long wait-access ok	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jc cga80r;		      /*short wait-wait it out	      */
   cga80s:
      asm  in al,dx;		      /*get 6845 status again	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jnc cga80s;		      /*wait for retrace	      */
   cga80t:
      asm  mov ax,cx;		      /*move word back to AX..	      */
      asm  stosw;		      /*and then to screen	      */
      asm  sti; 		      /*allow interrupts	      */
   cga80u:
      asm  cmp di,4000; 	      /*end of screen?		      */
      asm  jnl cga80v;		      /*yes:scroll		      */
      asm  jmp cga80a;		      /*get next character	      */
      /* scroll the screen 1 line */
   cga80v:
      asm  push di;		      /*save screen offset	      */
      asm  push si;		      /*save string offset	      */
      asm  push ds;		      /*save string base	      */
      asm  push ax;		      /*save video attribute	      */
      asm  mov si,160;		      /*point si to line 1	      */
      asm  xor di,di;		      /*point di to line 0	      */
      asm  mov ax,es;		      /*move es...		      */
      asm  mov ds,ax;		      /*...to ds		      */
   cga80w:
      asm  cli; 		      /*no interrupts		      */
   cga80x:
      asm  in al,dx;		      /*get 6845 status 	      */
      asm  test al,8;		      /*vertical retrace?	      */
      asm  jnz cga80z;		      /*long wait-access ok	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jc cga80x;		      /*short wait-wait it out	      */
   cga80y:
      asm  in al,dx;		      /*get 6845 status again	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jc cga80y;		      /*wait for retrace	      */
   cga80z:
      asm  movsw;
      asm  sti; 		      /*allow interrupts	      */
      asm  cmp si,4000; 	      /*end of screen?		      */
      asm  jne cga80w;		      /*no - continue scroll	      */
      asm  mov cl,020h; 	      /*load ' ' for last line	      */
      asm  mov ch,lattr;	      /*load attr for last line       */
   cga80aa:
      asm  cli; 		      /*no interrupts		      */
   cga80bb:
      asm  in al,dx;		      /*get 6845 status 	      */
      asm  test al,8;		      /*vertical retrace?	      */
      asm  jnz cga80dd; 	      /*long wait-access ok	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jc cga80bb;		      /*short wait-wait it out	      */
   cga80cc:
      asm  in al,dx;		      /*get 6845 status again	      */
      asm  rcr al,1;		      /*horizontal retrace?	      */
      asm  jnc cga80cc; 	      /*wait for retrace	      */
   cga80dd:
      asm  mov ax,cx;		      /*get blanking word	      */
      asm  stosw;		      /*and then to screen	      */
      asm  sti; 		      /*allow interrupts	      */
      asm  cmp di,4000; 	      /*end of screen?		      */
      asm  jne cga80aa; 	      /*no - continue blanking	      */
      asm  pop ax;		      /*restore video attribute       */
      asm  pop ds;		      /*restore string base	      */
      asm  pop si;		      /*restore string offset	      */
      asm  pop di;		      /*restore screen offset	      */
      asm  sub di,160;		      /*move up one line on screen    */
      asm  jmp cga80a;		      /*resume writing to screen      */
   cga80ee:
      asm  mov ax,di;		      /*AX=((row * 80) + column) * 2  */
      asm  shr ax,1;		      /*AX=(row * 80) + column	      */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,80;		      /*BX=row size		      */
      asm  div bx;		      /*AX=row,DX=column	      */
      asm  mov dh,al;		      /*DH=row,DL=column	      */
      asm  mov bh,page; 	      /*retrieve video page	      */
      asm  mov ah,02h;		      /*set cursor position	      */
      asm  int 010h;		      /*video bios interrupt	      */
      break;
   /*******************************************************************/
   /*								      */
   /*	40 column CGA graphics					      */
   /*								      */
   /*******************************************************************/
   case 4:			      /*B&W 40x25 graphics	      */
   case 5:			      /*Color 40x25 graphics	      */
      asm  mov ah,3;		      /*request row and column	      */
      asm  mov bh,0;		      /*set page		      */
      asm  int 010h;		      /*bios video interrupt	      */
      asm  mov al,dh;		      /*AL=row			      */
      asm  mov ah,160;		      /*AH=row size		      */
      asm  mul ah;		      /*AX=row offset		      */
      asm  xor dh,dh;		      /*DX=column		      */
      asm  add ax,dx;		      /*AX=(row offset) + column      */
      asm  shl ax,1;		      /*AX=((row offset) + column) * 2*/
      asm  mov di,ax;		      /*DI=AX			      */
      asm  mov ax,0b800h;	      /*AX=cga adapter base	      */
      asm  mov es,ax;		      /*ES=AX			      */
      asm  mov al,lattr;	      /*AL=attribute		      */
      asm  and al,03h;		      /*grab two low order bits       */
      asm  mov dl,al;		      /*DL=foreground		      */
      asm  mov ax,lattr;	      /*AL=attribute		      */
      asm  shr ax,1;		      /*shift high nible....	      */
      asm  shr ax,1;
      asm  shr ax,1;
      asm  shr ax,1;		      /*....to low nible	      */
      asm  and ax,03h;		      /*grab two low order bits       */
      asm  mov dh,al;		      /*DH=background		      */
   cga320a:
      asm  xor ax,ax;		      /*AX=0			      */
      asm  lodsb;		      /*load next char into al	      */
      asm  or al,al;		      /*null?			      */
      asm  jne cga320b; 	      /*no:continue processing	      */
      asm  jmp cga320bb;	      /*yes:go to end of routine      */
   cga320b:
      asm  cmp al,0dh;		      /*carraige return?	      */
      asm  jng cga320c; 	      /*possible control chcarcter    */
      asm  jmp cga320o; 	      /*too big for control character */
   cga320c:
      asm  jne cga320d; 	      /*not a CR		      */
      asm  push dx;		      /*save video attributes	      */
      asm  mov ax,di;		      /*get current screen offset     */
      asm  xor dx,dx;		      /*zero out DX		      */
      asm  mov bx,320;		      /*line length in bytes	      */
      asm  div bx;		      /*DX=offset into line in bytes  */
      asm  sub di,dx;		      /*DI=offset to beginning of line*/
      asm  pop dx;		      /*restore video attributes      */
      asm  jmp short cga320a;	      /*get next character	      */
   cga320d:
      asm  cmp al,0ch;		      /*form feed?		      */
      asm  jne cga320g; 	      /*not a FF		      */
      asm  mov cx,8;		      /*number of dots in line	      */
   cga320e:			      /*make fill character...	      */
      asm  shl ax,1;
      asm  shl ax,1;
      asm  or al,dh;
      asm  loop cga320e;	      /*...in AX		      */
      asm  push dx;		      /*save video attributes	      */
      asm  xor bx,bx;		      /*zero out offset from page     */
      asm  mov cx,25;		      /*lines in a page 	      */
   cga320f:
      asm  push cx;		      /*save outer loop 	      */
      asm  mov di,bx;		      /*page offset		      */
      asm  mov cx,160;		      /*words in a line 	      */
      asm  rep stosw;		      /*store fill character	      */
      asm  add di,02000h;	      /*offset to second half of line */
      asm  mov cx,160;		      /*words in a line 	      */
      asm  rep stosw;		      /*store fill character	      */
      asm  add bx,320;		      /*jump to next line	      */
      asm  pop cx;		      /*pop outer loop		      */
      asm  loop cga320f;	      /*do next line		      */
      asm  pop dx;		      /*restore video attributes      */
      asm  xor di,di;		      /*go to beginning of page       */
      asm  jmp short cga320a;	      /*get next character	      */
   cga320g:
      asm  cmp al,0ah;		      /*line feed?		      */
      asm  jne cga320h; 	      /*not a LF		      */
      asm  add di,320;		      /*jump one line		      */
      asm  jmp cga320x; 	      /*go check for end of page      */
   cga320h:
      asm  cmp al,09h;		      /*horizontal tab? 	      */
      asm  jne cga320i; 	      /*not a HT		      */
      asm  push dx;		      /*save video attributes	      */
      asm  mov ax,di;		      /*AX=((row * 160) + column) * 2 */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,16;		      /*BX=tab size in bytes	      */
      asm  div bx;		      /*DX=modulus		      */
      asm  sub bx,dx;		      /*BX=tab jump		      */
      asm  add di,bx;		      /*DI=screen offset incl tab     */
      asm  pop dx;		      /*restore video attribute       */
      asm  jmp cga320w; 	      /*go check for end of line      */
   cga320i:
      asm  cmp al,08h;		      /*backspace?		      */
      asm  jne cga320o; 	      /*not a BS		      */
      asm  or di,di;		      /*beginning of screen?	      */
      asm  je cga320a;		      /*yes:ignore request	      */
      asm  push dx;		      /*save video attributes	      */
      asm  mov ax,di;		      /*AX=(row * 320) + (column * 2) */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,320;		      /*BX=line size in bytes	      */
      asm  div bx;		      /*DX=(column * 2) 	      */
      asm  mov ax,dx;		      /*AX=(column * 2) 	      */
      asm  pop dx;		      /*restore video attribute       */
      asm  or ax,ax;		      /*beginning of line?	      */
      asm  je cga320k;		      /*yes:jump to end of last line  */
      asm  sub di,2;		      /*decrement one space	      */
      asm  jmp short cga320l;	      /*go blank out icon	      */
   cga320k:
      asm  sub di,242;		      /*decrement to end of last line */
   cga320l:
      asm  mov cx,8;		      /*number of dots in icon	      */
   cga320m:			      /*make fill character...	      */
      asm  shl ax,1;
      asm  shl ax,1;
      asm  or al,dh;
      asm  loop cga320m;	      /*...in AX		      */
      asm  mov cx,4;		      /*set outside loop duration     */
   cga320n:			      /*begin outside loop	      */
      asm  mov es:[di],ax;	      /*and then to screen	      */
      asm  add di,8192;
      asm  mov es:[di],ax;	      /*and then to screen	      */
      asm  sub di,8112;
      asm  loop cga320n;	      /*end of outside loop	      */
      asm  sub di,320;		      /*increment screen pointer      */
      asm  jmp cga320a; 	      /*get next character	      */
   cga320o:
      asm  push si;		      /*save si on stack	      */
      asm  push ds;		      /*save ds on stack	      */
      asm  mov si,ax;		      /*SI=char 		      */
      asm  shl si,1;		      /*SI=(char * 2)		      */
      asm  shl si,1;		      /*SI=(char * 4)		      */
      asm  shl si,1;		      /*SI=(char * 8)		      */
      asm  add si,0eh;		      /*SI=(char * 8) + 14	      */
      asm  mov ax,0ffa6h;
      asm  mov ds,ax;		      /*ES=pattern segment	      */
      asm  mov cx,4;		      /*set outside loop duration     */
   cga320p:			      /*begin outside loop	      */
      asm  lodsb;		      /*load next char into al	      */
      asm  mov bl,al;		      /*move pattern to BL	      */
      asm  push cx;		      /*push outside loop	      */
      asm  mov cx,8;		      /*set inside loop duration      */
   cga320q:			      /*begin inside loop	      */
      asm  shl ax,1;		      /*shift video byte left	      */
      asm  shl ax,1;		      /*shift video byte left	      */
      asm  rcl bl,1;		      /*check high order bit of ptrn  */
      asm  jnc cga320r; 	      /*if 0 use background	      */
      asm  or al,dl;		      /*use foreground color	      */
      asm  jmp short cga320s;	      /*goto end of inside loop       */
   cga320r:
      asm  or al,dh;		      /*use background color	      */
   cga320s:
      asm  loop cga320q;	      /*end of inside loop	      */
      asm  mov es:[di],ah;	      /*and then to screen	      */
      asm  mov es:[di+1],al;	      /*and then to screen	      */
      asm  add di,8192;
      asm  lodsb;		      /*load next char into al	      */
      asm  mov bl,al;		      /*move pattern to BL	      */
      asm  mov cx,8;		      /*set inside loop duration      */
   cga320t:			      /*begin inside loop	      */
      asm  shl ax,1;		      /*shift video byte left	      */
      asm  shl ax,1;		      /*shift video byte left	      */
      asm  rcl bl,1;		      /*check high order bit of ptrn  */
      asm  jnc cga320u; 	      /*if 0 use background	      */
      asm  or al,dl;		      /*use foreground color	      */
      asm  jmp short cga320v;	      /*goto end of inside loop       */
   cga320u:
      asm  or al,dh;		      /*use background color	      */
   cga320v:
      asm  loop cga320t;	      /*end of inside loop	      */
      asm  mov es:[di],ah;	      /*and then to screen	      */
      asm  mov es:[di+1],al;	      /*and then to screen	      */
      asm  sub di,8112;
      asm  pop cx;		      /*pop outside loop	      */
      asm  loop cga320p;	      /*end of outside loop	      */
      asm  sub di,318;		      /*increment screen pointer      */
      asm  pop ds;		      /*restore ds from stack	      */
      asm  pop si;		      /*restore si from stack	      */
   cga320w:
      asm  push dx;		      /*push dx onto stack	      */
      asm  mov ax,di;
      asm  xor dx,dx;
      asm  mov bx,320;
      asm  div bx;
      asm  mov ax,dx;
      asm  pop dx;
      asm  cmp ax,80;
      asm  jl cga320x;
      asm  add di,240;
   cga320x:
      asm  cmp di,8000; 	      /*end of screen?		      */
      asm  jnl cga320y; 	      /*yes:perform scroll	      */
      asm  jmp cga320a; 	      /*no:get next character	      */
   cga320y:
      /* scroll the screen 1 line */
      asm  push di;		      /*save di on stack	      */
      asm  push si;		      /*save si on stack	      */
      asm  push ds;		      /*save ds on stack	      */
      asm  mov si,320;
      asm  xor di,di;
      asm  mov ax,es;
      asm  mov ds,ax;
      asm  mov cx,24;
   cga320z:
      asm  push cx;
      asm  mov cx,160;
      asm  rep movsw;
      asm  add di,7872;
      asm  add si,7872;
      asm  mov cx,160;
      asm  rep movsw;
      asm  sub di,8192;
      asm  sub si,8192;
      asm  pop cx;
      asm  loop cga320z;
      asm  mov al,lattr;
      asm  shr al,1;
      asm  shr al,1;
      asm  shr al,1;
      asm  shr al,1;
      asm  and al,03h;
      asm  mov cx,8;
   cga320aa:
      asm  shl bx,1;
      asm  shl bx,1;
      asm  or bl,al;
      asm  loop cga320aa;
      asm  mov ax,bx;
      asm  mov cx,160;
      asm  rep stosw;
      asm  add di,7872;
      asm  mov cx,160;
      asm  rep stosw;
      asm  pop ds;		      /*restore ds from stack	      */
      asm  pop si;		      /*restore si from stack	      */
      asm  pop di;		      /*restore di from stack	      */
      asm  sub di,320;
      asm  jmp cga320a; 	      /*resume writing to screen      */
   cga320bb:
      asm  mov ax,di;		      /*AX=((row * 160) + column) * 2 */
      asm  shr ax,1;		      /*AX=(row * 160) + column       */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,160;		      /*BX=row size		      */
      asm  div bx;		      /*AX=row,DX=column	      */
      asm  mov dh,al;		      /*DH=row,DL=column	      */
      asm  mov bh,page; 	      /*retrieve video page	      */
      asm  mov ah,02h;		      /*set cursor position	      */
      asm  int 010h;		      /*video bios interrupt	      */
      break;
   /*******************************************************************/
   /*								      */
   /*	80 column CGA graphics					      */
   /*								      */
   /*******************************************************************/
   case 6:			      /*B&W 80x25 graphics	      */
      asm  mov ah,3;		      /*request row and column	      */
      asm  mov bh,0;		      /*set page		      */
      asm  int 010h;		      /*bios video interrupt	      */
      asm  mov al,dh;		      /*AL=row			      */
      asm  xor ah,ah;		      /*AX=row			      */
      asm  mov cx,dx;		      /*CH=row,CL=column	      */
      asm  mov bx,320;		      /*BX=row size		      */
      asm  mul bx;		      /*AX=row offset		      */
      asm  mov dx,cx;		      /*DH=row,DL=column	      */
      asm  xor dh,dh;		      /*DX=column		      */
      asm  add ax,dx;		      /*AX=(row offset) + column      */
      asm  mov di,ax;		      /*DI=AX			      */
      asm  mov ax,0b800h;	      /*AX=cga adapter base	      */
      asm  mov es,ax;		      /*ES=AX			      */
   cga640a:
      asm  xor ax,ax;		      /*AX=0			      */
      asm  lodsb;		      /*load next char into al	      */
      asm  or al,al;		      /*test for null character       */
      asm  jne cga640b; 	      /*no:continue		      */
      asm  jmp cga640t; 	      /*yes:go to end of routine      */
   cga640b:
      asm  cmp al,0dh;		      /*carraige return?	      */
      asm  jng cga640c; 	      /*possible control character    */
      asm  jmp cga640m; 	      /*too big for control character */
   cga640c:
      asm  jne cga640d; 	      /*not a CR		      */
      asm  mov ax,di;		      /*get current screen offset     */
      asm  xor dx,dx;		      /*zero out DX		      */
      asm  mov bx,320;		      /*line length in bytes	      */
      asm  div bx;		      /*DX=offset into line in bytes  */
      asm  sub di,dx;		      /*DI=offset to beginning of line*/
      asm  jmp short cga640a;	      /*get next character	      */
   cga640d:
      asm  cmp al,0ch;		      /*form feed?		      */
      asm  jne cga640f; 	      /*not a FF		      */
      asm  xor ax,ax;		      /*blank			      */
      asm  xor di,di;		      /*zero out offset from page     */
      asm  mov cx,25;		      /*lines in a page 	      */
   cga640e:
      asm  push cx;		      /*save outer loop 	      */
      asm  mov cx,160;		      /*words in a line 	      */
      asm  rep stosw;		      /*store fill character	      */
      asm  add di,7872; 	      /*offset to second half of line */
      asm  mov cx,160;		      /*words in a line 	      */
      asm  rep stosw;		      /*store fill character	      */
      asm  sub di,8192; 	      /*jump to next line	      */
      asm  pop cx;		      /*pop outer loop		      */
      asm  loop cga640e;	      /*do next line		      */
      asm  xor di,di;		      /*go to beginning of page       */
      asm  jmp short cga640a;	      /*get next character	      */
   cga640f:
      asm  cmp al,0ah;		      /*line feed?		      */
      asm  jne cga640g; 	      /*not a LF		      */
      asm  add di,320;		      /*jump one line		      */
      asm  jmp cga640q; 	      /*go check for end of page      */
   cga640g:
      asm  cmp al,09h;		      /*horizontal tab? 	      */
      asm  jne cga640h; 	      /*not a HT		      */
      asm  mov ax,di;		      /*AX=(row * 320) + column       */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,8;		      /*BX=tab size in bytes	      */
      asm  div bx;		      /*DX=modulus		      */
      asm  sub bx,dx;		      /*BX=tab jump		      */
      asm  add di,bx;		      /*DI=screen offset incl tab     */
      asm  jmp short cga640o;	      /*go check for end of line      */
   cga640h:
      asm  cmp al,08h;		      /*backspace?		      */
      asm  jne cga640m; 	      /*not a BS		      */
      asm  or di,di;		      /*beginning of screen?	      */
      asm  je cga640a;		      /*yes:ignore request	      */
      asm  mov ax,di;		      /*AX=(row * 320) + column       */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,320;		      /*BX=line size in bytes	      */
      asm  div bx;		      /*DX=column		      */
      asm  or dx,dx;		      /*beginning of line?	      */
      asm  je cga640j;		      /*yes:jump back to end of last  */
      asm  sub di,1;		      /*decrement one space	      */
      asm  jmp short cga640k;	      /*blnk out icon		      */
   cga640j:
      asm  sub di,241;		      /*decrement to end of last line */
   cga640k:
      asm  xor al,al;		      /*load al with blanking icon    */
      asm  mov cx,4;		      /*set loop duration	      */
   cga640l:			      /*begin loop		      */
      asm  mov es:[di],al;	      /*and then to screen	      */
      asm  add di,8192;
      asm  mov es:[di],al;	      /*and then to screen	      */
      asm  sub di,8112;
      asm  loop cga640l;	      /*end of loop		      */
      asm  sub di,320;		      /*increment screen pointer      */
      asm  jmp cga640a; 	      /*get next character	      */
   cga640m:
      asm  push si;		      /*save string offset	      */
      asm  push ds;		      /*save string base	      */
      asm  mov si,ax;		      /*SI=char 		      */
      asm  shl si,1;		      /*SI=(char * 2)		      */
      asm  shl si,1;		      /*SI=(char * 4)		      */
      asm  shl si,1;		      /*SI=(char * 8)		      */
      asm  add si,0eh;		      /*SI=(char * 8) + 14	      */
      asm  mov ax,0ffa6h;
      asm  mov ds,ax;		      /*ES=pattern segment	      */
      asm  mov cx,4;		      /*set loop duration	      */
   cga640n:			      /*begin loop		      */
      asm  lodsb;		      /*load next char into al	      */
      asm  mov es:[di],al;	      /*and then to screen	      */
      asm  add di,8192;
      asm  lodsb;		      /*load next char into al	      */
      asm  mov es:[di],al;	      /*and then to screen	      */
      asm  sub di,8112;
      asm  loop cga640n;	      /*end of loop		      */
      asm  sub di,319;		      /*increment screen pointer      */
      asm  pop ds;		      /*restore string base	      */
      asm  pop si;		      /*restore string offset	      */
   cga640o:
      asm  mov ax,di;		      /*AX=((row * 320) + column)     */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,320;		      /*BX=line length in bytes       */
      asm  div bx;		      /*DX=column		      */
      asm  cmp dx,80;		      /*end of line?		      */
      asm  je cga640p;		      /*yes:increment di	      */
      asm  jmp cga640a; 	      /*no:get next character	      */
   cga640p:
      asm  add di,240;		      /*point di to next line	      */
   cga640q:
      asm  cmp di,8000; 	      /*end of screen?		      */
      asm  jnl cga640r; 	      /*yes:scroll		      */
      asm  jmp cga640a; 	      /*no:get next character	      */
   cga640r:
      /* scroll the screen 1 line */
      asm  push di;		      /*save screen offset	      */
      asm  push si;		      /*save string offset	      */
      asm  push ds;		      /*save string base	      */
      asm  mov si,320;		      /*point si to line 1	      */
      asm  xor di,di;		      /*point di to line 0	      */
      asm  mov ax,es;		      /*move es...		      */
      asm  mov ds,ax;		      /*...to ds		      */
      asm  mov cx,24;		      /*lines to move		      */
   cga640s:			      /*beginning of loop	      */
      asm  push cx;		      /*save loop count 	      */
      asm  mov cx,160;		      /*CX=words to move	      */
      asm  rep movsw;		      /*move words		      */
      asm  add di,7872;
      asm  add si,7872;
      asm  mov cx,160;		      /*CX=words to move	      */
      asm  rep movsw;		      /*move words		      */
      asm  sub di,8192;
      asm  sub si,8192;
      asm  pop cx;		      /*restore loop count	      */
      asm  loop cga640s;	      /*end of loop		      */
      asm  xor ax,ax;		      /*AX=blanking word	      */
      asm  mov cx,160;		      /*words to blank		      */
      asm  rep stosw;		      /*blank last line 	      */
      asm  add di,7872;
      asm  mov cx,160;		      /*words to blank		      */
      asm  rep stosw;		      /*blank last line 	      */
      asm  pop ds;		      /*restore string base	      */
      asm  pop si;		      /*restore string offset	      */
      asm  pop di;		      /*restore screen offset	      */
      asm  sub di,320;		      /*decrement 1 line	      */
      asm  jmp cga640a; 	      /*get next character	      */
   cga640t:
      asm  mov ax,di;		      /*AX=(row * 320) + column       */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,320;		      /*BX=row size		      */
      asm  div bx;		      /*AX=row,DX=column	      */
      asm  mov dh,al;		      /*DH=row,DL=column	      */
      asm  mov bh,page; 	      /*retrieve video page	      */
      asm  mov ah,02h;		      /*set cursor position	      */
      asm  int 010h;		      /*video bios interrupt	      */
      break;
   /*******************************************************************/
   /*								      */
   /*	80 column - MONO adapter				      */
   /*								      */
   /*******************************************************************/
   case 7:
      asm  mov ah,3;		      /*request row and column	      */
      asm  mov bh,page; 	      /*retieve page		      */
      asm  int 010h;		      /*bios video interrupt	      */
      asm  mov al,dh;		      /*AL=row			      */
      asm  mov ah,80;		      /*AH=row size		      */
      asm  mul ah;		      /*AX=row offset		      */
      asm  xor dh,dh;		      /*DX=column		      */
      asm  add ax,dx;		      /*AX=(row offset) + column      */
      asm  shl ax,1;		      /*AX=((row offset) + column) * 2*/
      asm  mov di,ax;		      /*DI=AX			      */
      asm  mov al,bh;		      /*AL=page 		      */
      asm  xor ah,ah;		      /*AX=page 		      */
      asm  mov bx,256;		      /*BX=(page size)/16	      */
      asm  mul bx;		      /*BX=(page offset)/16	      */
      asm  mov dx,0b000h;	      /*DX=Monocrome adapter base     */
      asm  add ax,dx;		      /*AX=page base		      */
      asm  mov es,ax;		      /*ES=AX			      */
      asm  mov ah,lattr;	      /*AH=attribute		      */
   mon80a:
      asm  lodsb;		      /*load next char into al	      */
      asm  or al,al;		      /*null?			      */
      asm  jne mon80b;		      /*no:continue		      */
      asm  jmp mon80k;		      /*yes:go to end of routine      */
   mon80b:
      asm  cmp al,0dh;		      /*carriage return?	      */
      asm  jg mon80i;		      /*too big for control character */
      asm  jne mon80c;		      /*not a cr		      */
      asm  push ax;		      /*save video attribute	      */
      asm  mov ax,di;		      /*get current screen offset     */
      asm  xor dx,dx;		      /*zero out DX		      */
      asm  mov bx,160;		      /*line length in bytes	      */
      asm  div bx;		      /*DX=offset into line in bytes  */
      asm  sub di,dx;		      /*DI=offset to beginning of line*/
      asm  pop ax;		      /*restore video attribute       */
      asm  jmp short mon80a;	      /*get next character	      */
   mon80c:
      asm  cmp al,0ch;		      /*form feed?		      */
      asm  jne mon80d;		      /*not a ff		      */
      asm  mov al,020h; 	      /*blanking icon		      */
      asm  xor di,di;		      /*move to beginning of screen   */
      asm  mov cx,2000; 	      /*number of words to clear      */
      asm  rep stosw;		      /*clear screen		      */
      asm  xor di,di;		      /*move to beginning of screen   */
      asm  jmp short mon80a;	      /*get next character	      */
   mon80d:
      asm  cmp al,0ah;		      /*line feed?		      */
      asm  jne mon80e;		      /*not a LF		      */
      asm  add di,160;		      /*move down one line	      */
      asm  jmp short mon80j;	      /*go check for end of page      */
   mon80e:
      asm  cmp al,09h;		      /*horizontal tab? 	      */
      asm  jne mon80f;		      /*not a HT		      */
      asm  push ax;		      /*save video attribute	      */
      asm  mov ax,di;		      /*AX=((row * 80) + column) * 2  */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,16;		      /*BX=tab size		      */
      asm  div bx;		      /*DX=modulus		      */
      asm  sub bx,dx;		      /*BX=tab jump		      */
      asm  add di,bx;		      /*DI=screen offset incl tab     */
      asm  pop ax;		      /*restore video attribute       */
      asm  jmp short mon80j;	      /*go check for end of screen    */
   mon80f:
      asm  cmp al,08h;		      /*backspace?		      */
      asm  jne mon80i;		      /*not a BS		      */
      asm  or di,di;		      /*beginning of screen?	      */
      asm  je mon80a;		      /*yes:ignore request	      */
      asm  sub di,2;		      /*no:decrement screen pointer   */
      asm  mov es:[di],ax;	      /*store video word	      */
      asm  jmp short mon80a;	      /*get next character	      */
   mon80i:
      asm  stosw;		      /*and then to screen	      */
   mon80j:
      asm  cmp di,4000; 	      /*end of screen?		      */
      asm  jne mon80a;		      /*get next character	      */
      /* scroll the screen 1 line */
      asm  push di;		      /*save screen offset	      */
      asm  push si;		      /*save string offset	      */
      asm  push ds;		      /*save string base	      */
      asm  push ax;		      /*save video attribute	      */
      asm  mov si,160;		      /*point si to line 1	      */
      asm  xor di,di;		      /*point di to line 0	      */
      asm  mov ax,es;		      /*move es...		      */
      asm  mov ds,ax;		      /*...to ds		      */
      asm  mov cx,1920; 	      /*words to move		      */
      asm  rep movsw;		      /*move the words		      */
      asm  mov al,020h; 	      /*load ' ' for last line	      */
      asm  mov ah,lattr;	      /*load attr for last line       */
      asm  mov cx,80;		      /*words to clear		      */
      asm  rep stosw;		      /*clear the words 	      */
      asm  pop ax;		      /*restore video attribute       */
      asm  pop ds;		      /*restore string base	      */
      asm  pop si;		      /*restore string offset	      */
      asm  pop di;		      /*restore screen offset	      */
      asm  sub di,160;		      /*move up one line on screen    */
      asm  jmp mon80a;		      /*resume writing to screen      */
   mon80k:
      asm  mov ax,di;		      /*AX=((row * 80) + column) * 2  */
      asm  shr ax,1;		      /*AX=(row * 80) + column	      */
      asm  xor dx,dx;		      /*DX=0			      */
      asm  mov bx,80;		      /*BX=row size		      */
      asm  div bx;		      /*AX=row,DX=column	      */
      asm  mov dh,al;		      /*DH=row,DL=column	      */
      asm  mov bh,page; 	      /*retrieve video page	      */
      asm  mov ah,02h;		      /*set cursor position	      */
      asm  int 010h;		      /*video bios interrupt	      */
      break;
      }
   asm	mov al,ds:[si-1];	      /*get last character written... */
   asm	mov last_char,al;	      /*...and put it in last_char    */
#if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
   asm	pop ds; 		      /*retrieve ds from stack	      */
#endif
   return(last_char);
   }
