/*

	eb.cpp
	7-30-91
	Electronic Book


	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList may use and modify this
	tool for use in their programs.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233


	Notes:  The Electronic Book was coded to demonstrate
	the various uses of FlexList.


*/

#include <eb4.hpp>
#include <cmdln.hpp>
#include <pckey.hpp>


class ElectronicBook : HyperView {
public:
	ElectronicBook() : HyperView() {}
	void frontCover();
	HyperView::view;
	void backCover();
	~ElectronicBook() {}
};

void ElectronicBook::frontCover()
{
	if (forcedmonochrome)
		textattr(LIGHTGRAY+BLACK*16);
	else
		textattr(RED+CYAN*16);
	clrscr();

	cout << "\n\tEB"
		<< "\n\n\tThe Electronic Book"
		<< "\n\n\n\tA FlexList HyperText Viewer";
}

void ElectronicBook::backCover()
{
	textmode(C80);
	textattr(LIGHTGRAY+BLACK*16);
	clrscr();

cout

<< "\nCopyright 1991, John W. Small, All rights reserved"
<< "\nPSW / Power SoftWare,  P.O. Box 10072"
<< "\nMcLean, Virginia 22102 8072 USA"
<< "\nVoice: (703) 759-3838,  CIS: 73757,2233"
<< "\n"
<< "\nEB is meant to be primarily a demonstration of how easy it"
<< "\nis to use the FlexList programming tool.  This version of"
<< "\nEB.EXE is freeware, meaning that there is no fee for using"
<< "\nEB.EXE, but you must leave my copyright notice intact!"
<< "\nShareware/Freeware distributors are also free to distribute"
<< "\nit.  Commercial venders may bundle EB.EXE (unmodified) with"
<< "\ntheir software without cost but in any literature mentioning"
<< "\nit they must give proper credit to PSW!  Licensing is"
<< "\nrequired for other uses, e.g. you must register FlexList to"
<< "\nincorporate components of EB into your software.\n\n";

}


main(int argc, char *argv[])
{
	CmdLn CL(argc,argv,"mMt:T:");
	char * fname = (char *) 0;
	char * topic = (char *) 0;
	int ok = 1;

	do  {
		while (CL.getOption() != -1 && ok)
			switch (CL.optCh)  {
			case '?':
				ok = 0;
				break;
			case 'm':
			case 'M':
				forcedmonochrome = 1;
				break;
			case 't':
			case 'T':
				topic = CL.optArg;
				break;
			}
		if (CL.Argi() < argc)
			fname =  argv[CL.Argi()];
		CL.lookForMoreOptions();
	} while (CL.Argi() < argc && ok);

	if (ok)  {
		ElectronicBook EB;
		EB.frontCover();
		EB.view(fname,topic);
		EB.backCover();
	}
	else

cout
<< "\n\nusage: eb [-m] [[-ttopic] filename]"
<< "\n\n\t[-m]\t\t\toptionally force monochrome display"
<< "\n\t[[-ttopic] filename]\toptionally load hypertext file and topic"
<< "\n\n";


	PCK.fastTypeMaticOnExit();
	return 0;
}