/*

	eb4.cpp
	7-31-91
	Electronic Book


	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList may use and modify this
	tool for use in their programs.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233


	Notes:  The Electronic Book was coded to demonstrate
	the various uses of FlexList.


*/

#include <process.h>
#include <ctype.h>
#include <eb4.hpp>

#ifndef PICKFILE_HPP
#include <pickfile.hpp>
#endif




Arguments::Arguments(const char *A) : FlexList(FLstrings)
{
	int i, j, l;

	V = (char **)0;
	if (!A)
		return;
	for (i = j = 0; A[i] && i < MAX_HYPER_LINE; i = j) {
		while (isspace(A[i]))
			i++;
		for (j = i; A[j] && !isspace(A[j]); j++)
			/* null stmt */;
		if (j > i && (l = (j-i)) < MAX_ARG_LEN)  {
			strncpy(buf,&A[i],l);
			buf[l] = '\0';
			insQD(buf);
		}
	}
	V = (char **) packPtrs();
}



int HyperView::view(const char * hyperFname, const char * topic)
{
	PickFile pf;
	TargetParser tp;
	ArgumentS A;
	enum HC_ACTIONS hca;

	if (hyperFname)
		hstk.pushTarget(hyperFname,topic);
	while (1)  {
		if (!hstk.targets()) if (pf.choose
			((char *)0,FA_DIREC,".htx"))
			hstk.pushTarget(pf.choice());
		else
			return -1;
		if ((HC = hser.fetch(hstk.topTarget()))
			== HyperContexT0)  {
			hstk.popTarget();
			continue;
		}
		while (HC)  {
		hca = HC->view();
		hstk.setTopView(HC->StartColumn(),HC->StartRow(),
			HC->CursorColumn(),HC->CursorRow());
		switch (hca)  {
		case HyperContext::HELP:
			break;
		case HyperContext::LOAD:
			if (pf.choose((char *)0,FA_DIREC,".htx"))
				if (hstk.pushTarget(pf.choice()))  {
					delete TOC;
					delete IDX;
					TOC = PickTOC0;
					IDX = PickIDX0;
					delete HC;
					HC = HyperContexT0;
				}
			break;
		case HyperContext::TABLE_OF_CONTENTS:
			if (!TOC) TOC = hser.TableOfContents
				(hstk.topFname());
			if (TOC) if (TOC->choose(HC->TopicNum()))
			if (hstk.pushTarget(hstk.topFname(),
				TOC->choice())) {
				delete HC;
				HC = HyperContexT0;
			}
			break;
		case HyperContext::INDEX:
			if (!IDX) IDX = hser.Index(hstk.topFname());
			if (IDX) if (IDX->choose())
			if (hstk.pushTarget(hstk.topFname(),
				IDX->choice())) {
				delete HC;
				HC = HyperContexT0;
			}
			break;
		case HyperContext::LAUNCH:
			switch (tp.parse(HC->newTarget()))  {
			case TargetParser::UNKNOWN:
				break;
			case TargetParser::NEAR_TOPIC:
			case TargetParser::NEAR_DEFAULT:
				if (hstk.pushTarget(hstk.topFname(),
					tp.topic())) {
					delete HC;
					HC = HyperContexT0;
				}
				break;
			case TargetParser::FAR_TOPIC:
			case TargetParser::FAR_DEFAULT:
				if (hstk.pushTarget(tp.params(),
					tp.topic())) {
					delete TOC;
					delete IDX;
					TOC = PickTOC0;
					IDX = PickIDX0;
					delete HC;
					HC = HyperContexT0;
				}
				break;
			case TargetParser::FAR_SYSTEM:
				delete TOC;
				delete IDX;
				TOC = PickTOC0;
				IDX = PickIDX0;
				delete HC;
				HC = HyperContexT0;
				textattr(LIGHTGRAY+BLACK*16);
				clrscr();
				system(tp.params());
				cputs("Press any key ...");
				getch();
				break;
			case TargetParser::FAR_SPAWN:
				if ((A = new Arguments(tp.params()))
					== ArgumentS0)
					break;
				if (!A->argc())  {
					delete A;
					break;
				}
				delete TOC;
				delete IDX;
				TOC = PickTOC0;
				IDX = PickIDX0;
				delete HC;
				HC = HyperContexT0;
				textattr(LIGHTGRAY+BLACK*16);
				clrscr();
				spawnvp(P_WAIT,A->argv0(),A->argv());
				delete A;
				break;
			}
			break;
		case HyperContext::BACKUP:
			if (hstk.targets() > 1)  {
				delete TOC;
				delete IDX;
				TOC = PickTOC0;
				IDX = PickIDX0;
				delete HC;
				HC = HyperContexT0;
				hser.discard(hstk.topFname());
				hstk.popTarget();
			}
			break;
		case HyperContext::EXIT:
			delete TOC;
			delete IDX;
			TOC = PickTOC0;
			IDX = PickIDX0;
			delete HC;
			HC = HyperContexT0;
			return 0;
		} // switch (hca)
		} // while (HC)
	}  // while (1)
	return -1;
}


HyperView::~HyperView()
{
	delete HC; delete TOC; delete IDX;
	while (hstk.targets()) {
		hser.discard(hstk.topFname());
		hstk.popTarget();
	}
}
