/* ----------------------------------------------------------------------
   This is based on EXECWINDOW by Kim Kokkonen, TurboPower Software, ported
   to Turbo C. What it does is to use a routine doswdw() to keep the video
   output of a child process within a specified window on the screen.
   The technique used is to grab interrupt 21h and thus control all
   writes to the standard output and error devices.  These are rerouted
   to the screen, within the specified window.  Note that the technique
   will not work for programs that write directly to video memory,
   through the BIOS, or through some other file handle assigned to the
   console.  It does work with standard DOS commands, with the TPC.EXE
   compiler, and with other command line utilities like ARCX.COM.
   -------------------------------------------------------------------- */
#include <stdio.h>
#include <alloc.h>
#include <string.h>
#include <mem.h>
#include <conio.h>
#include <stdarg.h>

/* Note that the standard definition of getvect and setvect are altered */
void	interrupt	(* _Cdecl getvect(int interruptno)) ();
void     _Cdecl setvect (int interruptno,void far *isr);

/* For best results, these should be global variables */
void	interrupt doswdw(void);		/* DOS window routine */
void	setup21(int NumberOfRows);	/* doswdw() setup routine */
void 	far *oldint21 = NULL;		/* to save the old int 21h vector */
void 	far *newint21 = &doswdw;	/* points to doswdw() */
int	wdwpos,		/* cursor position in window */
	wdwupr,		/* top right corner */
	wdwlwr;		/* bottom left corner */
char	wdwattr;	/* desired attribute */

void far DosWdw(int xleft,int ytop,int xrite,int ybottom,int attrib,char *cmd)
{
/* set up window */
	textattr(attrib);			/* set text attribute */
	window(xleft, ytop, xrite, ybottom);	/* make the window */
	clrscr();				/* clear the window */

/* -----------------------------------------------------------------------
   Set up window parameters for doswdw(). 'wdwpos', 'wdwupr', and 'wdwlwr'
   are actually packed short unsigned integers, each comprising bytes for
   the x- and y-coordinates. See code below for order of bytes. The x- and
   y-coordinates are DECREMENTED by one to conform with the standard BIOS
   screen conventions which start from (0,0), instead of Turbo C's con-
   vention of starting at (1,1).
   ---------------------------------------------------------------------- */
	wdwpos = ((ytop - 1) * 256) + (xleft - 1);
	wdwupr = wdwpos;
	wdwlwr = ((ybottom - 1) * 256) + (xrite - 1);
	wdwattr = (attrib);

/* -----------------------------------------------------------------------
   The following is straightforward. First, we take over interrupt 21h,
   pointing it to our own doswdw(). Then we run our child process; in
   this case, we use the system() command. You can use spawn instead.
   After running, we restore the old 21h interrupt vector, to return to
   normal operations. In this example, we set NumberOfRows equal to the
   number of Rows in the WINDOW we create. This causes doswdw() to PAUSE
   (like DOS's command MORE) when we output that number of rows, and wait
   for a keystroke before continuing. If NumberOfRows is set to ZERO (0),
   then no pause occurs, and the material in the WINDOW scrolls until the
   child process is complete.
   ---------------------------------------------------------------------- */
	oldint21 = getvect(0x21);	/* save old interrupt 21h */
	setup21(ybottom-ytop);		/* move vector into CS */
	setvect(0x21,newint21);		/* point to dos window */
	system(cmd);			/* run the command */
	setvect(0x21,oldint21);		/* restore interrupt 21h */
}

main()
{
	DosWdw(5,1,45,20,0x70,"dir");	/* simple case: DIR command */
}

