/*
    TESTCLIP.C
    
    A test DOS program for the DOS/Windows Clipboard functions provided in DOSCLIP.C.
    
    To use this program, first build it for the DOS LARGE model. Then copy some text 
    onto the Windows Clipboard, and execute the program. It might also be informative
    to have the Windows' Clipboard Viewer running.
    
    Please use and distribute freely, but don't hold me responsible for 
    anything that happens ;-).
    
    I H Ting
    Compuserve ID : 100023,3363
    Internet Email: cm1826@wlv.ac.uk
*/
    

#include <stdio.h>
#include <stdlib.h>
#include "dosclip.h"  
#include "string.h"

void main(void)
{
  unsigned uVersion;
  unsigned long ulDataSize;
  char *pBuffer;
  size_t sLen;

  uVersion = IndentifyWinOldApVersion();
  
  printf("IdentifyWinOldApVersion() returned major version %u, minor version %x.\n",
    uVersion,(uVersion>>8));
  
  printf("Opening Clipboard for pasting...\n");
  if (OpenClipboard()) {
    ulDataSize = GetClipboardDataSize(1); /* CF_TEXT format */
    if (ulDataSize > 0) {
      printf("Size of CF_TEXT data on the Clipboard is %lu\n",ulDataSize);
      if (ulDataSize < 0xffff) {  /* malloc can only managed 64K */
        pBuffer = (char *) malloc((size_t)ulDataSize+1);
        if (GetClipboardData(1,pBuffer)) 
          printf("The Clipboard contained the following CF_TEXT data:\n%s\n",pBuffer);
        else
          printf("Error - GetClipboardData() returned 0.\n");
      }
      else
        printf("The Clipboard contained >64K of CF_TEXT data\n");
    }
    else
      printf("The Clipboard doesn't contain CF_TEXT data.\n",ulDataSize);
    
    printf("Closing Clipboard...\n");
    if (CloseClipboard() == 0)
      printf("Error - CloseClipboard() returned 0.\n");
  }
  else  
    printf("Error - OpenClipboard() returned 0.\n");

  free(pBuffer);
  pBuffer = (char *) malloc(512);
  if (pBuffer==0) return;
  
  printf("Enter a string to copy onto the Clipboard.\n");
  gets(pBuffer);
  sLen = strlen(pBuffer);
  if(sLen==0) return;

  printf("Opening Clipboard for copying...\n");
  if (OpenClipboard()) {
    if (EmptyClipboard()) {
        if (SetClipboardData(1,pBuffer,sLen)) 
          printf("The Clipboard now contains the following CF_TEXT data:\n%s\n",pBuffer);
        else
          printf("Error - SetClipboardData() returned 0.\n");
    }
    else
      printf("Error - EmptyClipboard() returned 0.\n");
    printf("Closing Clipboard...\n");
    if (CloseClipboard() == 0)
      printf("Error - CloseClipboard() returned 0.\n");
  }
  else  
    printf("Error - OpenClipboard() returned 0.\n");
  return;

}

