/*  
    DOSCLIP.C
    
    A set of 'C' wrapper functions for the DOS INT 2FH interface to Windows'
    Clipboard, as documented in Microsoft's Knowledge Base article Q67675 -
    "Access to the Windows Clipboard by DOS Applications"
    
    Please use and distribute freely, but don't hold me responsible for 
    anything that happens ;-).
    
    I H Ting
    Compuserve ID : 100023,3363
    Internet Email: cm1826@wlv.ac.uk
*/

#include <dos.h>  
#include "dosclip.h"

#ifdef __TURBOC__
#define _REGS REGS
#define _SREGS SREGS
#define _int86 int86
#define _int86x int86x
#define _FP_SEG FP_SEG
#define _FP_OFF FP_OFF
#endif

typedef unsigned short      WORD;
typedef unsigned long       DWORD;

#define LOWORD(l)           ((WORD)(DWORD)(l))
#define HIWORD(l)           ((WORD)((((DWORD)(l)) >> 16) & 0xFFFF))
#define MAKEDWORD(low, high) ((DWORD)(((WORD)(low)) | (((DWORD)((WORD)(high))) << 16)))


/*  
Name            IdentifyWinOldApVersion()
Parameters      none
Return Values   0x1700  : Clipboard functions not available
                otherwise:
                    Low byte  : Major version number.
                    High byte : Minor version number.
*/
unsigned IndentifyWinOldApVersion(void)
{
  union _REGS regs;
  
  regs.x.ax = 0x1700;
  _int86(0x2f, &regs,&regs);
  return regs.x.ax;
}



/*
Name            OpenClipboard()
Parameters      none
Return Values   
                0    : Clipboard in use.
                != 0 : Success.
*/
unsigned OpenClipboard(void)
{
  union _REGS regs;

  regs.x.ax = 0x1701;
  _int86(0x2f, &regs,&regs);
  return regs.x.ax;
}


/* 
Name            EmptyClipboard()
Parameters      none
Return Values   
                0    - Error.
                != 0 - Success.
*/
unsigned EmptyClipboard(void)
{
  union _REGS regs;
  
  regs.x.ax = 0x1702;
  _int86(0x2f, &regs,&regs);
  return regs.x.ax;
}


/*
Name            SetClipboardData(uFormat, lpData, ulSize)
Parameters      uFormat =           
                   0x01 = CF_TEXT        
                   0x02 = CF_BITMAP     
                   0x07 = CF_OEMTEXT    
                   0x81 = CF_DSPTEXT    
                   0x82 = CF_DSPBITMAP <Please see MSKB article for more info> 

                lpData = far pointer to data
                ulSize = Size of data in bytes

Return Values   0    : Error occurred
                != 0 : Success. Data copied into allocated memory.
*/
unsigned SetClipboardData(unsigned uFormat, void far *lpData, unsigned long ulSize )
{
  union _REGS regs;
  struct _SREGS sregs;
  
  regs.x.ax = 0x1703;
  regs.x.dx = uFormat;
  regs.x.si = HIWORD(ulSize);
  regs.x.cx = LOWORD(ulSize);
  sregs.es = _FP_SEG(lpData);
  regs.x.bx = _FP_OFF(lpData);
  _int86x(0x2f, &regs,&regs,&sregs);
  return regs.x.ax;
}


/*
Name            GetClipboardDataSize(uFormat)
Parameters      uFormat = Clipboard format
Return Values   
                Size of the data in bytes.
                0 If data in this format is not in the clipboard.
*/
unsigned long GetClipboardDataSize(unsigned uFormat)
{
  union _REGS regs;
  
  regs.x.ax = 0x1704;
  regs.x.dx = uFormat;
  _int86(0x2f, &regs,&regs);
  return MAKEDWORD(regs.x.ax,regs.x.dx);
}


/*
Name            GetClipboardData(uFormat, lpBuffer)
Parameters      uFormat =          
                   0x01 = CF_TEXT        
                   0x02 = CF_BITMAP     
                   0x07 = CF_OEMTEXT    
                   0x81 = CF_DSPTEXT    
                   0x82 = CF_DSPBITMAP  

                lpData = far pointer to data

Return Values   0    : Error occurred
                != 0 : Success. Data copied into allocated memory.
*/
unsigned GetClipboardData(unsigned uFormat, void far *lpBuffer)
{
  union _REGS regs;
  struct _SREGS sregs;
  
  regs.x.ax = 0x1705;
  regs.x.dx = uFormat;
  sregs.es = _FP_SEG(lpBuffer);
  regs.x.bx = _FP_OFF(lpBuffer);
  _int86x(0x2f, &regs,&regs,&sregs);
  return regs.x.ax;
}


/*
Name            CloseClipboard()
Parameters      none
Return Values   
                0    : Error.
                != 0 : Success.
*/
unsigned CloseClipboard(void)
{
  union _REGS regs;

  regs.x.ax = 0x1708;
  _int86(0x2f, &regs,&regs);
  return regs.x.ax;
}


