#include "STDIO.h"
#include "STDLIB.h"
#include "IO.h"
#include "FCNTL.h"
#include "DOS.h"
#include "DIR.h"

/*
    DIRSEL.c   v1.00    Vernon E. Davis
    07/12/87            17 South Centre Street
                        Merchantville, NJ 08109
                        CompuServe [71330,2705]
                        GEnie - VED


    purpose   : to select one filename from the list presented
    syntax    : #include "STDIO.h"
              : #include "STDLIB.h"
              : #include "IO.h"
              : #include "FCNTL.h"
              : #include "DOS.h"
              : #include "DIR.h"
              : *p = dirselect(*mask,attr);
              : char *p;     the filename
              : char *mask;  the directory mask, i.e. "*.*"
              : int attr;    the attribute to look for,i.e.
              :               FA_RDONLY, FA_HIDDEN, FA_SYSTEM,
              :               FA_LABEL,  FA_DIREC,  FA_ARCH.
              :               (see dos.h or Turbo C manual for info.)
              :
    returns   : either a pointer to a filename that was selected or
              : NULL if Escape was pressed and if no file is found.
              :
    descrip.  : a call to dirselect() first determines if there are any files
              : that meet the specs received from the directory mask. If
              : no files were found, the function immediately returns NULL.
              : Otherwise, all filenames that meet the mask spec are copyed
              : into an array that can hold up to 120 selections. The routine
              : then clears a portion of the screen, saving the contents of
              : the screen in an array. A frame is drawn in the cleared portion
              : of the screen and the current directory contents are displayed
              : in the boxed area as per the  mask that was received. The first
              : selection is highlighted in reverse video. The up/down/left/
              : right arrow keys will move the highlight around.  The Home Key
              : returns to the first selection. The End key moves to the last
              : selection. When < CR > is pressed,  the screen returns to
              : normal, the cursor is placed in its original position and the
              : value returned from the function is a pointer to a string
              : containing the filename selected.  If Esc was pressed instead,
              : the previous sequence is performed, with the exception of NULL
              : being returned instead of the filename.
              :
    notes     : A. All routines in this file can be run under TC, the
              :    Turbo C Integrated Development Environment. Because of
              :    this, the routine will run slow when executed. It was
              :    not designed for speed.
              : B. These routines rely on the video hardware interrupt 0x10
              :    for the cursor information. Insure that the PC is an IBM
              :    or compatable.
              : C. Three (3) cursor functions and a frame drawing function are
              :    available. They are as follows:
              :    1. void     gotoxy(x,y); move cursor to new location
              :                int x (0..79)
              :                int y (0..24)
              :    2. void     cursor(ON/OFF); turn cursor on or off
              :                int ON (1) or OFF (0)
              :    3. xyposdef wherecur(void); locate cursor position
              :                xyposdef.x (0..79)  column location
              :                xyposdef.y (0..24)  row location
              :    4. void     drframe(top,left,bottom,right); draw double fr.
              :                int top    (0..24)  top corner
              :                int left   (0..79)  left corner
              :                int bottom (0..24)  bottom corner
              :                int right  (0..79)  right corner
              :    The other functions declared are special to dirselect()
              :    and of no real use; however, they are documented.
*/

#define TRUE 1
#define FALSE 0
#define ON 1
#define OFF 0
#define VIDINTR 0x10
#define EQUINTR 0x11
#define FPOS1  1
#define FPOS2 14
#define FPOS3 27
#define FPOS4 40
#define FPOS5 53
#define FPOS6 66

   typedef struct     /* structure for directory array */
   {  char fname[13];
   }  dirdef;

   typedef struct     /* structure for cursor column(x) and row(y) */
   {  int x,y;
   }  xyposdef;

/*  function declarations  */

char* dirselect(char*,int);                   /* the main function */
void hilite(unsigned char,unsigned char);     /* highlights the filename */
xyposdef fnamepos(unsigned char);             /* X/Y position of filename */
void drframe(int,int,int,int);                /* draw double-line frame */
void gotoxy(unsigned char,unsigned char);     /* move cursor to new location */
void cursor(int);                             /* turn cursor on or off */
xyposdef wherecur(void);                      /* current cursor location */

char* dirselect(mask,attr)
   char mask[13];
   int attr;
{  union REGS regs;
   struct ffblk ffblk;
   int h,i,j,k,row,error,oldcurx,oldcury;
   unsigned char oldpos,newpos;
   char chrbuf[4000],atrbuf[4000];
   char key;
   dirdef dos_dir[121],*dos_dirptr;
   xyposdef xypos;
   h=0;
   if((error=findfirst(mask,&ffblk,attr))==-1) /* if not found, return NULL */
      return(NULL);
   while(!error&&h!=120)        /* else, collect filenames */
   {  dos_dirptr=&dos_dir[h++];
      strcpy(dos_dirptr->fname,ffblk.ff_name);
      error=findnext(&ffblk);
   };
   xypos=wherecur();     /* store old cursor position */
   oldcurx=xypos.x;
   oldcury=xypos.y;
   cursor(OFF);
   k=0;
   for(i=0;i<((h/6)+3);i++)   /* store old screen info & clear portion */
   {  for(j=0;j<80;j++)
      {  gotoxy(j,i);
         regs.h.bh=0;
         regs.h.ah=8;
         int86(VIDINTR,&regs,&regs);
         chrbuf[k]=regs.h.al;
         atrbuf[k]=regs.h.ah;
         putch(32);
         k++;
      };
   };
   gotoxy(0,0);
   i=0; j=0; row=1;
   while(TRUE)                  /* display all filenames */
   {  dos_dirptr=&dos_dir[i];
      xypos=fnamepos(i);
      gotoxy(xypos.x,xypos.y);
      printf("%-012.12s",dos_dirptr->fname);
      i++; j++;
      if(i==h||i==120) break;
      if(j>5)
      {  j=0;
         row++;
         printf("\n");
      };
   };
   drframe(0,0,(row+1),79);  /* draw the frame */
   hilite(255,0);            /* highlight the first filename */
   oldpos=0;
   newpos=0;
   while(TRUE)           /* get keypress and do appropriate action */
   {  key=getch();
      switch(key)
      {  case 27:  /* Esc  */
            k=0;
            for(i=0;i<((h/6)+3);i++)  /* return contents of old screen */
            {  for(j=0;j<80;j++)
               {  gotoxy(j,i);
                  regs.h.al=chrbuf[k];
                  regs.h.bl=atrbuf[k];
                  regs.h.ch=0;
                  regs.h.cl=1;
                  regs.h.bh=0;
                  regs.h.ah=9;
                  int86(VIDINTR,&regs,&regs);
                  k++;
               };
            };
            gotoxy(oldcurx,oldcury);         /* return old cursor position */
            cursor(ON);
            return(NULL);                    /* return NULL */
         case 71:  /* Home */                /* goto first filename */
            oldpos=newpos;
            newpos=0;
            hilite(oldpos,newpos);
            break;
         case 79:  /* End  */                /* goto last filename */
            oldpos=newpos;
            newpos=(h-1);
            hilite(oldpos,newpos);
            break;
         case 72:  /* Up   */                /* move up one filename */
            i=newpos;
            i-=6;
            if(i>=0)
            {  oldpos=newpos;
               newpos=i;
               hilite(oldpos,newpos);
            };
            break;
         case 80:  /* Down */                /* move down one filename */
            i=newpos;
            i+=6;
            if(i<h)
            {  oldpos=newpos;
               newpos=i;
               hilite(oldpos,newpos);
            };
            break;
         case 75:  /* Left */                /* move left one filename */
            i=newpos;
            i--;
            if(i>=0)
            {  oldpos=newpos;
               newpos=i;
               hilite(oldpos,newpos);
            };
            break;
         case 77:  /* Right */               /* move right one filename */
            i=newpos;
            i++;
            if(i<h)
            {  oldpos=newpos;
               newpos=i;
               hilite(oldpos,newpos);
            };
            break;
         case 13:  /* CR */
            k=0;
            for(i=0;i<((h/6)+3);i++)       /* return contents of old screen */
            {  for(j=0;j<80;j++)
               {  gotoxy(j,i);
                  regs.h.al=chrbuf[k];
                  regs.h.bl=atrbuf[k];
                  regs.h.ch=0;
                  regs.h.cl=1;
                  regs.h.bh=0;
                  regs.h.ah=9;
                  int86(VIDINTR,&regs,&regs);
                  k++;
               };
            };
            gotoxy(oldcurx,oldcury);    /* return old cursor position */
            cursor(ON);
            return(dos_dir[newpos].fname);   /* return with filename */
      };
   };
}

void hilite(old,new)         /* highlight a filename on the screen */
   unsigned char old,new;
{  union REGS regs;
   int oldx,oldy,newx,newy,i;
   unsigned char ccolor,locolor,hicolor;
   xyposdef xypos;
   xypos=fnamepos(old);
   oldx=xypos.x;
   oldy=xypos.y;
   xypos=fnamepos(new);    /* get the position in the array of the filename */
   newx=xypos.x;
   newy=xypos.y;
   for(i=0;i<12;i++)
   {  if(old<121)       /* if valid position, reverse video, old selection */
      {  gotoxy((oldx+i),oldy);
         regs.h.bh=0;
         regs.h.ah=8;
         int86(VIDINTR,&regs,&regs);
         ccolor=regs.h.ah;
         locolor=ccolor&0x0F;
         locolor<<=4;
         hicolor=ccolor&0xF0;
         hicolor>>=4;
         ccolor=locolor+hicolor;
         regs.h.ch=0;
         regs.h.cl=1;
         regs.h.bh=0;
         regs.h.bl=ccolor;
         regs.h.ah=9;
         int86(VIDINTR,&regs,&regs);
      };
      gotoxy((newx+i),newy);         /* reverse video, new selection */
      regs.h.bh=0;
      regs.h.ah=8;
      int86(VIDINTR,&regs,&regs);
      ccolor=regs.h.ah;
      locolor=ccolor&0x0F;
      locolor<<=4;
      hicolor=ccolor&0xF0;
      hicolor>>=4;
      ccolor=locolor+hicolor;
      regs.h.ch=0;
      regs.h.cl=1;
      regs.h.bh=0;
      regs.h.bl=ccolor;
      regs.h.ah=9;
      int86(VIDINTR,&regs,&regs);
   };
   return;
}

xyposdef fnamepos(arypos)   /* determine position on screen of filename[] */
   unsigned char arypos;
{  int x,y;
   xyposdef xyp;
   switch(arypos)
   {  case   0: x=FPOS1; y= 1; break;   /* see #define for x coordinates */
      case   1: x=FPOS2; y= 1; break;
      case   2: x=FPOS3; y= 1; break;
      case   3: x=FPOS4; y= 1; break;
      case   4: x=FPOS5; y= 1; break;
      case   5: x=FPOS6; y= 1; break;
      case   6: x=FPOS1; y= 2; break;
      case   7: x=FPOS2; y= 2; break;
      case   8: x=FPOS3; y= 2; break;
      case   9: x=FPOS4; y= 2; break;
      case  10: x=FPOS5; y= 2; break;
      case  11: x=FPOS6; y= 2; break;
      case  12: x=FPOS1; y= 3; break;
      case  13: x=FPOS2; y= 3; break;
      case  14: x=FPOS3; y= 3; break;
      case  15: x=FPOS4; y= 3; break;
      case  16: x=FPOS5; y= 3; break;
      case  17: x=FPOS6; y= 3; break;
      case  18: x=FPOS1; y= 4; break;
      case  19: x=FPOS2; y= 4; break;
      case  20: x=FPOS3; y= 4; break;
      case  21: x=FPOS4; y= 4; break;
      case  22: x=FPOS5; y= 4; break;
      case  23: x=FPOS6; y= 4; break;
      case  24: x=FPOS1; y= 5; break;
      case  25: x=FPOS2; y= 5; break;
      case  26: x=FPOS3; y= 5; break;
      case  27: x=FPOS4; y= 5; break;
      case  28: x=FPOS5; y= 5; break;
      case  29: x=FPOS6; y= 5; break;
      case  30: x=FPOS1; y= 6; break;
      case  31: x=FPOS2; y= 6; break;
      case  32: x=FPOS3; y= 6; break;
      case  33: x=FPOS4; y= 6; break;
      case  34: x=FPOS5; y= 6; break;
      case  35: x=FPOS6; y= 6; break;
      case  36: x=FPOS1; y= 7; break;
      case  37: x=FPOS2; y= 7; break;
      case  38: x=FPOS3; y= 7; break;
      case  39: x=FPOS4; y= 7; break;
      case  40: x=FPOS5; y= 7; break;
      case  41: x=FPOS6; y= 7; break;
      case  42: x=FPOS1; y= 8; break;
      case  43: x=FPOS2; y= 8; break;
      case  44: x=FPOS3; y= 8; break;
      case  45: x=FPOS4; y= 8; break;
      case  46: x=FPOS5; y= 8; break;
      case  47: x=FPOS6; y= 8; break;
      case  48: x=FPOS1; y= 9; break;
      case  49: x=FPOS2; y= 9; break;
      case  50: x=FPOS3; y= 9; break;
      case  51: x=FPOS4; y= 9; break;
      case  52: x=FPOS5; y= 9; break;
      case  53: x=FPOS6; y= 9; break;
      case  54: x=FPOS1; y=10; break;
      case  55: x=FPOS2; y=10; break;
      case  56: x=FPOS3; y=10; break;
      case  57: x=FPOS4; y=10; break;
      case  58: x=FPOS5; y=10; break;
      case  59: x=FPOS6; y=10; break;
      case  60: x=FPOS1; y=11; break;
      case  61: x=FPOS2; y=11; break;
      case  62: x=FPOS3; y=11; break;
      case  63: x=FPOS4; y=11; break;
      case  64: x=FPOS5; y=11; break;
      case  65: x=FPOS6; y=11; break;
      case  66: x=FPOS1; y=12; break;
      case  67: x=FPOS2; y=12; break;
      case  68: x=FPOS3; y=12; break;
      case  69: x=FPOS4; y=12; break;
      case  70: x=FPOS5; y=12; break;
      case  71: x=FPOS6; y=12; break;
      case  72: x=FPOS1; y=13; break;
      case  73: x=FPOS2; y=13; break;
      case  74: x=FPOS3; y=13; break;
      case  75: x=FPOS4; y=13; break;
      case  76: x=FPOS5; y=13; break;
      case  77: x=FPOS6; y=13; break;
      case  78: x=FPOS1; y=14; break;
      case  79: x=FPOS2; y=14; break;
      case  80: x=FPOS3; y=14; break;
      case  81: x=FPOS4; y=14; break;
      case  82: x=FPOS5; y=14; break;
      case  83: x=FPOS6; y=14; break;
      case  84: x=FPOS1; y=15; break;
      case  85: x=FPOS2; y=15; break;
      case  86: x=FPOS3; y=15; break;
      case  87: x=FPOS4; y=15; break;
      case  88: x=FPOS5; y=15; break;
      case  89: x=FPOS6; y=15; break;
      case  90: x=FPOS1; y=16; break;
      case  91: x=FPOS2; y=16; break;
      case  92: x=FPOS3; y=16; break;
      case  93: x=FPOS4; y=16; break;
      case  94: x=FPOS5; y=16; break;
      case  95: x=FPOS6; y=16; break;
      case  96: x=FPOS1; y=17; break;
      case  97: x=FPOS2; y=17; break;
      case  98: x=FPOS3; y=17; break;
      case  99: x=FPOS4; y=17; break;
      case 100: x=FPOS5; y=17; break;
      case 101: x=FPOS6; y=17; break;
      case 102: x=FPOS1; y=18; break;
      case 103: x=FPOS2; y=18; break;
      case 104: x=FPOS3; y=18; break;
      case 105: x=FPOS4; y=18; break;
      case 106: x=FPOS5; y=18; break;
      case 107: x=FPOS6; y=18; break;
      case 108: x=FPOS1; y=19; break;
      case 109: x=FPOS2; y=19; break;
      case 110: x=FPOS3; y=19; break;
      case 111: x=FPOS4; y=19; break;
      case 112: x=FPOS5; y=19; break;
      case 113: x=FPOS6; y=19; break;
      case 114: x=FPOS1; y=20; break;
      case 115: x=FPOS2; y=20; break;
      case 116: x=FPOS3; y=20; break;
      case 117: x=FPOS4; y=20; break;
      case 118: x=FPOS5; y=20; break;
      case 119: x=FPOS6; y=20; break;
   };
   xyp.x=x; xyp.y=y;
   return(xyp);      /* return with X/Y coordinates of filename[] */
}

void drframe(t,l,b,r)  /* draw a frame on the screen */
   int t,l,b,r;
{  int h,i;
   gotoxy(l,t); printf("%c",201);  /* draw upper corners */
   gotoxy(r,t); printf("%c",187);
   gotoxy(l+1,t);
   for(i=0;i<(r-(l+1));i++)  /* draw top bar */
      printf("%c",205);
   gotoxy(l+1,b);
   for(i=0;i<(r-(l+1));i++)  /* draw bottom bar */
      printf("%c",205);
   gotoxy(l,b); printf("%c",200);  /* draw bottom corners */
   gotoxy(r,b); printf("%c",188);
   for(i=(t+1);i<b;i++)      /* draw left side bar */
   {  gotoxy(l,i);
      printf("%c",186);
   };
   for(i=(t+1);i<b;i++)      /* draw right side bar */
   {  gotoxy(r,i);
      printf("%c",186);
   };
   return;
}

void cursor(mode)  /* turn the cursor on or off */
   int mode;
{  union REGS regs;
   int i;
   if(mode==OFF)
   {  regs.h.cl=7;
      regs.h.ch=32;    /* set bit 5 high to turn cursor off */
   }
   else
   {  int86(EQUINTR,&regs,&regs);  /* get equipment to determine video mode */
      i=regs.h.al;
      regs.x.cx=0x0607;    /* prepare for CGA */
      if((i&=0x10)!=NULL)  /* if MA/MGA */
        regs.x.cx=0x0B0C;  /* prepare for MA/MGA */
   };
   regs.h.ah=1;
   int86(VIDINTR,&regs,&regs);
   return;
};

void gotoxy(x,y)  /* move cursor to a new location */
   unsigned char x,y;
{  union REGS regs;
   regs.h.bh=0;
   regs.h.dl=x;
   regs.h.dh=y;
   regs.h.ah=2;
   int86(VIDINTR,&regs,&regs);
   return;
}

xyposdef wherecur(void)  /* report current cursor location */
{  union REGS regs;
   xyposdef xyp;
   regs.h.ah=3;
   regs.h.bh=0;
   int86(VIDINTR,&regs,&regs);
   xyp.y=regs.h.dh;
   xyp.x=regs.h.dl;
   return(xyp);
}

/*  End Of Function  dirselect()  */

/*  The following main() is only for demo purposes. It is not needed in
    your own programs.  */

main()
{  char fname[13],*name;
   char fmask[13],*mask;
   while(TRUE)
   {  name=&fname[0];
      mask=&fmask[0];
      printf("Enter a directory mask => ");
      gets(mask);
      if((name=dirselect(mask,FA_ARCH))==NULL)
      {  printf("\nNo file selected\nProgram aborted.\n");
         break;
      }
      else
         printf("The file you selected was %s.\n",name);
   };
   exit(0);
}
