/*
	DIRECTRY.C	Routines to create, empty, and search directories.
				4 June 1994
				Adrian Urquhart 100126, 1211
				Read COMMENTS.DOC for more details. You are free to use/modify
				these routines for your own use.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <direct.h>
#include "directry.h"

static char * ExtractDirectory (char *, char *) ;

int SearchDisk (const char * FileName)
{
	struct find_t f ;
	if (_dos_findfirst ("*.*", _A_NORMAL | _A_SUBDIR, &f) == 0)
	{
	if (f.attrib & _A_SUBDIR)
		{
		if (* f.name != '.')
			{
			chdir (f.name) ;
			if (SearchDisk (FileName))
				return 1 ;
			chdir ("..") ;
			}
		}
	else if (stricmp (f.name, FileName) == 0)
			return 1 ;
	while (_dos_findnext (&f) == 0)
		{
		if (f.attrib & _A_SUBDIR)
			{
			if (* f.name != '.')
				{
				chdir (f.name) ;
				if (SearchDisk (FileName))
					return 1 ;
				chdir ("..") ;
				}
			}
		else if (stricmp (f.name, FileName) == 0)
				return 1 ;
		}
	}
	return 0 ;
}

int EmptyDirectory (void)
{
	struct find_t f ;
	if (_dos_findfirst ("*.*", _A_NORMAL | _A_HIDDEN | _A_SYSTEM | _A_SUBDIR, &f) == 0)
	{
	if (f.attrib & _A_SUBDIR)
		{
		if (* f.name != '.')
			{
			chdir (f.name) ;
			if (!EmptyDirectory ())
				return 0 ;
			chdir ("..") ;
			if (rmdir (f.name))
				return 0 ;
			}
		}
	else
		if (remove (f.name))
			return 0 ;
	while (_dos_findnext (&f) == 0)
		{
		if (f.attrib & _A_SUBDIR)
			{
			if (* f.name != '.')
				{
				chdir (f.name) ;
				if (!EmptyDirectory ())
					return 0 ;
				chdir ("..") ;
				if (rmdir (f.name))
					return 0 ;
				}
			}
		else
			if (remove (f.name))
				return 0 ;
		}
	}
	return 1 ;
}

int CreateDirectory (char * NewPath)
{
	char drive [_MAX_DRIVE], dir [_MAX_DIR], filename [_MAX_FNAME], ext [_MAX_EXT], NextDirectory [13], * path ;
	strupr (NewPath) ;
	_splitpath (NewPath, drive, dir, filename, ext) ;
	_chdrive (* drive - 64) ;
	if (chdir (dir) == 0)
		return 1 ;
	chdir ("\\") ;
	path = dir + 1 ;
	while (path = ExtractDirectory (path, NextDirectory))
	{
	if (chdir (NextDirectory))
		{
		if (mkdir (NextDirectory))
			return 0 ;
		if (chdir (NextDirectory))
			return 0 ;
		}
	}
	return 1 ;
}

static char * ExtractDirectory (char * FullPath, char * Target)
{
	int x = 0 ;
	while (* FullPath)
	{
	if (* FullPath == 92)
		{
		Target [x] = 0 ;
		return ++ FullPath ;
		}
	Target [x ++] = * FullPath ;
	++ FullPath ;
	}
	Target [x] = 0 ;
	return (x ? FullPath : NULL) ;
}
