//==============================================================
//
//	Filename	:	DBDEMO.CPP
//
//	Purpose		:	Dynamic Link Library Database Demo
//
//	Date			:	December 25, 1991
//
//	Prog/Dev	:	Edward B. Toupin
//
//==============================================================
//
//	COMPILER	:	Borland C++ / TCW++
//							Borland Resource Workshop
//
//	MODEL			:	Compact
//
//	NOTICE		:	(c)1992 Edward B. Toupin
//							All Rights Reserved
//
//							The reader may use as seen fit, for profit
//							and otherwise, so long as credit is given
//							to the author Edward B. Toupin.
//
//==============================================================


#include	<windows.h>
#include	<stdlib.h>
#include	<string.h>
#include	<stdio.h>
#include	<math.h>
#include	"dlldb.h"

//Global declarations
HANDLE	hInst;  						//Application instance
HANDLE	DBLIB;							//Handle to DLLDB
FARPROC	MainProcInst;				//Main procedure instance
FARPROC	AboutProcInst;			//About procedure instance
FARPROC	SearchProcInst;			//Search procedure instance
HWND		MainWnd;						//Main window handle
char		SearchVal[100];			//Search Value
BOOL		TempBool;						//Temporary boolean variable

//Dialog window defines
#define ID_FINDSALARY 375
#define ID_YORN	374
#define ID_SALARY	371
#define ID_SORTSALARY	373
#define ID_PURGE	370
#define ID_COMPANY	362
#define ID_POSITION	363
#define ID_SEARCH	200
#define ID_AGE	361
#define ID_OK	250
#define ID_CANCEL	251
#define ID_SORT	254
#define ID_FINDNAME	300
#define ID_SORTNAME	302
#define ID_SORTADDRESS	305
#define ID_SORTAGE	310
#define ID_SORTORDER	360
#define ID_FINDADDRESS	306
#define ID_FINDAGE	308
#define ID_FIND	134
#define ID_RECNUM	130
#define ID_ABOUT	111
#define ID_CITY	109
#define ID_ADDRESS	108
#define ID_NAME	107
#define ID_NEXT	101
#define ID_PREV	102
#define ID_CLEAR	103
#define ID_ADD	104
#define ID_DEL	105
#define ID_UPDATE	106


#define	ID_UPDATE_DISPLAY 400
#define	ID_READ_DISPLAY 401

//Filename
char		DBName[] 	= "DEMO.DAT";
char		DBIndex[]	=	"DEMO.IDX";

//Database field offsets
#define	NAME_OFFSET				0
#define	ADDRESS_OFFSET		100
#define CITY_OFFSET				200
#define	COMPANY_OFFSET		300
#define	POSITION_OFFSET		400
#define	AGE_OFFSET				500
#define SALARY_OFFSET			502
#define	YESORNO_OFFSET		506

#define	NAME_INDEX				0
#define	ADDRESS_INDEX			1
#define	AGE_INDEX					2
#define SALARY_INDEX			3
int	CurrentIndex = NAME_INDEX;


typedef char string[20];
string SortOrder[]={"Name","Address","Age","Salary"};

//Main database structure
struct MainDB
{
	char		name[100];     		//Name
	char		address[100];			//Address
	char		city[100];				//City, State, Zip
	char		company[100];			//Name of company
  char		position[100];		//Position in company
	int			age;							//Age of person
	float		salary;						//Salary
  char		yesorno;					//Whatever
}
MainDB;

//Union for passing information to and from the library
//	The "buffer" is used to genericise the structure making
//	it a character array
union 	MainUnion
{
	char		buffer[sizeof(struct MainDB)];//Generic buffer
	struct	MainDB	Main;							//Reference to main	structure
}
MainUnion, TempMainUnion;


//Exports for windows
extern"C"
{
	BOOL FAR PASCAL MainProc(HWND,unsigned,WORD,LONG);
	BOOL FAR PASCAL AboutProc(HWND,unsigned,WORD,LONG);
	BOOL FAR PASCAL NameSearchProc(HWND,unsigned,WORD,LONG);
	BOOL FAR PASCAL AgeSearchProc(HWND,unsigned,WORD,LONG);
	BOOL FAR PASCAL AddressSearchProc(HWND,unsigned,WORD,LONG);
	BOOL FAR PASCAL SalarySearchProc(HWND,unsigned,WORD,LONG);
}


//--------------------------------------------------------------
//
//	BOOL SetupDatabases()
//
//	Setup all databases and indexes.
//
//--------------------------------------------------------------
BOOL SetupDatabases()
{
	//Pass the required information to the DLL to
	//	create an object.
	if(!SetupDatabase((LPSTR)DBName,sizeof(struct MainDB),(LPSTR)DBIndex))
	{
		return(FALSE);
	}

	//First index contains NAME
	CreateIndex((LPSTR)DBName,NAME_INDEX,0,STRING,(LPSTR)"NAME",(long)NAME_OFFSET,
		(long)40);

	//Second index contains ADDRESS
	CreateIndex((LPSTR)DBName,ADDRESS_INDEX,0,STRING,"ADDRESS",(long)ADDRESS_OFFSET,
		(long)40);

	//Third index contains AGE
	CreateIndex((LPSTR)DBName,AGE_INDEX,0,INT,"AGE",(long)AGE_OFFSET,
		(long)2);

	//Fourth index contains SALARY
	CreateIndex((LPSTR)DBName,SALARY_INDEX,0,FLOAT,"SALARY",(long)SALARY_OFFSET,
		(long)20);

	//Open the database
	if(!OpenDatabase((LPSTR)DBName))
	{
		return(FALSE);
	}

	//Close the database
	CloseDatabase(DBName);

	return(TRUE);
}


//--------------------------------------------------------------
//
//	BOOL FAR PASCAL AboutProc()
//
//	Procedure for the database about dialog.
//
//--------------------------------------------------------------
BOOL FAR PASCAL AboutProc(HWND hDlg, unsigned message, WORD wParam,
													LONG lParam)
{
	switch(message)
	{
		//Initialize the dialog
		case WM_INITDIALOG	:
		{
			return(TRUE);
		}

		//User commands
		case WM_COMMAND		:
		{
			switch(wParam)
			{
				//OK Button
				case IDOK	:
				{
					//Close the dialog
					EndDialog(hDlg,TRUE);
					break;
				}
			}
		}
		default	:
			return(FALSE);
	}
}


//--------------------------------------------------------------
//
//	BOOL FAR PASCAL NameSearchProc()
//
//	Procedure to search for a record in the database by name
//
//--------------------------------------------------------------
BOOL FAR PASCAL NameSearchProc(HWND hDlg, unsigned message,
													 WORD wParam, LONG lParam)
{
	switch(message)
	{
		//Initialize the dialog
		case WM_INITDIALOG	:
		{
			return(TRUE);
		}

		//User command
		case WM_COMMAND		:
		{
			switch(wParam)
			{
				//Cancel button, close the dialog and return a FALSE
				case IDCANCEL	:
				{
					EndDialog(hDlg,FALSE);
					break;
				}

				//OK Button pressed
				case IDOK	:
				{
					//Get the entered value for searching
					SendDlgItemMessage(hDlg,ID_SEARCH,WM_GETTEXT,sizeof(TempMainUnion.Main.name)-1,
														(long)(LPSTR)TempMainUnion.Main.name);

					EndDialog(hDlg,TRUE);
					break;
				}
			}
		}
		default	:
			return(FALSE);
	}
}

//--------------------------------------------------------------
//
//	BOOL FAR PASCAL SalarySearchProc()
//
//	Procedure to search for a record in the database by salary
//
//--------------------------------------------------------------
BOOL FAR PASCAL SalarySearchProc(HWND hDlg, unsigned message,
													 WORD wParam, LONG lParam)
{
	char	tempbuff[30];

	switch(message)
	{
		//Initialize the dialog
		case WM_INITDIALOG	:
		{
			return(TRUE);
		}

		//User command
		case WM_COMMAND		:
		{
			switch(wParam)
			{
				//Cancel button, close the dialog and return a FALSE
				case IDCANCEL	:
				{
					EndDialog(hDlg,FALSE);
					break;
				}

				//OK Button pressed
				case IDOK	:
				{
					//Get the entered value for searching
					SendDlgItemMessage(hDlg,ID_SEARCH,WM_GETTEXT,sizeof(tempbuff)-1,
														(long)(LPSTR)tempbuff);
					TempMainUnion.Main.salary=atof((LPSTR)tempbuff);

					EndDialog(hDlg,TRUE);
					break;
				}
			}
		}
		default	:
			return(FALSE);
	}
}


//--------------------------------------------------------------
//
//	BOOL FAR PASCAL AgeSearchProc()
//
//	Procedure to search for a record in the database by age
//
//--------------------------------------------------------------
BOOL FAR PASCAL AgeSearchProc(HWND hDlg, unsigned message,
													 WORD wParam, LONG lParam)
{
	char	tempbuff[30];

	switch(message)
	{
		//Initialize the dialog
		case WM_INITDIALOG	:
		{
			return(TRUE);
		}

		//User command
		case WM_COMMAND		:
		{
			switch(wParam)
			{
				//Cancel button, close the dialog and return a FALSE
				case IDCANCEL	:
				{
					EndDialog(hDlg,FALSE);
					break;
				}

				//OK Button pressed
				case IDOK	:
				{
					//Get the entered value for searching
					SendDlgItemMessage(hDlg,ID_SEARCH,WM_GETTEXT,sizeof(tempbuff)-1,
														(long)(LPSTR)tempbuff);
					TempMainUnion.Main.age=atoi((LPSTR)tempbuff);

					EndDialog(hDlg,TRUE);
					break;
				}
			}
		}
		default	:
			return(FALSE);
	}
}


//--------------------------------------------------------------
//
//	BOOL FAR PASCAL AddressSearchProc()
//
//	Procedure to search for a record in the database by name
//
//--------------------------------------------------------------
BOOL FAR PASCAL AddressSearchProc(HWND hDlg, unsigned message,
													 WORD wParam, LONG lParam)
{
	switch(message)
	{
		//Initialize the dialog
		case WM_INITDIALOG	:
		{
			return(TRUE);
		}

		//User command
		case WM_COMMAND		:
		{
			switch(wParam)
			{
				//Cancel button, close the dialog and return a FALSE
				case IDCANCEL	:
				{
					EndDialog(hDlg,FALSE);
					break;
				}

				//OK Button pressed
				case IDOK	:
				{
					//Get the entered value for searching
					SendDlgItemMessage(hDlg,ID_SEARCH,WM_GETTEXT,sizeof(TempMainUnion.Main.address)-1,
														(long)(LPSTR)TempMainUnion.Main.address);

					EndDialog(hDlg,TRUE);
					break;
				}
			}
		}
		default	:
			return(FALSE);
	}
}

//--------------------------------------------------------------
//
//	BOOL FAR PASCAL MainProc()
//
//	Main procedure for the database demo dialog.
//
//--------------------------------------------------------------
BOOL FAR PASCAL MainProc(HWND hwnd, unsigned message,
												 WORD wParam, LONG lParam)
{
	static 		BOOL ADDING = FALSE;				//Record addition flag
	char 			RecNum[30],tempbuff[30];
	BOOL			Status;

	switch(message)
	{
		//Initialize the dialog
		case WM_INITDIALOG	:
		{
			//Call the DLL to get the first record from the named
			//	database
//			GetFirstRecord(DBName,MainUnion.buffer);
			GetFirstIndexEntry(DBName,CurrentIndex,MainUnion.buffer);

			//Get the current record number.  If deleted, mark with an
			//	asterisk
			if(!RecordDeleted(DBName))
			{
				wsprintf(RecNum,"%d",GetCurrentRecordNumber(DBName));
			}
			else
			{
				wsprintf(RecNum,"%d (Deleted)",GetCurrentRecordNumber(DBName));
			}

			//Update the record number
			SendDlgItemMessage(hwnd,ID_RECNUM,WM_SETTEXT,NULL,(long)(LPSTR)RecNum);

			//Update the name field
			SendDlgItemMessage(hwnd,ID_NAME,WM_SETTEXT,0,(long)(LPSTR)MainUnion.Main.name);

			//Update the address field
			SendDlgItemMessage(hwnd,ID_ADDRESS,WM_SETTEXT,0,(long)(LPSTR)MainUnion.Main.address);

			//Update the city field
			SendDlgItemMessage(hwnd,ID_CITY,WM_SETTEXT,0,(long)(LPSTR)MainUnion.Main.city);

			//Update the company field
			SendDlgItemMessage(hwnd,ID_COMPANY,WM_SETTEXT,0,(long)(LPSTR)MainUnion.Main.company);

			//Update the position field
			SendDlgItemMessage(hwnd,ID_POSITION,WM_SETTEXT,0,(long)(LPSTR)MainUnion.Main.position);

			//Update the age field
			wsprintf((LPSTR)tempbuff,"%d",MainUnion.Main.age);
			SendDlgItemMessage(hwnd,ID_AGE,WM_SETTEXT,0,(long)(LPSTR)tempbuff);

			//Update the salary field
			sprintf((LPSTR)tempbuff,"%10.5f",(float)MainUnion.Main.salary);
			SendDlgItemMessage(hwnd,ID_SALARY,WM_SETTEXT,0,(long)(LPSTR)tempbuff);

			//Update the yesno field
			wsprintf((LPSTR)tempbuff,"%c",MainUnion.Main.yesorno);
			SendDlgItemMessage(hwnd,ID_YORN,WM_SETTEXT,0,(long)(LPSTR)tempbuff);

			//Update the sort order field
			SendDlgItemMessage(hwnd,ID_SORTORDER,WM_SETTEXT,0,(long)(LPSTR)SortOrder[CurrentIndex]);

			return(TRUE);
		}

		//User command
		case WM_COMMAND		:
		{
			switch(wParam)
			{
      	//Purge the databases
				case ID_PURGE :
				{
					if(!ADDING)
          {
						if(PurgeDatabases())
						{
							//Read in the first record
							GetFirstIndexEntry(DBName,CurrentIndex,MainUnion.buffer);
						}
					}

					//Update the display
					SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);

					break;
				}

				//Set sort orders
				case ID_SORTNAME :
				{
					CurrentIndex=NAME_INDEX;
					SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
          break;
				}

				case ID_SORTAGE :
				{
					CurrentIndex=AGE_INDEX;
					SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
          break;
				}

				case ID_SORTADDRESS :
				{
					CurrentIndex=ADDRESS_INDEX;
					SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
          break;
				}

				case ID_SORTSALARY :
				{
					CurrentIndex=SALARY_INDEX;
					SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					break;
      	}

				//Locate a particular record by name
				case ID_FINDNAME :
				{
					//Initiate and display the search window
					SearchProcInst=MakeProcInstance((FARPROC)NameSearchProc,hInst);
					TempBool = DialogBox(hInst,(LPSTR)"NAME_SEARCH",hwnd,SearchProcInst);
					FreeProcInstance(SearchProcInst);

					//If CANCEL was pressed, abort
					if(!TempBool)
					{
						return(FALSE);
					}

					//Locate the record
					//if(!FindRecord(DBName,MainUnion.buffer,&TempMainUnion.buffer[NAME_OFFSET],STRING,NAME_OFFSET))
					if(!FindIndexEntryPartial(DBName,NAME_INDEX,TempMainUnion.buffer,MainUnion.buffer))
					{
						MessageBox(NULL,"Unable to Locate Record","Information",MB_OK|MB_ICONINFORMATION);
					}
					else
					{
						//Send a message to the window to update the
						//	display with the new data
						SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					}
					return(FALSE);
				}

				//Locate a particular record by salary
				case ID_FINDSALARY :
				{
					//Initiate and display the search window
					SearchProcInst=MakeProcInstance((FARPROC)SalarySearchProc,hInst);
					TempBool = DialogBox(hInst,(LPSTR)"SALARY_SEARCH",hwnd,SearchProcInst);
					FreeProcInstance(SearchProcInst);

					//If CANCEL was pressed, abort
					if(!TempBool)
					{
						return(FALSE);
					}

					//Locate the record
					//if(!FindRecord(DBName,MainUnion.buffer,&TempMainUnion.buffer[SALARY_OFFSET],FLOAT,SALARY_OFFSET))
					if(!FindIndexEntryPartial(DBName,SALARY_INDEX,TempMainUnion.buffer,MainUnion.buffer))
					{
						MessageBox(NULL,"Unable to Locate Record","Information",MB_OK|MB_ICONINFORMATION);
					}
					else
					{
						//Send a message to the window to update the
						//	display with the new data
						SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					}
					return(FALSE);
				}

				//Locate a particular record by age
				case ID_FINDAGE :
				{
					//Initiate and display the search window
					SearchProcInst=MakeProcInstance((FARPROC)AgeSearchProc,hInst);
					TempBool = DialogBox(hInst,(LPSTR)"AGE_SEARCH",hwnd,SearchProcInst);
					FreeProcInstance(SearchProcInst);

					//If CANCEL was pressed, abort
					if(!TempBool)
					{
						return(FALSE);
					}

					//Locate the record
					//if(!FindRecord(DBName,MainUnion.buffer,&TempMainUnion.buffer[AGE_OFFSET],INT,AGE_OFFSET))
				  if(!FindIndexEntryPartial(DBName,AGE_INDEX,TempMainUnion.buffer,MainUnion.buffer))
					{
						MessageBox(NULL,"Unable to Locate Record","Information",MB_OK|MB_ICONINFORMATION);
					}
					else
					{
						//Send a message to the window to update the display with the new data
						SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					}
					return(FALSE);
				}

				//Locate a particular record by address
				case ID_FINDADDRESS :
				{
					//Initiate and display the search window
					SearchProcInst=MakeProcInstance((FARPROC)AddressSearchProc,hInst);
					TempBool = DialogBox(hInst,(LPSTR)"ADDRESS_SEARCH",hwnd,SearchProcInst);
					FreeProcInstance(SearchProcInst);

					//If CANCEL was pressed, abort
					if(!TempBool)
					{
						return(FALSE);
					}

					//Locate the record
					//if(!FindRecord(DBName,MainUnion.buffer,&TempMainUnion.buffer[ADDRESS_OFFSET],STRING,ADDRESS_OFFSET))
					if(!FindIndexEntryPartial(DBName,ADDRESS_INDEX,TempMainUnion.buffer,MainUnion.buffer))
					{
						MessageBox(NULL,"Unable to Locate Record","Information",MB_OK|MB_ICONINFORMATION);
					}
					else
					{
						//Send a message to the window to update the
						//	display with the new data
						SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					}
					return(FALSE);
				}



				//Update the display from the update structure
				case ID_UPDATE_DISPLAY :
				{
					//Get the current record number.  If deleted, mark
					//	with an asterisk
					if(!RecordDeleted(DBName))
					{
						wsprintf(RecNum,"%d",GetCurrentRecordNumber(DBName));
					}
					else
					{
						wsprintf(RecNum,"%d*",GetCurrentRecordNumber(DBName));
					}

					//Update the record number
					SendDlgItemMessage(hwnd,ID_RECNUM,WM_SETTEXT,NULL,(long)(LPSTR)RecNum);

					//Update the name field
					SendDlgItemMessage(hwnd,ID_NAME,WM_SETTEXT,NULL,(long)(LPSTR)MainUnion.Main.name);

					//Update the address field
					SendDlgItemMessage(hwnd,ID_ADDRESS,WM_SETTEXT,NULL,(long)(LPSTR)MainUnion.Main.address);

					//Update the city field
					SendDlgItemMessage(hwnd,ID_CITY,WM_SETTEXT,NULL,(long)(LPSTR)MainUnion.Main.city);

					//Update the company field
					SendDlgItemMessage(hwnd,ID_COMPANY,WM_SETTEXT,NULL,(long)(LPSTR)MainUnion.Main.company);

					//Update the position field
					SendDlgItemMessage(hwnd,ID_POSITION,WM_SETTEXT,NULL,(long)(LPSTR)MainUnion.Main.position);

					//Update the sort order field
					SendDlgItemMessage(hwnd,ID_SORTORDER,WM_SETTEXT,NULL,(long)(LPSTR)SortOrder[CurrentIndex]);

					//Update the age order field
					wsprintf((LPSTR)tempbuff,"%d",MainUnion.Main.age);
					SendDlgItemMessage(hwnd,ID_AGE,WM_SETTEXT,NULL,(long)(LPSTR)tempbuff);

					//Update the salary field
					sprintf((LPSTR)tempbuff,"%10.5f",(float)MainUnion.Main.salary);
					SendDlgItemMessage(hwnd,ID_SALARY,WM_SETTEXT,0,(long)(LPSTR)tempbuff);

					//Update the yesno field
					wsprintf((LPSTR)tempbuff,"%c",MainUnion.Main.yesorno);
					SendDlgItemMessage(hwnd,ID_YORN,WM_SETTEXT,
														0,(long)(LPSTR)tempbuff);

					return(FALSE);
				}

				//Read the display and update the structure
				case ID_READ_DISPLAY :
				{
					//Get the name field
					SendDlgItemMessage(hwnd,ID_NAME,WM_GETTEXT,sizeof(MainUnion.Main.name)-1,
														(long)(LPSTR)MainUnion.Main.name);

					//Get the address field
					SendDlgItemMessage(hwnd,ID_ADDRESS,WM_GETTEXT,sizeof(MainUnion.Main.address)-1,
														(long)(LPSTR)MainUnion.Main.address);

					//Get the city field
					SendDlgItemMessage(hwnd,ID_CITY,WM_GETTEXT,sizeof(MainUnion.Main.city)-1,
														(long)(LPSTR)MainUnion.Main.city);

					//Get the compnay field
					SendDlgItemMessage(hwnd,ID_COMPANY,WM_GETTEXT,sizeof(MainUnion.Main.company)-1,
														(long)(LPSTR)MainUnion.Main.company);

					//Get the position field
					SendDlgItemMessage(hwnd,ID_POSITION,WM_GETTEXT,sizeof(MainUnion.Main.position)-1,
														(long)(LPSTR)MainUnion.Main.position);

					//Get the age field
					SendDlgItemMessage(hwnd,ID_AGE,WM_GETTEXT,sizeof(tempbuff)-1,(long)(LPSTR)tempbuff);
					MainUnion.Main.age=atoi((LPSTR)tempbuff);

					//Update the salary field
					SendDlgItemMessage(hwnd,ID_SALARY,WM_GETTEXT,sizeof(tempbuff)-1,(long)(LPSTR)tempbuff);
					MainUnion.Main.salary=atof(tempbuff);

					//Update the yesno field
					SendDlgItemMessage(hwnd,ID_YORN,WM_GETTEXT,sizeof(tempbuff)-1,(long)(LPSTR)tempbuff);
					MainUnion.Main.yesorno=tempbuff[0];

					return(FALSE);
				}

				//Call the about dialog procedure and display the about
				//	dialog
				case ID_ABOUT :
				{
					//Initiate and display the about window
					AboutProcInst=MakeProcInstance((FARPROC)AboutProc,
																				 hInst);
					DialogBox(hInst,(LPSTR)"ABOUT_DIALOG",hwnd,
										AboutProcInst);
					FreeProcInstance(AboutProcInst);
					return(FALSE);
				}

				//Get the next record from the database
				case ID_NEXT	:
				{
					//If the adding flag was set.  Cannot perform
					//	operation if adding
					if(ADDING)
					{
						//Abort the operation
						return(FALSE);
					}

					//Select the method to move through the database
					//Status=GetNextRecord(DBName,MainUnion.buffer);
					Status=GetNextIndexEntry(DBName,CurrentIndex,MainUnion.buffer);

					if(Status)
					{
						//Update the display if successful
						SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					}
					else
					{
						MessageBox(NULL,"Unable to Get the Next Record","Information",MB_OK|MB_ICONINFORMATION);
					}
					return(FALSE);
				}

				//Update the edited record to the database
				case ID_UPDATE	:
				{
					//If the adding flag was set.  Cannot perform
					//	operation if adding
					if(ADDING)
					{
						//Abort the operation
						return(FALSE);
					}

					//Read the data from the display
					SendMessage(hwnd,WM_COMMAND,ID_READ_DISPLAY,0L);

					if(UpdateRecord(DBName,MainUnion.buffer))
					{
						//Update the display
						SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					}
					else
					{
						MessageBox(NULL,"Unable to Update the Record","Information",MB_OK|MB_ICONINFORMATION);
					}
					return(FALSE);
				}


				//Delete the current record from the database
				case ID_DEL	:
				{
					//If the adding flag was set, abort.  Cannot perform the operation if adding
					if(ADDING)
					{
						//Abort the operation
						return(FALSE);
					}

					//Delete the current record
					if(DeleteRecord(DBName))
					{
						//Update the display
						SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					}
					else
					{
						MessageBox(NULL,"Unable to Delete Record","Information",MB_OK|MB_ICONINFORMATION);
					}
					return(FALSE);
				}

				//Get the previous record from the database
				case ID_PREV	:
				{
					//If the adding flag was set, abort.  Cannot perform
					//	the operation of adding
					if(ADDING)
					{
						//Abort the operation
						return(FALSE);
					}

					//Select the method to move through the database
//					Status=GetPreviousRecord(DBName,MainUnion.buffer);
					Status=GetPreviousIndexEntry(DBName,CurrentIndex,MainUnion.buffer);

					if(Status)
					{
						//Update the display
						SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					}
					else
					{
						MessageBox(NULL,"Unable to Get the Previous Record","Information",MB_OK|MB_ICONINFORMATION);
					}
					return(FALSE);
				}

				//Add a new record to the database
				case ID_ADD	:
				{
					//If the adding flag was not set, abort.  Prevents blank records
					if(!ADDING)
					{
						//Abort the operation to eliminate blank records in the database
						return(FALSE);
					}

					//Reset the adding flag
					ADDING=FALSE;

					//Read the data from the display
					SendMessage(hwnd,WM_COMMAND,ID_READ_DISPLAY,0L);

					//Add the record
					if(AddRecord(DBName,MainUnion.buffer))
					{
						//Send a message to update the display
						SendMessage(hwnd,WM_COMMAND,ID_UPDATE_DISPLAY,0L);
					}
					else
					{
						//Issue an error
						MessageBox(NULL,"Unable to Add the Record",
											"Information",MB_OK|MB_ICONINFORMATION);
					}
					return(FALSE);
				}

				//The clear button was selected, clear the entry
				//	fields
				case ID_CLEAR :
				{
					//Allow for the addition of a record if cleared.
					ADDING=TRUE;

					//Update the name field
					SendDlgItemMessage(hwnd,ID_NAME,WM_SETTEXT,NULL,(long)(LPSTR)"");

					//Update the address field
					SendDlgItemMessage(hwnd,ID_ADDRESS,WM_SETTEXT,NULL,(long)(LPSTR)"");

					//Update the city field
					SendDlgItemMessage(hwnd,ID_CITY,WM_SETTEXT,NULL,(long)(LPSTR)"");


					//Update the company field
					SendDlgItemMessage(hwnd,ID_COMPANY,WM_SETTEXT,NULL,(long)(LPSTR)"");

					//Update the position field
					SendDlgItemMessage(hwnd,ID_POSITION,WM_SETTEXT,NULL,(long)(LPSTR)"");

					//Update the age field
					SendDlgItemMessage(hwnd,ID_AGE,WM_SETTEXT,NULL,(long)(LPSTR)"0");

					//Update the salary field
					SendDlgItemMessage(hwnd,ID_SALARY,WM_SETTEXT,NULL,(long)(LPSTR)"0");

					//Update the yesorno field
					SendDlgItemMessage(hwnd,ID_YORN,WM_SETTEXT,NULL,(long)(LPSTR)"N");

					return(FALSE);
				}

				//The OK button was selected.  Exit the application
				case ID_OK	:
				{
					EndDialog(hwnd,TRUE);
					PostQuitMessage(0);
					KillTimer(hwnd,1);
					return(FALSE);
				}
			}
		}
		default	:
			return(FALSE);
	}
}

//-------------------------------------------------------------------------
//
//	int PASCAL WinMain()
//
//	Main window call function.  This function is called by WINDOWS 3.0
//	on startup.
//
//-------------------------------------------------------------------------
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
									 LPSTR lpszCmdParam, int nCmdShow)
{
	MSG				msg;
	BOOL			OK=TRUE;

	//Assign the process instance to a global for global
	//	window processing
	hInst=hInstance;

	//Load the database management DLL
	if((DBLIB = LoadLibrary("DLLDB.DLL"))<32)
	{
		MessageBox(NULL,"Unable to Load Database Manager","Error",MB_OK|MB_ICONSTOP);
		OK=FALSE;
	};

	//Setup the databases
	if(!SetupDatabases())
	{
		MessageBox(NULL,"Unable to Open Database","Error",MB_OK|MB_ICONSTOP);
		OK=FALSE;
	}

	if(OK)
	{
		//Initiate and display the document list window
		MainProcInst=MakeProcInstance((FARPROC)MainProc,hInst);
		MainWnd = DialogBox(hInst,(LPSTR)"MAIN_DIALOG",NULL,MainProcInst);

		//Process messages
		while(GetMessage((LPMSG)&msg,NULL,NULL,NULL))
		{
			TranslateMessage((LPMSG)&msg);
			DispatchMessage((LPMSG)&msg);
		}
	}


	//Free the procedure instance for the main dialog
	FreeProcInstance(MainProcInst);

	//Free DLLDB
	FreeLibrary(DBLIB);

	return(msg.wParam);
}




