;------------------------------------------------------------------
;  Function:  SYSDATE()
;
;   Description:   Returns the system date in packed format:
;
;        15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
;        --------------------  ----------  -------------
;             year                month          day
;
;   Syntax:   todaysdate = sysdate();
;        unsigned int   todaysdate;
;
;------------------------------------------------------------------

INCLUDE  PROGSEG.H

PUBLIC   sysdate
sysdate  PROC NEAR

    mov  ah,02ah
    int  21h                 ; call dos to get the system date
    mov  ax,cx
    sub  ax,1980             ; get rid of DOS format year bias
    mov  cl,4
    shl  ax,cl               ; room for month
    add  al,dh
    mov  cl,5                ; shift count to make room for the day
    shl  ax,cl
    add  al,dl               ; drop in the day

    ret
 
sysdate  ENDP
INCLUDE  ENDPSEG.H
END      sysdate




