include PROGSEG.H

;----------------------------------------------------------------------------
;   c_reate(filename,attr) - creates a file
;        char *filename - ptr to filename
;        int  attr      - attributes to use for file
;
;   returns file handle or        -1 - error
;
;----------------------------------------------------------------------------
public   c_reate
c_reate  proc near

         push bp
         mov  bp,sp

         mov  ax,03c00h
         mov  dx,4[bp]       ; get the file name
         mov  cx,6[bp]       ;get attributes of new file

         int  21h            ; call dos

         jnc  createx
         mov  ax,-1

createx:
         mov  sp,bp
         pop  bp
         ret

c_reate  endp

;-----------------------------------------------------------------------------
;
;   o_pen(filename,acc_code)
;        char *filename      - file name string
;        int  acc_code       - 0 - file opened for reading
;                              1 - file opened for writing
;                              2 - file opened for read/write
;   returns - file handle or error code ( see error table)
;----------------------------------------------------------------------------

public   o_pen 

o_pen    proc near

         push bp
         mov  bp,sp

         mov  dx,[bp+4]             ;offset, small model ds points already
         mov  al,[bp+6]             ;access code r/w/w-r
         mov  ah,03dh               ; open a file 
         int  21h

         jnc  openex
         mov  ax,-1

openex:  mov  sp,bp
         pop  bp
         ret

o_pen    endp

;-----------------------------------------------------------------------------
;   C_LOSE(fh) - closes a valid file handle
;        int  fh   - file handle
;
;   returns - 0 - successfull, -1 - invalid file handle
;-----------------------------------------------------------------------------

public   c_lose
c_lose   proc near

         push bp
         mov  bp,sp

         mov  bx,4[bp]       ; get file handle
         mov  ah,03eh        ; service to close a file handle

         int  21h
         mov  ax,00

         jnc  closex

         mov  ax,-1          ; tell prog that error occurred

closex:  mov  sp,bp
         pop  bp
         ret

c_lose   endp
;---------------------------------------------------------------------------
;   _DEL(filename) - deletes a file from the directory
;
;   char *filename - name of file to delete
;
;   returns   0 - success    or error code: 2 - file not found
;                                           5 - access denied
;----------------------------------------------------------------------------
public   _del
_del     proc near

         push bp
         mov  bp,sp

         mov  dx,4[bp]
         mov  ax,4100h
         int  21h

         jc  delex
         mov  ax,0

delex:   mov  sp,bp
         pop  bp
         ret

_del     endp



;----------------------------------------------------------------------------
;
;  l_seek(fh,offset,method)
;  int fh;             file handle
;  long offset;        offset in file to seek to (from start of file)
;   int  method;       - 0 - offset from beginning of file
;                       - 1 - offset from current position
;                       - 2 - from end of file
;
;  Seek to a specific position in file.
;
;------------------------------------------------------------------------------

PUBLIC  l_seek

l_seek PROC    NEAR
        push    bp
        mov     bp,sp

;       Basically lseek(fh,offset,method)

        mov     ah,42h                 
        mov     bx,[bp+4]              ;file handle
        mov     cx,[bp+8]              ;offset (most significant)
        mov     dx,[bp+6]              ;       (least significant)
        mov     al,[bp+10]             ; get seek method

        int     21h

seekex: mov     sp,bp
        pop     bp
        ret

l_seek ENDP


;*****************************************************************************
;
;  r_ead(fh,bp,bl)
;  int fh;                     /* file handle */
;  char near *bp;               /* memory loc to read to */
;  unsigned int bl;            /* amount to read */
;
;  Read a buffer from the current location in file.
;
;*****************************************************************************

         PUBLIC  r_ead

r_ead    PROC NEAR
         push bp
         mov  bp,sp

         mov  ah,3fh              ;read file
         mov  bx,[bp+4]           ;file handle
         mov  cx,[bp+8]           ;bl (buffer length)
         mov  dx,[bp+6]           ;bp (buffer pointer)
         int  21h

         jnc  readex
         mov  ax,-1               ; error reading file

readex:  mov  sp,bp
         pop  bp
         ret

r_ead    ENDP


;*****************************************************************************
;
;  w_rite(fh,bp,bl)
;  int fh;                     /* file handle */
;  char near *bp;              /* memory loc to read to */
;  unsigned int bl;            /* amount to read */
;
;  Write a buffer to the current location in file.
;
;*****************************************************************************

        PUBLIC  w_rite
 w_rite   PROC NEAR
          push    bp
          mov     bp,sp

          push    ds                     ;save current data seg

          mov     ah,40h               ;write file
          mov     bx,[bp+4]            ;file handle
          mov     cx,[bp+8]            ;bl(buffer length)
          mov     dx,[bp+6]            ;bp (buffer pointer)
          int     21h

          jnc     writex               ;jmp if no error
          mov     ax,-1                ;tell caller error happened

writex:   mov     sp,bp
          pop     bp
          ret

w_rite    ENDP


;*****************************************************************************
;
;  _setftime(fh,date,time)
;  int fh;                     /* file handle */
;  unsigned int date;          /* date to set on file */
;  unsigned int time;          /* time to set on file */
;
;  Set the creation/revision date/time on a file.
;
;*****************************************************************************

        PUBLIC  _setftime

_setftime PROC NEAR
        push    bp
        mov     bp,sp

        mov     ax,5701h               ;set file date/time function
        mov     bx,[bp+4]              ;file handle
        mov     cx,[bp+8]              ;file time
        mov     dx,[bp+6]              ;file date
        int     21h

        mov     sp,bp                  ;no error checking done
        pop     bp
        ret

_setftime ENDP


;-----------------------------------------------------------------------------
;
;  _getcdir(drive,buffer)
;  int drive;
;  char *buffer;
;
;  Get the current dir for given drive.
;
;-------------------------------------------------------------------------------

        PUBLIC  _getcdir

_getcdir PROC NEAR
         push bp
         mov  bp,sp

         push si

         mov  ah,47h                 ;get current dir
         mov  dl,BYTE PTR [bp+4]     ;drive code to DL
         mov  si,[bp+6]              ;buffer ptr to DS:SI
         mov  BYTE PTR [si],0        ;make sure its terminated if error
         int  21h
         
         pop  si
         
         mov  sp,bp                  ;no error checking done
         pop  bp
         ret
         
_getcdir ENDP

;-----------------------------------------------------------------------------
;
;  _chdir(dir_name)
;  char *dir_name;           /* name of directory to make current */
;
;   returns   0 - successfull,  -1 - error
;-------------------------------------------------------------------------------

         PUBLIC  _chdir

_chdir PROC NEAR
         push bp
         mov  bp,sp


         mov  ah,3bh                 ;get current dir
         mov  dx,4[bp]               ; get offset to new dir name
         int  21h

         mov  ax,0
         jnc  endset
         mov  ax,-1

endset:
         mov  sp,bp                  ;no error checking done
         pop  bp
         ret
         
_chdir ENDP

;-----------------------------------------------------------------------------
;   _MKDIR(dir_name)    - creates a new subdirectory
;
;   char *dir_name      - ptr to name of directory to create
;
;   returns   - 0 - successfull        3 - path not found
;                                      5 - access denied
;----------------------------------------------------------------------------

public   _mkdir
_mkdir   proc near

    push bp
    mov  bp,sp

    mov  dx,4[bp]       ; get ptr to dir to make
    mov  ax,3900h
    int  21h            ; call dos

    jc   mkdirex        ; keep error code in ax for return
    mov  ax,00          ; no error


mkdirex:
    mov  sp,bp
    pop  bp
    ret
_mkdir   endp


;-----------------------------------------------------------------------------
;   _RD(dir_name)  - removes a subdirectory
;
;   char *dir_name - ptr to dir name to remove
;
;   returns - 0 - successful      or  error code: 3 - path not found
;                                                 5 - dir not empty or 
;                                                     access denied
;------------------------------------------------------------------------------

public   _rd
_rd proc near

         push bp
         mov  bp,sp

         mov  dx,4[bp]       ; get dir name to remove
         mov  ax,03a00h
         int  21h

         jc   rdex
         mov  ax,0

rdex:    mov  sp,bp
         pop  bp
         ret
_rd endp





;-----------------------------------------------------------------------------
;
;  _setattrib(fn,attrs)
;  char *fn;                   /* file name */
;  unsigned int attrs;         /* attributes to set */
;
;  Set the file attributes
;
;-----------------------------------------------------------------------------

        PUBLIC  _setattrib

_setattrib PROC NEAR
        push    bp
        mov     bp,sp

        mov     ax,4301h               ;CHMOD dos function
        mov     cx,[bp+6]              ;file attributes
        mov     dx,[bp+4]              ;file name
        int     21h

        mov     sp,bp                  ;no error checking done
        pop     bp
        ret

_setattrib ENDP


;-----------------------------------------------------------------------------
;
;  unsigned int _getattrib(fn)
;  char *fn;                   /* file name */
;
;  get the file attributes
;  returns attributes in ax
;-----------------------------------------------------------------------------

        PUBLIC  _getattrib

_getattrib PROC NEAR
        push  bp
        mov   bp,sp

        mov   ax,4300h                 ;CHMOD dos function
        mov   dx,[bp+4]                ;file name
        int   21h

        mov   ax,cx                    ; mov attributes to cx for return to C
        mov   sp,bp                    ;no error checking done
        pop   bp
        ret

_getattrib endp

include  endpseg.h

         end
