/*-----------------------------------------------------------------------
    Name:     DBASE.H

    Function: This header file defines the data structures used to 
              read the dBASE file

    Note:     This is for dBASE III plus ONLY !

         Copyright (c) 1987 LOGITEK
-------------------------------------------------------------------------*/


struct   db_head   {

         char vers;
         unsigned char  yy,
                        mm,
                        dd;
         unsigned long int   no_recs;
         unsigned int   head_len,
                        rec_len;

         char reserved[20];
};

typedef struct db_head   DBF_HEAD;

struct   fld_stru  {

         char name[11],
              type;

         struct fld_stru     *next,
                             *prev;

         unsigned  char fld_len,
                        decimals;

         unsigned int offset;
                                       /* these four bytes are listed as
                                          reserved for the actual disk based
                                          structure */
         char *fld_val;
         char reserved[10];            /* reserved */
};

typedef  struct    fld_stru  FIELD;


struct   _dbf  {
    char filename[64];            /* file name, max len 64 with dir path */
    int  fh;                      /* file handle returned by DOS */
    char updated,                 /* boolean value, indicates if file was updated */
         deleted;                 /* boolean t/f if curr rec is deleted */
    DBF_HEAD  header;             /* actual header struct of file */
    long int  curr_rec;           /* current record in the dbf */
    FIELD     *fields;            /* pointer to a list of field structs */
    int       no_fields;          /* number of fields in the struct */
    char      *record;            /* pointer to record buffer */
};

typedef  struct    _dbf DBF;

