// *********************************************** //
// DbClient.C: Program to manage the flow of the
// messages to the listbox.
// *********************************************** //

#include <windows.h>
#include "stdio.h"
#include "DbClient.H"
#include "DBPUTS.H"
#include "string.h"

HANDLE hInst;
HWND	hDbLog = (HWND) NULL;

#pragma argsused
// **************************************************
// WinMain function.
// --------------------------------------------------
// Note that there is no "FAR" used in the call here.
// **************************************************
int PASCAL WinMain(
HANDLE hi,
HANDLE hPrevi,
LPSTR lpCmdLine,
int nCmdShow )
{
	MSG msg;

	if (!hPrevi)
	if (!MkClass(hi))
		return (FALSE);


	if (!MkWindow(hi, nCmdShow))
		 return (FALSE);


	while (GetMessage(&msg,
		NULL,
		NULL,
		NULL))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return (msg.wParam);
}


// **************************************************
// Function MkClass()
// --------------------------------------------------
// Register the class.
// **************************************************
BOOL MkClass(
HANDLE hi)
{
	WNDCLASS  wc;

	wc.style = NULL;
	wc.lpfnWndProc = DbMessageClient;

	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hi;
	wc.hIcon = LoadIcon(hi, (LPSTR) "DbClientIcon");
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName =  "DbClientMenu";
	wc.lpszClassName = "DbClientClass";


	return (RegisterClass(&wc));

}


// **************************************************
// Function MkWindow()
// --------------------------------------------------
// Perform a standard Windows window initalization.
// **************************************************
BOOL MkWindow(
HANDLE	hi,
int		nCmdShow)
{
	HWND	hWnd;

	hInst = hi;


	hWnd = CreateWindow(
		 "DbClientClass",
		 "DbClient Application",
		 WS_OVERLAPPEDWINDOW,
		 CW_USEDEFAULT,
		 CW_USEDEFAULT,
		 220,					// CX
		 170,					// CY
		 NULL,
		 NULL,
		 hi,
		 NULL
	);


	if (!hWnd)
		 return (FALSE);


	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	return (TRUE);

}


// **************************************************
// DbMessageClient()
// --------------------------------------------------
// This is the MainWinProc().  Simply creates a list
// box, and manages the string flow from the DLL.
// **************************************************
long FAR PASCAL DbMessageClient(
HWND hWnd,
WORD message,
WORD wP,
LONG lP)
{
	FARPROC lpAbout;

	switch (message)
	{
	case WM_COMMAND:
		switch(wP)
		{
			case MSG_ABOUT:

				lpAbout = MakeProcInstance(About, hInst);

				DialogBox(hInst,
					"AboutBox",
					hWnd,
					lpAbout);

				FreeProcInstance(lpAbout);

			break;

			// This message will send the message via the DLL.
			case MSG_DbClient:
			{
			static int times = 0;
			char buf[80];

				sprintf(buf,"Client Message #%d.", times++);
				DbPuts(buf);
			}
			break;

			default:
				return (DefWindowProc(hWnd, message, wP, lP));
		}
	break;

	case WM_DESTROY:

		PostQuitMessage(0);
	break;


	default:
		return (DefWindowProc(hWnd, message, wP, lP));
	}

	return (NULL);
}


#pragma argsused
// **************************************************
// Function ABOUT
// --------------------------------------------------
// A simple ABOUT procedure.
// **************************************************
BOOL FAR PASCAL About(
HWND hDlg,
unsigned message,
WORD wP,
LONG lP)
{
	switch (message) {
	case WM_INITDIALOG:
		return (TRUE);

	case WM_COMMAND:
		if (wP == IDOK
					|| wP == IDCANCEL) {
		EndDialog(hDlg, TRUE);
		return (TRUE);
		}
		break;
	}
	return (FALSE);
}

