#include "dbops.h"

/* question types */
#define FREE_FORM							1
#define MULTI_CHOICE						2
#define TITLE								3
#define BUTTON								4
#define REDUCE								5
#define LIST								6
#define SCROLLING_TEXT						7
#define RCBUTTON							8

#define CURRQ				(db_ptr->questions[db_ptr->id_select])
#define CURRTILE			(db_ptr->questions[db_ptr->id_select])[1]
#define CURRAVAIL			(db_ptr->available[db_ptr->id_select])
#define LISTAVAIL			(list_ptr->available[list_ptr->selected] == 1)
#define LISTTITLE			(list_ptr->available[list_ptr->selected] == 2)
#define CURRMC				((multi_choice *)(db_ptr->questions[db_ptr->id_select]))
#define CURRSCROLLQ			((scroll_txt *)(db_ptr->questions[db_ptr->id_select]))
#define CURRFF				((free_form *)(db_ptr->questions[db_ptr->id_select]))
#define CURRR				((reducer *)(db_ptr->questions[db_ptr->id_select]))
#define CURRBUTTON			((button *)(db_ptr->questions[db_ptr->id_select]))
#define CURRRCBUTTON		((rcbutton *)(db_ptr->questions[db_ptr->id_select]))
#define CURRLIST			((list *)(db_ptr->questions[db_ptr->id_select]))
#define DBERROR(errnum,	functnum) {db_errorhandler(errnum,functnum); return(errnum);}
#define MCQUEST(id)			((multi_choice *)(db_ptr->questions[id]))
#define FFQUEST(id)			((free_form *)(db_ptr->questions[id]))
#define ROOTQUEST(id)		((root *)(db_ptr->questions[id]))
#define RQUEST(id)			((reducer *)(db_ptr->questions[id]))
#define BUTTONQUEST(id)		((button *)(db_ptr->questions[id]))
#define RCBUTTONQUEST(id)	((rcbutton *)(db_ptr->questions[id]))
#define LISTQUEST(id)		((list *)(db_ptr->questions[id]))
#define TITLEQUEST(id)		((title *)(db_ptr->questions[id]))
#define SCROLLQUEST(id)		((scroll_txt *)(db_ptr->questions[id]))
#define QTYPE(id)			*((char *)(db_ptr->questions[id]))
#define NO_EVENT			((*db_head) == (*db_tail))
#define DB_MOVABLE			db_ptr->move_ok
#define LST_MOVABLE			list_ptr->move_ok
#define DB_SIZABLE			db_ptr->size_ok
#define LST_SIZABLE			list_ptr->size_ok
#define ID_NEXT				(db_ptr->questions[db_ptr->id_select+1] ? db_ptr->id_select + 1 : 0)
#define ID_PREV				(db_ptr->id_select ? db_ptr->id_select - 1 : db_lastq(db_ptr))
#define makemacro(name,key,function)	unsigned long name[] = {key+(3*65536L),(unsigned long) function,EXECUTE};

/* list types */
#define CHECKLIST							1
#define SELECT_ONE							2

/* rc button types */
#define CHECK								0
#define RADIO(n)							(1+n)

typedef struct {

	/* foreground and background colors of titles */
	unsigned char title_bg, title_fg;

	/*
	 * foreground and background colors of the statement portion
	 * of questions
	*/
	unsigned char question_bg, question_fg;

	/*
	 * foreground and background colors of the response portion
	 * of questions: available, unavailable, selected unavailable, &
	 * selected available.
	*/
	unsigned char response_bg, response_fg;
	unsigned char un_bg, un_fg;
	unsigned char sun_bg, sun_fg;
	unsigned char select_bg, select_fg;

	/*
	 * foreground & background colors of the shortcut keys
	*/
	unsigned char key_bg, key_fg;

	/*
	 * foreground and background colors to be used when editing a
	 * text response.
	*/
	unsigned char edit_bg, edit_fg;

} db_colors;

typedef struct {

	/*
	 * The characters to place around the response portion of a free
	 * form question.  These character arrays are defined the same
	 * as the window border character arrays.  Note that any NULL
	 * characters are simply not output.  This means that you do not
	 * have to triple space questions as you would by putting a
	 * complete box around each, but could just define delimiters
	 * on either side (as in DBPRO 1.1) or even none at all.
	*/
	unsigned char *ff_boxchars;

	/* multiple choice delimiters */
	unsigned char *mc_boxchars;

	/* reducer delimiters */
	unsigned char *r_boxchars;

	/*
	 * the characters to place to the left of a check box when checked
	 * and not checked -- note that these must be the same length!
	*/
	char *check_on, *check_off;

	/*
	 * the characters to place to the left of a radio button when checked
	 * and not checked -- note that these must be the same length!
	*/
	char *radio_on, *radio_off;

} db_delimiters;

/* storage record -- keeps previous answers to a dialog box in case of abort */
typedef struct {

	/* type of question being stored */
	unsigned char question_type;

	/* the question's id */
	unsigned char id;

	/*
	 * pointer to the next storage record -- used in creating a linked
	 * list of storage records to let you preserve a snapshot of the
	 * db at any point
	*/
	void *next;

	/*
	 * Used to store either -- a pointer to a string for the response
	 * to a free form question or an integer representing an offset
	 * into a multiple choice list
	*/
	void *keeper;

} storage;


/*
 * the state of the list is temporarily stored in this structure on a
 * call to lst_run.  If the user confirms the list -- then this data
 * is discarded otherwise it is used to restore the list to its previous
 * state.
*/

typedef struct {
	char *selections;
	int selected;
} lst_storage;

/* list handler record */
typedef struct {

	unsigned handle;				/* a window where the list will be
									   be displayed */
	unsigned char tile_handle;		/* the tile within the window where
									   the list will be displayed */
	char list_type;					/* CHECKLIST or SELECTONE */
	char move_ok, size_ok;			/* is the window movable/sizable? */
	char auto_vert;					/* resize the viewport vertically to
									   match the width of the elements
									   within the list on each call to
									   lst_run */
	char auto_horiz;				/* resize the viewport horizontally
									   to match the number of elements
									   within the list on each call to
									   lst_run */
	char alpha_confirm;				/* Pressing the shortcut key of an
									   item toggle it on off? */
	char bg_operation;				/* of FALSE the window is brought
									   to the top of the stack of windows
									   on each call to lst_run */
	int selected;					/* the currently selected element */
	int numopts, taglen, optlen;	/* used internally by lst_run */
	unsigned *cmds;					/* keyboard command table used in this
									   list */
	char *on, *off;					/* the strings to place to the left of
									   of each element to indicate whether
									   an items is toggled on or off */
	char **options;					/* a null terminated list of char strings
									   representing the elements of the list */
	char *selections;				/* a list of chars which corresponds to the
									   list of elements where: 1 = toggled on,
									   2 = toggled off. */
	char *available;				/* a list of chars which corresponds to the
									   list of elements where: 0 = element
									   can not be toggled, 1 = element can
									   be toggled, and 2 = element is a title */
	unsigned *keybind;				/* a list of keyboard codes which corresponds
									   to the list of elements representing
									   the shortcut key for each element */
	db_colors *colors;				/* the color scheme to be used when
									   displaying the list */
	lst_storage *insurance;			/* set to NULL. Used internally */
	unsigned **macros;				/* a list of local macros for the list */
	unsigned maxcols;				/* a list of the maximum number of side
									   by side columns to display the elements
									   in. */
	unsigned						/* this info is used to create a valid */
		physical_x,					/* window to display the list in if the */
		physical_y,					/* window handle (above) is not valid */
		virtual_x, virtual_y,
		virtual_rows,
		virtual_columns,
		port_rows,
		port_columns,
		shading;
	char *name1,
		*name2;
	unsigned char
		*boxchars;
} list_rec;

/*
 * all question types (except titles) have this same info in these
 * same positions.  This type is used to access these values from
 * any question pointer.
*/
typedef struct {
	char question_type;
	unsigned char tile_handle;
	int (far *whenon)(void *);
	int (far *whenoff)(void *);
	int (far *action)(void *);
	char *statement;
	int statementx, statementy;
	unsigned key;
} root;

/* free form question record */
typedef struct {

	/* Must be set equal to FREE_FORM */
	char question_type;

	/* tile to display the question in */
	unsigned char tile_handle;

	/*
	 * pointer to edit check routines -- you can use this to
	 * check that a string represents a valid number, etc. that
	 * the item is within a certain range etc.  The routine must
	 * return an integer.
	 *
	 * Set this value to NULL to perform no edit checking on the
	 * question.
	*/
	int (far *whenon)(void *);

	/*
	 * same as above except it does not allow the user to navigate
	 * off of the question until the routine returns TRUE
	*/
	int (far *whenoff)(void *);

	/*
	 * same as above but does not allow a user to exit a question
	 * until it returns TRUE.
	*/
	int (far *action)(void *);

	/* statement portion of the question -- e.g. How many inches? */
	char *statement;

	/* the statement begins at this coordinate */
	int statementx, statementy;

	/* short cut key for navigating to this question */
	unsigned key;

	/*
	 * the current response to the question; This must be a dynamically
	 * allocated string (or NULL) because db_run will free this and replace it
	 * with the edited version.
	*/
	char *response;

	/*
	 * If response (above) is NULL db_run automatically creates a dynamically
	 * allocated duplicate of this string and assigns it to response.
	*/
	char *default_response;

	/* the beginning coordinate of the response */
	int responsex, responsey;

	/*
	 * the maximum displayed length of the response -- the actual
	 * length can be longer
	*/
	int responselen;

	/*
	 * used internally
	*/
	char *insurance,

	/*
	 * this pointer is set to the the value of response (above) on
	 * exiting the dialog box.  This introduces two copies of a
	 * a dynamically allocated variable -- do not free this pointer
	 * without setting response (above) to NULL.  Otherwise, next time
	 * you execute db_run response (above) will be free'd corrupting
	 * the heap.
	*/
	**target;

	/*
	 * the default cursor position when entering edlin.  Normally
	 * this is set to the last character in the string on exiting
	 * the line editor.  But if you prefer to not do this you can
	 * remove the statement from db_edlin whereupon this variable
	 * will hold the position of the cursor in the line editor when
	 * you last exited the question.
	*/
	int cursor_position;

	/* local macro definitions */
	unsigned **macros;

	/*
	 * If TRUE statement, delimiters, and response are
	 * redrawn. Otherwise, just the response are is redrawn.
	 * This flag is set to FALSE after drawing the statement,
	 * delimiters, and response
	*/
	char refresh;

} free_form;

/* list question record */
typedef struct {

	/* Must be set equal to LIST */
	char question_type;

	/* tile to display the question in */
	unsigned char tile_handle;

	/*
	 * edit check routines -- see explanation in free_form.
	*/
	int (far *whenon)(void *);
	int (far *whenoff)(void *);
	int (far *action)(void *);

	/* the title of the list */
	char *statement;

	/* the statement begins at this coordinate */
	int statementx, statementy;

	/* shortcut key */
	unsigned key;

	/* CHECKLIST or SELECTONE */
	char list_type;

	/* a list question uses a window for some interim stuff -- supply a handle here */
	unsigned handle;

	unsigned				/* if handle (above) is not a valid handle */
		virtual_rows,		/* we use this info to create a window */
		virtual_columns,
		physical_x,
		physical_y,
		virtual_x,
		virtual_y,
		port_rows,
		port_columns,
		shading;
	char *name1, *
		name2;
	unsigned char *boxchars,
		scroll_bars;

	/* the currently selected item in the list */
	int offset;

	/* the items in the list */
	char **options;

	/* are they available -- see explanation in list_rec */
	char *available;

	/* which are toggled on/off -- see explanation in list_rec */
	char *selected;

	/* the on -- off designators */
	char *on, *off;

	/* list pointer -- normally set to NULL -- used internally */
	list_rec *list_ptr;

	/* set to the value of selected (above) when the db is exited */
	char **target;

	/* macro definitions */
	unsigned **macros;

	/*
	 * set this to TRUE if you have modified any members of this
	 * structure.  Always set to TRUE on first usage.
	*/
	char refresh;

	/*
	 * set to TRUE if on selecting the list you want to automatically
	 * place the cursor in the list -- note that after you
	 * exit a list this value is set to TRUE.   Set this to FALSE
	 * initially for MAC/WINDOWS-like behavior.
	*/
	char autodescend;

	/*
	 * if you want a simple vertical list use 1.  If you want two
	 * columns side by side set to 2.  If you want the minimum number
	 * of columns required given the height of the list's viewport
	 * set this to MAXINT.
	*/
	unsigned maxcols;

} list;

/* scrolling text question record */
typedef struct {

	/* Must be set equal to SCROLLING_TEXT */
	char question_type;

	/* tile to display the question in */
	unsigned char tile_handle;

	/* edit check routines -- see free_form for explanation */
	int (far *whenon)(void *);
	int (far *whenoff)(void *);
	int (far *action)(void *);

	/* box title */
	char *statement;

	/* coordinates for the sub-box */
	unsigned statementx, statementy;

	/* shortcut key */
	unsigned key;

	/*
	 * the function which is called on entering the question -- determines
	 * behavior of the question.
	*/
	int (far *control)(void *, int);

	/*
	 * use to associate additional data with the text, you might
	 * use this data in edit checking or action routines.
	*/
	void *misc_ptr;

	/*
	 * the box is in this position in the dialog box
	 * You should set it to the appropriate size before calling the
	 * dialog box.
	*/
	int boxx, boxy;

	/* uses a window for some interim stuff -- supply a handle here */
	unsigned aux_handle;

	/* macro definitions */
	unsigned **macros;

} scroll_txt;

/* multiple choice question record */
typedef struct {

	/* must be set to MULTI_CHOICE */
	char question_type;

	/* the tile to display the question in */
	unsigned char tile_handle;

	/*
	 * edit check routines -- see free_form for explanation
	*/
	int (far *whenon)(void *);
	int (far *whenoff)(void *);
	int (far *action)(void *);

	/* the statement portion of the question */
	char *statement;

	/* begin displaying the statement at these coordinates */
	int statementx, statementy;

	/* shortcut key */
	unsigned key;

	/*
	 * response mask -- will display this string in place of the
	 * current response.  Normally set to NULL but is useful
	 * in creating a menu bar type dialog box, where the menu bar
	 * represents a series of multiple choice questions.  Or in
	 * inserting pulldown menus anywhere in a dialog box.
	*/
	char *response_mask;

	/* Pointer to an array of pointers -- pointing to each of the
	 * available responses in a multiple choice question.  The
	 * last pointer in the array must be a null pointer.
	*/
	char **response_list;

	/*
	 * corresponds to above array.  A value of TRUE indicates that
	 * the item is available for selection.  FALSE, it is not. 2 if
	 * the element is a title.
	*/
	char *available;

	/*
	 * The offset into the above array representing the current response
	 * to the question.
	*/
	int response_offset;

	/* the beginning coordinate of the response */
	int responsex, responsey;

	/*
	 * the maximum displayed length of the response -- the actual
	 * length can be longer
	*/
	int responselen;

	/* window and tile to display the pull down list in */
	unsigned aux_handle;
	unsigned char aux_tile;

	/*
	 * if the handle (above) is invalid use this info to create
	 * a window
	*/
	unsigned char
		*boxchars;
	char *major_head,
		*minor_head,
		shading;

	/* list pointer -- normally set to NULL -- used internally */
	list_rec *list_ptr;

	/* set to the value of response_offset on exiting the dialog box */
	int *target;

	/* macro definitions */
	unsigned **macros;

	/*
	 * indicate the number of side by side columns desired in the pull
	 * down list.  use 1 for a vertical list, MAXINT for a horizontal list,
	 * 2 for a 2 column vertical list, etc.
	*/
	unsigned maxcols;

	/*
	 * If TRUE statement, delimiters, and response are
	 * redrawn. Otherwise, just the response are is redrawn.
	 * This flag is set to FALSE after drawing the statement,
	 * delimiters, and response
	*/
	char refresh;

} multi_choice;

/* reducer question record */
typedef struct {

	/* must be set to REDUCER */
	char question_type;

	/* the tile to display the question in */
	unsigned char tile_handle;

	/*
	 * edit checking routines -- see free_form for explanation
	*/
	int (far *whenon)(void *);
	int (far *whenoff)(void *);
	int (far *action)(void *);

	/* the statement portion of the question */
	char *statement;

	/* begin displaying the statement at these coordinates */
	int statementx, statementy;

	/* shortcut key */
	unsigned key;

	/* Pointer to an array of pointers -- pointing to each of the
	 * available responses in a reducer question.  The
	 * last pointer in the array must be a null pointer.
	*/
	char **response_list;

	/*
	 * corresponds to above array.  A value of TRUE indicates that
	 * the item is available for selection.  FALSE, it is not. 2 is
	 * a title.
	*/
	char *available;

	/*
	 * the current response -- must be a dynamically allocated string
	 * just like in a free_form question. or NULL.  If NULL a dynamically
	 * allocated string is created from default_response.
	*/
	char *response;
	char *default_response;

	/* the beginning coordinate of the response */
	int responsex, responsey;

	/*
	 * the maximum displayed length of the response -- the actual
	 * length can be longer
	*/
	int responselen;

	/* see multi_choice for explanation */
	unsigned aux_handle;
	unsigned char aux_tile;
	unsigned char *boxchars;
	char *major_head, *minor_head, shading;

	/* set to NULL -- used internally */
	list_rec *list_ptr;
	char *insurance,

	/* set to the value of the list element selected. */
	**target;

	/* see free_form for explanation */
	int cursor_position;

	/* macro definitions */
	unsigned **list_macros;
	unsigned **edlin_macros;

	/* see multi_choice for explanation */
	unsigned maxcols;

	/*
	 * If TRUE statement, delimiters, and response are
	 * redrawn. Otherwise, just the response are is redrawn.
	 * This flag is set to FALSE after drawing the statement,
	 * delimiters, and response
	*/
	char refresh;

} reducer;


/* title record */
typedef struct {

	/* MUST be set to TITLE */
	char question_type;

	/* tile to display the title in */
	unsigned char tile_handle;

	/* the title itself */
	char *statement;

	/* beginning coordinate of the title */
	int statementx, statementy;

	/* center justifies the title if TRUE */
	char center_justify;


} title;


/* button record */
typedef struct {

	/* MUST be set to BUTTON */
	char question_type;

	/* the tile to display the question in */
	unsigned char tile_handle;

	/*
	 * see free_form for explanation
	*/
	int (far *whenon)(void *);
	int (far *whenoff)(void *);
	int (far *action)(void *);

	/* the statement portion of the question */
	char *statement;

	/*
	 * coordinate to display the button at
	*/
	int statementx, statementy;

	/* shorcut key */
	unsigned key;

	/*
	 * array of characters to be used in building the box around
	 * the statement -- set to NULL for no box
	*/
	unsigned char *boxchars;

	/*
	 * Shading to be used in making a box around the statement
	*/
	char shading;

	/*
	 * Resets the keyboard code on pressing a button to this value.
	 * This lets you use buttons like an extension of the keyboard.
	 * You can have buttons that mimic hitting the ENTER key, etc.
	*/
	unsigned cmdkey;

	/*
	 * This value binds a keyboard code to a button.  This way you
	 * don't actually have to navigate to a button to 'press it.'
	*/
	unsigned keybind;

	/*
	 * if TRUE, holding the mouse on the button will continually
	 * put the value key (above) onto the queue
	*/
	char continuous;

	/*
	 * This lets you modify the exit value from db_run on pressing a
	 * button.  This code can then let your application know which
	 * button was pressed -- in order to perform the proper operation
	*/
	unsigned exitval;

} button;

/* radio/check button record */
typedef struct {

	/* MUST be set to RCBUTTON */
	char question_type;

	/* the tile to display the question in */
	unsigned char tile_handle;

	/* edit checking routines */
	int (far *whenon)(void *);
	int (far *whenoff)(void *);
	int (far *action)(void *);

	/* the statement portion of the question */
	char *statement;

	/*
	 * coordinate to display the radio button/checkbox at
	*/
	int statementx, statementy;

	/* the keyboard code for the shortcut key */
	unsigned key;

	/* CHECK or RADIO(N) where N indicates a group number from 0 to 254 */
	unsigned char btype;

	/* TRUE if the button is checked */
	char checked;

	/* set to the value of checked (above) when the dialog box is exited */
	char *target;

} rcbutton;

/* db record */
typedef struct {

	unsigned handle;			/* window where the db will be displayed */
	int (*post_size)(void *);	/* if window is resized this function is called */
	int (*post_move)(void *);	/* if window is moved this function is called */
	char move_ok, size_ok;		/* allows moving and/or sizing */
	void **questions;			/* a null terminated list of pointers to the
								   questions composing the db */
	char *available;			/* a list of chars indicating which questions
								   can be modified, where 0 = NO, 1 = YES */
	unsigned char id_select;	/* the question which will initially be
								   selected */
	unsigned *cmds;				/* keyboard command table -- i.e. which keys
								   are bound to which operations */
	char bg_operation;			/* if FALSE the dialog box window is always
								   brought to the top of the stack of windows
								   when the dbrun is called. */
	db_colors *colors;			/* a pointer to the color scheme to be used
								   in this db */
	db_delimiters *delimiters;	/* a pointer to the delimiter types to use
								   when displaying the questions in this
								   dialog box */
	storage *insurance;			/* set this to NULL.  This pointer is used
								   to keep a record of the dialog box
								   responses, before any changes are made.
								   This record can then be used to restore
								   the dialog box answers is necessary */
	unsigned **macros;			/* a list of local macros to be used in this
								   dialog box */
	unsigned					/* all of this info is used to create a */
		virtual_rows,			/* window to display the dialog box if  */
		virtual_columns,        /* the handle specified above is not a  */
		physical_x,				/* valid window handle */
		physical_y,
		virtual_x,
		virtual_y,
		port_rows,
		port_columns,
		shading;
	char *name1,
		*name2;
	unsigned char
		*boxchars,
		scroll_bars,
		fg, bg;
} dialog_box;

extern int 		db_display(dialog_box *);
extern int 		db_display_title(dialog_box *, title *);
extern int 		db_display_ff(dialog_box *, free_form *, char, char);
extern int 		db_display_mc(dialog_box *, multi_choice *, char, char);
extern int 		db_display_button(dialog_box *, button *, char, char);
extern int 		db_display_rcbutton(dialog_box *, rcbutton *, char, char);
extern void 	clearradiobutton(dialog_box *, unsigned char);
extern int 		db_display_scroll(dialog_box *, int);
extern int 		db_display_r(dialog_box *, reducer *, char, char);
extern int	 	db_displayq(dialog_box *, unsigned char);
extern int 		db_selectq(dialog_box *, unsigned char);
extern int 		db_run(dialog_box *, unsigned);
extern int 		db_touchbutton(dialog_box *, unsigned *);
extern int 		db_storeanswers(dialog_box *, storage **);
extern int 		db_restoreanswers(dialog_box *, storage **);
extern int 		db_freestorage(dialog_box *, storage **);
extern int 		db_getopcode(int, unsigned*);
extern int 		db_rlist(dialog_box *, int, char **, char**, char*);
extern char **	db_reductionstr(char **, char **, char *);
extern int 		db_interp_mouseclicks(dialog_box *, int, unsigned *,
				unsigned *, int *);
extern int 		db_onquestion(dialog_box *, int *, int, int,
				unsigned char, int *);
extern int 		db_mclist(dialog_box *, int, int *);
extern int 		lst_interpmouse(list_rec *, int, unsigned *, unsigned *,
				int *, unsigned, unsigned);
extern int 		lst_freestorage(lst_storage **);
extern int 		lst_restoreanswers(list_rec *, lst_storage **);
extern int 		lst_storeanswers(list_rec *, lst_storage**);
extern int 		lst_toggle(list_rec *, int);
extern int 		lst_displayitem(list_rec *, int);
extern int 		lst_select(list_rec *, int);
extern int 		lst_run(list_rec *, unsigned);
extern int 		lst_runp(list_rec *, unsigned, dialog_box *);
extern int 		lst_longestoption(list_rec *, int*);
extern int 		lst_display(list_rec *, unsigned char);
extern int 		lst_numopts(list_rec *);
extern void 	do_editcheckin(dialog_box *);
extern int 		do_editcheckout(dialog_box *);
extern int 		db_push(short int);
extern int 		db_priority(short int);
extern int 		db_pop(void);
extern int 		db_pushw(long int);
extern int 		db_priorityw(long int);
extern long 	db_popw(void);
extern int 		run_free_form(dialog_box *, int, char);
extern int 		run_multi_choice(dialog_box *);
extern int 		run_reducer(dialog_box *, int, char);
extern int 		force_cur(unsigned, unsigned char, unsigned, unsigned);
extern void 	db_errorhandler(signed int, signed int);
extern int 		get_event(void *);
extern int 		db_runlist(dialog_box *, int, int *, int);
extern int 		db_edlin(unsigned, unsigned char, char **, char, int, int,
				int, int, int, unsigned char, unsigned char, unsigned *,
				char**, int*, int, unsigned **, dialog_box *);
extern int 		db_executemacros(unsigned, unsigned **);
extern void 	db_switchqueue(unsigned char *, unsigned char *, unsigned *);
extern void 	db_flushqueue(void);
extern void 	do_post_wdw(dialog_box *, int);
extern void 	do_post_size(dialog_box *);
extern void 	do_post_move(dialog_box *);
extern void 	do_action(dialog_box *);
extern int 		run_window(unsigned, unsigned char, int);
extern int 		wn_draww_on_vs(unsigned, unsigned, unsigned char);
extern int 		db_updatetargets(dialog_box *);
extern int 		do_control(dialog_box *, int);
extern int 		db_runscroll(dialog_box *, int);
extern int 		db_run_subdb(dialog_box *, int);
extern void 	db_adjustvs(dialog_box *);
extern void 	q_open(unsigned);
extern void 	q_close(void);
extern void 	db_display_subdb(dialog_box *);
extern int 		alt(char);
extern int 		caps_lock(void);
extern int 		scroll_lock(void);
extern int 		vs_putcods(unsigned, unsigned char, unsigned, unsigned,
				unsigned, unsigned char, unsigned char, unsigned char,
				unsigned char, char *);

/* db globals */

/* pointer to offsets into the current queue */
extern unsigned char *db_head, *db_tail;

/* pointer a 256 byte queue */
extern unsigned	*dbqueue;

/*
 * determines how sensitive the mouse is to clicks, etc. -- set to 10 or 15 for
 * best results
*/
extern unsigned mouse_sensitivity;

/* a default keyboard command table */
extern unsigned default_db_cmds[NUM_OPS];

/* used internally */
extern int force_list_update;
extern unsigned long prev_event, curr_event;
extern unsigned button_press;
extern unsigned char ascii;
extern int mouse_timeout;
extern char monitor_buffer[];


/* window to display the dbqueue mnemonic codes in -- useful for debugging */
extern unsigned monitor_wdw;
extern unsigned char monitor_tile;

extern int monitor_speed;	/* 0 = by keypress, 1 > sleep interval between
							   opcodes */

extern int monitor_switch;	/* TRUE is monitor is on, FALSE is off. */

/* colors to display the opcodes in */
extern unsigned char monitor_fg, monitor_bg;

/* some useful default color and delimiter schemes */
extern db_colors default_db_colors, msmono;
extern db_delimiters default_db_delimiters;

/* this function is called repeatedly during the keyboard/mouse polling loop */
extern int (far *idle)(void *);

/*
 * when macros are processed -- all codes are passed through this list
 * before being passed on to the local macro list
*/
extern unsigned **global_macros;
