;
;  CPU type determination
;  function:  int cputype( void )
;  returns:   386  if processor is 80386
;             286  if processor is 80286
;             186  if processor is 80188/80186
;              86  if processor is 8088/8086
;
;  Note: this is designed for medium, large or huge model
;        to use small model, change the following
;
;      CPU_TEXT            to   _TEXT
;      _cputype PROC FAR   to   _cputype PROC
;
;
;  Assemble with   TASM /MX cpu.asm
;
;  This code is not an official Borland product.  Borland is not
;  responsible for the code or the action of any program using the
;  code.  Borland is not required to provide technical support on
;  this code.

CPU_TEXT segment byte public "CODE"
      assume cs:CPU_TEXT

_cputype PROC FAR
      pushf                     ; save flags
      xor    ax, ax             ; clear ax
      push   ax                 ; push ax
      popf                      ; pop zero into flags
      pushf                     ; attempt to make bits 12-15 zero
      pop    ax                 ; retrieve flags
      and    ax, 08000h         ; mask all bits but 12-15
      cmp    ax, 08000h         ; if bits 12-15 set (ie not 0)
      jz     _8x_18x            ; processor is 80188/86 or 8088/86
      mov    ax, 07000h         ; attempt to set bits
      push   ax                 ; 12-14 to one's
      popf                      ; if this is not possible
      pushf
      pop    ax
      and    ax, 07000h         ; ie bits are still zero
      jz     _286               ; then processor is a 286
      mov    ax, 386            ; otherwise it is a 386
      jmp    done
_286: mov    ax, 286            ; set return value to 286
      jmp    done
_8x_18x:
      mov    ax, 0FFFFh         ; test for 8088/86 vs 80188/86
      mov    cl, 33             ; by attempting to shift left 33 bits
      shl    ax, cl             ; 8018x can do this, leaving ax set to
      jnz    _18x               ; zero.
      mov    ax, 86             ; 808x will only shift one bit, leaving
      jmp    done               ; some bits left on
_18x: mov    ax, 186            ; set return to 186
done: popf                      ; restore flags
      ret
_cputype endp
CPU_TEXT ends

public _cputype

end
