//***************************** mytable.cpp ***************************
#include "all.h"
#pragma hdrstop

// preprocess(): which is called before a record is written to the table.

Retcode mytable::preprocess()
{
    getBCDFld() ;

    return(lastError = PXSUCCESS);
}

// postprocess(): which is called after a record is read from the table

Retcode mytable::postprocess()
{
    setBCDFld() ;
    return(lastError = PXSUCCESS);
}

// nameOf(): returns the name of the class

char * mytable::nameOf() const
{
    return("mytable");
}

// set(): marks all fields in the Custom Record as being used.

Retcode mytable::set( void )
{
    for (int i=0; i < sizeof nullVec; i++)
	nullVec[i] = 0x00;
    return(lastError = PXSUCCESS);
}

// getBCDFld(): forces information from the derived field data to fields
// which are directly mapped to the table

Retcode mytable::getBCDFld()
{
    Exponent = data.expo ;
    Mantissa_1 = data.mantissa[0] ;
    Mantissa_2 = data.mantissa[1] ;
    return(lastError = PXSUCCESS);
}

// setBCDFld(): used to copy information from fields which
// directly map to the table to the derived field which is not
// directly mapped to the table.

Retcode mytable::setBCDFld()
{
    data.expo = Exponent ;
    data.mantissa[0] = Mantissa_1 ;
    data.mantissa[1] = Mantissa_2;
    return(lastError = PXSUCCESS);
}

// display(): Output the contents of the class to the screen.

Retcode mytable::display( void )
{
    cout << setiosflags( ios::left ) ;
    cout << "Expo: " << setw( 6 ) << data.expo ;
    cout << "Mantissa[0]: " << setw( 6 ) << data.mantissa[0] ;
    cout << "Mantissa[1]: " << setw( 6 ) << data.mantissa[1] ;
    cout << endl ;
    cout << setiosflags( ios::right ) ;
    return( lastError = PXSUCCESS ) ;
}

//*************************** end of mytable.cpp **********************
