//******************************* Modify.cpp ****************************
//
// This program will display the field parameters of the Custom Record,
// display all records in a table, and modify one of the records in the
// table.
//
// The output of this program describes the 'data' field as being a BLOb
// field. The Database Framework treats types it does not understand as
// BLOb fields, which means that the Database Framework will do nothing
// with that field unless explicitly programmed.
//
// This example can be easily modified to use the Borland BCD class which
// ships with the compiler. The BCD class will have to be modified so that
// the members are public ( comment out the ' private: ' line ). The source
// to this example will have to be modified: change ' #include "mybcd.h" '
// to ' #include <bcd.h> ' in every file where it is found.
//
// DISCLAIMER: Although it is believed that this examples works as
// advertised, we make no guarantees, express or implied, that this
// program works.
//
// This example was tested under Borland C++ v3.1.
//


#include <all.h>
#pragma hdrstop

PXCODE PXError( char *module, int line, char *function, int retval ) ;
void display_info( void ) ;

#define PXErr(parm) PXError( __FILE__, __LINE__, #parm, parm )

extern int GlobalPXErr ;

extern unsigned _stklen = 16323 ;

int main( void )
{
    clrscr() ;

    // Framework initializations

    BEngine myEngine( pxLocal ) ;
    PXErr( myEngine.lastError ) ;
    if ( GlobalPXErr ) exit( __LINE__ ) ; // Returns the line number as the
					  // error code
    BDatabase myDataBase( &myEngine ) ;
    PXErr( myDataBase.lastError ) ;
    if ( GlobalPXErr ) exit( __LINE__ );

    if ( myDataBase.tableExists( TABLENAME ) )
    {
	PXErr( myDataBase.lastError ) ;

	BCursor myCursor( &myDataBase, TABLENAME, 0, TRUE ) ;
	PXErr( myDataBase.lastError ) ;
	if ( GlobalPXErr ) exit( __LINE__ ) ;

	mytable table( &myCursor ) ;
	PXErr( table.lastError ) ;
	if ( GlobalPXErr ) exit( __LINE__ ) ;

	display_info() ;
	cout << endl ;
	myCursor.gotoBegin() ;    // Go to atBegin, which is the start of
				  // the table before the first record.
	PXErr( table.lastError ) ;
	if ( GlobalPXErr ) exit( __LINE__ ) ;

	// Read values from the table
	// Notice that we do not have to use the getField function.
	// The custom record takes care of loading the variables for us

	myCursor.gotoNext() ;    // Go to the first record of the table
	while ( !myCursor.lastError ) // While not end of table
	{
	    PXErr( myCursor.lastError ) ;
	    myCursor.getRecord( &table ) ;
	    PXErr( table.lastError ) ;
	    if ( !GlobalPXErr )
	    {
		table.display( ) ;  // Show the record
	    }
	    myCursor.gotoNext() ;  // Get the next record in the table
	} // while records in table
	if ( myCursor.lastError != PXERR_ENDOFTABLE ) // We expect the end
	{
	    PXErr( myCursor.lastError ) ;  // of table error - how we exit loop
	}
	cout << endl ;
	cout << "Press any key to continue." << endl ;
	getch() ;

	// Search for the first exponent in the table with a value
	// greater than 100

	table.data.expo = 100 ;
	table.getBCDFld() ;    // Move the data from the structure to
			       // the Exponent variable which is directly
			       // Mepped to a field in the table. The
			       // searchIndex function does not do derived
			       // Fields. What you could do is modify
			       // searchIndex to call preprocess(), or derive
			       // your own BCursor class so that the
			       // searchIndex function can call getBCDFld
			       // without having to worry about a Generic
			       // Record getting used ( which will not have
			       // a getBCDFLd() method ).

	GlobalPXErr = myCursor.searchIndex( &table, pxClosestRecord, 1) ;
	if ( ( GlobalPXErr == PXERR_RECNOTFOUND ) ||
	     ( GlobalPXErr == PXSUCCESS ) )
	{
	    myCursor.getRecord( &table ) ;
	    PXErr( table.lastError ) ;
	    if ( GlobalPXErr ) exit( __LINE__ ) ;

	    cout << "The first record with an exponent greater than 100: "
		 << endl ;
	    table.display() ;  // Show the record
	    table.data.expo = table.data.expo - 10 ; // Make a change to
						     // the record.
	    myCursor.updateRec( &table ) ; // Update the table
	    PXErr( myCursor.lastError ) ;
	    if ( GlobalPXErr ) exit( __LINE__ ) ;
	    cout << "The value has been changed to: " << endl ;
	    table.display() ;  // Show the record
	} else {
	    PXErr( myCursor.lastError ) ;
	}

    } else {  // if tableExists
	cout << "Table does not exist: Run maketbl." << endl ;
    }

    return 0 ;
}//*************************** end of modify.cpp ***********************

