#include <iostream.h>
#include <alloc.h>

#include <pxengine.h>
#include <envdef.h>
#include <bengine.h>
#include <bdatabas.h>

PXCODE PXError( char *module, int line, char *function, int retval ) ;

#define PXErr(parm) PXError( __FILE__, __LINE__, #parm, parm )

extern int GlobalPXErr ;

#define TABLENAME "mytable"
const int numFields = 3 ;
FieldDesc desc[numFields] = { { 1, "Exponent", fldShort, fldstNone, 0 },
			      { 2, "Mantissa_1", fldDouble, fldstNone, 0 },
			      { 3, "Mantissa_2", fldDouble, fldstNone, 0 } } ;


int main( void )
{
	BEngine myEngine( pxLocal ) ;
	PXErr( myEngine.lastError ) ;

	if ( GlobalPXErr ) return 1 ;

	BDatabase myDataBase( &myEngine ) ;
	PXErr( myDataBase.lastError ) ;

	if ( GlobalPXErr ) return 1 ;

	if ( !myDataBase.tableExists( TABLENAME ) )
	{
		PXErr( myDataBase.lastError ) ;
		myDataBase.createTable ( TABLENAME, numFields, desc ) ;
		if ( GlobalPXErr ) return 1 ;
		cout << "Table \"" << TABLENAME << "\" created." << endl ;
		myDataBase.createPIndex( TABLENAME, 3 ) ;
		PXErr( myDataBase.lastError ) ;
	} else {
		cout << "Table already exists" << endl ;
	}
	PXErr( myDataBase.lastError ) ;

	return 0 ;
}
