//                mytable.h  

#ifndef mytable_H 
#define mytable_H 

#include "envdef.h" 
#include "brecord.h"

class mytable : public BRecord { 

public: 
  double Exponent; 
  double Mantissa_1; 
  double Mantissa_2; 
  char nullVec[1]; 

public:
  static CRFldMapdef* mytable_CRFldMap; 
  void     **fldPtr; 

  mytable(BCursor *cursor = 0); 
  virtual ~mytable(); 
  virtual Retcode clear(); 
  virtual FIELDNUMBER getFieldNumber(const char *fldName); 
  virtual FIELDNUMBER getTblFieldNumber(FIELDNUMBER fldnbr); 
  virtual int         getFieldCount(); 
  virtual Retcode     getFieldDesc(FIELDNUMBER fldnbr, FieldDesc& desc);
  virtual Retcode     getFieldDesc(FIELDNUMBER     fldnbr,  
                                   PXFieldType    &fldType, 
                                   PXFieldSubtype &fldSubtype, 
                                   int            &fldLen); 

  virtual Retcode getField(FIELDNUMBER fldnbr,   
                           void *buf, int bufLen, BOOL& fNull);
  virtual Retcode getField(FIELDNUMBER fldnbr,	 
                           char *buf, int bufLen, BOOL& fNull); 
  virtual Retcode getField(FIELDNUMBER fldnbr, double& val, BOOL& fNull); 
  virtual Retcode getField(FIELDNUMBER fldnbr, INT16& val, BOOL& fNull); 
  virtual Retcode getField(FIELDNUMBER fldnbr, INT32& val, BOOL& fNull); 
  virtual Retcode getField(FIELDNUMBER fldnbr, BDate& val, BOOL& fNull); 
 
  virtual Retcode getField(char *fldName, char *buf, int bufLen, BOOL& fNull); 
  virtual Retcode getField(char *fldName, void *buf, int bufLen, BOOL& fNull); 
  virtual Retcode getField(char *fldName, double& val, BOOL& fNull); 
  virtual Retcode getField(char *fldName, INT16& val, BOOL& fNull);  
  virtual Retcode getField(char *fldName, INT32& val, BOOL& fNull); 
  virtual Retcode getField(char *fldName, BDate& val, BOOL& fNull); 
 
  virtual Retcode putField(FIELDNUMBER fldnbr, const void *buf); 
  virtual Retcode putField(FIELDNUMBER fldnbr, const char *buf); 
  virtual Retcode putField(FIELDNUMBER fldnbr, double val); 
  virtual Retcode putField(FIELDNUMBER fldnbr, INT16 val);  
  virtual Retcode putField(FIELDNUMBER fldnbr, INT32 val);  
  virtual Retcode putField(FIELDNUMBER fldnbr, const BDate& val); 
 
  virtual Retcode putField(char *fldName, const char *buf); 
  virtual Retcode putField(char *fldName, const void *buf); 
  virtual Retcode putField(char *fldName, double val);  
  virtual Retcode putField(char *fldName, INT16 val);   
  virtual Retcode putField(char *fldName, INT32 val);   
  virtual Retcode putField(char *fldName, const BDate& val);	

  virtual BOOL    isNull(FIELDNUMBER fldnbr); 
  virtual BOOL    isNull(const char *fldname); 
  virtual Retcode setNull(FIELDNUMBER fldnbr); 
  virtual Retcode setNull(const char *fldname); 
  virtual Retcode clearNull(FIELDNUMBER fldnbr); 
  virtual Retcode clearNull(const char *fldname); 

  virtual Retcode     preprocess(); 
  virtual Retcode     postprocess(); 
  virtual char  *     nameOf() const; 
}; 
#endif 
