/*
** Task Control Block (TCB) structure, along with other related
** memory structures for the Adept Multi-Tasker
**
** Copyright 1990 Herb Rose
**
*/

#define maxtasks 32
#define num_mcbs 512

struct tcb_rec {
    int     next_tcb;   /* tcbs are arranged as a table, this is next index */
    int     base_pri;   /* base priority */
    int     cur_pri;    /* current priority */
    unsigned int     stackseg;
    unsigned int     stackptr;
    int     mcb_ptr;    /* first mcb */
    int     emm_handle; /* handle for task if swapped out to ems */
    int     tcbflags;   /* various state flags */
    int     cur_state;  /* numerical value for task state */
    int     sem_wait_num;
    int     mcbs_in_use;
    int     mcbs_avail;
    unsigned int dtaseg;    /* this guys disk transfer area - segment */
    unsigned int dtaoff;    /* dta offset   */
    unsigned int pspseg;    /* our psp segment */
    char    tcbname[10];
    };

#define st_free    -1   /* this tcb not being used */
#define st_active   0   /* the runner */
#define st_ready    1   /* ready to run */
#define st_sem_wait 2   /* waiting for a semaphore */
#define st_delay    3   /* task is delaying */
#define st_suspend  4   /* task is suspended - needs a wakeup signal */
#define st_msg_wait 5   /* task is waiting for a message */
#define st_stopping 6   /* task is terminating */

/* the following are bit values for the flags word */

#define fl_no_swap  1   /* when this task is the runner, do not task swap */
#define fl_in_dos   2   /* this task is in dos */
#define fl_in_emm   4   /* this task executes in emm */
#define fl_spawned  8   /* this task created with spawn */

struct mem_ctrl_block {
    int fwd_link;       /* index of next tcb */
    unsigned int actlen;         /* actual length of data (for message queues) */
    unsigned int m_size;         /* number of paragraphs */
    unsigned int m_address;      /* the segment address */
    };

struct msgq_rec {
    int mmcb[2];    /* hoq and toq mcbs for messages */
    int mtcb[2];    /* same for tcbs */
    };


