	// bdrdem5.cpp
	// Demo Binder with generic heterogeneous
	//   streamable nodes.

	#include <string.h>
	#include <fstream.h>
	#include <sbnode.hpp>

	#define DID_Int	2

	#define ID_SBN_CMP  1



	// display integers and strings
	
	void display(SBN N)
	{
		cout << endl << "DID: " << setw(6)
			<< N->DID()
			<< "  sizeofData: " << setw(6)
			<< N->SizeofData() << "  D:  ";
		switch (N->DID())  {
		case DID_Generic:
			cout << "unknown";
			break;
		case DID_String:
			cout << (char *)(voiD) * N;
			break;
		case DID_Int:
			cout << *(int *)(voiD) * N;
			break;
		}

	}


	// sort integers and strings
	
	int sbncmp(SBN N1, SBN N2)
	{
		// integers sorted to the front
		// strings sorted to the rear

		if (N1->DID() == DID_Generic)
			return 1;
		else if (N2->DID() == DID_Generic)
			return -1;
		if (N1->DID() == DID_Int)
			if (N2->DID() == DID_Int)
				return *(int *)(voiD)*N1
					- *(int *)(voiD)*N2;
			else
				return -1;
		else
			if (N2->DID() == DID_Int)
				return 1;
			else
				return strcmp((const char *)
					(voiD)*N1,
					(const char *)
					(voiD)*N2);
	}


	main()
	{
		Binder::registerClass();
		SBNode::registerClass();


		Binder B(Binder::STREAMABLE_NODES);

		B.push(new SBNode("Hello LDB!"));
		B.insQ(new SBNode("Goodbye linked"));
		B.insQ(new SBNode("list programming!"));
		B.insQ(((StreamablE)B.bottom())->link());
		B.insQ(new SBNode(
			"Line above tests multilinking!"));

		for (int i = 3; i; i--)
			B.insQ(new SBNode(&i,sizeof(i),
				DID_Int));

		cout << "\n\nBinder of streamable integers"
			<< " and strings!\n\n";

		B.forEach((BDRforEachBlocK)display);

		cout << "\n\nPress enter to continue ...";
		cin.get();


		B.setComparE((BDRcomparE)sbncmp);

		RegisterFunction(ID_SBN_CMP,
			(GenericFnC)sbncmp);

		ofstream oS("bdrdem5.txt");
		if (oS)  {

		  oS << (StreamablE) B;

		  B.restream();

		  // Don't stream B again
		  // without restreaming!!!

		  oS.close();
		  ifstream iS("bdrdem5.txt");
		  if (iS)  {

		    StreamablE C;

		    cout << "\nStreamed and "
			<< "reloaded Binder with "
			<< "multiple links maintained "
			<< "\nand sorted with streamed "
			<< "compare fnc, ints in front:"
			<< " \n";

		    iS >> C;

		    RestreamRegistry();

		    // Don't load again from
		    // any stream with
		    // restreaming!!!

		    if (C)
		    {
		      ((BindeR)C)->sort();
		      ((BindeR)C)->forEach(
			(BDRforEachBlocK)display);
		      delete C;
		    }
		    else
		      cout << "\n\nUnable to reload"
			<< " Binder \n\n";
		  }
		  else
		    cout << "\n\nUnable to reopen"
		      << " stream for input of"
		      << " of Binder \n\n";
		}


		return 0;
	}