/*
	CSTRINGS.LBR VERSION 1.0
	Spark Software, Inc.

		If you find this software of use, it is requested that you send
		a donation ($10.00 suggested) to:

			Spark Software, Inc.
			24 Royal Crest Dr., #5
			Nashua, NH  03060

		Upon receiving your donation, your name will be added to the 
		List of Registered Users, and future updates can be obtained
		from the SPARKIE RBBS at (603) 888-8179.

		If you include an extra $10.00 with your donation, the newest
		version of CSTRINGS.LBR will be mailed to you.

		Call SPARKIE RBBS at the number above for other Spark Software
		products!!!
*/

/*
 *	char *
 *	mid (dest, str, pos, n)
 *	char *dest, *str;
 *	int pos, n;
 *
 *	This function works very much like the BASIC function MID$.
 *	It returns a pointer to a character stringing containing n
 *	characters (null padded if needed) from str starting from position
 *	pos (remember:	since C is zero based, the first position is
 *	postion 0, not position 1).  The new string (dest) is assumed
 *	to be large enough to hold the result.	Not also the external
 *	declaration of strncpy.  This is needed for Lattice C large
 *      model copilation to work (since int's and char *'s are not the
 *	same size in that memory model).
 */

char *mid (dest, str, pos, n)
register char *dest, *str;
register int pos, n;
{
	extern char *strncpy ();

					/* Do a strncpy () to fill
					   the new string with the
					   proper characters */
	new_string = strncpy (dest, &str[pos], n);

					/* Return the pointer to the result */
	return (dest);

} /* mid */
