#include <stdio.h>
#include "config.h"

int TopMargin = 0, BotMargin = 0;
int Margin[4]= {10,20,30,40};
char keys[2][6];
char *line;
char swch='/';
double Mag = 1;
int Case;

char *boolkw[] = {
    "false", "true", NULL
};

KeyRec KeyTable[] = {
    { "TopMargin", &TopMargin, V_int, cfgDefault, 0, -50, 50 },
    { "BottomMargin", &BotMargin, V_int, cfgDefault, 0, -50, 50 },
    { "Magnification", &Mag, V_double, cfgDefault, 0, 0, 10 },
    { "Margin", Margin, V_int, cfgDefault, 4 },
    { "Keys", keys, V_string, FALSE, 2, 0, 6 },
    { "Line", &line, V_charptr, FALSE, 0, 0, 0 },
    { "SwitchChar", &swch, V_char, cfgDefault, 0 },
    { "CaseSensitive", &Case, V_intkw, FALSE, 0, 0, 0, FALSE, boolkw },
    { NULL } };


main()
{
    cfgVerbose = TRUE;
    KeyCaseSensitive = TRUE;
    PresetKey("TopMargin");
    if (readconfig("config.cfg") == 0) {
        fprintf(stderr,"Configuration Not found\n");
        exit(1);
    }
    CheckAllKeys();
    printf("%d %d\n", TopMargin, BotMargin);
    printf("%d %d %d %d\n", Margin[0], Margin[1],Margin[2], Margin[3]);
    printf("%s %s\n", keys[0], keys[1]);
    printf("%s\n", line);
    printf("%lf\n", Mag);
    printf("switch char = %c\n", swch);
    printf("case %d\n", Case);
}

