/*

    This program shows an example of searching on a composite secondary
    index. A compound-secondary index is created for table "table", the
    table is opened on that index, and then PXSrchFLd is called to search
    for the value.

    This example also shows one possible workaround for the problem with
    PXSrchFld on a composite secondary or a case-insensitive index. The
    workaround consists of doing an explicit check on all fields in the
    composite secondary index after doing a CLOSESTRECORD search. Look at
    TI-1168 for more information regarding the problem with PXSrchFld
    randomly failing.


/* comsch.c */

*/
/* The SETUP.C program must be compiled and run before this example */
/* can be executed. Run this program in the \pxengine\c\examples directory */

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <process.h>
#include <math.h>
#include "pxengine.h"

#define TABLENAME  "table"
#define MODE 0
#define TRUE 1
#define FALSE 0
// Increase this if you want comparisons of floats to be more precise
#define SIGFIG 0.0001

// Field 1) A30
// Field 2) N
// Field 3) A3

FIELDHANDLE fields[] = { 1, 3, 6 };
FIELDHANDLE fldHandles[6];

// Function for comparing doubles
int compdbl( double one, double two ) ;

// Prototype for the error checking routine
PXCODE PXErr(PXCODE pxcff, unsigned line, char *fn);

// Macro that we define to add line and filename information to the
// error checking
#define PXError(a) PXErr(a,__LINE__,__FILE__)

int main(void)
{
  TABLEHANDLE  tblHandle;
  RECORDHANDLE recHandle;
  RECORDHANDLE recHandleTest;
  FIELDHANDLE  indexID;
  PXCODE       pxErr;
  double       Fld3[2] ;
  char         Fld1[2][31] ;
  char         Fld6[2][4] ;
  int          found ;

  clrscr() ;
  PXInit();

  /* Determine field handle of composite index. */

  PXError( PXKeyMap(TABLENAME, 3, fields, "New Order", MODE, &indexID ) ) ;

  /* Add the composite secondary index to the table. */

  fldHandles[0] = indexID;
  PXError( PXKeyAdd(TABLENAME, 1, fldHandles, SECONDARY) ) ;

  /* Open a table on the composite index. */

  PXError( PXTblOpen(TABLENAME, &tblHandle, indexID, 0) ) ;

  /* Open our record buffers */
  PXError( PXRecBufOpen( tblHandle, &recHandle ) ) ;
  PXError( PXRecBufOpen( tblHandle, &recHandleTest ) ) ;

  // Search on composite secondary index

  strcpy( Fld1[0], "Value 2" ) ;
  Fld3[0] = 3422 ;
  strcpy( Fld6[0], "cat" ) ;
  PXError( PXPutDoub ( recHandle, 3, Fld3[0] ) ) ;
  PXError( PXPutAlpha( recHandle, 1, Fld1[0] ) ) ;
  PXError( PXPutAlpha( recHandle, 6, Fld6[0] ) ) ;

  pxErr = PXSrchFld( tblHandle, recHandle, indexID, CLOSESTRECORD ) ;
  if ( pxErr )
  { // PXSrchFld will fail in certain cases - this tests if a fail
    // was the correct result.
    if ( pxErr == PXERR_RECNOTFOUND )
    {
       PXError( PXRecGet( tblHandle, recHandleTest ) ) ;
       PXError( PXGetDoub( recHandleTest, 3, &Fld3[1] ) ) ;
       PXError( PXGetAlpha( recHandleTest, 1, 31, Fld1[1] ) ) ;
       PXError( PXGetAlpha( recHandleTest, 6, 4, Fld6[1] ) ) ;

       // We use this method for comparing floating point
       // numbers because of the way floats are represented
       // in binary. For example, we cannot guarantee if
       // (.100 - .23) == .67 is going to return true because
       // .23 might be .2299998 as represented internally.

       if ( ( !strcmp( Fld1[0], Fld1[1] ) ) &&
            ( compdbl( Fld3[0], Fld3[1] ) ) &&
            ( !strcmp( Fld6[0], Fld6[1] ) ) )
       {
          found = TRUE ;
       } else {
          found = FALSE ;
       }
    } // PXERR_RECNOTFOUND
    else {  // Error other than PXERR_RECNOTFOUND
       if ( pxErr == PXERR_ENDOFTABLE )
       {
          printf("End of table reached: Record not found\n");
          found = FALSE ;
       } else {
          printf("%s\n", PXErrMsg(pxErr));
          PXExit() ;
          return ( pxErr ) ;
       }
    }
  } // PXSrchFld error handler
  else {
    found = TRUE ;
  }

  // Display the current record

  if ( found )  // Found a match
  {
     PXError( PXRecGet( tblHandle, recHandleTest ) ) ;
     PXError( PXGetDoub( recHandleTest, 3, &Fld3[1] ) ) ;
     PXError( PXGetAlpha( recHandleTest, 1, 31, Fld1[1] ) ) ;
     PXError( PXGetAlpha( recHandleTest, 6, 4, Fld6[1] ) ) ;

     printf("Found value: %s Number %lf Pet: %s \n",
             Fld1[1], Fld3[1], Fld6[1] ) ;
  } else {  // Did not find a match
      // Get values actually in buffer
     PXError( PXGetDoub( recHandle, 3, &Fld3[0] ) ) ;
     PXError( PXGetAlpha( recHandle, 1, 31, Fld1[0] ) ) ;
     PXError( PXGetAlpha( recHandle, 6, 4, Fld6[0] ) ) ;

     printf( "Value not found. Value at current record: %s Number %lf Pet: %s \n",
              Fld1[0], Fld3[0], Fld6[0] ) ;
  }

  // Close table
  PXError( PXRecBufClose( recHandle ) ) ;
  PXError( PXRecBufClose( recHandleTest ) ) ;
  PXError( PXTblClose(tblHandle) ) ;

  PXExit();
  return(pxErr);
}

int compdbl( double one, double two )
{
   int equal ;
   double temp ; // Local variable used in comparison

   if ( ( ISBLANKDOUBLE( one ) ) ||
        ( ISBLANKDOUBLE( two ) ) )
   {
      equal = FALSE ; // Blank is equal to -NAN. I made a design decision
                      // that two values of -NAN are not equal. You can
                      // change this logic if you want.
   } else {  // If neither are blank, do regular compare
      temp = fabs( one - two );
      equal = ( temp < SIGFIG ) ;
   }
   return ( equal ) ;
}

PXCODE PXErr(PXCODE pxcff, unsigned line, char *fn)
{
  if (pxcff==PXSUCCESS)
     return( pxcff ) ;

  printf("PXERR error code %d : %s\n",pxcff,PXErrMsg(pxcff));
  printf("Error occured on line number %d in file %s\n",line,fn);
  // You might want to modify these two lines to return the error
  // code as opposed to exiting the engine and the application.
  PXExit() ;
  exit(pxcff);
  return( pxcff ) ;
}

/*

  DISCLAIMER: This example is provided as a service of the Borland C++
  Technical Support Department. As such, we do not make any quarantees,
  express or implied, as to its correctness or functionality. There also
  is no guarantee of technical support for this program.

*/
