/******************************************************/
/*  COMM.H  - this set of routines is an              */
/*            interupt driven communications          */
/*            interface for MSC 5.1,  QuickC,         */
/*            and TurboC.                             */
/*                                                    */
/*    By  Mario Giannini                              */
/*    Version 1.1  March 12, 1990                     */
/*                                                    */
/*  SetIntr(port) - install driver for com port       */
/*              port where 0 = com1:                  */
/*              returns -1 if port not installed      */
/*                                                    */
/*  ResetInt(port) - remove above driver              */
/*                                                    */
/*  SerAvl() -  tests to see if a character is        */
/*              available in the serial buffer        */
/*                                                    */
/*  GetSer() -  gets a character from the serial      */
/*              buffer                                */
/*                                                    */
/*  PortInit(port, baud, parity, data, stop)          */
/*              returns  0 if ok                      */
/*                      -1 if port not there,         */
/*                      -2 if invalid parameter       */
/*                                                    */
/*  IsCarrier(port) - returns a non-zero if           */
/*                     carrier detect is true         */
/*                                                    */
/*                                                    */
/*  Xmit(ch) -  transmit character ch                 */
/*                                                    */
/*  SendStr(char *Str) - Sends specified string to    */
/*         default Com port.  A '|' is converted to   */
/*         a Carriage Return char, a '~' results in a */
/*         one (about) second delay in transmission.  */
/*                                                    */
/*  HWHangup() - Performs a Hardware hangup by drop-  */
/*     ping the DTR line to the modem for about 1     */
/*     second then restoring it.                      */
/*                                                    */
/*  OneSec() and Delay() - Wait for about 1 second,   */
/*      and Delay() waits for the specified number of */
/*      clock ticks.                                  */
/******************************************************/

#define seravl() (tailp!=headp)
#define keyavl() kbhit()

int SetIntr(int cport);
int PortInit(int cport, int baud, int parity, int data, int stop);
int GetSer();
int SerAvl();
int IsCarrier();
void SendStr(char *Str);
void Xmit(char ch);
void ResetIntr(int cport);
int ModemStatus();
void HWHangup();
void OneSec();
void Delay(int Len);
void ClearBuffer();
void ClearBuffer();
