#include <owl.h>
#include <dialog.h>
#include <listbox.h>
#include "dlgid.h"

#ifndef __TCOLORLISTBOX
#define __TCOLORLISTBOX

_CLASSDEF(TColorListBox)
// OwnerDraw List BOX which Associates a Color with A String
class TColorListBox : public TListBox{

// Array to Hold Colors inside the List Box
	COLORREF * crpTColor;
// Array to Hold Rectangles Associated with Each of the Colors
	RECT * rpListRect,rListBox;

	int ID;

// Which Index To Put the New List Item At If List Box is LBS_SORT
// USer Must Provide this Function Otherwise it uses LSTRCMPI
	int WhichIndex(LPSTR); // Function to Keep List IN order

public:
	TColorListBox(PTWindowsObject AParent , int AnId,int X,int Y, int W, int H);
	~TColorListBox(void);

	// Paint the Information into the List Box
	virtual void	WMPaint(RTMessage Msg) = [WM_FIRST + WM_PAINT];

	// Handle Scrolling of List Box to Get Top Item and Force Paint
	virtual	void	WMVScroll(RTMessage Msg) = [WM_FIRST + WM_VSCROLL];

	// Allow User to Select Color Using Common Dialog 
	virtual void	WMLButtonDown(RTMessage Msg) = [WM_FIRST + WM_LBUTTONDOWN];

// Functions Similar to List Box Functions
	COLORREF GetColor(int index);
	COLORREF GetSelColor(void);

	void	ClearList(void);
	int		DeleteString(int Index);
	int		DeleteColString(int Index);
	int		ChangeColor(COLORREF crColor,int Index);
	int		AddColString(COLORREF crColor,LPSTR AString);
	int		InsertColString(COLORREF crColor,LPSTR AString,int Index);

};
#endif


#ifndef __TCOLORLISTDLG
#define __TCOLORLISTDLG

_CLASSDEF(TColorListDlg)
class TColorListDlg : public TDialog{

	BOOL bCanClose;
	COLORREF crEditColor;
	TColorListBox * pTColorBox;
	RECT rEditColor;

public:

// Constructor to Fill in Information
	TColorListDlg(PTWindowsObject AParent,LPSTR AName);
	~TColorListDlg(void);

// To Initialize Items in Dialog Box
	virtual void	SetupWindow(void);
	virtual BOOL	CanClose();

	virtual void Cancel(RTMessage Msg) = [ID_FIRST + IDCANCEL];
	virtual void Ok(RTMessage Msg) = [ID_FIRST + IDOK];

	// Recieve Messages from List Box When have Changed Selection
	// Put New Selection in Edit Field and Color Box
	virtual void	COLORLIST(RTMessage Msg) =	[ID_FIRST + IDC_COLORLIST];

	// Add Edit Field Clip Value and Color to List Box
	virtual void	CLIPADD(RTMessage Msg) = 	[ID_FIRST + IDC_CLIPADD];

	// Delete ClipValue and Color From List Box
	virtual void	CLIPDELETE(RTMessage Msg) = [ID_FIRST + IDC_CLIPDELETE];

	// Paint Color Box
	virtual void	WMPaint(void) = [WM_FIRST + WM_PAINT];

	// Allow User to Change Color Using Common Dialog Interface
	virtual void	WMLBUTTONDOWN(RTMessage Msg) = [WM_FIRST + WM_LBUTTONDOWN];

};

#endif
