#ifndef NOICP

/*  C K U U S 3 --  "User Interface" for Unix Kermit, part 3  */
 
/*
 Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET),
 Columbia University Center for Computing Activities.
 First released January 1985.
 Copyright (C) 1985, 1990, Trustees of Columbia University in the City of New 
 York.  Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as it is not sold for profit, provided this
 copyright notice is retained.
*/
 
/*  SET and REMOTE commands; screen, debug, interrupt, and logging functions */
 
/* Includes */
 
#ifdef TRS16
#include <sys/types.h>
#endif

#include <stdio.h>
#include <ctype.h>
#include "ckcdeb.h"			/* Debugging & compiler things */
#include "ckcasc.h"			/* ASCII character symbols */
#include "ckcker.h"			/* Kermit application definitions */
#include "ckcfil.h"			/* File-related symbols */
#include "ckcxla.h"			/* Character set translation */
#include "ckcnet.h"			/* Network symbols */
#include "ckuusr.h"			/* User interface symbols */
#ifdef UXIII
#include <termio.h>
#endif
 
#ifdef datageneral
extern int con_reads_mt,            /* Flag if console read asynch is active */
           conint_ch,               /* The character read by asynch read */
           conint_avl;              /* Flag that char available */
#endif
 
/* Variables */

#ifdef SUNX25
extern int revcall, closgr;
extern CHAR padparms[MAXPADPARMS+1];
#endif /* SUNX25 */

extern int size, spsiz, spmax, rpsiz, urpsiz, npad, timint, srvtim, rtimo,
  local, server, lpcapr, fmask, cmask, backgrd, atcapr, success, winlo, wmax,
  flow, displa, binary, fncnv, delay, parity, deblog, escape, xargc, what,
  turn, duplex, cxseen, czseen, nfils, ckxech, pktlog, seslog, tralog, stdouf,
  turnch, bctr, bctu, dfloc, mdmtyp, keep, maxtry, unkcs, network, tvtflg,
  rptflg, ebqflg, warn, quiet, cnflg, timef, spsizf, mypadn, swcapr, nettype,
  wslots, wslotr, wslotn, fcharset, tcharset, tslevel, nfilc, language,
  fblksiz, frecl, frecfm, forg, fcctrl, carrier, xmitf, xmitl, xmitp, debses,
  cdtimo, dialhang, pkttim, nlangs, maxsps, maxrps, bgset, pflag, dblchar,
  cmdmsk, mdmspd, spsizr, wildxpand;

#ifdef NETCONN
  extern int tn_init;
#endif

extern int
  atenci, atenco, atdati, atdato, atleni, atleno, atblki, atblko,
  attypi, attypo, atsidi, atsido, atsysi, atsyso, atdisi, atdiso; 

extern int xxstring();
extern int count[];
extern int maclvl, macargc[];
extern int techo, mecho, terror, merror, rprintf, fncact;
extern int indef, intime, incase, inecho;

extern int bigsbsiz, bigrbsiz;

#ifdef OS2
extern int Term_mode;
#endif

extern long filcnt, tlci, tlco, ffc, tfc, fsize, speed, ttgspd();

extern char *versio, *protv, *ckxv, *ckzv, *fnsv, *connv, *dftty, *cmdv;
extern char *cmarg, *cmarg2, **xargv, **cmlist;
extern CHAR stchr, mystch, sstate, padch, mypadc, eol, seol, ctlq;
extern char ttname[], filnam[];
char *strcpy();

/* system-dependent character sets, defined in ckcxla.[ch] */
extern struct keytab fcstab[];		/* For 'set file character-set' */
extern struct csinfo fcsinfo[];		/* For 'show', etc. */
extern struct csinfo tcsinfo[];
extern struct langinfo langs[];
 
/* Declarations from cmd package */
 
extern char cmdbuf[],			/* Command buffer */
 optbuf[];				/* Buffer for MAIL or PRINT options */

/* From main ckuser module... */
 
extern char line[], *lp;		/* Character buffer for anything */
extern char debfil[],			/* Debugging log file name */
 pktfil[],				/* Packet log file name */
 sesfil[],				/* Session log file name */
 trafil[],				/* Transaction log file name */
 tmpbuf[];				/* Temporary buffer */
extern char *tp;			/* Temp buf pointer */
extern int tlevel;			/* Take Command file level */
extern int cmdlvl;			/* Overall command level */
extern FILE *tfile[];			/* Array of take command fd's */

int mdmsav = -1;			/* Save modem type around network */

#ifdef UNIX
extern int sessft;			/* Session-log file type */
#endif

#define XMBUFL 50
char xmitbuf[XMBUFL+1] = { NUL };	/* TRANSMIT eof string */

/* Keyword tables for SET commands */
 
/* For SET MODEM */

struct keytab autotab[] = {
    "changes-speed", 1, 0,
    "matches-speed", 0, 0
};

/* For SET CARRIER */

struct keytab crrtab[] = {
    "auto", CAR_AUT, 0,
    "off",  CAR_OFF, 0,
    "on",   CAR_ON, 0
};
int ncrr = 3;

/* For SET DEBUG */

struct keytab dbgtab[] = {
    "off",     0,  0,
    "on",      1,  0,
    "session", 2,  0
};
int ndbg = 3;

/* Transmission speeds */

/* Note, the values are encoded in cps rather than bps because 19200 and */
/* 38400 are too big for some ints.  All but 75bps are multiples of ten. */
/* Result of lookup in this table must be multiplied by 10 to get actual */
/* speed in bps.  If this number is 70, it must be changed to 75. */
/* If it is 888, this means 75/1200 split speed.  134.5 (IBM 2741) is not */
/* supported, and split speed is not possible in AT&T UNIX. */ 

/* The values are generic, rather than specific to UNIX.  We can't use */
/* B75, B1200, B9600, etc, because non-UNIX versions of C-Kermit will not */
/* necessarily have these symbols defined. */

/* Like all other keytabs, this one must be in "alphabetical" order, */
/* rather than numeric order. */ 

struct keytab spdtab[] = {
      "0",    0,  CM_INV,
    "110",   11,  0,
   "1200",  120,  0,
    "150",   15,  0,
  "19200", 1920,  0,
    "200",   20,  0,
   "2400",  240,  0,
    "300",   30,  0,
   "3600",  360,  0,
  "38400", 3840,  0,
   "4800",  480,  0,
     "50",    5,  0,
    "600",   60,  0,
     "75",    7,  0,
#ifndef UXIII
"75/1200",  888,  0,		/* Special code "888" for split speed */
#endif
   "9600",  960,  0,
};
int nspd = (sizeof(spdtab) / sizeof(struct keytab)); /* how many speeds */

struct keytab attrtab[] = {
#ifdef COMMENT
    "blocksize",     AT_BLKS, 0,	/* not used by UNIX or VMS */
#endif
    "character-set", AT_ENCO, 0,
    "date",          AT_DATE, 0,
    "disposition",   AT_DISP, 0,
    "encoding",      AT_ENCO, CM_INV,
    "length",        AT_LENK, 0,
    "off",           AT_ALLN, 0,
    "on",            AT_ALLY, 0,
#ifdef COMMENT
    "os-specific",   AT_SYSP, 0,	/* not used by UNIX or VMS */
#endif
    "system-id",     AT_SYSI, 0,
    "type",          AT_TYPE, 0,
};
int natr = (sizeof(attrtab) / sizeof(struct keytab)); /* how many attributes */

extern struct keytab lngtab[];		/* Languages for SET LANGUAGE */
extern int nlng;

/* Duplex keyword table */
 
struct keytab dpxtab[] = {
    "full", 	 0, 0,
    "half",      1, 0
};
 
/* For SET FILE COLLISION */
/* Some of the following may be possible for some C-Kermit implementations */
/* but not others.  Those that are not possible for your implementation */
/* should be ifdef'd out. */

struct keytab colxtab[] = { /* SET FILE COLLISION options */
    "append",    XYFX_A, 0,  /* append to old file */
#ifdef COMMENT
    "ask",       XYFX_Q, 0,  /* ask what to do (not implemented) */
#endif
    "backup",    XYFX_B, 0,  /* rename old file */
    "discard",   XYFX_D, 0,  /* don't accept new file */
    "no-supersede", XYFX_D, CM_INV, /* ditto (MSK compatibility) */
    "overwrite", XYFX_X, 0,  /* overwrite the old file == file warning off */
    "rename",    XYFX_R, 0,  /* rename the incoming file == file warning on */
    "update",    XYFX_U, 0,  /* replace if newer */
};
int ncolx = (sizeof(colxtab) / sizeof(struct keytab));

/* SET FILE parameters */

struct keytab filtab[] = {
#ifdef COMMENT
    "blocksize",        XYFILB, 0,
#endif
    "bytesize",         XYFILS, 0,
#ifdef COMMENT
    "carriage-control", XYFILP, 0,
#endif
#ifndef NOCSETS
    "character-set",    XYFILC, 0,
#endif /* NOCSETS */
    "collision",        XYFILX, 0,
    "display",          XYFILD, 0,
#ifdef COMMENT
    "format",           XYFILF, 0,
#endif
    "names",            XYFILN, 0,
#ifdef COMMENT
    "organization",     XYFILO, 0,
#endif
#ifdef vms
    "record-length",    XYFILR, 0,
#endif
    "type",             XYFILT, 0,
    "warning",          XYFILW, CM_INV
};
int nfilp = (sizeof(filtab) / sizeof(struct keytab));

#ifdef COMMENT
/* For VMS, but not needed after all */ 
struct keytab fcctab[] = {		/* File carriage control */
    "fortran",  XYFP_F, 0,
    "newline",  XYFP_N, 0,
    "machine",  XYFP_P, 0,
    "none",     XYFP_X, 0
};
int nfcc = (sizeof(fcctab) / sizeof(struct keytab));

struct keytab forgtab[] = {		/* File organization */
    "indexed",     XYFO_I, 0,
    "relative",    XYFO_R, 0,
    "sequential",  XYFO_S, 0
};
int nforg = (sizeof(forgtab) / sizeof(struct keytab));

struct keytab frectab[] = {		/* Record format */
    "fixed",     XYFF_F,  0,
    "stream",    XYFF_S,  0,
    "undefined", XYFF_U,  0,
    "variable",  XYFF_V,  0,
    "vfc",       XYFF_VB, 0

};
int nfrec = (sizeof(frectab) / sizeof(struct keytab));
#endif /* COMMENT */

struct keytab rfiltab[] = {		/* for REMOTE SET FILE */
#ifdef COMMENT
    "blocksize",     XYFILB, CM_INV,
#endif
    "collision",     XYFILX, 0,
#ifdef COMMENT
    "format",        XYFILF, 0,
#endif
    "record-length", XYFILR, 0,
    "type",          XYFILT, 0
};
int nrfilp = (sizeof(rfiltab) / sizeof(struct keytab));

/* Send/Receive Parameters */
 
struct keytab srtab[] = {
    "end-of-packet", XYEOL, 0,
    "packet-length", XYLEN, 0,
    "pad-character", XYPADC, 0,
    "padding", XYNPAD, 0,
    "start-of-packet", XYMARK, 0,
    "timeout", XYTIMO, 0
};
int nsrtab = (sizeof(srtab) / sizeof(struct keytab));
 
struct keytab rsrtab[] = {		/* For REMOTE SET RECEIVE */
    "packet-length", XYLEN, 0,
    "timeout", XYTIMO, 0
};
int nrsrtab = (sizeof(rsrtab) / sizeof(struct keytab));

/* REMOTE SET */

struct keytab rmstab[] = {
    "attributes",  XYATTR, 0,
    "block-check", XYCHKT, 0,
    "file",        XYFILE, 0,
    "incomplete",  XYIFD,  0,
    "receive",     XYRECV, 0,
    "retry",       XYRETR, 0,
    "server",      XYSERV, 0,
    "transfer",    XYXFER, 0,
    "window",      XYWIND, 0
};
int nrms = (sizeof(rmstab) / sizeof(struct keytab));

/* Flow Control */

#ifdef OS2
extern int odsr;    /* In ckotio.c */
extern int idsr;
extern int octs;

struct keytab flotab[] = {
    "none",     0,    0,
    "xon/xoff", 1,    0,
    "odsr",     ODSR, 0,
    "idsr",     IDSR, 0,
    "octs",     OCTS, 0
};
#else
struct keytab flotab[] = {
    "none",     0, 0,
    "xon/xoff", 1, 0
};
#endif /* OS2 */
int nflo = (sizeof(flotab) / sizeof(struct keytab));

/*  Handshake characters  */
 
struct keytab hshtab[] = {
    "bell", 007, 0,
    "code", 998, 0,
    "cr",   015, 0,
    "esc",  033, 0,
    "lf",   012, 0,
    "none", 999, 0,			/* (can't use negative numbers) */
    "xoff", 023, 0,
    "xon",  021, 0
};
int nhsh = (sizeof(hshtab) / sizeof(struct keytab));
 
struct keytab fntab[] = {   		/* File naming */
    "converted", 1, 0,
    "literal",   0, 0
};
 
struct keytab fttab[] = {		/* File types */
    "binary",    XYFT_B, 0,
#ifdef VMS
    "image",     XYFT_I, 0,
    "labeled",   XYFT_L, 0,
#endif
    "text",      XYFT_T, 0
};
int nfttyp = (sizeof(fttab) / sizeof(struct keytab));
 
#ifndef NODIAL
extern struct keytab mdmtab[] ;		/* Modem types (in module ckudia.c) */
extern int nmdm;
#endif
 
#ifdef UNIX
struct keytab wildtab[] = {		/* SET WILDCARD-EXPANSION */
    "kermit",  0, 0,
    "shell",   1, 0
};
#endif

extern struct keytab netcmd[];
extern int nnets;

#ifdef SUNX25
struct keytab x25tab[] = {
    "closed-user-group", XYCLOS, 0,
    "reverse-charge",    XYREVC, 0  
};
int nx25 = (sizeof(x25tab) / sizeof(struct keytab));

struct keytab padx3tab[] = {
    "break-action",         PAD_BREAK_ACTION,           0,
    "break-character",      PAD_BREAK_CHARACTER,        0,
    "character-delete",     PAD_CHAR_DELETE_CHAR,       0,
    "cr-padding",           PAD_PADDING_AFTER_CR,       0,
    "discard-output",       PAD_SUPPRESSION_OF_DATA,    0,
    "echo",                 PAD_ECHO,                   0,
    "editing",              PAD_EDITING,                0,
    "escape",               PAD_ESCAPE,                 0,
    "forward",              PAD_DATA_FORWARD_CHAR,      0,
    "lf-padding",           PAD_PADDING_AFTER_LF,       0,
    "lf-insert",            PAD_LF_AFTER_CR,            0,
    "line-delete",          PAD_BUFFER_DELETE_CHAR,     0,
    "line-display",         PAD_BUFFER_DISPLAY_CHAR,    0,
    "line-fold",            PAD_LINE_FOLDING,           0,
    "pad-flow-control",     PAD_FLOW_CONTROL_BY_PAD,    0,
    "service-signals",      PAD_SUPPRESSION_OF_SIGNALS, 0,
    "timeout",              PAD_DATA_FORWARD_TIMEOUT,   0,
#ifdef COMMENT
/* Speed is read-only */
    "transmission-rate",    PAD_LINE_SPEED,             0,
#endif
    "user-flow-control",    PAD_FLOW_CONTROL_BY_USER,   0
};
int npadx3 = (sizeof(padx3tab) / sizeof(struct keytab));
#endif /* SUNX25 */

/* Parity keyword table */
 
struct keytab partab[] = {
    "even",    'e', 0,
    "mark",    'm', 0,
    "none",      0, 0,
    "odd",     'o', 0,
    "space",   's', 0
};
int npar = (sizeof(partab) / sizeof(struct keytab));
 
struct keytab inptab [] = {		/* SET INPUT parameters */
    "case",            IN_CAS, 0,
    "default-timeout", IN_DEF, CM_INV,
    "echo",            IN_ECH, 0,
    "timeout-action",  IN_TIM, 0
};
int ninp = (sizeof(inptab) / sizeof(struct keytab));

struct keytab intimt[] = {		/* SET INPUT TIMEOUT parameters */
    "proceed", 0, 0,			/* 0 = proceed */
    "quit",    1, 0			/* 1 = quit */
};

struct keytab incast[] = {		/* SET INPUT CASE parameters */
    "ignore",  0, 0,			/* 0 = ignore */
    "observe", 1, 0			/* 1 = observe */
};

/* On/Off table */
 
struct keytab onoff[] = {
    "off",       0, 0,
    "on",        1, 0
};
 
/* Incomplete File Disposition table */
 
struct keytab ifdtab[] = {
    "discard",   0, 0,
    "keep",      1, 0
};

/* Take parameters table */
struct keytab taktab[] = {
    "echo",  0, 0,
    "error", 1, 0
};


struct keytab dialtab[] = {
    "hangup", 0, 0
};
int ndial = 1;

#ifdef OS2
/* Terminal parameters table */
struct keytab trmtab[] = {
    "bytesize",  0, 0,
    "type",      1, 0
};
int ntrm = 2;
#else
/* Terminal parameters table */
struct keytab trmtab[] = {
    "bytesize",  0, 0
};
int ntrm = 1;
#endif /* OS2 */
struct keytab ttyptab[] = {
    "tek4014",2,0,
    "vt100", 1, 0
};
int nttyp = 2;

/* Bytesize table */
struct keytab byttab[] = {
    "bytesize",  0, 0
};
int nbytt = 1;

/* Server parameters table */
struct keytab srvtab[] = {
    "timeout",   0, 0
};

#ifndef NOCSETS
/* 'set transfer' table */
struct keytab tstab[] = {
    "character-set", 1,   0  /*, */
/*  "international", 2,   0, */  /* (not yet!) */
};
int nts = (sizeof(tstab) / sizeof(struct keytab));

/* 'set transfer character-set' table */

extern struct keytab tcstab[];
extern int ntcs;

#endif /* NOCSETS */

/* set transmit */

#define XMITF 0
#define XMITL 1
#define XMITP 2
#define XMITE 3

struct keytab xmitab[] = {
    "eof",      XMITE, 0,
    "fill",     XMITF, 0,
    "linefeed", XMITL, 0,
    "prompt",   XMITP, 0
};
int nxmit = (sizeof(xmitab) / sizeof(struct keytab));

/*  D O P R M  --  Set a parameter.  */
/*
 Returns:
  -2: illegal input
  -1: reparse needed
   0: success
*/
doprm(xx,rmsflg) int xx, rmsflg; {
    int i, x, y = 0, z;
    long zz;
    char *s;
 
switch (xx) {
 
#ifdef SUNX25				/* SET X25 ... */
case XYX25:
    if ((y = cmkey(x25tab,nx25,"X.25 call options","",xxstring)) < 0)
        return(y);
    switch (y) {
        case XYCLOS:
            if ((z = cmkey(onoff,2,"X.25 closed user group call","",xxstring))
                < 0) return(z);
            if (z == 0) {
		if ((z = cmcfm()) < 0) return(z);
                closgr = -1;		/* disable closed user group */
                return (success = 1);
            }
            if ((y = cmnum("0 <= cug index >= 99","",10,&x,xxstring)) < 0)
                return(y);
            if (x < 0 || x > 99) {
	        printf("?The choices are 0 <= cug index >= 99\n");
	        return(-2);
            }
	    if ((y = cmcfm()) < 0) return(y);
            closgr = x;			/* closed user group selected */
            return (success = 1);

        case XYREVC:
            if((z = cmkey(onoff,2,"X.25 reverse charge call","",xxstring)) < 0)
                return(z);
            if ((x = cmcfm()) < 0) return(x);
            revcall = z;
            return (success = 1);
	}

case XYPAD:				/* SET PAD ... */
    if ((y = cmkey(padx3tab,npadx3,"PAD X.3 parameter name","",xxstring)) < 0)
        return(y);
    x = y;
    switch (x) {
      case PAD_BREAK_CHARACTER:
	y = cmnum("PAD break character value","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	break;
      case PAD_ESCAPE:
	y = cmnum("PAD escape","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 1) {
	    printf("?The choices are 0 or 1\n");
	    return(-2);
	}
	break;
      case PAD_ECHO:
	y = cmnum("PAD echo","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 1) {
	    printf("?The choices are 0 or 1\n");
	    return(-2);
	}
	break;
      case PAD_DATA_FORWARD_CHAR:
	y = cmnum("PAD data forward char","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 2) {
	    printf("?The choices are 0 or 2\n");
	    return(-2);
	}
	break;
      case PAD_DATA_FORWARD_TIMEOUT:
	y = cmnum("PAD data forward timeout","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z < 0 || z > 255) {
	    printf("?The choices are 0 or 1 <= timeout <= 255\n");
	    return(-2);
	}
	break;
      case PAD_FLOW_CONTROL_BY_PAD:
	y = cmnum("PAD pad flow control","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 1) {
	    printf("?The choices are 0 or 1\n");
	    return(-2);
	}
	break;
      case PAD_SUPPRESSION_OF_SIGNALS:
	y = cmnum("PAD service","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 1) {
	    printf("?The choices are 0 or 1\n");
	    return(-2);
	}
	break;

      case PAD_BREAK_ACTION:
	y = cmnum("PAD break action","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 1 && z != 2 && z != 5 && z != 8 && z != 21) {
	    printf("?The choices are 0, 1, 2, 5, 8 or 21\n");
	    return(-2);
	}
	break;

      case PAD_SUPPRESSION_OF_DATA:
	y = cmnum("PAD data delivery","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 1) {
	    printf("?The choices are 0 or 1\n");
	    return(-2);
	}
	break;

      case PAD_PADDING_AFTER_CR:
	y = cmnum("PAD crpad","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z < 0 || z > 7) {
	    printf("?The choices are 0 or 1 <= crpad <= 7\n");
	    return(-2);
	}
	break;
      case PAD_LINE_FOLDING:
	y = cmnum("PAD linefold","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z < 0 || z > 255) {
	    printf("?The choices are 0 or 1 <= linefold <= 255\n");
	    return(-2);
	}
	break;

      case PAD_LINE_SPEED:
	y = cmnum("PAD baudrate","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z < 0 || z > 18) {
	    printf("?The choices are 0 <= baudrate <= 18\n");
	    return(-2);
	}
	break;

      case PAD_FLOW_CONTROL_BY_USER:
	y = cmnum("PAD terminal flow control","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 1) {
	    printf("?The choices are 0 or 1\n");
	    return(-2);
	}
	break;

      case PAD_LF_AFTER_CR:
	y = cmnum("PAD linefeed insert","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 1 && z != 4 && z != 5 && z != 6 && z != 7) {
	    printf("?The choices are 0, 1, 4, 5, 6 or 7\n");
	    return(-2);
	}
	break;

      case PAD_PADDING_AFTER_LF:
	y = cmnum("PAD lfpad","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z < 0 || z > 7) {
	    printf("?The choices are 0 or 1 <= lfpad <= 7\n");
	    return(-2);
	}
	break;

      case PAD_EDITING:
	y = cmnum("PAD edit control","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z != 0 && z != 1) {
	    printf("?The choices are 0 or 1\n");
	    return(-2);
	}
	break;

      case PAD_CHAR_DELETE_CHAR:
	y = cmnum("PAD char delete char","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z < 0 || z > 127) {
	    printf("?The choices are 0 or 1 <= chardelete <= 127\n");
	    return(-2);
	}
	break;

      case PAD_BUFFER_DELETE_CHAR:
	y = cmnum("PAD buffer delete char","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z < 0 || z > 127) {
	    printf("?The choices are 0 or 1 <= bufferdelte <= 127\n");
	    return(-2);
	}
	break;

      case PAD_BUFFER_DISPLAY_CHAR:
	y = cmnum("PAD display line char","",10,&z,xxstring);
	if ((y = cmcfm()) < 0) return(y);
	if (z < 0 || z > 127) {
	    printf("?The choices are 0 or 1 <= displayline <= 127\n");
	    return(-2);
	}
	break;
    }
    padparms[x] = z;
    return(success = 1);
#endif /* SUNX25 */ 

case XYEOL:	/* These have all been moved to set send/receive... */
case XYLEN: 	/* Let the user know what to do. */
case XYMARK:
case XYNPAD:
case XYPADC:
case XYTIMO:
    printf("...Use 'set send' or 'set receive' instead.\n");
    printf("Type 'help set send' or 'help set receive' for more info.\n");
    return(success = 0);

case XYATTR:				/* File Attribute packets */
    if ((y = cmkey(attrtab,natr,"File Attribute packets","",xxstring)) < 0)
      return(y);    
    if (y == AT_ALLY || y == AT_ALLN) {	/* All On or All Off */
	if ((x = cmcfm()) < 0) return(x);
	atcapr = (y == AT_ALLY) ? 1 : 0;
	if (rmsflg) {
	    sstate = setgen('S', "132", atcapr ? "1" : "0", "");
	    return((int) sstate);
	} else return(success = 1);
    }
    /* Otherwise, it's an individual attribute that wants turning off/on */

    if ((z = cmkey(onoff,2,"","",xxstring)) < 0) return(z);
    if ((x = cmcfm()) < 0) return(x);

/* There are better ways to do this... */
/* The real problem is that we're not separating the in and out cases */
/* and so we have to arbitrarily pick the "in" case, i.e tell the remote */
/* server to ignore incoming attributes of the specified type, rather */
/* than telling it not to send them.  The protocol does not (yet) define */
/* codes for "in-and-out-at-the-same-time". */

    switch(y) {
      case AT_DISP:
	if (rmsflg) {
	    sstate = setgen('S', "142", z ? "1" : "0", "");
	    return((int) sstate);
	}
	atdisi = atdiso = z; break;
      case AT_ENCO:
	if (rmsflg) {
	    sstate = setgen('S', "141", z ? "1" : "0", "");
	    return((int) sstate);
	}
	atenci = atenco = z; break;
      case AT_DATE:
	if (rmsflg) {
	    sstate = setgen('S', "135", z ? "1" : "0", "");
	    return((int) sstate);
	}
	atdati = atdato = z; break;
      case AT_LENB:
      case AT_LENK:
	if (rmsflg) {
	    sstate = setgen('S', "133", z ? "1" : "0", "");
	    return((int) sstate);
	}
	atleni = atleno = z; break;
      case AT_BLKS:
	if (rmsflg) {
	    sstate = setgen('S', "139", z ? "1" : "0", "");
	    return((int) sstate);
	}
	atblki = atblki = z; break;
      case AT_TYPE:
	if (rmsflg) {
	    sstate = setgen('S', "134", z ? "1" : "0", "");
	    return((int) sstate);
	}
	attypi = attypo = z; break;
      case AT_SYSI:
	if (rmsflg) {
	    sstate = setgen('S', "145", z ? "1" : "0", "");
	    return((int) sstate);
	}
	atsidi = atsido = z; break;
      case AT_SYSP:
	if (rmsflg) {
	    sstate = setgen('S', "147", z ? "1" : "0", "");
	    return((int) sstate);
	}
	atsysi = atsyso = z; break;
      default:
	printf("?Not available\n");
	return(-2);
    }

case XYIFD:				/* Incomplete file disposition */
    if ((y = cmkey(ifdtab,2,"","discard",xxstring)) < 0) return(y);
    if ((x = cmcfm()) < 0) return(x);
    if (rmsflg) {
	sstate = setgen('S', "310", y ? "1" : "0", "");
	return((int) sstate);
    } else {
	keep = y;
	return(success = 1);
    }
 
case XYINPU:				/* SET INPUT */
    if ((y = cmkey(inptab,ninp,"","",xxstring)) < 0) return(y);
    switch (y) {
      case IN_DEF:			/* SET INPUT DEFAULT-TIMEOUT */
	z = cmnum("Positive number","",10,&x,xxstring);
	return(success = setnum(&indef,x,z,94));
      case IN_TIM:			/* SET INPUT TIMEOUT-ACTION */
	if ((z = cmkey(intimt,2,"","",xxstring)) < 0) return(z);
	if ((x = cmcfm()) < 0) return(x);
	intime = z;
	return(success = 1);
      case IN_CAS:			/* SET INPUT CASE */
	if ((z = cmkey(incast,2,"","",xxstring)) < 0) return(z);
	if ((x = cmcfm()) < 0) return(x);
	incase = z;
	return(success = 1);
      case IN_ECH:			/* SET INPUT ECHO */
	return(success = seton(&inecho));
    }
    return(0);

#ifdef NETCONN
case XYNET:
    if ((z = cmkey(netcmd,nnets,"","tcp/ip",xxstring)) < 0) return(z);
    if ((x = cmcfm()) < 0) return(x);	/* And confirmation of command */
    nettype = z;
    if (
#ifdef SUNX25
	(nettype != NET_SX25) &&
#endif /* SUNX25 */
        (nettype != NET_TCPB)) {
	printf("?Network type not supported\n");
	return(success = 0);
    } else {
	return(success = 1);
    }
#endif /* NETCONN */

case XYHOST:				/* SET HOST or SET LINE */
case XYLINE:
    if (xx == XYHOST) {			/* SET HOST <hostname> */
#ifndef NETCONN
        printf("?Network connections not supported\n");
	return(-9);
#else
	if (
#ifdef SUNX25
	    (nettype != NET_SX25) &&
#endif /* SUNX25 */
            (nettype != NET_TCPB)) {
	    printf("?Network not type supported\n");
	    return(-9);
	  }
	if ((x = cmtxt("Network host name","",&s,xxstring)) < 0) return(x);
	if (*s) {			/* They gave a hostname */
	    x = 1;			/* Network connection always local */
	    mdmsav = mdmtyp;		/* Remember old modem type */
	    mdmtyp = -nettype;		/* Special code for network */
	} else {			/* They just said "set host" */
	    s = dftty;			/* So go back to normal */
	    x = dfloc;			/* default tty, location, */
	    mdmtyp = mdmsav;		/* previous modem type. */
	}
#endif /* NETCONN */
    }

    if (xx == XYLINE) {			/* SET LINE */
	if ((x = cmtxt("Device name",dftty,&s,xxstring)) < 0) return(x);
	if (*s) {			/* They gave a device name */
	    x = -1;			/* Let ttopen decide about it */
	} else {			/* They just said "set host" */
	    s = dftty;			/* So go back to normal tty */
	    x = dfloc;			/* and mode. */
	}
	if (mdmsav > -1) mdmtyp = mdmsav;
	if (mdmtyp < 0) mdmtyp = 0;
    }
    ttclos();				/* close old line, if any was open */
    if ((y = ttopen(s,&x,mdmtyp,cdtimo)) < 0 ) { /* Open the new line */
	if (y == -2) {
	    printf("?Timed out, no carrier.\n");
	    printf("Try SET CARRIER OFF and SET LINE again, or else\n");
	    printf("SET MODEM, SET LINE, and then DIAL.\n");
	} else if (y == -3) {
	    printf("Sorry, access to lock denied\n");
	} else if (y == -4) {
	    printf("Sorry, access to tty device denied\n");
	} else if (y == -5) {
	    printf("Sorry, device is in use\n");
        } else {
	    perror("Sorry, can't open connection"); /* Other error. */
	}    
	local = dfloc;			/* Go back to normal */
	strcpy(ttname,dftty);		/* Restore default tty name */
	speed = ttgspd();
	network = 0;			/* Not a network connection */
	return(success = 0);		/* and return */
    }
    if (x > -1) local = x;		/* Opened ok, set local/remote. */
    network = (mdmtyp < 0);		/* Remember connection type. */
#ifdef NETCONN
    if (network) tn_init = 0;		/* Say telnet not init'd yet. */
#endif
    strcpy(ttname,s);			/* Copy name into real place. */
    speed = ttgspd();			/* Get the current speed. */
    debug(F111,"set line ",ttname,local);
#ifdef NETCONN
#ifdef SUNX25
    if (nettype == NET_SX25) duplex = 1; /* Duplex half */
#endif /* SUNX25 */
#endif /* NETCONN */
    return(success = 1);
 
#ifndef NOCSETS
case XYLANG: 				/* Language */
    if ((y = cmkey(lngtab,nlng,"","ascii",xxstring)) < 0) /* language code */
      return(y);
    if ((x = cmcfm()) < 0) return(x);	/* And confirmation of command */

    /* Look up language and get associated character sets */
    for (i = 0; (i < nlangs) && (langs[i].id != y); i++) ;
    if (i >= nlangs) {
	printf("internal error, sorry\n");
	return(success = 0);
    }
    language = i;			/* All good, set the language, */
#ifdef COMMENT				/* No more side effects! */
    fcharset = langs[i].fc;		/* the file character set, */
    tcharset = langs[i].tc;		/* and the transfer character set, */
    tslevel = (tcharset == TC_USASCII) ? TS_L0 : TS_L1;	/* Kermit's "Level" */
#endif /* COMMENT */
    return(success = 1);
#endif /* NOCSETS */

case XYBACK:				/* BACKGROUND */
    if ((z = cmkey(onoff,2,"","",xxstring)) < 0) return(z);
    if ((y = cmcfm()) < 0) return(y);
    bgset = z;
    success = 1;
    bgchk();
    return(success);

case XYBUF: {
#ifdef DYNAMIC
    int sb, rb;
    if ((y = cmnum("send buffer size","",10,&sb,xxstring)) < 0) {
	if (y == -3) printf("?two numbers required required\n");
	return(y);
    }
    if (sb < 0) {
	printf("?negative or overflow");
	return(-2);
    }
    if ((y = cmnum("receive buffer size","",10,&rb,xxstring)) < 0)  {
	if (y == -3) printf("?receive buffer size required\n");
	return(y);
    }
    if (rb < 0) {
	printf("?negative or overflow");
	return(-2);
    }
    if ((y = cmcfm()) < 0) return(y);
    if ((y = inibufs(sb,rb)) < 0) return(y);
    y = adjpkl(urpsiz,wslotr,bigrbsiz); /* Maybe adjust packet sizes */
    if (y != urpsiz) urpsiz = y;
    y = adjpkl(spsiz,wslotr,bigsbsiz);
    if (y != spsiz) spsiz = spmax = spsizr = y;
    return(success = 1);
#else
    printf("?Sorry, not available\n");
    return(success = 0);
#endif
}

case XYCHKT:				/* Block check type */
    if ((y = cmnum("1, 2, or 3","1",10,&x,xxstring)) < 0) return(y);
    if ((y = cmcfm()) < 0) return(y);
    if (x < 0 || x > 3) {
	printf("?The choices are 1, 2, and 3\n");
	return(-2);
    }
    bctr = x;			     /* Set locally too, even if REMOTE SET */
    if (rmsflg) {
	sprintf(tmpbuf,"%d",x);
	sstate = setgen('S', "400", tmpbuf, "");
	return((int) sstate);
    } else {
	return(success = 1);
    }
 
case XYCARR:				/* CARRIER */
    if ((y = cmkey(crrtab,ncrr,"","auto",xxstring)) < 0) return(y);
    if (y == CAR_ON) {
	x = cmnum("Carrier wait timeout, seconds","0",10,&z,xxstring);
	if (x < 0) return(z);
    }
    if ((x = cmcfm()) < 0) return(x);
    carrier = ttscarr(y);
    cdtimo = z;
    return(success = 1);

case XYCOUN:				/* SET COUNT */
    x = cmnum("Positive number","0",10,&z,xxstring);
    if (x < 0) return(z);
    if ((x = cmcfm()) < 0) return(x);
    if (z < 0) {
	printf("?A positive number, please\n");
	return(0);
    }
    debug(F101,"XYCOUN: z","",z);
    return(success = setnum(&count[cmdlvl],z,0,10000));

case XYCASE:
    success = seton(&incase);

case XYCMD:
    if ((y = cmkey(byttab,nbytt,"","bytesize",xxstring)) < 0) return(y);
    if ((y = cmnum("bytesize for command characters, 7 or 8","7",10,&x,
		   xxstring)) < 0)
	  return(y);
    if (x != 7 && x != 8) {
	printf("\n?The choices are 7 and 8\n");
	return(success = 0);
    }
    if ((y = cmcfm()) < 0) return(y);
    if (x == 7) cmdmsk = 0177;
    else if (x == 8) cmdmsk = 0377;
    return(success = 1);
    
case XYDFLT:
    return(success = docd());

case XYDEBU:				/* set debug { on, off, session } */
    if ((y = cmkey(dbgtab,ndbg,"","",xxstring)) < 0) return(y);
    if ((x = cmcfm()) < 0) return(x);
    switch (y) {
      case 0:				/* 0 = all debugging off. */
	debses = 0;
	if (deblog) doclslog(LOGD);
        return(success = 1);

      case 1:				/* 1 = log debugging to debug.log */
	deblog = debopn("debug.log");
	return(success = deblog ? 1 : 0);

      case 2:				/* 2 = session. */
	return(success = debses = 1);
    }
 
case XYDELA:
    y = cmnum("Number of seconds before starting to send","5",10,&x,xxstring);
    debug(F101,"XYDELA: y","",y);
    return(success = setnum(&delay,x,y,94));
 
case XYDIAL:
    if ((y = cmkey(dialtab,ndial,"","hangup",xxstring)) < 0) return(y);
    return(success = seton(&dialhang));

#ifdef COMMENT				/* Unused at present */
case XYDOUB:
    if ((x = cmfld("Character to double","none",&s,xxstring)) < 0) {
	if (x == -3) {
	    dblchar = -1;
	    printf("Doubling Off\n");
	    return(success = 1);
	} else return(x);
    }
    strcpy(line,s);
    lp = line;
    if ((x = cmcfm()) < 0) return(x);
    if (!xxstrcmp(lp,"none")) {
	dblchar = -1;
	printf("Doubling Off\n");
	return(success = 1);
    }
    if (strlen(lp) != 1) return(-2);
    dblchar = *lp & 0xFF;
    printf("Doubled: %d\n",dblchar);
    return(success = 1);
#endif

case XYDUPL:
    if ((y = cmkey(dpxtab,2,"","full",xxstring)) < 0) return(y);
    if ((x = cmcfm()) < 0) return(x);
    duplex = y;
    return(success = 1);
 
case XYESC:
    y = cmnum("Decimal ASCII code for escape character","",10,&x,xxstring);
    return(success = setcc(&escape,x,y));

case XYFILE:
    if (rmsflg) {
	if ((y = cmkey(rfiltab,nrfilp,"Remote file parameter","",
		       xxstring)) < 0) {
	    if (y == -3) {
		printf("?Remote file parameter required\n");
		return(-9);
	    } else return(y);
	}
    } else {
	if ((y = cmkey(filtab,nfilp,"File parameter","",xxstring)) < 0)
	  return(y);
    }
    switch (y) {
      case XYFILB:			/* Blocksize */
	sprintf(tmpbuf,"%d",DBLKSIZ);
	if ((y = cmnum("file block size",tmpbuf,10,&z,xxstring)) < 0)
	  return(y);
	if ((x = cmcfm()) < 0) return(x);
	if (rmsflg) {
	    sprintf(tmpbuf,"%d",z);
	    sstate = setgen('S', "311", tmpbuf, "");
	    return((int) sstate);
	} else {
	    fblksiz = z;
	    return(success = 1);
	}

      case XYFILS:			/* Byte size */
	if ((y = cmnum("file byte size (7 or 8)","8",10,&z,xxstring)) < 0)
	  return(y);
	if (z != 7 && z != 8) {
	    printf("\n?The choices are 7 and 8\n");
	    return(0);
	}
	if ((y = cmcfm()) < 0) return(y);
	if (z == 7) fmask = 0177;
	else if (z == 8) fmask = 0377;
	return(success = 1);

#ifndef NOCSETS
      case XYFILC:			/* Character set */
	if ((x = cmkey(fcstab,nfilc,"local file code","ascii", xxstring)) < 0)
	  return(x);
	if ((z = cmcfm()) < 0) return(z);
	fcharset = x;
	return(success = 1);
#endif /* NOCSETS */

      case XYFILD:			/* Display */
	y = seton(&z);
	if (y < 0) return(y);
	quiet = !z;
	return(success = 1);
 
      case XYFILN:			/* Names */
	if ((x = cmkey(fntab,2,"how to handle filenames","converted",
		       xxstring)) < 0)
	  return(x);
	if ((z = cmcfm()) < 0) return(z);
	fncnv = x;
	return(success = 1);
 
      case XYFILR:			/* Record length */
	sprintf(tmpbuf,"%d",DLRECL);
	if ((y = cmnum("file record length",tmpbuf,10,&z,xxstring)) < 0)
	  return(y);
	if ((x = cmcfm()) < 0) return(x);
	if (rmsflg) {
	    sprintf(tmpbuf,"%d",z);
	    sstate = setgen('S', "312", tmpbuf, "");
	    return((int) sstate);
	} else {
	    frecl = z;
	    return(success = 1);
	}

#ifdef COMMENT
      case XYFILO:			/* Organization */
	if ((x = cmkey(forgtab,nforg,"file organization","sequential",
		       xxstring)) < 0)
	  return(x);
	if ((y = cmcfm()) < 0) return(y);
	if (rmsflg) {
	    sprintf(tmpbuf,"%d",x);
	    sstate = setgen('S', "314", tmpbuf, "");
	    return((int) sstate);
	} else {
	    forg = x;
	    return(success = 1);
	}	
#endif

#ifdef COMMENT
      case XYFILF:			/* Format */
	if ((x = cmkey(frectab,nfrec,"file record format","stream",
		       xxstring)) < 0)
	  return(x);
	if ((y = cmcfm()) < 0) return(y);
	if (rmsflg) {
	    sprintf(tmpbuf,"%d",x);
	    sstate = setgen('S', "313", tmpbuf, "");
	    return((int) sstate);
	} else {
	    frecfm = x;
	    return(success = 1);
	}	
#endif

#ifdef COMMENT
      case XYFILP:			/* Printer carriage control */
	if ((x = cmkey(fcctab,nfcc,"file carriage control","newline",
		       xxstring)) < 0)
	  return(x);
	if ((y = cmcfm()) < 0) return(y);
	if (rmsflg) {
	    sprintf(tmpbuf,"%d",x);
	    sstate = setgen('S', "315", tmpbuf, ""));
	    return((int) sstate);
	} else {
	    fcctrl = x;
	    return(success = 1);
	}	
#endif

      case XYFILT:			/* Type */
	if ((x = cmkey(fttab,nfttyp,"type of file","text",xxstring)) < 0)
	  return(x);
	if ((y = cmnum("file byte size (7 or 8)","8",10,&z,xxstring)) < 0)
	  return(y);
	if (z != 7 && z != 8) {
	    printf("\n?The choices are 7 and 8\n");
	    return(0);
	}
	if ((y = cmcfm()) < 0) return(y);
	if (rmsflg) {
	    sstate = setgen('S', "300", x ? "1" : "0", "");
	    return((int) sstate);
	} else {
	    binary = x;
	    if (z == 7) fmask = 0177;
	    else if (z == 8) fmask = 0377;
	    return(success = 1);
	}
 
      case XYFILX:			/* Collision Action */
	if ((x = cmkey(colxtab,ncolx,"Filename collision action","backup",
		       xxstring)) < 0)
	  return(x);
	if ((y = cmcfm()) < 0) return(y);
	fncact = x;
	if (rmsflg) {
	    sprintf(tmpbuf,"%d",fncact);
	    sstate = setgen('S', "302", tmpbuf, "");
	    return((int) sstate);
	} else {
	    if (fncact == XYFX_R) warn = 1; /* SET FILE WARNING implications */
	    if (fncact == XYFX_X) warn = 0; /* ... */
	    return(success = 1);
	}

      case XYFILW:			/* Warning/Write-Protect */
	seton(&warn);
	if (warn)
	  fncact = XYFX_R;
	else
	  fncact = XYFX_X;
	return(success = 1);

      default:
	printf("?unexpected file parameter\n");
	return(-2);
    }
 
case XYFLOW:				/* Flow control */
    if ((y = cmkey(flotab,nflo,"","xon/xoff",xxstring)) < 0) return(y);
    if ((x = cmcfm()) < 0) return(x);
    flow = y;
    return(success = 1);
 
case XYHAND:				/* Handshake */
    if ((y = cmkey(hshtab,nhsh,"","none",xxstring)) < 0) return(y);
    if (y == 998) {
	if ((x = cmnum("ASCII value","",10,&y,xxstring)) < 0)
	  return(x);
	if ((y < 1) || ((y > 31) && (y != 127))) {
	    printf("?Character must be in ASCII control range\n");
	    return(-9);
	}
    }
    if ((x = cmcfm()) < 0) return(x);
    turn = (y > 0127) ? 0 : 1 ;
    turnch = y;
    return(success = 1);
 
case XYMACR:
    /* Note, if TAKE and MACRO options become different, make a new table */
    if ((y = cmkey(taktab,2,"","",xxstring)) < 0) return(y);
    switch (y) {
      case 0: return(success = seton(&mecho));
      case 1: return(success = seton(&merror));
      default: return(-2);
    }

#ifndef NODIAL
case XYMODM:
    if ((x = cmkey(mdmtab,nmdm,"type of modem","none", xxstring)) < 0)
	return(x);
    if ((y = cmkey(autotab,2,
		   "speed configuration","changes-speed",xxstring)) < 0)
      return(y);
    if ((z = cmcfm()) < 0) return(z);
    mdmtyp = x;
    mdmspd = y;
    return(success = 1);
#endif
	
case XYPARI:				/* Parity */
    if ((y = cmkey(partab,npar,"","none",xxstring)) < 0) return(y);
    if ((x = cmcfm()) < 0) return(x);
 
/* If parity not none, then we also want 8th-bit prefixing */
 
    if (parity = y) ebqflg = 1; else ebqflg = 0;
    return(success = 1);
 
case XYPROM:
    if ((x = cmtxt("Program's command prompt","C-Kermit>",&s,xxstring)) < 0)
      return(x);
    if (*s == '{') {			/* Remove enclosing braces, if any */
	x = strlen(s);
	if (s[x-1] == '}') {
	    s[x-1] = NUL;
	    s++;
	}
    } else if (*s == '"') {		/* For compatibility with pre-5A */
	x = strlen(s);
	if (s[x-1] == '"') {
	    s[x-1] = NUL;
	    s++;
	}
    }
    cmsetp(s);				/* set the prompt */
    return(success = 1);
 
case XYRETR:				/* Per-packet retry limit */
    y = cmnum("Maximum retries per packet","10",10,&x,xxstring);
    if ((x = setnum(&maxtry,x,y,94)) < 0) return(x);
    if (maxtry <= wslotr) {
	printf("?Retry limit must be greater than window size\n");
	return(success = 0);
    }
    sprintf(tmpbuf,"%d",maxtry);
    if (rmsflg) {
	sstate = setgen('S', "403", tmpbuf, "");
	return((int) sstate);
    } else return(success = x);
 
case XYSERV:				/* Server timeout */
    if ((y = cmkey(srvtab,1,"","timeout",xxstring)) < 0) return(y);
    switch (y) {
      case XYSERT:
	tp = tmpbuf;
        sprintf(tp,"%d",DSRVTIM);
	if ((y = cmnum("interval for server NAKs, 0 = none",tp,10,&x,
		       xxstring)) < 0)
	  return(y);
	if (x < 0) {
	    printf("\n?Specify a positive number, or 0 for no server NAKs\n");
	    return(0);
	}
	if ((y = cmcfm()) < 0) return(y);
	sprintf(tp,"%d",x);
	if (rmsflg) {
	    sstate = setgen('S', "404", tp, "");
	    return((int) sstate);
	} else {
	    srvtim = x;			/* Set the server timeout variable */
	    return(success = 1);
	}
      default:
	return(-2);
    }

case XYTAKE:				/* SET TAKE */
    if ((y = cmkey(taktab,2,"","",xxstring)) < 0) return(y);
    switch (y) {
      case 0: return(success = seton(&techo));
      case 1: return(success = seton(&terror));
      default: return(-2);
    }

case XYTERM:				/* Terminal parameters */
    if ((y = cmkey(trmtab,ntrm,"","bytesize",xxstring)) < 0) return(y);
    switch (y) {
      case 0:
	if ((y = cmnum("bytesize for terminal connection","8",10,&x,
		       xxstring)) < 0)
	  return(y);
	if (x != 7 && x != 8) {
	    printf("\n?The choices are 7 and 8\n");
	    return(success = 0);
	}
	if ((y = cmcfm()) < 0) return(y);
	if (x == 7) cmask = 0177;
	else if (x == 8) cmask = 0377;
        return(success = 1);
#ifdef OS2
      case 1:				/* Select terminal emulation */
	if ((x = cmkey(ttyptab,nttyp,"","vt100",xxstring)) < 0) return(x);
	if ((y = cmcfm()) < 0) return(y);
	if (x == 1) {
	    Term_mode = VT100;
	    return(success = 1);
	} else if (x == 2) {
	    Term_mode = TEKTRONIX;
	    Tek_scrinit(0);		/* Initialise Tektronix emulation */
	    return(success = 1);
	} else {
	    printf("%s - invalid\n",cmdbuf);
	    return(0);
	}
#endif /* OS2 */
      default:       /* Add more cases when we think of more parameters */
	return(-2);
    }    

/* SET SEND/RECEIVE... */
 
case XYRECV:
case XYSEND:
    if (xx == XYRECV)
    	strcpy(line,"Parameter for inbound packets");
    else
    	strcpy(line,"Parameter for outbound packets");
 
    if (rmsflg) {
	if ((y = cmkey(rsrtab,nrsrtab,line,"",xxstring)) < 0) {
	    if (y == -3) {
		printf("?Remote receive parameter required\n");
		return(-9);
	    } else return(y);
	}
    } else {
	if ((y = cmkey(srtab,nsrtab,line,"",xxstring)) < 0) return(y);
    }
    switch (y) {
 
case XYEOL:
    y = cmnum("Decimal ASCII code for packet terminator","13",10,&x,xxstring);
    if ((y = setcc(&z,x,y)) < 0) return(y);
    if (xx == XYRECV) eol = z; else seol = z;
    return(success = y);
 
case XYLEN:
    y = cmnum("Maximum number of characters in a packet","90",10,&x,xxstring);
    if (xx == XYRECV) {			/* Receive... */
	if ((y = setnum(&z,x,y,maxrps)) < 0)
	  return(y);
	if (rmsflg) {
	    tp = tmpbuf;
	    sprintf(tp,"%d",z);
	    sstate = setgen('S', "401", tp, "");
	    return((int) sstate);
	} else {
	    if (z > MAXRP) z = MAXRP;
	    y = adjpkl(z,wslotr,bigrbsiz);
	    if (y != z) {
		urpsiz = y;
		if (cmdlvl == 0)
		  printf("Adjusting packet size to %d for %d window slots\n",
			 y, wslotr);
	    }
	    urpsiz = y;
	    rpsiz =  (y > 94) ? 94 : y;
	}
    } else {				/* Send... */
	if ((y = setnum(&z,x,y,maxsps)) < 0)
	  return(y);
	if (z > MAXSP) z = MAXSP;
	spsiz = z;			/* Set it */
	y = adjpkl(spsiz,wslotr,bigsbsiz);
	if (y != spsiz && cmdlvl == 0)
	    printf("Adjusting packet size to %d for %d window slots\n",
		   y,wslotr);
	spsiz = spmax = spsizr = y;	/* Set it and flag that it was set */
	spsizf = 1;			/* to allow overriding Send-Init. */
    }
    if (pflag && cmdlvl == 0) {
	if (z > 94) {
	    printf("Extended-length packets requested.\n");
	    if (bctr < 2 && z > 200) printf("\
Remember to SET BLOCK 2 or 3 for long packets.\n");
	}
	if (speed <= 0L) speed = ttgspd();
	if (speed <= 0L && z > 200) {
	    printf("\
Make sure your timeout interval is long enough for %d-byte packets.\n",z);
	}
    }
    chktimo();				/* Check timeout */
    return(success = y);
 
case XYMARK:
    y = cmnum("Code for packet-start character","1",10,&x,xxstring);
    if ((y = setcc(&z,x,y)) < 0) return(y);
    if (xx == XYRECV) stchr = z; else mystch = z;
    return(success = y);

case XYNPAD:				/* Padding */
    y = cmnum("How many padding characters for inbound packets","0",10,&x,
	      xxstring);
    if ((y = setnum(&z,x,y,94)) < 0) return(y);
    if (xx == XYRECV) mypadn = z; else npad = z;
    return(success = y);
 
case XYPADC:				/* Pad character */
    y = cmnum("Decimal ASCII code for packet padding character","0",10,&x,
	      xxstring);
    if ((y = setcc(&z,x,y)) < 0) return(y);
    if (xx == XYRECV) mypadc = z; else padch = z;
    return(success = y);
 
case XYTIMO:
    y = cmnum("Interpacket timeout interval","5",10,&x,xxstring);
    if ((y = setnum(&z,x,y,94)) < 0) return(y);
    if (xx == XYRECV) {
	if (rmsflg) {
	    tp = tmpbuf;
	    sprintf(tp,"%d",z);
	    sstate = setgen('S', "402", tp, "");
	    return((int) sstate);
	} else {
	    timef = 1;
	    timint = pkttim = z;
	}
    } else rtimo = z;
    chktimo();
    return(success = y);
 
  }					/* End of SET SEND/RECEIVE... */
 
#ifdef UNIX
case XYSESS:				/* SESSION-LOG */
    if ((x = cmkey(fttab,2,"type of file","text",xxstring)) < 0)
      return(x);
    if ((y = cmcfm()) < 0) return(y);
    sessft = x;
    return(success = 1);
#endif

case XYSPEE:
    if (network) {
	printf("\n?Speed cannot be set for network connections\n");
	return(success = 0);
    }
    lp = line;
    sprintf(lp,"Transmission rate for %s in bits per second",ttname);

    if ((x = cmkey(spdtab,nspd,line,"",xxstring)) < 0) {
	if (x == -3) printf("?value required\n");
	return(x);
    }
    if ((y = cmcfm()) < 0) return(y);
    if (!local) {
	printf("?Speed may be changed only on an external line\n");
	return(success = 0);
    }
    zz = (long) x * 10L;
    if (zz == 70) zz = 75;		/* (see spdtab[] def) */
    y = ttsspd(x);			/* Call ttsspd with cps, not bps! */
    if (y < 0)  {
	printf("?Unsupported line speed - %ld\n",zz);
	return(success = 0);
    } else {
	speed = zz;
	if (pflag && cmdlvl == 0) {
	    if (speed == 8880)
	      printf("%s, 75/1200 bps\n",ttname);
	    else
	      printf("%s, %ld bps\n",ttname,speed);
	}
	return(success = 1);
    }
 
#ifndef NOCSETS
  case XYXFER:
    if ((y = cmkey(tstab,nts,"","character-set",xxstring)) < 0) return(y);
    if (y == 1) {			/* character-set */
	if ((y = cmkey(tcstab,ntcs,"","transparent",xxstring)) < 0) return(y);
	if ((x = cmcfm()) < 0) return(x);
	if (rmsflg) {
	    sstate = setgen('S', "405", tcsinfo[y].designator, "");
	    return((int) sstate);
	} else {
	    tslevel = 1;		/* transfer syntax level 1 */
	    tcharset = y;		/* transfer character set */
	    return(success = 1);
	}
    }
    if ((x = cmcfm()) < 0) return(x);
    if (y > 1) {			/* International syntax */
	printf("(not implemented yet)\n");
	return(success = 0);
    }
    if (y == 0) {			/* ASCII or transparent */
	tslevel = 0;
	tcharset = y;
	return(success = 1);
    }
    printf("?Internal problem\n");	/* shouldn't see this */
    return(0);
#endif /* NOCSETS */

  case XYXMIT:				/* Transmit */
    if ((y = cmkey(xmitab,nxmit,"","",xxstring)) < 0) return(y);
    switch (y) {
      case XMITE:			/* EOF */
	y = cmtxt("Characters to send at end of file,\n\
 Use backslash codes for control characters","",&s,xxstring);
	if (y < 0) return(y);
	if (strlen(s) > XMBUFL) {
	    printf("?Too many characters, %d maximum\n",XMBUFL);
	    return(-2);
	}
	strcpy(xmitbuf,s);
	return(success = 1);

      case XMITF:			/* Fill */
	y = cmnum("Numeric code for blank-line fill character","0",10,&x,
		  xxstring);
	if ((y = setnum(&z,x,y,127)) < 0) return(y);
	xmitf = z;
	return(success = 1);
      case XMITL:			/* Linefeed */
        return(success = seton(&xmitl));
      case XMITP:			/* Prompt */
	y = cmnum("Numeric code for host's prompt character","10",10,&x,
		  xxstring);
	if ((y = setnum(&z,x,y,127)) < 0) return(y);
	xmitp = z;
	return(success = 1);
    }

#ifndef NOCSETS
  case XYUNCS:				/* Unknown character set */
    if ((y = cmkey(ifdtab,2,"","discard",xxstring)) < 0) return(y);
    if ((x = cmcfm()) < 0) return(x);
    unkcs = y;
    return(success = 1);
#endif /* NOCSETS */

#ifdef UNIX
  case XYWILD:				/* Wildcard expansion */
    if ((y = cmkey(wildtab,2,"who expands wildcards","kermit",xxstring)) < 0)
      return(y);
    if ((x = cmcfm()) < 0) return(x);
    wildxpand = y;
    return(success = 1);
#endif /* UNIX */

  case XYWIND:				/* Window slots */
    y = cmnum("Number of sliding-window slots, 1 to 31","1",10,&x,xxstring);
    y = setnum(&wslotr,x,y,31);
    if (y < 0) return(y);
    if (wslotr < 1) wslotr = 1;
#ifdef COMMENT
    /* This is unreasonable */
    if (maxtry < wslotr) {
	printf("?Window slots must be less than retry limit\n");
	return(success = 0);
    }
#endif
    if (rmsflg) {
	tp = tmpbuf;
	sprintf(tp,"%d",wslotr);
	sstate = setgen('S', "406", tp, "");
	return((int) sstate);
    }
    swcapr = (wslotr > 1) ? 1 : 0;	/* Set window bit in capas word? */
    if (wslotr > 1) {			/* Window size > 1? */
	y = adjpkl(urpsiz,wslotr,bigrbsiz); /* Maybe adjust packet size */
	if (y != urpsiz) {		       /* Did it change? */
	    urpsiz = y;
	    printf("Adjusting receive packet size to %d for %d window slots\n",
		   urpsiz, wslotr);
	}
    } else swcapr = 0;
    return(success = 1);

default:
    if ((x = cmcfm()) < 0) return(x);
    printf("Not working yet - %s\n",cmdbuf);
    return(success = 0);
    }
}

/*  S E T O N  --  Parse on/off (default on), set parameter to result  */
 
seton(prm) int *prm; {
    int x, y;
    if ((y = cmkey(onoff,2,"","on",xxstring)) < 0) return(y);
    if ((x = cmcfm()) < 0) return(x);
    *prm = y;
    return(1);
}
 
/*  S E T N U M  --  Set parameter to result of cmnum() parse.  */
/*
 Call with x - number from cnum parse, y - return code from cmnum
*/
setnum(prm,x,y,max) int x, y, *prm, max; {
    extern int cmflgs; extern char atxbuf[];
    debug(F101,"setnum","",y);
    if (y == -3) {
	printf("\n?Value required\n");
	return(-9);
    }
    if (y == -2) {
	printf("%s?Not a number: %s\n",cmflgs == 1 ? "" : "\n", atxbuf);
	return(-9);
    }
    if (y < 0) return(y);
    if (x > max) {
	printf("?Sorry, %d is the maximum\n",max);
	return(-9);
    }
    if ((y = cmcfm()) < 0) return(y);
    *prm = x;
    return(1);
}
 
/*  S E T C C  --  Set parameter to an ASCII control character value.  */
 
setcc(prm,x,y) int x, y, *prm; {
    if (y == -3) {
	printf("\n?Value required\n");
	return(-3);
    }
    if (y < 0) return(y);
    if ((x > 037) && (x != 0177)) {
	printf("\n?Not in ASCII control range - %d\n",x);
	return(-2);
    }
    if ((y = cmcfm()) < 0) return(y);
    *prm = x;
    return(1);
}

/*  D O R M T  --  Do a remote command  */
 
dormt(xx) int xx; {
    int x, y, retcode;
    char *s, sbuf[50], *s2;
 
    if (xx < 0) return(xx);

    if (xx == XZSET) {			/* REMOTE SET */
	if ((y = cmkey(rmstab,nrms,"","",xxstring)) < 0) {
	    if (y == -3) {
		printf("?Parameter name required\n");
		return(-9);
	    } else return(y);
	}
	return(doprm(y,1));
    }

    switch (xx) {			/* Others... */
 
case XZCWD:				/* CWD */
    if ((x = cmtxt("Remote directory name","",&s,xxstring)) < 0) return(x);
    debug(F111,"XZCWD: ",s,x);
    *sbuf = NUL;
    s2 = sbuf;

/* The following is commented out, because there is practically no */
/* computer in the world that requires a password for directory changing. */
/* (The DEC-20 was the only one, and they're mostly all gone.) */
#ifdef DIRPWDPR
    if (*s != NUL) {			/* If directory name given, */
					/* get password on separate line. */
        if (tlevel > -1) {		/* From take file... */
 
	    if (fgets(sbuf,50,tfile[tlevel]) == NULL)
	    	fatal("take file ends prematurely in 'remote cwd'");
	    debug(F110," pswd from take file",s2,0);
	    for (x = strlen(sbuf);
	     	 x > 0 && (sbuf[x-1] == NL || sbuf[x-1] == CR);
		 x--)
		sbuf[x-1] = '\0';
 
        } else {			/* From terminal... */
 
	    printf(" Password: "); 		/* get a password */
#ifdef OS2
	    while (((x = isatty(0) ? coninc(0) :
		     getchar()) != NL) && (x != CR)) {     /* with no echo */
#else
	    while (((x = getchar()) != NL) && (x != CR)) { /* with no echo */
#endif
	    	if ((x &= 0177) == '?') {
	    	    printf("? Password of remote directory\n Password: ");
		    s2 = sbuf;
		    *sbuf = NUL;
	    	}
	    	else if (x == ESC)	/* Mini command line editor... */
	    	    putchar(BEL);
		else if (x == BS || x == 0177)
		    s2--;
		else if (x == 025) {	/* Ctrl-U */
		    s2 = sbuf;
		    *sbuf = NUL;
		}
	    	else
		    *s2++ = x;
            }
	    *s2 = NUL;
	    putchar('\n');
        }
        s2 = sbuf;
    } else s2 = "";
#endif /* DIRPWDPR */

    debug(F110," password",s2,0);
    sstate = setgen('C',s,s2,"");
    retcode = 0;
    break;

case XZDEL:				/* Delete */
    if ((x = cmtxt("Name of remote file(s) to delete","",&s,xxstring)) < 0) {
	if (x == -3) {
	    printf("?Name of remote file(s) required\n");
	    return(-9);
	} else return(x);
    }
    if (local) ttflui();		/* If local, flush tty input buffer */
    retcode = sstate = rfilop(s,'E');
    break;
 
case XZDIR:				/* Directory */
    if ((x = cmtxt("Remote directory or file specification","",&s,
		   xxstring)) < 0)
    	return(x);
    if (local) ttflui();		/* If local, flush tty input buffer */
    retcode = sstate = setgen('D',s,"","");
    break;
 
case XZHLP:				/* Help */
    if ((x = cmcfm()) < 0) return(x);
    sstate = setgen('H',"","","");
    retcode = 0;
    break; 

case XZHOS:				/* Host */
    if ((x = cmtxt("Command for remote system","",&cmarg,xxstring)) < 0)
      return(x);
    if (strlen(cmarg) < 1)  {
	if (x == -3) {
	    printf("?Remote host command required\n");
	    return(-9);
	} else return(x);
    }
    retcode = sstate = 'c';
    break; 

case XZPRI:				/* Print */
    if (!atdiso || !atcapr) {		/* Disposition attribute off? */
	printf("?Disposition Attribute is Off\n");
	return(-2);
    }
    cmarg = "";
    cmarg2 = "";
    if ((x = cmifi("Local file(s) to print on remote printer","",&s,&y,
		   xxstring)) < 0) {
	if (x == -3) {
	    printf("?Name of local file(s) required\n");
	    return(-9);
	}
	return(x);
    }
    strcpy(line,s);			/* Make a safe copy of filename */
    *optbuf = NUL;			/* Wipe out any old options */
    if ((x = cmtxt("Options for remote print command","",&s,xxstring)) < 0)
      return(x);
    strcpy(optbuf,s);			/* Make a safe copy of options */
    if (strlen(optbuf) > 94) {		/* Make sure this is legal */
	printf("?Option string too long\n");
	return(-9);
    }
    nfils = -1;				/* Expand file list internally */
    cmarg = line;			/* Point to file list. */
    rprintf = 1;			/* REMOTE PRINT modifier for SEND */
    sstate = 's';			/* Set start state to SEND */
    if (local) displa = 1;
    retcode = 0;
    break;
	
case XZSPA:				/* Space */
    if ((x = cmtxt("Confirm, or remote directory name","",&s,xxstring)) < 0)
      return(x);
    retcode = sstate = setgen('U',s,"","");
    break;
    
case XZTYP:				/* Type */
    if ((x = cmtxt("Remote file specification","",&s,xxstring)) < 0)
      return(x);
    if (strlen(s) < 1) {
	printf("?Remote filename required\n");
        return(-9);	
    }
    retcode = sstate = rfilop(s,'T');
    break;
 
case XZWHO:
    if ((x = cmtxt("Remote user name, or carriage return","",&s,xxstring)) < 0)
    	return(x);
    retcode = sstate = setgen('W',s,"","");
    break;
 
default:
        if ((x = cmcfm()) < 0) return(x);
        printf("not working yet - %s\n",cmdbuf);
        return(-2);
    }
    if (local) ttflui();		/* If local, flush tty input buffer */
    return(retcode);
}
 
 
/*  R F I L O P  --  Remote File Operation  */
 
rfilop(s,t) char *s, t; {
    if (*s == NUL) {
	printf("?File specification required\n");
	return(-2);
    }
    debug(F111,"rfilop",s,t);
    return(setgen(t,s,"",""));
}
#endif /* NOICP */
