char *userv = "User Interface 5A(072), 12 Oct 90";
#ifndef NOICP
 
/*  C K U U S R --  "User Interface" for Unix Kermit (Part 1)  */

/*
 Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET),
 Columbia University Center for Computing Activities.
 First released January 1985.
 Copyright (C) 1985, 1990, Trustees of Columbia University in the City of New 
 York.  Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as it is not sold for profit, provided this
 copyright notice is retained. 
*/

/*
  NOTE: Because of the massive additions in functionality, and therefore
  the increase in the number of commands, much code was moved from here to
  the two new modules, ckuus4.c and ckuus5.c.  This module now contains only
  the top-level command keyword table, the SET command keyword table, and
  the top-level interactive command parser/dispatcher.  ckuus3.c contains the
  rest of the SET and REMOTE command parsers; ckuus2.c contains the help
  command parser and help text strings, and ckuus4.c and ckuus5.c contain
  miscellaneous pieces that logically belong in the ckuusr.c file but had to
  be moved because of size problems with some C compilers / linkers.
*/

/*
 The ckuus*.c modules depend on the existence of C library features like fopen,
 fgets, feof, (f)printf, argv/argc, etc.  Other functions that are likely to
 vary among Unix implementations -- like setting terminal modes or interrupts
 -- are invoked via calls to functions that are defined in the system-
 dependent modules, ck?[ft]io.c.  The command line parser processes any
 arguments found on the command line, as passed to main() via argv/argc.  The
 interactive parser uses the facilities of the cmd package (developed for this
 program, but usable by any program).  Any command parser may be substituted
 for this one.  The only requirements for the Kermit command parser are these:

1. Set parameters via global variables like duplex, speed, ttname, etc.  See
   ckmain.c for the declarations and descriptions of these variables.

2. If a command can be executed without the use of Kermit protocol, then
   execute the command directly and set the variable sstate to 0. Examples
   include 'set' commands, local directory listings, the 'connect' command.

3. If a command requires the Kermit protocol, set the following variables:

    sstate                             string data
      'x' (enter server mode)            (none)
      'r' (send a 'get' command)         cmarg, cmarg2
      'v' (enter receive mode)           cmarg2
      'g' (send a generic command)       cmarg
      's' (send files)                   nfils, cmarg & cmarg2 OR cmlist
      'c' (send a remote host command)   cmarg

    cmlist is an array of pointers to strings.
    cmarg, cmarg2 are pointers to strings.
    nfils is an integer.

    cmarg can be a filename string (possibly wild), or
       a pointer to a prefabricated generic command string, or
       a pointer to a host command string.
    cmarg2 is the name to send a single file under, or
       the name under which to store an incoming file; must not be wild.
       If it's the name for receiving, a null value means to store the
       file under the name it arrives with.
    cmlist is a list of nonwild filenames, such as passed via argv.
    nfils is an integer, interpreted as follows:
      -1: filespec (possibly wild) in cmarg, must be expanded internally.
       0: send from stdin (standard input).
      >0: number of files to send, from cmlist.

 The screen() function is used to update the screen during file transfer.
 The tlog() function writes to a transaction log.
 The debug() function writes to a debugging log.
 The intmsg() and chkint() functions provide the user i/o for interrupting
   file transfers.
*/

/* Includes */
 
#include <stdio.h>
#include <ctype.h>
#ifndef AMIGA
/* Apparently these should be included for OS/2 C-Kermit after all... */
/* #ifndef OS2 */
/* #include <signal.h> (not needed, see zshcmd()) */
#include <setjmp.h> /* maybe this is not needed either? */
/* #endif */
#endif

#include "ckcdeb.h"
#include "ckcasc.h"
#include "ckcker.h"
#include "ckcfil.h"
#include "ckuusr.h"
#include "ckcxla.h"
#include "ckcnet.h"			/* Network symbols */
 
#ifdef datageneral
#define fgets(stringbuf,max,fd) dg_fgets(stringbuf,max,fd)
#endif

/* External Kermit Variables, see ckmain.c for description. */
 
extern int size, rpsiz, urpsiz, local, rmailf, stdinf, sndsrc,
  server, displa, binary, parity, deblog, escape, xargc, flow,
  turn, duplex, nfils, ckxech, pktlog, seslog, tralog, stdouf,
  turnch, dfloc, keep, maxrps, warn, quiet, cnflg, tlevel, pflag,
  mdmtyp, zincnt, fblksiz, frecl, frecfm, atcapr, atdiso, verwho;
 
extern int xxstring();			/* Variable expander */

extern long vernum, speed, zchki();
extern char *versio, *protv, *ckxv, *ckzv, *fnsv, *connv, *dftty, *cmdv;
extern char *dialv, *loginv;
extern char *ckxsys, *ckzsys, *cmarg, *cmarg2, **xargv, **cmlist;
extern char *DIRCMD, *PWDCMD, *DELCMD, *WHOCMD, optbuf[], ttname[], filnam[];
extern char *malloc();
extern CHAR sstate;
extern CHAR *zinptr;

#ifndef NOMSEND				/* Multiple SEND */
#define MSENDMAX 100			/* adds about 200 words... */
#define FSPECL 100
extern char *msfiles[];
#else
#define FSPECL 50
#endif
char fspec[FSPECL];			/* Most recent filespec */

#ifndef NOCSETS
extern int tcharset, fcharset;
extern struct csinfo fcsinfo[], tcsinfo[];
#endif

char *strcpy(), *getenv(), *arrayval();
#ifdef AMIGA
char *getcwd();
#endif
#ifdef OS2
char *getcwd();
#endif

/* Variables for TRANSMIT command */

int xmitf = 0;			/* Character to fill empty lines */
int xmitl = 0;			/* 1 = Send linefeeds too */
int xmitp = LF;			/* Host line prompt */

/* Declarations from cmd package */
 
extern char cmdbuf[], atmbuf[], savbuf[]; /* Command buffers */
 
/* Declarations from ck?fio.c module */
 
extern char *SPACMD, *zhome();	/* Space command, home directory. */
extern int backgrd, bgset;	/* Kermit executing in background */
#ifdef OS2
extern char *zfindfile();
#endif
 
/* Variables and symbols local to this module */
 
extern char line[];			/* Character buffer for anything */
char *lp;				/* Pointer to line buffer */
extern char inpbuf[];			/* Buffer for INPUT and REINPUT */
char *inpbp = inpbuf;			/* And pointer to same */
char psave[80] = { NUL };		/* For saving & restoring prompt */
extern char vnambuf[];			/* Buffer for variable names */
extern char *vnp;			/* Pointer to same */
extern char lblbuf[];			/* Buffer for labels */
extern char debfil[];			/* Debugging log file name */
extern char pktfil[];			/* Packet log file name */
extern char sesfil[];			/* Session log file name */
extern char trafil[];			/* Transaction log file name */
extern char tmpbuf[];			/* Temporary buffer */
char *tp;				/* Temporary pointer */
 
extern int action, cflg,		/* Command-line connect cmd given */
fblksiz, frecl, frecfm, forg, fcctrl;

static int n;				/* General-purpose int */

int repars,				/* Reparse needed */
    ifc,				/* IF case */
    not = 0,				/* Flag for IF NOT */
    techo = 0,				/* Take echo */
    terror = 1,				/* Take error action, 1 = quit */
    cwdf = 0;				/* CWD has been done */

extern int en_cwd, en_del, en_dir, en_fin, /* Flags for ENABLE/DISABLE */
   en_get, en_hos, en_sen, en_set, en_spa, en_typ, en_who, en_bye;

int					/* SET INPUT parameters. */
  indef = 5,				/* 5 seconds default timeout */
  intime = 0,				/* 0 = proceed */
  incase = 0,				/* 0 = ignore */
  inecho = 1;				/* 1 = echo on */
 
int maclvl = -1;			/* Macro to execute */
extern char *macx[];			/* Index of current macro */
extern char *mrval[];			/* Macro return value */
int mecho = 0;				/* Macro echo */
int merror = 0;				/* Macro error action */
extern char *macp[];			/* Pointer to macro */
char varnam[6];				/* For variable names */
extern int macargc[];			/* ARGC from macro invocation */
extern int success;			/* Command success/failure flag */

extern FILE *tfile[];			/* File pointers for TAKE command */

extern char *m_arg[MACLEVEL][NARGS];	/* Stack of macro arguments */
extern char *g_var[];			/* Global variables %a, %b, etc */
 
extern char **a_ptr[];			/* Array pointers */
extern int a_dim[];			/* Array dimensions */

extern struct cmdptr cmdstk[];		/* The command stack itself */
extern int cmdlvl;			/* Current position in command stack */
extern int count[];			/* For IF COUNT, one for each cmdlvl */
extern int ifcmd[];			/* Last command was IF */
extern int iftest[];			/* Last IF was true */
int ifargs;				/* Count of IF condition words */
char ifcond[100];			/* IF condition text */
char *ifcp;				/* Pointer to IF condition text */

char *homdir;				/* Pointer to home directory string */
extern char kermrc[];			/* Name of initialization file */
int rcflag = 0;				/* Flag for alternate init file name */
extern char cmdstr[];			/* Place to build generic command */
extern int tvtflg;			/* Flag that ttvt() has been called */

/* Top-Level Interactive Command Keyword Table */
 
struct keytab cmdtab[] = {
    "!",	   XXSHE, 0,		/* shell escape */
    "#",    	   XXCOM, CM_INV,	/* comment */
    ":",           XXLBL, CM_INV,	/* label */
    "@",           XXSHE, CM_INV,	/* DCL escape */
    "asg",         XXASS, CM_INV,       /* invisible synonym for assign */
    "ask",         XXASK, 0,		/* ask */
    "askq",        XXASKQ,0,            /* ask quietly */
    "assign",      XXASS, 0,            /* assign */
    "bug",         XXBUG, 0,		/* bug report instructions */
    "bye",         XXBYE, 0,		/* bye to remote server */
    "c",           XXCON, CM_INV|CM_ABR, /* invisible synonym for connect */
    "cat",         XXTYP, CM_INV,	/* display a local file */
    "cd",          XXCWD, 0,		/* change directory */
    "clear",       XXCLE, 0,		/* clear input buffer */
    "close",	   XXCLO, 0,		/* close a log file */
    "comment",     XXCOM, 0,		/* comment */
    "connect",     XXCON, 0,		/* connect to remote system */
    "cwd",	   XXCWD, CM_INV,	/* invisisble synonym for cd */
    "dcl",         XXDCL, CM_INV,	/* declare an array */
    "declare",     XXDCL, 0,		/* declare an array */
    "decrement",   XXDEC, 0,		/* decrement a numeric variable */
    "define",      XXDEF, 0,		/* define a macro */
    "delete",      XXDEL, 0,		/* delete a file */
#ifndef NODIAL
    "dial",	   XXDIAL,0,		/* dial a phone number */
#endif
    "directory",   XXDIR, 0,		/* directory of files */
    "disable",     XXDIS, 0,		/* disable server function */
    "do",          XXDO,  0,		/* execute a macro */
    "echo",        XXECH, 0,		/* echo argument */
    "else",        XXELS, CM_INV,	/* ELSE part of IF statement */
    "enable",      XXENA, 0,		/* enable a server function */
    "end",         XXEND, 0,		/* END command file or macro */
    "error",       XXERR, 0,		/* Send an Error packet */
    "exit",	   XXEXI, 0,		/* exit the program */
    "finish",      XXFIN, 0,		/* FINISH */
    "for",         XXFOR, 0,		/* FOR loop */
    "get",         XXGET, 0,		/* GET */
    "goto",        XXGOTO,0,		/* goto label in take file or macro */     "hangup",      XXHAN, 0,		/* hangup dialed phone connection */
    "help",	   XXHLP, 0,		/* display help text */
    "i",           XXINP, CM_INV|CM_ABR, /* invisible synonym for INPUT */
    "if",          XXIF,  0,		/* if (condition) command */
    "increment",   XXINC, 0,		/* increment a numeric variable */
    "input",       XXINP, 0,		/* input string from comm line */
    "l",           XXLOG, CM_INV|CM_ABR,/* invisible synonym for log */
    "log",  	   XXLOG, 0,		/* open a log file */
    "ls",          XXDIR, CM_INV,	/* invisible synonym for directory */
    "mail",        XXMAI, 0,		/* mail file to user */
    "man",         XXHLP, CM_INV,       /* Synonym for help */
#ifndef NOMSEND
    "msend",       XXMSE, 0,		/* Multiple SEND */
#endif
    "open",        XXOPE, 0,		/* open file for reading or writing */
    "output",      XXOUT, 0,		/* output string to comm line */
#ifdef SUNX25
    "pad",         XXPAD, 0,            /* PAD commands */
#endif /* SUNX25 */
    "pause",       XXPAU, 0,		/* sleep for specified interval */
    "pop",         XXEND, CM_INV,	/* allow POP as synonym for END */
    "push",        XXSHE, 0,		/* PUSH command (like RUN, !) */
    "pwd",         XXPWD, 0,            /* print working directory */
    "quit",	   XXQUI, 0,		/* quit from program = exit */
    "r",           XXREC, CM_INV,	/* invisible synonym for receive */
    "read",        XXREA, 0,            /* read */
    "receive",	   XXREC, 0,		/* receive files */
    "reinput",     XXREI, 0,            /* reinput */
    "remote",	   XXREM, 0,		/* send generic command to server */
    "rename",      XXREN, 0,		/* rename a local file */
    "replay",      XXTYP, CM_INV,	/* replay (for now, just type) */
    "return",      XXRET, 0,		/* return from function */
    "rm",          XXDEL, CM_INV,	/* invisible synonym for delete */
    "run",         XXSHE, 0,		/* run a program or command */
    "s",           XXSEN, CM_INV|CM_ABR, /* invisible synonym for send */
#ifndef NOSCRIPT
    "script",	   XXLOGI,0,		/* execute a uucp-style script */
#endif
    "send",	   XXSEN, 0,		/* send files */
    "server",	   XXSER, 0,		/* be a server */
    "set",	   XXSET, 0,		/* set parameters */
    "show", 	   XXSHO, 0,		/* show parameters */
    "sleep",       XXPAU, CM_INV,	/* sleep for specified interval */
    "space",       XXSPA, 0,		/* show available disk space */
    "spawn",       XXSHE, CM_INV,	/* synonym for PUSH, RUN */
#ifdef COMMENT /* These don't work yet */
    "ssend",       XXCMS, 0,		/* send from a shell command */
    "sreceive",    XXCMR, 0,            /* receive to a shell command */
    "sget",        XXCMG, 0,		/* get to a shell command */
#endif
    "statistics",  XXSTA, 0,		/* display file transfer stats */
    "stop",        XXSTO, 0,		/* stop all take files */
    "suspend",     XXSUS, 0,		/* Suspend */
    "take",	   XXTAK, 0,		/* take commands from file */
    "test",        XXTES, CM_INV,	/* (for testing) */
#ifndef NOCSETS
    "translate",   XXXLA, 0,		/* translate local file char sets */
#endif
    "transmit",    XXTRA, 0,		/* raw upload file */
    "type",        XXTYP, 0,		/* display a local file */
    "version",     XXVER, 0,		/* version number display */
    "wait",        XXWAI, 0,		/* wait (like pause) */
    "while",       XXWHI, 0,		/* while */
    "who",         XXWHO, 0,		/* who */
    "write",       XXWRI, 0,		/* write */
    "xif",         XXIFX, 0,		/* Extended IF */
    "z",           XXSUS, CM_INV	/* Suspend */
};
int ncmd = (sizeof(cmdtab) / sizeof(struct keytab));

char toktab[] = {
    '!',				/* Shell escape */
    '#',				/* Comment */
    ';',				/* Comment */
#ifdef COMMENT  /* who needs it */
    '&',				/* Echo */
#endif
    ':',				/* Label */
    '@',				/* DCL escape */
    '\0'				/* End of this string */
};

/* Parameter keyword table */
 
struct keytab prmtab[] = {
    "attributes",       XYATTR,  0,
    "background",       XYBACK,  0,
    "baud",	        XYSPEE,  CM_INV,
    "block-check",  	XYCHKT,  0,
#ifdef DYNAMIC
    "buffers",          XYBUF,   0,
#endif
    "carrier",          XYCARR,  0,
    "case",             XYCASE,  0,
    "command",          XYCMD,   0,
#ifdef COMMENT
    "compression",      XYCOMP,  0,
#endif
    "count",            XYCOUN,  0,
    "debug",            XYDEBU,  CM_INV,
#ifdef vms
    "default",          XYDFLT,  0,
#else
    "default",          XYDFLT,  CM_INV,
#endif
    "delay",	    	XYDELA,  0,
    "dial",             XYDIAL,  0,
#ifdef COMMENT
    "double",           XYDOUB,  0,	/* No, too expensive. */
#endif
    "duplex",	    	XYDUPL,  0,
    "end-of-packet",    XYEOL,   CM_INV, /* moved to send/receive */
    "escape-character", XYESC,   0,
    "file", 	  	XYFILE,  0,
    "flow-control", 	XYFLOW,  0,
    "handshake",    	XYHAND,  0,
#ifdef NETCONN
    "host",             XYHOST,  0,
#endif /* NETCONN */
    "incomplete",   	XYIFD,   0,
    "input",            XYINPU,  0,
    "l",                XYLINE,  CM_INV|CM_ABR,
#ifndef NOCSETS
    "language",         XYLANG,  0,
#endif
    "line",             XYLINE,  0,
    "macro",            XYMACR,  0,
#ifndef NODIAL
    "modem-dialer",	XYMODM,	 0,
#endif
#ifdef NETCONN
    "network",          XYNET,   CM_INV,
#endif /* NETCONN */
    "packet-length",    XYLEN,   CM_INV, /* moved to send/receive */
#ifdef SUNX25
    "pad",              XYPAD,   0,
#endif /* SUNX25 */
    "pad-character",    XYPADC,  CM_INV, /* moved to send/receive */
    "padding",          XYNPAD,  CM_INV, /* moved to send/receive */
    "parity",	    	XYPARI,  0,
    "port",             XYLINE,  CM_INV,
    "prompt",	    	XYPROM,  0,
    "receive",          XYRECV,  0,
    "retry",            XYRETR,  0,
    "send",             XYSEND,  0,
    "server",           XYSERV,  0,
#ifdef UNIX
    "session-log",      XYSESS,  0,
#endif
    "speed",	        XYSPEE,  0,
    "start-of-packet",  XYMARK,  CM_INV, /* moved to send/receive */
    "take",             XYTAKE,  0,
    "terminal",         XYTERM,  0,
    "timeout",	        XYTIMO,  CM_INV, /* moved to send/receive */
#ifndef NOCSETS
    "transfer",         XYXFER,  0,
#endif
    "transmit",         XYXMIT,  0,
    "unknown-char-set", XYUNCS, 0,
    "window-size",      XYWIND,  0,
#ifdef UNIX
    "wildcard-expansion", XYWILD, 0
#endif
#ifdef SUNX25
    ,"x.25",            XYX25,   0
#endif /* SUNX25 */
};
int nprm = (sizeof(prmtab) / sizeof(struct keytab)); /* How many parameters */
 
/* Table of networks */
#ifdef NETCONN
struct keytab netcmd[] = {
/*  "decnet",        NET_DEC,  0, */
    "tcp/ip",        NET_TCPB, 0
/*  "stream-tcp-ip", NET_TCPA, 0  */
#ifdef SUNX25
    ,"x.25",         NET_SX25, 0
#endif /* SUNX25 */
};
int nnets = (sizeof(netcmd) / sizeof(struct keytab)); /* How many networks */
#endif /* NETCONN */

/* Remote Command Table */
 
struct keytab remcmd[] = {
    "cd",        XZCWD, 0,
    "cwd",       XZCWD, CM_INV,
    "delete",    XZDEL, 0,
    "directory", XZDIR, 0,
    "help",      XZHLP, 0,
    "host",      XZHOS, 0,
    "print",     XZPRI, 0,
    "set",       XZSET, 0,
    "space",	 XZSPA, 0,
    "type", 	 XZTYP, 0,
    "who",  	 XZWHO, 0
};
int nrmt = (sizeof(remcmd) / sizeof(struct keytab));
 
/* Modem signal table */

struct keytab mstab[] = {
#ifdef COMMENT
/* The forms preceded by backslash are for MS-DOS Kermit compatibility */
/* But... \dsr doesn't work because \d = decimal constant introducer */
    "\\cd",  BM_DCD, CM_INV,		/* Carrier Detect */
    "\\cts", BM_CTS, CM_INV,		/* Clear To Send  */
    "\\dsr", BM_DSR, CM_INV,		/* Data Set Ready */
    "\\ri",  BM_RNG, CM_INV,		/* Ring Indicator */
#endif
    "cd",    BM_DCD, 0,			/* Carrier Detect */
    "cts",   BM_CTS, 0,			/* Clear To Send  */
    "dsr",   BM_DSR, 0,			/* Data Set Ready */
    "ri",    BM_RNG, 0			/* Ring Indicator */
};
int nms = (sizeof(mstab) / sizeof(struct keytab));

struct keytab logtab[] = {
    "debugging",    LOGD, 0,
    "packets",	    LOGP, 0,
    "session",      LOGS, 0,
    "transactions", LOGT, 0
};
int nlog = (sizeof(logtab) / sizeof(struct keytab));
 
struct keytab writab[] = {
    "append-file",     LOGW, CM_INV,
    "debug-log",       LOGD, 0,
    "file",            LOGW, 0,
    "packet-log",      LOGP, 0,
    "screen",          LOGX, 0,
    "session-log",     LOGS, 0,
    "sys$output",      LOGX, CM_INV,
    "transaction-log", LOGT, 0
};
int nwri = (sizeof(writab) / sizeof(struct keytab));

struct keytab clstab[] = {
    "append-file",     LOGW, CM_INV,
    "debug-log",       LOGD, 0,
    "packet-log",      LOGP, 0,
    "read-file",       LOGR, 0,
    "session-log",     LOGS, 0,
    "transaction-log", LOGT, 0,
    "write-file",      LOGW, 0
};
int ncls = (sizeof(clstab) / sizeof(struct keytab));

/* SHOW command arguments */
 
struct keytab shotab[] = {
    "arguments", SHARG, 0,
    "arrays", SHARR, 0,
    "attributes", SHATT, 0,
    "communications", SHCOM, 0,
    "count", SHCOU, 0,
#ifdef vms
    "default", SHDFLT, 0,
#else
    "default", SHDFLT, CM_INV,
#endif
    "file", SHFIL, 0,
    "functions", SHFUN, 0,
    "globals", SHVAR, 0,
    "key", SHKEY, CM_INV,
    "languages", SHLNG, 0,
    "macros", SHMAC, 0,
    "modem", SHMOD, 0,
#ifdef SUNX25
    "pad", SHPAD, 0,
#endif /* SUNX25 */
    "parameters", SHPAR, CM_INV,
    "protocol", SHPRO, 0,
    "scripts", SHSCR, 0,
    "server", SHSER, 0,
    "status", SHSTA, 0,
    "transmit", SHXMI, 0,
    "variables", SHBUI, 0,
    "versions", SHVER, 0
};
int nsho = (sizeof(shotab) / sizeof(struct keytab));

#ifdef SUNX25
struct keytab padtab[] = {              /* PAD commands */
    "clear",      XYPADL, 0,
    "interrupt",  XYPADI, 0,
    "reset",      XYPADR, 0,
    "status",     XYPADS, 0
};
int npadc = (sizeof(padtab) / sizeof(struct keytab));
#endif /* SUNX25 */

struct keytab iftab[] = {		/* IF commands */
    "<",          XXIFLT, 0,
    "=",          XXIFAE, 0,
    ">",          XXIFGT, 0,
    "background", XXIFBG, 0,
    "count",      XXIFCO, 0,
    "defined",    XXIFDE, 0,
#ifdef COMMENT
    "eof",        XXIFEO, 0,
#endif
    "equal",      XXIFEQ, 0,
    "exist",      XXIFEX, 0,
    "failure",    XXIFFA, 0,
    "llt",        XXIFLL, 0,
    "lgt",        XXIFLG, 0,
    "not",        XXIFNO, 0,
    "success",    XXIFSU, 0
};
int nif = (sizeof(iftab) / sizeof(struct keytab));

struct keytab enatab[] = {		/* ENABLE commands */
    "all",        EN_ALL,  0,
    "bye",        EN_BYE,  0,
    "cd",         EN_CWD,  0,
    "cwd",        EN_CWD,  CM_INV,
    "delete",     EN_DEL,  0,
    "directory",  EN_DIR,  0,
    "finish",     EN_FIN,  0,
    "get",        EN_GET,  0,
    "host",       EN_HOS,  0,
    "send",       EN_SEN,  0,
    "set",        EN_SET,  0,
    "space",      EN_SPA,  0,
    "type",       EN_TYP,  0,
    "who",        EN_WHO,  0
};
int nena = (sizeof(enatab) / sizeof(struct keytab));

struct keytab opntab[] = {
    "!read",  XYFZ_Y, 0,
    "!write", XYFZ_X, 0,
    "append", XYFZ_A, 0,
    "read",   XYFZ_O, 0,
    "write",  XYFZ_N, 0
};
int nopn = (sizeof(opntab) / sizeof(struct keytab));

struct mtab mactab[MAC_MAX] = {		/* Preinitialized macro table */
    NULL, NULL, 0
};
int nmac = 0;

struct keytab mackey[MAC_MAX];		/* Macro names as command keywords */

#define xsystem(s) zsyscmd(s)

/*  D O C M D  --  Do a command  */
 
/*
 Returns:
   -2: user typed an illegal command
   -1: reparse needed
    0: parse was successful (even tho command may have failed).
*/ 
 
docmd(cx) int cx; {
    int x, y, z = 0;
    long zl;
    char *s, *p;
/*  int b; char a;  (apparently not referenced) */

#ifdef DTILDE
    char *tilde_expand();		/* May have to expand tildes */
#endif
 
    debug(F101,"docmd entry, cx","",cx);

    switch (cx) {
 
case -4:				/* EOF */
#ifdef OSK
    if (!quiet && pflag)  printf("\n");
#else
    if (!quiet && pflag)  printf("\r\n");
#endif /* OSK */
    doexit(GOOD_EXIT);
case -3:				/* Null command */
    return(0);
case -9:				/* Like -2, but errmsg already done */
case -6:				/* Special */
case -2:				/* Error, maybe */
case -1:				/* Reparse needed */
    return(cx);
 
case XXASK:				/* ask */
case XXASKQ:
case XXREA:
    if ((y = cmfld("Variable name","",&s,NULL)) < 0) { /* Get variable name */
	if (y == -3) {
	    printf("?Variable name required\n");
	    return(-9);
	} else return(y);
    }
    strcpy(line,s);			/* Make a copy. */
    lp = line;
    if ((y = parsevar(s,&x,&z)) < 0)	/* Check it. */
      return(y);

    if (cx == XXREA) {			/* READ command */
	if ((y = cmcfm()) < 0)		/* Get confirmation */
	  return(y);
	if (chkfn(ZRFILE) < 1) {	/* File open? */
	    printf("?Read file not open\n");
	    return(0);
	}
	s = line+VNAML+1;		/* Where to read into. */
	y = zsinl(ZRFILE, s, LINBUFSIZ - VNAML - 1); /* Read a line. */
	debug(F111,"read zsinl",s,y);
	if (y < 0) {			/* On EOF or other error, */
	    zclose(ZRFILE);		/* close the file, */
	    delmac(lp);			/* delete the variable, */
	    return(success = 0);	/* and return failure. */
	} else {			/* Read was OK. */
	    success = (addmac(lp,s) < 0 ? 0 : 1); /* Define the variable */
            debug(F111,"read addmac",lp,success);
	    return(success);		/* Return success. */
	}
    }

    /* ASK or ASKQ */

    if ((y = cmtxt("Prompt, enclose in { braces } to preserve\n\
leading and trailing spaces, type \\? to include question mark.",
		   "",&p,xxstring)) < 0) return(y);
    cmsavp(psave,80);
    if (*p == '{') {			/* New prompt enclosed in braces? */
	x = strlen(p) - 1;
	if (p[x] == '}') {
	    p[x] = NUL;
	    p++;
	}
    }
    cmsetp(p);				/* Make new one */
    if (cx == XXASK)			/* ASK echoes what the user types */
      cmini(ckxech);
    else				/* ASKQ does not echo */
      cmini(0);
    x = -1;				/* This means to reparse. */
    if (pflag) prompt();		/* Issue prompt. */
    while (x == -1) {			/* Prompt till they answer */
	x = cmtxt("please respond.\n\
type \\? to include a question mark","",&s,NULL);
	    debug(F111," cmtxt",s,x);
    }
    if (cx == XXASKQ)			/* ASKQ must echo CRLF here */
      printf("\r\n");
    if (x < 0) {			/* If cmtxt parse error, */
	cmsetp(psave);			/* restore original prompt */
	return(x);			/* and return cmtxt's error code. */
    }
    if (*s == NUL) {			/* If user typed a bare CR, */
	cmsetp(psave);			/* Restore old prompt, */
	delmac(lp);			/* delete variable if it exists, */
	return(success = 1);		/* and return. */
    }
    y = addmac(lp,s);			/* Add it to the macro table. */
    debug(F111,"ask addmac",lp,y);
    cmsetp(psave);			/* Restore old prompt. */
    return(success = y < 0 ? 0 : 1);

case XXBUG:				/* bug */
    if ((x = cmcfm()) < 0) return(x);
printf("\n%s,%s\n Numeric: %ld",versio,ckxsys,vernum);
if (verwho) printf("-%d",verwho);
printf("\nTo report C-Kermit bugs, send e-mail to:\n");
printf(" Info-Kermit@columbia.edu (Internet)\n KERMIT@CUVMA (BITNET/EARN)\n");
printf(" ...!uunet!columbia.edu!info-kermit (Usenet)\n");
printf("Or write to:\n Kermit Development\n Columbia University\n");
printf(" Center for Computing Activities\n 612 W 115 Street\n");
printf(" New York, NY 10025 USA\nOr call:\n (212) 854-5126 (USA)\n\n");
    return(success = 1);

case XXBYE:				/* bye */
    if ((x = cmcfm()) < 0) return(x);
    sstate = setgen('L',"","","");
    if (local) ttflui();		/* If local, flush tty input buffer */
    return(0);
 
case XXCLE:				/* clear */
    if ((x = cmcfm()) < 0) return(x);
    y = ttflui();			/* flush input buffer */
    for (x = 0; x < INPBUFSIZ; x++)	/* and our local copy too */
      inpbuf[x] = 0;
    inpbp = inpbuf;
    success = (y == 0);			/* Set SUCCESS/FAILURE */
    return(success);

case XXCOM:				/* comment */
    if ((x = cmtxt("Text of comment line","",&s,NULL)) < 0) return(x);
    /* Don't change SUCCESS flag for this one */
    return(0);
 
case XXCON:                     	/* Connect */
    if ((x = cmcfm()) < 0)
      return(x);
    return(success = doconect());

case XXCWD:
    return(success = docd());

case XXCLO:
    x = cmkey(clstab,ncls,"Which log or file to close","",xxstring);
    if (x == -3) {
	printf("?You must tell which file or log\n");
	return(-9);
    }
    if (x < 0) return(x);
    if ((y = cmcfm()) < 0) return(y);
    y = doclslog(x);
    success = (y == 1);
    return(success);

case XXDEC: 				/* DECREMENT */
case XXINC: 				/* INCREMENT */
    if ((y = cmfld("Variable name","",&s,NULL)) < 0) {
	if (y == -3) {
	    printf("?Variable name required\n");
	    return(-9);
	} else return(y);
    }
    if (*s != CMDQ) {
        *vnambuf = CMDQ;
	strncpy(vnambuf+1,s,VNAML-1);
    } else strncpy(vnambuf,s,VNAML);

    if ((y = parsevar(vnambuf,&x,&z)) < 0)
      return(y);

    if ((y = cmnum("by amount","1",10,&x,xxstring)) < 0) return(y);
    if ((y = cmcfm()) < 0) return(y);

    z = (cx == XXINC ? 1 : 0);		/* Increment or decrement? */

    if (incvar(vnambuf,x,z,&y) < 0) {
	printf("?Variable %s not defined or not numeric\n",vnambuf);
	return(success = 0);
    }
    return(success = 1);

case XXDEF:				/* DEFINE */
case XXASS:				/* ASSIGN */
    if ((y = cmfld("Macro or variable name","",&s,NULL)) < 0) {
	if (y == -3) {
	    printf("?Variable name required\n");
	    return(-9);
	} else return(y);
    }
    strcpy(vnambuf,s);
    vnp = vnambuf;
    if (vnambuf[0] == CMDQ && (vnambuf[1] == '%' || vnambuf[1] == '&')) vnp++;
    if (*vnp == '%' || *vnp == '&') {
	if ((y = parsevar(vnp,&x,&z)) < 0) return(y);
	if (y == 1) {			/* Simple variable */
	    if ((y = cmtxt("Definition of variable","",&s,NULL)) < 0)
	      return(y);
	    debug(F110,"xxdef var name",vnp,0);
	    debug(F110,"xxdef var def",s,0);
	} else if (y == 2) {		/* Array element */
	    if ((y = arraynam(s,&x,&z)) < 0) return(y);
	    if (chkarray(x,z) < 0) return(-2);
	    if ((y = cmtxt("Definition of array element","",&s,NULL)) < 0)
	      return(y);
	    debug(F110,"xxdef array ref",vnp,0);
	    debug(F110,"xxdef array def",s,0);
	}
    } else {				/* Macro */
	if ((y = cmtxt("Definition of macro","",&s,NULL)) < 0) return(y);
	debug(F110,"xxdef macro name",vnp,0);
	debug(F110,"xxdef macro def",s,0);
	if (*s == '{') {		/* Allow macro def to be bracketed. */
	    s++;			/* If it is, remove the brackets. */
	    y = strlen(s);		/* FOR command depends on this! */
	    if (y > 0 && s[y-1] == '}') s[y-1] = NUL;
	}
    }
    if (*s == NUL) {			/* No arg given, undefine */
	delmac(vnp);			/* silently... */
	return(success = 1);		/* even if it doesn't exist... */
    } 

    /* Defining a new macro or variable */

    if (cx == XXASS) {			/* ASSIGN rather than DEFINE? */
	int t;
	t = LINBUFSIZ-1;
	lp = line;			/* If so, expand its value now */
	xxstring(s,&lp,&t);
	s = line;
    }
    debug(F111,"calling addmac",s,strlen(s));

    y = addmac(vnp,s);			/* Add it to the appropriate table. */
    if (y < 0) {
	printf("?%s failed\n",cx == XXASS ? "Assign" : "Define");
	return(success = 0);
    }
    return(success = 1);
    
case XXDCL:				/* declare an array */
    if ((y = cmfld("Array name","",&s,NULL)) < 0) {
	if (y == -3) {
	    printf("?Array name required\n");
	    return(-9);
	} else return(y);
    }
    if ((y = arraynam(s,&x,&z)) < 0) return(y);
    if ((y = cmcfm()) < 0) return(y);
    if (dclarray(x,z) < 0) {
	printf("?Declare failed\n");
	return(success = 0);
    }
    return(success = 1);

#ifndef NODIAL
case XXDIAL:				/* dial phone number */
    if ((x = cmtxt("Number to be dialed","",&s,xxstring)) < 0)
      return(x);
    if (s == NULL || strlen(s) == 0) {
	printf("?You must specify a number to dial\n");
	return(-9);
    }
#ifdef VMS
    conres();				/* So Ctrl-C/Y will work */
#endif /* VMS */
    success = ckdial(s);		/* Try to dial */
#ifdef VMS
    concb(escape);			/* Back to command parsing mode */
#endif /* VMS */
    return(success);
#endif /* NODIAL */
 
case XXDEL:				/* delete */
    if ((x = cmifi("File(s) to delete","",&s,&y,xxstring)) < 0) {
	if (x == -3) {
	    printf("?A file specification is required\n");
	    return(-9);
	} else return(x);
    }
    strncpy(tmpbuf,s,50);		/* Make a safe copy of the name. */
    debug(F110,"xxdel tmpbuf",s,0);
    sprintf(line,"%s %s",DELCMD,s);	/* Construct the system command. */
    debug(F110,"xxdel line",line,0);
    if ((y = cmcfm()) < 0) return(y);	/* Confirm the user's command. */
#ifdef VMS
    conres();
#endif
    xsystem(line);			/* Let the system do it. */
    zl = zchki(tmpbuf);
    success = (zl == -1L);
    if (cmdlvl == 0 && pflag) {
	if (success)
	  printf("%s - deleted\n",tmpbuf);
	else
	  printf("%s - not deleted\n",tmpbuf);
    }
    return(success);

case XXDIR:				/* directory */
#ifdef VMS
    if ((x = cmtxt("Directory/file specification","",&s,xxstring)) < 0)
      return(x);
    /* now do this the same as a shell command - helps with LAT  */
    conres();				/* make console normal */
    lp = line;
    sprintf(lp,"%s %s",DIRCMD,s);
    debug(F110,"Directory string: ", line, 0);
    xsystem(lp);
    return(success = 0);
#else
#ifdef AMIGA
    if ((x = cmtxt("Directory/file specification","",&s,xxstring)) < 0)
      return(x);
#else
#ifdef datageneral
    if ((x = cmtxt("Directory/file specification","+",&s,xxstring)) < 0)
      return(x);
#else
    if ((x = cmdir("Directory/file specification","",&s,xxstring)) < 0)
      if (x != -3) return(x);
    strcpy(tmpbuf,s);
    if ((y = cmcfm()) < 0) return(y);
    s = tmpbuf;
#endif
#endif
    lp = line;
    sprintf(lp,"%s %s",DIRCMD,s);
#ifdef OS2
    concooked();
    xsystem(line);
    conraw();
#else
#ifdef VMS
    conres();
#endif /* VMS */
    xsystem(line);
#endif
    return(success = 1);		/* who cares... */
#endif 
 
case XXELS:				/* else */
    if (!ifcmd[cmdlvl]) {
	printf("?ELSE doesn't follow IF\n");
	return(-2);
    }
    ifcmd[cmdlvl] = 0;
    if (!iftest[cmdlvl]) {		/* If IF was false do ELSE part */
	if (maclvl > -1) {		/* In macro, */
	    pushcmd();			/* save rest of command. */
	} else if (tlevel > -1) {	/* In take file, */
	    pushcmd();			/* save rest of command. */
	} else {			/* If interactive, */
	    cmini(ckxech);		/* just start a new command */
	    printf("\n");		/* (like in MS-DOS Kermit) */
	    if (pflag) prompt();
	}
    } else {				/* Condition is false */
	if ((y = cmtxt("command to be ignored","",&s,NULL)) < 0)
	  return(y);			/* Gobble up rest of line */
    }
    return(0);

case XXENA:				/* enable */
case XXDIS:				/* disable */
    s = (cx == XXENA) ?
      "Server function to enable" :
	"Server function to disable";

    if ((x = cmkey(enatab,nena,s,"",xxstring)) < 0) {
	if (x == -3) {
	    printf("?Name of server function required\n");
	    return(-9);
	} else return(x);
    }
    if ((y = cmcfm()) < 0) return(y);
    y = ((cx == XXENA) ? 1 : 0);
    switch (x) {
      case EN_ALL:
	en_cwd = en_del = en_dir = en_fin = en_get = en_bye = y;
	en_hos = en_sen = en_set = en_spa = en_typ = en_who = y;
	break;
      case EN_BYE:
	en_bye = y;
	break;
      case EN_CWD:
	en_cwd = y;
	break;
      case EN_DEL:
	en_del = y;
	break;
      case EN_DIR:
	en_dir = y;
	break;
      case EN_FIN:
	en_fin = y;
	break;
      case EN_GET:
	en_get = y;
	break;
      case EN_HOS:
	en_hos = y;
	break;
      case EN_SEN:
	en_sen = y;
	break;
      case EN_SET:
	en_set = y;
	break;
      case EN_SPA:
	en_spa = y;
	break;
      case EN_TYP:
	en_typ = y;
	break;
      case EN_WHO:
	en_who = y;
	break;
      default:
	return(-2);
    }
    return(0);

case XXEND:				/* END, POP (same thing) */
    if (cmdlvl == 0) {			/* At top level, nothing happens... */
	if ((x = cmcfm()) < 0)
	  return(x);
	return(success = 1);
    }
    popclvl();
    return(success = 1);

case XXRET:				/* RETURN */
    if (cmdlvl == 0) {			/* At top level, nothing happens... */
	if ((x = cmcfm()) < 0)
	  return(x);
	return(success = 1);
    } else if (cmdstk[cmdlvl].src == CMD_TF) { /* In TAKE file, same as POP */
	if ((x = cmcfm()) < 0)
	  return(x);
	popclvl();			/* pop command level */
	return(success = 1);		/* always succeeds */
    } else if (cmdstk[cmdlvl].src == CMD_MD) { /* Within macro */  
	if ((x = cmtxt("optional return value","",&s,NULL)) < 0) return(x);
	if (maclvl < 0) {
	    printf("\n?Can't return from level %d\n",maclvl);
	    return(success = 0);
	}
	lp = line;			/* Expand return value now */
	x = LINBUFSIZ-1;
	if (xxstring(s,&lp,&x) > -1) {
	    s = line;
	}
	x = strlen(s);			/* Is there a return value? */
	if (x) {			/* Yes */
	    p = malloc(x+2);		/* Allocate a place to keep it */
	    if (p) {			/* Did we get a place? */
		strcpy(p, s);		/* Yes, copy the string into it. */
		mrval[maclvl] = p;	/* Make return value point to it. */
	    } else {			/* No, could not get space. */
		mrval[maclvl] = NULL;	/* Return null pointer. */
		x = 0;			/* Set failure return code. */
	    }
	} else mrval[maclvl] = NULL;	/* Blank return code */
	popclvl();			/* Pop command level */
	if (mrval[maclvl+1])
	  debug(F111,"&return",mrval[maclvl+1],maclvl);
	else debug(F111,"&return","NULL",maclvl);
	return(success = x ? 1 : 0);	/* Return status code */	
    } else return(-2);

case XXDO:				/* do (a macro) */
    if (nmac == 0) {
	printf("\n?No macros defined\n");
	return(-2);
    }
    for (y = 0; y < nmac; y++) {	/* copy the macro table */
	mackey[y].kwd = mactab[y].kwd;	/* into a regular keyword table */
	mackey[y].val = y;		/* with value = pointer to macro tbl */
	mackey[y].flgs = mactab[y].flgs;
    }
    /* parse name as keyword */
    if ((x = cmkey(mackey,nmac,"macro","",xxstring)) < 0) {
	if (x == -3) {
	    printf("?Macro name required\n");
	    return(-9);
	} else return(x);
    }
    if ((y = cmtxt("optional arguments","",&s,xxstring)) < 0) /* get args */
      return(y);
    return(success = dodo(x,s));

case XXECH: 				/* echo */
    if ((x = cmtxt("Material to be echoed","",&s,xxstring)) < 0) return(x);
    printf("%s\n",s);
    return(1);				/* Don't bother with success? */

case XXOPE: {				/* OPEN { append, read, write } */
    static struct filinfo fcb;		/* (must be static) */
    if ((x = cmkey(opntab,nopn,"mode","",xxstring)) < 0) {
	if (x == -3) {
	    printf("?Mode required\n");
	    return(-9);
	} else return(x);
    }
    switch (x) {
      case XYFZ_O:			/* Old file (READ) */
	if (chkfn(ZRFILE) > 0) {
	    printf("?Read file already open\n");
	    return(-2);
	}
	if ((z = cmifi("File to read","",&s,&y,xxstring)) < 0) {
	    if (z == -3) {
		printf("?Input filename required\n");
		return(-9);
	    } else return(z);
	}
	if (y) {				/* No wildcards allowed */
	    printf("\n?Please specify a single file\n");
	    return(-2);
	}
	strcpy(line,s);
	if (strlen(line) < 1) return(-2);
	if ((y = cmcfm()) < 0) return(y);
	return(success = zopeni(ZRFILE,line));

      case XYFZ_Y:			/* Pipe/Process (READ) */
	if (chkfn(ZRFILE) > 0) {
	    printf("?Read file already open\n");
	    return(-2);
	}
        if ((y = cmtxt("System command to read from","",&s,xxstring)) < 0) {
	    if (y == -3) {
		printf("?Command name required\n");
		return(-9);
	    } else return(y);
	}
	strcpy(line,s);
	if (strlen(line) < 1) return(-2);
	if ((y = cmcfm()) < 0) return(y);
	return(success = zxcmd(ZRFILE,line));

      case XYFZ_X:			/* Write to pipe */
	if (chkfn(ZWFILE) > 0) {
	    printf("?Write file already open\n");
	    return(-2);
	}
        if ((y = cmtxt("System command to write to","",&s,xxstring)) < 0) {
	    if (y == -3) {
		printf("?Command name required\n");
		return(-9);
	    } else return(y);
	}
	strcpy(line,s);
	if (strlen(line) < 1) return(-2);
	if ((y = cmcfm()) < 0) return(y);
	return(success = zxcmd(ZWFILE,line));

      case XYFZ_N:			/* New file (WRITE) */
      case XYFZ_A:			/* (APPEND) */
	if ((z = cmofi("Name of local file to create","",&s,xxstring)) < 0) {
	    if (z == -3) {
		printf("?Filename required\n");
		return(-9);
	    } else return(z);
	}
	if (chkfn(ZWFILE) > 0) {
	    printf("?Write/Append file already open\n");
	    return(-2);
	}
        fcb.bs = fcb.cs = fcb.rl = fcb.fmt = fcb.org = fcb.cc = fcb.typ = 0;
	fcb.dsp = x;			/* Create or Append */
	strcpy(line,s);
	if (strlen(line) < 1) return(-2);
	if ((y = cmcfm()) < 0) return(y);
	return(success = zopeno(ZWFILE,line,NULL,&fcb));
      default:
	printf("?Not implemented yet");
	return(-2);
    } }

case XXOUT:				/* Output */
    if ((x = cmtxt("Text to be output","",&s,xxstring)) < 0) return(x);
    return(success = dooutput(s));

#ifdef SUNX25
case XXPAD:                             /* PAD commands */
    x = cmkey(padtab,npadc,"PAD command","",xxstring);
    if (x == -3) {
	printf("?You must specify a PAD command to execute\n");
	return(-2);
    }
    if (x < 0) return(x);
    
    switch (x) {
      case XYPADL: 
	if (x25stat() < 0)
	  printf("Sorry, you must 'set network' & 'set host' first\r\n");
	else {
	    x25clear();
	    initpad();
	}
	break;
      case XYPADS:
	if (x25stat() < 0)
	  printf("Not connected\r\n");
	else {
	    extern int linkid, lcn;
	    conol("Connected thru ");
	    conol(ttname);
	    printf(", Link id %d, Logical channel number %d\r\n",
		   linkid,lcn);
	}
	break;
      case XYPADR:
	if (x25stat() < 0)
	  printf("Sorry, you must 'set network' & 'set host' first\r\n");
	else
	  x25reset(0,0);
	break;
      case XYPADI:
	if (x25stat() < 0)
	  printf("Sorry, you must 'set network' & 'set host' first\r\n");
	else 
	  x25intr(0);
    }
    return(0);
#endif /* SUNX25 */

case XXPAU:				/* Pause */
case XXWAI: 				/* Wait */
    /* Both should take not only secs but also hh:mm:ss as argument. */
    if (cx == XXWAI)
      y = cmnum("seconds to wait","1",10,&x,xxstring);
    else y = cmnum("seconds to pause","1",10,&x,xxstring);
    if (y < 0) return(y);
    if (x < 0) x = 0;
    switch (cx) {
      case XXPAU:			/* PAUSE */
	if ((y = cmcfm()) < 0) return(y);
	break;
      case XXWAI:			/* WAIT */
	z = 0;				/* Modem signal mask */
	while (1) {			/* Read zero or more signal names */
	    y = cmkey(mstab,nms,"modem signal","",xxstring);
	    if (y == -3) break;		/* -3 means they typed CR */
	    if (y < 0) return(y);	/* Other negatives are errors */
	    z |= y;			/* OR the bit into the signal mask */
	}
	break;

      default:
	return(-2);
    }

/* Command is entered, now do it. */

    while (x--) {			/* Sleep loop */
	int mdmsig;
	if (y = conchk()) {		/* Did they type something? */
	    while (y--) coninc(0);	/* Yes, gobble it up */
	    break;			/* And quit PAUSing or WAITing */
	}
	if (cx == XXWAI && z != 0) {
	    mdmsig = ttgmdm();
	    if (mdmsig < 0) return(success = 0);
	    if ((mdmsig & z) == z) return(success = 1);
	}
	sleep(1);			/* No interrupt, sleep one second */
    }
    if (cx == XXWAI) success = 0;
    else success = (x == -1);		/* Set SUCCESS/FAILURE for PAUSE. */
    return(0);

case XXPWD:				/* PWD */
    if ((x = cmcfm()) < 0) return(x);
    xsystem(PWDCMD);
    return(success = 1);		/* blind faith */

case XXQUI:				/* quit */
case XXEXI:				/* exit */
    sprintf(tmpbuf,"%d",GOOD_EXIT);
    if ((y = cmnum("exit status code",tmpbuf,10,&x,xxstring)) < 0) return(y);
    if ((y = cmcfm()) < 0) return(y);
    doexit(x);

case XXERR:
    if ((x = cmcfm()) < 0) return(x);
    ttflui();
    sstate = 'a';
    return(0);

case XXFIN:				/* finish */
    if ((x = cmcfm()) < 0) return(x);
    sstate = setgen('F',"","","");
    if (local) ttflui();		/* If local, flush tty input buffer */
    return(0);

case XXFOR: {				/* for loop */
    int fx, fy, fz;			/* loop variables */
    char *ap;				/* macro argument pointer */

    if ((y = cmfld("Variable name","",&s,NULL)) < 0) { /* Get variable name */
	if (y == -3) {
	    printf("?Variable name required\n");
	    return(-9);
	} else return(y);
    }
    if ((y = parsevar(s,&x,&z)) < 0)	/* Check it. */
      return(y);

    lp = line;				/* Build a copy of the command */
    strcpy(lp,"_forx ");
    lp += strlen(line);			/* "_for" macro. */
    ap = lp;				/* Save pointer to macro args. */

    if (*s == CMDQ) s++;		/* Skip past backslash if any. */
    while (*lp++ = *s++) ;		/* copy it */
    lp--; *lp++ = SP;			/* add a space */

    if ((y = cmnum("initial value","",10,&fx,xxstring)) < 0) {
	if (y == -3) return(-2);
	else return(y);
    }
    s = atmbuf;				/* copy the atom buffer */
    if (strlen(s) < 1) goto badfor;
    while (*lp++ = *s++) ;		/* (what they actually typed) */
    lp--; *lp++ = SP;

    if ((y = cmnum("final value","",10,&fy,xxstring)) < 0) {
	if (y == -3) return(-2);
	else return(y);
    }
    s = atmbuf;				/* same deal */
    if (strlen(s) < 1) goto badfor;
    while (*lp++ = *s++) ;
    lp--; *lp++ = SP;

    if ((y = cmnum("increment","1",10,&fz,xxstring)) < 0) {
	if (y == -3) return(-2);
	else return(y);
    }
    sprintf(tmpbuf,"%d ",fz);
    s = atmbuf;				/* same deal */
    if (strlen(s) < 1) goto badfor;
    while (*lp++ = *s++) ;
    lp--; *lp++ = SP;

    /* Insert the right comparison operator */
    if (fz < 0)
      *lp++ = '<';
    else
      *lp++ = '>';
    *lp++ = SP;

    if ((y = cmtxt("Command to execute","",&s,NULL)) < 0) return(y);
    if (strlen(s) < 1) return(-2);
    
    if (litcmd(&s,&lp) < 0) {
	printf("?Unbalanced brackets\n");
	return(0);
    }
    if (fz == 0) {
	printf("?Zero increment not allowed\n");
	return(0);
    }
    x = mlook(mactab,"_forx",nmac);
    if (x < 0) {
	printf("?FOR macro definition gone!\n"); /* (or... just put it back) */
	return(success = 0);
    }
    return(success = dodo(x,ap));	/* do it! */
 }
badfor: printf("?Incomplete FOR command\n");

case XXGET:				/* get */
    x = cmtxt("Name of remote file(s), or carriage return","",&cmarg,xxstring);
    if ((x == -2) || (x == -1)) return(x);
 
/* If foreign file name omitted, get foreign and local names separately */
 
    cmarg2 = "";			/* Initialize as-name to nothing */
    x = 0;				/* For some reason cmtxt returns 1 */
    if (*cmarg == NUL) {
 
	if (tlevel > -1) {		/* Input is from take file */
 
	    if (fgets(line,100,tfile[tlevel]) == NULL)
	    	fatal("take file ends prematurely in 'get'");
	    debug(F110,"take-get 2nd line",line,0);
	    for (x = strlen(line);
	     	 x > 0 && (line[x-1] == LF || line[x-1] == CR);
		 x--)
		line[x-1] = '\0';
	    cmarg = line;
	    if (fgets(cmdbuf,CMDBL,tfile[tlevel]) == NULL)
	    	fatal("take file ends prematurely in 'get'");
	    for (x = strlen(cmdbuf);
	     	 x > 0 && (cmdbuf[x-1] == LF || cmdbuf[x-1] == CR);
		 x--)
		cmdbuf[x-1] = '\0';
	    if (*cmdbuf == NUL) cmarg2 = line; else cmarg2 = cmdbuf;
            x = 0;			/* Return code */
	    printf("%s",cmarg2);
        } else {			/* Input is from terminal */
 
	    cmsavp(psave,80);
	    cmsetp(" Remote file specification: "); /* Make new one */
	    cmini(ckxech);
	    x = -1;
	    if (pflag) prompt();
	    while (x == -1) {		/* Prompt till they answer */
	    	x = cmtxt("Name of remote file(s)","",&cmarg,xxstring);
		debug(F111," cmtxt",cmarg,x);
	    }
	    if (x < 0) {
		cmsetp(psave);
		return(x);
	    }
	    if (*cmarg == NUL) { 	/* If user types a bare CR, */
		printf("(cancelled)\n"); /* Forget about this. */
	    	cmsetp(psave);		/* Restore old prompt, */
		return(0);		/* and return. */
	    }
	    strcpy(line,cmarg);		/* Make a safe copy */
	    cmarg = line;
	    cmsetp(" Local name to store it under: "); /* New prompt */
	    cmini(ckxech);
	    x = -1;
	    if (pflag) prompt();
	    while (x == -1) {		/* Again, parse till answered */
	    	x = cmofi("Local file name","",&cmarg2,xxstring);
	    }
	    if (x == -3) {	    	    	/* If bare CR, */
		printf("(cancelled)\n");	/* escape from this... */
	    	cmsetp(psave);		        /* Restore old prompt, */
		return(0);		    	/* and return. */
	    } else if (x < 0) return(x);        /* Handle parse errors. */
	    
	    x = -1;			/* Get confirmation. */
	    while (x == -1) x = cmcfm();
	    cmsetp(psave);		/* Restore old prompt. */
        }
    }
    if (x == 0) {			/* Good return from cmtxt or cmcfm, */
	debug(F110,"xxget cmarg",cmarg,0);
	strncpy(fspec,cmarg,FSPECL);
	debug(F111,"xxget fspec",fspec,FSPECL);
	sstate = 'r';			/* set start state. */
	if (local) {
	    displa = 1;
	    ttflui();
	}
    }
    return(x);

case XXHLP:				/* Help */
    x = cmkey2(cmdtab,ncmd,"C-Kermit command","help",toktab,xxstring);
    if (x == -5) {
	y = chktok(toktab);
	debug(F101,"top-level cmkey token","",y);
	ungword();
	switch (y) {
	  case '!': x = XXSHE; break;
	  case '#': x = XXCOM; break;
	  case ';': x = XXCOM; break;
	  case ':': x = XXLBL; break;
	  case '&': x = XXECH; break;
	  default:
	    printf("\n?Invalid - %s\n",cmdbuf);
	    x = -2;
	}
    }
    return(dohlp(x));
 
case XXHAN:				/* Hangup */
    if ((x = cmcfm()) < 0) return(x);
    success = (tthang() > -1);
    return(success);

case XXGOTO:				/* Goto */
/* Note, here we don't set SUCCESS/FAILURE flag */
    if ((y = cmfld("label","",&s,xxstring)) < 0) {
	if (y == -3) {
	    printf("?Label name required\n");
	    return(-9);
	} else return(y);
    }
    strcpy(lblbuf,s);
    if ((x = cmcfm()) < 0) return(x);
    debug(F101,"goto cmdlvl","",cmdlvl);
    debug(F101,"goto maclvl","",maclvl);
    debug(F101,"goto tlevel","",tlevel);
    s = lblbuf;
    debug(F110,"goto before conversion",s,0);
    if (*s != ':') {			/* If the label mentioned */
	int i;				/* does not begin with a colon, */
	y = strlen(s);			/* then insert one. */
	for (i = y; i > 0; i--)
	    s[i] = s[i-1];
	s[0] = ':';
	s[++y] = '\0';
    }
    debug(F111,"goto after conversion",s,y);
    if (s[1] == '.' || s[1] == SP || s[1] == NUL) {
	printf("?Bad label syntax - '%s'\n",s);
	return(success = 0);
    }
    if (cmdlvl == 0) {
	printf("?Nothing happens\n");
	return(success = 0);
    }
    while (cmdlvl > 0) {		/* Only works inside macros & files */
	if (cmdstk[cmdlvl].src == CMD_MD) { /* GOTO inside macro */
	    int i, m, flag;
	    lp = macx[maclvl];
	    m = strlen(lp) - y + 1;
	    debug(F111,"goto in macro",lp,m);

	    flag = 1;			/* flag for valid label position */
	    for (i = 0; i < m; i++,lp++) { /* search for label in macro body */
		if (flag && *lp == SP) continue;
		if (*lp == ',') {
		    flag = 1;
		    continue;
		}
		if (flag && !strncmp(s,lp,y))
		  break;
		else flag = 0;
	    }
	    if (i == m) {		/* didn't find the label */
		debug(F101,"goto failed at cmdlvl","",cmdlvl);
		if (!popclvl()) {	/* pop up to next higher level */
		    printf("?Label '%s' not found\n",s); /* if none */
		    return(0);		/* quit */
		} else continue;	/* otherwise look again */
	    }
	    debug(F110,"goto found macro label",lp,0);
	    macp[maclvl] = lp;		/* set macro buffer pointer */
	    return(1);
	} else if (cmdstk[cmdlvl].src == CMD_TF) {
	    x = 0;			/* GOTO issued in take file */
	    rewind(tfile[tlevel]);	/* Search file from beginning */
	    while (! feof(tfile[tlevel])) {
		if (fgets(line,LINBUFSIZ,tfile[tlevel]) == NULL) /* Get line */
		  break;		/* If no more, done, label not found */
		lp = line;		/* Got line */
		while (*lp == ' ' || *lp == '\t')
		  lp++;			/* Strip leading whitespace */
		if (!strncmp(lp,s,y)) {	/* Compare result with label */
		    x = 1;		/* Got it */
		    break;		/* done. */
		}
	    }
	    if (x == 0) {		/* If not found, print message */
		debug(F101,"goto failed at cmdlvl","",cmdlvl);
		if (!popclvl()) {	/* pop up to next higher level */
		    printf("?Label '%s' not found\n",s);	/* if none */
		    return(0);		/* quit */
		} else continue;	/* otherwise look again */
	    }
	    return(x);			/* Send back return code */
	}
    }
    printf("?Stack problem in GOTO\n",s); /* Shouldn't see this */
    return(0);

case XXIF:				/* IF command */
case XXIFX:				/* Extended IF command */
case XXWHI:				/* WHILE command */
    not = 0;				/* Flag for whether "NOT" was seen */
    ifargs = 0;				/* Count of IF condition words */

ifagain:
    if ((ifc = cmkey(iftab,nif,"","",xxstring)) < 0) { /* If what?... */
	if (ifc == -3) {
	    printf("?Condition required\n");
	    return(-9);
	} else return(ifc);
    }
    switch (ifc) {			/* z = 1 for true, 0 for false */
      case XXIFNO:			/* IF NOT */
	not ^= 1;			/* So NOT NOT NOT ... will work */
	ifargs++;
	goto ifagain;
      case XXIFSU:			/* IF SUCCESS */
	z = ( success != 0 );
	debug(F101,"if success","",z);
	ifargs += 1;
	break;
      case XXIFFA:			/* IF FAILURE */
	z = ( success == 0 );
	debug(F101,"if failure","",z);
	ifargs += 1;
	break;
      case XXIFDE:			/* IF DEFINED */
	if ((x = cmfld("Macro or variable name","",&s,NULL)) < 0) {
	    if (x == -3) return(-2);
	    else return(x);
	}
	strcpy(line,s);			/* Make a copy */
        if (strlen(line) < 1) return(-2);
	lp = line;
	if (line[0] == CMDQ && (line[1] == '%' || line[1] == '&')) lp++;
	if (*lp == '%')	{		/* Is it a variable? */
	    x = *(lp + 1);		/* Fold case */
	    if (isupper(x)) *(lp + 1) = tolower(x);
	    if (x >= '0' && x <= '9' && maclvl > -1) /* Digit is macro arg */
	      z = ( (m_arg[maclvl][x - '0'] != 0)
		   && strlen(m_arg[maclvl][x - '0']) != 0);
	    else			/* Otherwise it's a global variable */
	      z = ( (g_var[x] != 0)
		   &&  strlen(g_var[x]) != 0 );
	} else if (*lp == '&') {	/* Array reference */
	    int cc, nn;
	    if (arraynam(lp,&cc,&nn) < 0)
	      z = 0;
	    else z = (arrayval(cc,nn) == NULL ? 0 : 1);
	} else {			/* Otherwise it's a macro name */
	    z = ( mxlook(mactab,lp,nmac) > -1 ); /* Look for exact match */
	}
	debug(F111,"if defined",s,z);
	ifargs += 2;
	break;

      case XXIFBG:			/* IF BACKGROUND */
	if (backgrd != 0 || bgset > 0) z = 1; else z = 0;
	ifargs += 1;
	break;

      case XXIFCO:			/* IF COUNT */
	z = ( --count[cmdlvl] > 0 );
	debug(F101,"if count","",z);
	ifargs += 1;
	break;

      case XXIFEX:			/* IF EXIST */
	if ((x = cmfld("File","",&s,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Filename required\n");
		return(-9);
	    } else return(x);
	}
	z = ( zchki(s) > -1L );
	debug(F101,"if exist","",z);
	ifargs += 2;
	break;

      case XXIFEQ: 			/* IF EQUAL (string comparison) */
      case XXIFLL:			/* IF Lexically Less Than */
      case XXIFLG:			/* If Lexically Greater Than */
	if ((x = cmfld("first word or variable name","",&s,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Text required\n");
		return(-9);
	    } else return(x);
	}
	x = strlen(s);
	if (x > LINBUFSIZ-1) {
	    printf("?IF: strings too long\n");
	    return(-2);
	}
	lp = line;			/* lp points to first string */
	strcpy(lp,s);
	if ((y = cmfld("second word or variable name","",&s,xxstring)) < 0) {
	    if (y == -3) {
		printf("?Text required\n");
		return(-9);
	    } else return(y);
	}
	y = strlen(s);
	if (x + y + 2 > LINBUFSIZ) {
	    printf("?IF: strings too long\n");
	    return(-2);
	}
	tp = lp + y + 2;		/* tp points to second string */
	strcpy(tp,s);
	if (incase)			/* INPUT CASE OBSERVE */
	  x = strcmp(lp,tp);
	else				/* INPUT CASE IGNORE */
	  x = xxstrcmp(lp,tp);
	switch (ifc) {
	  case XXIFEQ: 			/* IF EQUAL (string comparison) */
	    z = (x == 0);
	    break;
	  case XXIFLL:			/* IF Lexically Less Than */
	    z = (x < 0);
	    break;
	  case XXIFLG:			/* If Lexically Greater Than */
	    z = (x > 0);
	    break;
	}
	ifargs += 3;
	break;

      case XXIFAE:			/* IF (arithmetically) = */
      case XXIFLT:			/* IF (arithmetically) < */
      case XXIFGT: {			/* IF (arithmetically) > */
	/* Really should use longs here... */
	int n1, n2;
	x = cmfld("first number or variable name","",&s,xxstring);
	if (x == -3) {
	    printf("?Quantity required\n");
	    return(-9);
	}
	if (x < 0) return(x);
	debug(F101,"xxifgt cmfld","",x);
	lp = line;
	strcpy(lp,s);
	debug(F110,"xxifgt exp1",lp,0);
	if (!xxstrcmp(lp,"count")) {
	    n1 = count[cmdlvl];
	} else if (!xxstrcmp(lp,"version")) {
	    n1 = (int) vernum;
	} else if (!xxstrcmp(lp,"argc")) {
	    n1 = (int) macargc[maclvl];
	} else {
	    if (!chknum(lp)) return(-2);
	    n1 = atoi(lp);
	}
	y = cmfld("second number or variable name","",&s,xxstring);
	if (y == -3) {
	    printf("?Quantity required\n");
	    return(-9);
	}
	if (y < 0) return(y);
        if (strlen(s) < 1) return(-2);
	x = strlen(lp);
	tp = line + x + 2;
	strcpy(tp,s);
	debug(F110,"xxifgt exp2",tp,0);
	if (!xxstrcmp(tp,"count")) {
	    n2 = count[cmdlvl];
	} else if (!xxstrcmp(tp,"version")) {
	    n2 = (int) vernum;
	} else if (!xxstrcmp(tp,"argc")) {
	    n2 = (int) macargc[maclvl];
	} else {
	    if (!chknum(tp)) return(-2);
	    n2 = atoi(tp);
	}
	debug(F101,"xxifft ifc","",ifc);
	z = ((n1 <  n2 && ifc == XXIFLT)
	  || (n1 == n2 && ifc == XXIFAE)
	  || (n1 >  n2 && ifc == XXIFGT));
	debug(F101,"xxifft n1","",n1);
	debug(F101,"xxifft n2","",n2);
	debug(F101,"xxifft z","",z);
	ifargs += 3;
	break; }

      default:				/* Shouldn't happen */
	return(-2);
    }

    switch (cx) {			/* Separate handling for IF and XIF */

      case XXIF:			/* This is IF... */
	ifcmd[cmdlvl] = 1;		/* We just completed an IF command */
	if (not) z = !z;		/* Handle NOT here */
	if (z) {			/* Condition is true */
	    iftest[cmdlvl] = 1;		/* Remember that IF succeeded */
	    if (maclvl > -1) {		/* In macro, */
		pushcmd();		/* save rest of command. */
	    } else if (tlevel > -1) {	/* In take file, */
		pushcmd();		/* save rest of command. */
	    } else {			/* If interactive, */
		cmini(ckxech);		/* just start a new command */
		printf("\n");		/* (like in MS-DOS Kermit) */
		if (pflag) prompt();
	    }
	} else {			/* Condition is false */
	    iftest[cmdlvl] = 0;		/* Remember command failed. */
	    if ((y = cmtxt("command to be ignored","",&s,NULL)) < 0)
	      return(y);		/* Gobble up rest of line */
	}
	return(0);

      case XXIFX: {			/* This is XIF (Extended IF) */
	char *p;
	char e[5];
	int i;
	if ((y = cmtxt("Object command","",&s,NULL)) < 0) /* Get object */
	  return(y);			                  /* command. */
	p = s;
	lp = line;
	if (litcmd(&p,&lp) < 0) {	/* Insert quotes in THEN-part */
	    return(-2);
	}
	if (!z) {			/* Use ELSE-part, if any */
	    lp = line;			/* Write over THEN part. */
	    *lp = NUL;
	    while (*p == SP) p++;	/* Strip trailing spaces */
	    if (*p) {			/* At end? */
		for (i = 0; i < 4; i++) e[i] = *p++; /* No, check for ELSE */
		if (xxstrcmp(e,"else")) return(-2);  /* No, syntax error */
		if (litcmd(&p,&lp) < 0) {            /* Insert quotes */
		    return(-2);
		}
		while (*p == SP) p++;	/* Strip trailing spaces */
		if (*p) return(-2);	/* Should be nothing here. */
	    }
	}
	if (line[0]) {
	    x = mlook(mactab,"_xif",nmac); /* get index of "_xif" macro. */
	    if (x < 0) {
		printf("?XIF macro definition gone!\n");
		return(0);
	    }
	    dodo(x,line);
	}
	return(0);
    }
      case XXWHI: {			/* WHILE Command */
	p = cmdbuf;			/* Capture IF condition */
	ifcond[0] = NUL;		/* from command buffer */
	while (*p == SP) p++;
	while (*p != SP) p++;
	ifcp = ifcond;
	strcpy(ifcp,"{ \\flit(if not ");
	ifcp += strlen(ifcp);
	while (*p != '{' && *p != NUL) *ifcp++ = *p++;
	p = " goto wbot) } ";
	while (*ifcp++ = *p++) ;
	debug(F110,"WHILE cmd",ifcond,0);

	if ((y = cmtxt("Object command","",&s,NULL)) < 0) /* Get object */
	  return(y);			                  /* command. */
	p = s;
	lp = line;
	if (litcmd(&p,&lp) < 0) {	/* Insert quotes in object command */
	    return(-2);
	}
	debug(F110,"WHILE body",line,0);
	if (line[0]) {
	    char *p;
	    x = mlook(mactab,"_while",nmac); /* get index of "_while" macro. */
	    if (x < 0) {
		printf("?WHILE macro definition gone!\n");
		return(success = 0);
	    }
	    p = malloc(strlen(ifcond) + strlen(line) + 2);
	    if (p) {
		strcpy(p,ifcond);
		strcat(p,line);
		debug(F110,"WHILE dodo",p,0);
		dodo(x,p);
		free(p);
	    } else {
		printf("?Can't allocate storage for WHILE command");
		return(success = 0);
	    }
	}
	return(0);
    }}


case XXINP:				/* INPUT and */
case XXREI:				/* REINPUT */
    y = cmnum("seconds to wait for input","1",10,&x,xxstring);
    if (y < 0) {
	return(y);
    }
    if (x <= 0) x = 1;
    if ((y = cmtxt("Material to be input","",&s,xxstring)) < 0) return(y);
    if (*s == '\0') {
	printf("?Text required\n");
	return(-9);
    }
    if (cx == XXINP) {			/* INPUT */
	if (local) {			/* Put line in "ttvt" mode */
	    y = ttvt(speed,flow);	/* if not already. */
	    if (y < 0) {
		printf("?Can't condition line for INPUT\n");
		return(0);		/* Watch out for failure. */
	    }
	}
	success = doinput(x,s);		/* Go try to input the search string */
    } else {				/* REINPUT */
	debug(F110,"xxrei line",s,0);
	success = doreinp(x,s);
    }
    if (intime && !success) {		/* TIMEOUT-ACTION = QUIT? */
	popclvl();			/* If so, pop command level. */
	if (pflag && cmdlvl == 0) {
	    if (cx == XXINP) printf("Input timed out\n");
	    if (cx == XXREI) printf("Reinput failed\n");
        }
    }
    return(success);			/* Return do(re)input's return code */

case XXLBL:				/* Label */
    if ((x = cmtxt("Command-file label","",&s,xxstring)) < 0) return(x);
    /* should be cmfld, then cmcfm, to prevent multiple words in label? */
    return(0);

case XXLOG:				/* Log */
    x = cmkey(logtab,nlog,"What to log","",xxstring);
    if (x == -3) {
	printf("?Type of log required\n");
        return(-9);
    }
    if (x < 0) return(x);
    x = dolog(x);
    if (x < 0)
      return(x);
    else
      return(success = x);
 
#ifndef NOSCRIPT
case XXLOGI:				/* UUCP-style script */
    if ((x = cmtxt("expect-send expect-send ...","",&s,xxstring)) < 0)
      return(x);
#ifdef VMS
    conres();				/* For Ctrl-C to work... */
#endif
    return(success = dologin(s));	/* Return 1=completed, 0=failed */
#endif
 
case XXREC:				/* Receive */
    cmarg2 = "";
    x = cmofi("Name under which to store the file, or CR","",&cmarg2,xxstring);
    if ((x == -1) || (x == -2)) return(x);
    debug(F111,"cmofi cmarg2",cmarg2,x);
    if ((x = cmcfm()) < 0) return(x);
    sstate = 'v';
    if (local) displa = 1;
    return(0);
 
case XXREM:				/* Remote */
    x = cmkey(remcmd,nrmt,"Remote Kermit server command","",xxstring);
    if (x == -3) {
	printf("?You must specify a command for the remote server\n");
	return(-9);
    }
    return(dormt(x));

case XXREN:				/* RENAME */
    if ((x = cmifi("File to rename","",&s,&y,xxstring)) < 0) {
	if (x == -3) {
	    printf("?Name of existing file required\n");
	    return(-9);
	} else return(x);
    }
    if (y) {				/* No wildcards allowed */
	printf("\n?Please specify a single file\n");
	return(-9);
    }
    strcpy(line,s);			/* Make a safe copy of the old name */
    p = line + strlen(line) + 2;	/* Place for new name */
    if ((x = cmofi("New name","",&s,xxstring)) < 0) { /* Get new name */
	if (x == -3) {
	    printf("?New name for file required\n");
	    return(-9);
	} else return(x);
    }
    strcpy(p,s);			/* Make a safe copy of the new name */
    if ((y = cmcfm()) < 0) return(y);
#ifdef VMS
    conres();				/* Let Ctrl-C work. */
#endif
    return(zrename(line,p));

case XXSEN:				/* SEND command and... */
case XXMAI:				/* MAIL command */
    cmarg = cmarg2 = "";
    if ((x = cmifi("File(s) to send","",&s,&y,xxstring)) < 0) {
	if (x == -3) {
	    printf("?A file specification is required\n");
	    return(-9);
	} else return(x);
    }
    nfils = -1;				/* Files come from internal list. */
    strcpy(line,s);			/* Save copy of string just parsed. */
    strncpy(fspec,s,FSPECL);		/* and here for \v(filespec) */
    if (cx == XXSEN) {			/* SEND command */
	debug(F101,"Send: wild","",y);
	if (y == 0) {
	    if ((x = cmtxt("Name to send it with","",&cmarg2,xxstring)) < 0)
	      return(x);
	} else {
	    if ((x = cmcfm()) < 0) return(x);
	}
	cmarg = line;			/* File to send */
	debug(F110,"Sending:",cmarg,0);
	if (*cmarg2 != '\0') debug(F110," as:",cmarg2,0);
    } else {				/* MAIL */
	if (!atdiso || !atcapr) {	/* Disposition attribute off? */
	    printf("?Disposition Attribute is Off\n");
	    return(-2);
	}
	debug(F101,"Mail: wild","",y);
	*optbuf = NUL;			/* Wipe out any old options */
	if ((x = cmtxt("Address to mail to","",&s,xxstring)) < 0) return(x);
        if (strlen(s) == 0) { printf("?Address required\n"); return(-9); }
	strcpy(optbuf,s);
	if (strlen(optbuf) > 94) { /* Ensure legal size */
	    printf("?Option string too long\n");
	    return(-2);
	}
	cmarg = line;			/* File to send */
	debug(F110,"Mailing:",cmarg,0);
	debug(F110,"To:",optbuf,0);
	rmailf = 1;			/* MAIL modifier flag for SEND */
    }
    sstate = 's';			/* Set start state to SEND */
    if (local) {			/* If in local mode, */
	displa = 1;			/* turn on file transfer display */
	ttflui();			/* and flush tty input buffer. */
    }
    return(0);
 
#ifndef NOMSEND
case XXMSE:				/* MSEND command */
    nfils = 0;				/* Like getting a list of */
    lp = line;				/* files on the command line */
    while (1) {
        char *p;
	if ((x = cmifi("List of files to send, or carriage return","",
		       &s,&y,xxstring)) < 0) {
	    if (x == -3) {
		if (nfils <= 0) {
		    printf("?A file specification is required\n");
		    return(-9);
		} else break;
	    }
	    return(x);
	}
        msfiles[nfils++] = lp;		/* Got one, count it, point to it, */
        p = lp;				/* remember pointer, */
        while (*lp++ = *s++) ;		/* and copy it into buffer */
        if (nfils == 1) *fspec = NUL;	/* Take care of \v(filespec) */
        if ((strlen(fspec) + strlen(p) + 1) < FSPECL) {
	    strcat(fspec,p);
	    strcat(fspec," ");
	}
    }
    cmlist = msfiles;			/* Point cmlist to pointer array */
    cmarg2 = "";			/* No internal expansion list (yet) */
    sndsrc = nfils;			/* Filenames come from cmlist */
    sstate = 's';			/* Set start state to SEND */
    if (local) {			/* If in local mode, */
	displa = 1;			/* turn on file transfer display */
	ttflui();			/* and flush tty input buffer. */
    }
    return(0);
#endif /* NOMSEND */

#ifdef COMMENT				/* doesn't work */
case XXCMS:				/* SSEND command */
    cmarg = cmarg2 = "";
    if ((x = cmtxt("Command whose output to send","",&s,xxstring)) < 0) {
	if (x == -3) {
	    printf("?A command name is required\n");
	    return(-9);
	}
	return(x);
    }
    nfils = 0;				/* Files come from stdin. */
    strcpy(line,s);			/* Save copy of string just parsed. */
    cmarg = line;			/* File to send */
    cmarg2 = "STDIN";
    debug(F110,"Sending:",cmarg,0);
    sstate = 's';			/* Set start state to SEND */
    if (local) displa = 1;
    return(0);
#endif

case XXSER:				/* Server */
    if ((x = cmcfm()) < 0) return(x);
    sstate = 'x';
    if (local) displa = 1;
#ifdef AMIGA
    reqoff();				/* No DOS requestors while server */
#endif
    return(0);
 
case XXSET:				/* SET command */
    x = cmkey(prmtab,nprm,"Parameter","",xxstring);
    if (x == -3) {
	printf("?You must specify a parameter to set\n");
	return(-9);
    }
    if (x < 0) return(x);
    /* have to set success separately for each item in doprm()... */
    /* actually not really, could have just had doprm return 0 or 1 */
    /* and set success here... */
    y = doprm(x,0);
    if (y == -3) {
	printf("?More fields required\n");
	return(-9);
    } else return(y);

case XXSHE:				/* Shell (system) command */
    if (cmtxt("System command to execute","",&s,xxstring) < 0) return(-1);
    conres();				/* Make console normal  */
    x = zshcmd(s);
    concb(escape);
    return(success = x);

case XXSHO:				/* Show */
    x = cmkey(shotab,nsho,"","parameters",xxstring);
    if (x < 0) return(x);
    return(success = doshow(x));
 
case XXSPA:				/* space */
#ifdef datageneral
    /* The DG can take an argument after its "space" command. */
    if ((x = cmtxt("Confirm, or local directory name","",&s,xxstring)) < 0)
      return(x);
    if (*s == NUL) xsystem(SPACMD);
    else {
    	char *cp;
    	cp = alloc(strlen(s) + 7);      /* For "space *s" */
    	strcpy(cp,"space "), strcat(cp,s);
    	xsystem(cp);
    	if (cp) free(cp);
    }
#else
    if ((x = cmcfm()) < 0) return(x);
#ifdef OS2
    concooked();
    xsystem(SPACMD);
    conraw();
#else
    xsystem(SPACMD);
#endif
#endif
    return(success = 1);		/* pretend it worked */
 
case XXSTA:				/* statistics */
    if ((x = cmcfm()) < 0) return(x);
    return(success = dostat());

case XXSTO:				/* stop */
    if ((x = cmcfm()) < 0) return(x);
    dostop();	
    success = 1;			/* always succeeds */
    return(0);

case XXSUS:				/* suspend */
    if ((y = cmcfm()) < 0) return(y);
    stptrap(0,0);
    return(0);

case XXTAK:				/* take */
    if (tlevel > MAXTAKE-1) {
	printf("?Take files nested too deeply\n");
	return(-2);
    }
    if ((y = cmifi("C-Kermit command file","",&s,&x,xxstring)) < 0) { 
	if (y == -3) {
	    printf("?A file name is required\n");
	    return(-9);
	} else return(y);
    }
    if (x != 0) {
	printf("?Wildcards not allowed in command file name\n");
	return(-2);
    }
    if ((y = cmcfm()) < 0) return(y);
    return(success = dotake(s));
 
case XXTRA:				/* transmit */
    if ((x = cmifi("File to transmit","",&s,&y,xxstring)) < 0) {
	if (x == -3) {
	    printf("?Name of an existing file\n");
	    return(-9);
	} else return(x);
    }
    if (y != 0) {
	printf("?Only a single file may be transmitted\n");
	return(-2);
    }
    strcpy(line,s);			/* Save copy of string just parsed. */
#ifdef COMMENT
/* Don't do this, it'll overwrite SET TRANSMIT PROMPT */
/* without user knowing about it. */
    y = cmnum("Decimal ASCII value of line turnaround character","10",10,&x,
	      xxstring);
    if (y < 0) return(y);
    if (x < 0 || x > 127) {
	printf("?Decimal number between 0 and 127\n");
	return(-2);
    }
#endif
    if ((y = cmcfm()) < 0) return(y);	/* Confirm the command */
    xmitp = x;
    debug(F111,"calling transmit",line,xmitp);
    return(success = transmit(line,x));	/* Do the command */

case XXTYP:				/* TYPE */
    if ((x = cmifi("File to type","",&s,&y,xxstring)) < 0) {
	if (x == -3) {
	    printf("?Name of an existing file\n");
	    return(-9);
	} else return(x);
    }
    if (y != 0) {
	printf("?A single file please\n");
	return(-2);
    }
    strcpy(line,s);			/* Save copy of string just parsed. */
    if ((y = cmcfm()) < 0) return(y);	/* Confirm the command */
    debug(F110,"calling dotype",line,0);
    return(success = dotype(line));	/* Do the TYPE command */

case XXTES:				/* TEST */
    /* Fill this in with whatever is being tested... */
    if ((y = cmcfm()) < 0) return(y);	/* Confirm the command */

    { int d, i, j;			/* Dump all arrays */
      char c, **p;
      for (i = 0; i < 26; i++) {
	  p = a_ptr[i];
	  d = a_dim[i];
	  c = i+'a';
	  if (d && p) {
	      fprintf(stderr,"&%c[%d]\n",c,d);
	      for (j = 0; j <= d; j++) {
		  if (p[j]) {
		      fprintf(stderr,"  &%c[%2d] = [%s]\n",c,j,p[j]);
		  }
	      }	  
	  }
      }
  }

#ifdef COMMENT
    printf("cmdlvl = %d, tlevel = %d, maclvl = %d\n",cmdlvl,tlevel,maclvl);
    if (maclvl < 0) {
	printf("%s\n",
	       "Call me from inside a macro and I'll dump the argument stack");
	return(0);
    }
    printf("Macro level: %d, ARGC = %d\n     ",maclvl,macargc[maclvl]);
    for (y = 0; y < 10; y++) printf("%7d",y);
    for (x = 0; x <= maclvl; x++) {
	printf("\n%2d:  ",x);
	for (y = 0; y < 10; y++) {
	    s = m_arg[x][y];
	    printf("%7s",s ? s : "(none)");
	}
    }
    printf("\n");
#endif
    return(0);

#ifndef NOCSETS
case XXXLA:				/* translate */
    if ((x = cmifi("File to translate","",&s,&y,xxstring)) < 0) {
	if (x == -3) {
	    printf("?Name of an existing file\n");
	    return(-9);
	} else return(x);
    }
    if (y != 0) {
	printf("?A single file please\n");
	return(-2);
    }
    strcpy(line,s);			/* Save copy of string just parsed. */
    if ((x = cmofi("Output file",CTTNAM,&s,xxstring)) < 0) return(x);
    strncpy(tmpbuf,s,50);
    if ((y = cmcfm()) < 0) return(y);	/* Confirm the command */
    return(success = xlate(line,tmpbuf)); /* Do the TRANSLATE command */
#endif /* NOCSETS */

case XXVER:
    if ((y = cmcfm()) < 0) return(y);
    printf("%s,%s\n Numeric: %ld",versio,ckxsys,vernum);
    if (verwho) printf("-%d\n",verwho); else printf("\n");
    return(success = 1);

case XXWHO:
    if ((y = cmtxt("user name","",&s,xxstring)) < 0) return(y);
    sprintf(line,"%s%s",WHOCMD,s);
    xsystem(line);
    return(success = 1);

case XXWRI:
    if ((x = cmkey(writab,nwri,"to file or log","",xxstring)) < 0) {
	printf("?Write to what?\n");
	return(x);
    }
    if ((y = cmtxt("text","",&s,xxstring)) < 0) return(y);
    switch (x) {
      case LOGD: y = ZDFILE; break;
      case LOGP: y = ZPFILE; break;
      case LOGS: y = ZSFILE; break;
      case LOGT: y = ZTFILE; break;
      case LOGW: y = ZWFILE; break;
      case LOGX:
	printf("%s",s);
	if (cmdlvl == 0) printf("\n");
	return(success = 1);
      default: return(-2);
    }
    if ((x = zsout(y,s)) < 0)
      printf("?File or log not open\n");
    return(success = (x == 0) ? 1 : 0);

default:
    printf("Not available - %s\n",cmdbuf);
    return(-2);
    }
}


/* Set up a TAKE command file */

dotake(s) char *s; {
    strcpy(line,s);			/* Make a safe copy of the string */
    if ((tfile[++tlevel] = fopen(line,"r")) == NULL) {
	perror(line);
	debug(F110,"Failure to open",line,0);
	success = 0;
	tlevel--;
    } else {
#ifdef VMS
	conres();			/* So Ctrl-C will work */
#endif
	cmdlvl++;			/* Entering a new command level */
	if (cmdlvl > CMDSTKL) {
	    cmdlvl--;
	    printf("?TAKE files and DO commands nested too deeply\n");
	    return(success = 0);
	}
	ifcmd[cmdlvl] = 0;
	iftest[cmdlvl] = 0;
	count[cmdlvl] = 0;
	cmdstk[cmdlvl].src = CMD_TF;	/* Say we're in a TAKE file */
	cmdstk[cmdlvl].val = tlevel;	/* nested at this level */
    }
    return(1);
}
#endif /* NOICP */
