char *connv = "Connect Command for Unix, 5A(026) 26 Nov 90";

/*  C K U C O N  --  Dumb terminal connection to remote system, for UNIX  */
/*
 Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET),
 Columbia University Center for Computing Activities.
 First released January 1985.
 Copyright (C) 1985, 1990, Trustees of Columbia University in the City of New 
 York.  Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as it is not sold for profit, provided this
 copyright notice is retained. 
*/

#include <stdio.h>
#include <ctype.h>			/* Character types */
#include <signal.h>

#ifndef ZILOG
#include <setjmp.h>			/* Longjumps */
#else
#include <setret.h>
#endif

#ifdef NETCONN
#include <arpa/telnet.h>
#ifdef SUNX25                           /* SUNLINK X.25 support added by */
#include <sys/types.h>			/* Marcello Frutig, Catholic */
#include <sys/mbuf.h>			/* University, Rio de Janeiro, */
#include <sundev/syncstat.h>		/* Brazil. */
#include <netx25/x25_pk.h>
#include <netx25/x25_ctl.h>
#include <netx25/x25_ioctl.h>
#endif /* SUNX25 */
#ifndef TELOPT_TTYPE			/* In case this symbol not known */
#define TELOPT_TTYPE    24
#endif /* TELOPT_TTYPE */
#endif

#include "ckcdeb.h"			/* Common things */
#include "ckcasc.h"			/* ASCII characters */
#include "ckcker.h"			/* Kermit things */
#include "ckcnet.h"			/* Network symbols */

#ifndef SIGUSR1				/* User-defined signals */
#define SIGUSR1 30
#endif
#ifndef SIGUSR2
#define SIGUSR2 31
#endif

extern int local, escape, duplex, parity, flow, seslog, mdmtyp, ttnproto,
 cmask, fmask, network, nettype, debses, deblog, tvtflg, sessft;
extern long speed;
extern char ttname[], sesfil[];
extern CHAR dopar();
static int quitnow = 0;
static int dohangup = 0;

int goterr = 0, active;			/* Variables global to this module */
char *chstr(), *dbchr();
static char *p;
static char temp[50];
#ifdef NETCONN
int sgaflg = 0;				/* Telnet SGA negotiation flag */
#endif

#define LBUFL 200			/* Line buffer */
char lbuf[LBUFL];
char kbuf[10], *kbp;			/* Keyboard buffer */

#ifdef NETCONN				/* Network defined */
#ifdef SUNX25				/* SunLink X.25 defined */
#define MAXIX25 MAX_USER_DATA*7
#define MAXOX25 MAX_USER_DATA

char x25ibuf[MAXIX25];
char x25obuf[MAXOX25];
int ibufl;
int obufl;
unsigned char tosend = 0;
int linkid, lcn;
static int dox25clr = 0;
CHAR padparms[MAXPADPARMS+1];
int padpipe[2];				/* Pipe descriptor to pass PAD parms */
#endif /* SUNX25 */
#endif /* NETCONN */

/* Connect state parent/child communication signal handlers */

static jmp_buf con_env;		 /* Environment pointer for connect errors */

static
SIGTYP
conn_int(foo) int foo; {		/* Modem read failure handler, */
    longjmp(con_env,1);			/* notifies parent process to stop */
}

static
SIGTYP
mode_chg(foo) int foo; {
#ifdef SUNX25				/* X.25 read new params from pipe */
    if (nettype == NET_SX25) {
        read(padpipe[0],padparms,MAXPADPARMS);
        debug(F100,"pad_chg","",0);
    } else {
#endif /* SUNX25 */
	duplex = 1 - duplex;		/* Toggle duplex mode. */
	debug(F101,"mode_chg duplex","",duplex);
#ifdef SUNX25
    }
#endif /* SUNX25 */
    longjmp(con_env,2);			/* Return 2 so we can tell. */
}

/*  C O N E C T  --  Perform terminal connection  */

int parent_id;			/* process id of parent (keyboard reader) */

#ifdef NETCONN
int tn_init;			/* Telnet initialized. */
#endif

conect() {
    int pid, 			/* process id of child (modem reader) */
       priv,			/* result of privilege check */
	n,			/* general purpose counter */
        i;			/* worker */

    int c;			/* c is a character, but must be signed 
				   integer to pass thru -1, which is the
				   modem disconnection signal, and is
				   different from the character 0377 */
    int c2;			/* A copy of c */
    int sjval;			/* Setjump return value */

/* Note: SO/SI code is sketched out, but is within #ifdef SOSI conditionals */
/* which are not turned on.  Somebody who actually needs this feature (for  */
/* example with a 7171 front end in Europe) will have to test it.  Locking  */
/* shifts are used rather than single shifts because these are more common  */
/* in practice.  If this is an issue, a new SET command can be added to     */
/* control this behavior.  */

#ifdef SOSI
    int shift = 0;			/* SO/SI shift state */
#endif

    char errmsg[50], *erp;

    if (!local) {
	printf("Sorry, you must 'set line' first\n");
	return(0);
    }
    if (speed < 0L && network == 0) {
	printf("Sorry, you must 'set speed' first\n");
	return(0);
    }
#ifdef NETCONN
    if (network && (nettype != NET_TCPB)
#ifdef SUNX25
        && (nettype != NET_SX25)
#endif /* SUNX25 */
    ) {
	printf("Sorry, network type not supported yet\n");
	return(0);
    }
#endif /* NETCONN */

    if (ttopen(ttname,&local,mdmtyp,0) < 0) {
	erp = errmsg;
	sprintf(erp,"Sorry, can't open %s",ttname);
	perror(errmsg);
	return(0);
    }
    dohangup = 0;
#ifdef NETCONN
    if (network) {
	printf("Connecting to host %s",ttname);
#ifdef SUNX25
        if (nettype == NET_SX25) {
            dox25clr = 0;
            printf(", Link id %d, Logical channel number %d",linkid,lcn);
        }
#endif /* SUNX25 */
    } else {
	printf("Connecting to %s",ttname);
	if (speed > -1L) printf(", speed %ld",speed);
    }
#else
    printf("Connecting to %s",ttname);
    if (speed > -1L) printf(", speed %ld",speed);
#endif
    printf(".\r\nThe escape character is %s (ASCII %d).\r\n",
	   chstr(escape),escape);
    printf("Type the escape character followed by C to get back,\r\n");
    printf("or followed by ? to see other options.\r\n");
    if (seslog) {
	printf("(Session logged to %s, ",sesfil);
	printf("%s)\r\n", sessft ? "binary" : "text");
    }
    if (debses) printf("Debugging Display...)\r\n");
    
/* Condition console terminal and communication line */	    

    if (conbin(escape) < 0) {
	printf("Sorry, can't condition console terminal\n");
	return(0);
    }
    goterr = 0;
    if (ttvt(speed,flow) < 0) {
	goterr = 1;
	tthang();
	ttclos();
	if (ttopen(ttname,&local,mdmtyp,0) < 0) {
	    erp = errmsg;
	    sprintf(erp,"Sorry, can't reopen %s",ttname);
	    perror(errmsg);
	    return(0);
	}
	if (ttvt(speed,flow) < 0) {
	    conres();
	    printf("Sorry, Can't condition communication line\n");
	    return(0);
	}
#ifdef COMMENT
	if (goterr) {			/* If there was an error just now,  */
	    ttflui();			/* there's probably garbage waiting */
	    goterr = 0;			/* in the input buffer.  Flush it.  */
	}
#endif
    }

/* This is a label we jump back to in case lower fork sensed the need */
/* to change modes.  Ugly, but it works. */

newfork:
    parent_id = getpid();		/* Get parent id for signalling */
    signal(SIGUSR1,SIG_IGN);		/* Don't kill myself */
    signal(SIGUSR2,SIG_IGN);
#ifdef SUNX25
    pipe(padpipe);                      /* Create pipe to pass PAD parms */
#endif /* SUNX25 */
    pid = fork();			/* All ok, make a fork */
    if (pid == -1) {			/* Can't create it. */
	conres();			/* Reset the console. */
	perror("Can't create keyboard fork");
	printf("[Back at Local System]\n");
	return(1);
    }
    if (pid) {
	priv = 0;			/* Assume privilege level ok */
	active = 1;			/* This fork reads, sends keystrokes */

        /* Turn off any inherited setuid privileges */
	/* Catch communication errors or mode changes in lower fork */

	if (((priv = priv_can()) == 0) && (sjval = setjmp(con_env)) == 0) {
	    signal(SIGUSR1,conn_int);	/* Routine for child process exit. */
	    signal(SIGUSR2,mode_chg);	/* Routine for mode change. */
#ifdef NETCONN
	    if (network && ttnproto == NP_TELNET) /* If telnet connection, */
	      if (!tn_init++) tn_ini();           /* initialize it. */
#ifdef SUNX25
	    if (network && nettype == NET_SX25) {
		obufl = 0;
		bzero (x25obuf,sizeof(x25obuf)) ;
	    }
#endif /* SUNX25 */
#endif /* NETCONN */
	    while (active) {
		c = coninc(0);		/* Get character from keyboard */
                if (c == -1) pause();	/* Wait for transmitter to finish */
		c &= cmask;
#ifdef sxaE50				/* Allow for Shift-JIS codes */
		if (c == escape) {	/* Got escape character? */
		    c = coninc(0) & cmask;  /* Yes, get argument */
		    doesc(c);		    /* and process it. */
		}
#else
		if ((c & 0177) == escape) { /* Look for escape char */
		    c = coninc(0) & 0177;   /* Got esc, get its arg */
		    doesc(c);		    /* And process it */
		}
#endif /* sxaE50 */
		else {		    /* Ordinary character */
#ifdef SOSI
/* If outputting 8-bit character in 7-bit environment, */
/* surround by Shift-Out (Ctrl-N) and Shift-In (Ctrl-O). */

		    shift = 0;
		    if ((c & \x80) && (cmask == \x7f)) {
			shift = 1;
			ttoc(SO);
		    }
#endif /* SOSI */

#ifdef NETCONN
#ifdef SUNX25
                    if (network && nettype == NET_SX25) {
                        if (padparms[PAD_ECHO]) {
                            if (debses)
			      conol (dbchr(c)) ;
                            else
			      if ((c != padparms[PAD_CHAR_DELETE_CHAR])   &&
				  (c != padparms[PAD_BUFFER_DELETE_CHAR]) &&
				  (c != padparms[PAD_BUFFER_DISPLAY_CHAR]))
                                conoc (c) ;
                            if (seslog)
			      if (zchout(ZSFILE,c) < 0) seslog = 0 ;
                        }
                        if (c == padparms[PAD_BREAK_CHARACTER])
			  breakact ();
                        else if (padparms[PAD_DATA_FORWARD_TIMEOUT]) {
                            tosend = 1;
                            x25obuf [obufl++] = c;
                        } else if (((c == padparms[PAD_CHAR_DELETE_CHAR])  ||
				    (c == padparms[PAD_BUFFER_DELETE_CHAR]) ||
				    (c == padparms[PAD_BUFFER_DISPLAY_CHAR])) 
				   && (padparms[PAD_EDITING]))
			  if (c == padparms[PAD_CHAR_DELETE_CHAR])
			    if (obufl > 0) {
				conol("\b \b"); obufl--;
			    } else {}
			  else if (c == padparms[PAD_BUFFER_DELETE_CHAR]) {
			      conol ("\r\nPAD Buffer Deleted\r\n");
			      obufl = 0;
			  }
			  else if (c == padparms[PAD_BUFFER_DISPLAY_CHAR]) {
			      conol("\r\n");
			      conol(x25obuf);
			      conol("\r\n");
			  } else {} 
                        else {
                            x25obuf [obufl++] = c;
                            if (obufl == MAXOX25) tosend = 1;
                            else if (c == CR) tosend = 1;
                        }
                        if (tosend) 
			  if (ttol(x25obuf,obufl) < 0) {
			      perror ("\r\nCan't send characters");
			      active = 0;
			  } else {
			      bzero (x25obuf,sizeof(x25obuf));
			      obufl = 0;
			      tosend = 0;
			  } else {};
                    } else {
#endif /* SUNX25 */ 

/* This is for telnetting to IBM mainframes in linemode. */
/* Blank lines (when you hit two CRs in a row) are normally ignored. */
/* But if we change carriage returns here to linefeeds, then */
/* everthing seems to work ok.  According to the telnet RFC, we should
/* really  send both the CR and the LF, but IBM's telnetd doesn't */
/* seem to require this. */

/* Also, if the user types the 0xff character, which happens to be the */
/* telnet IAC character, then it must be doubled. */

                    if (network && ttnproto == NP_TELNET) {
			if (c == '\r' && duplex != 0)
			  c = '\n';
			else if (c == IAC && parity == 0)
			  ttoc(IAC);
		    }			
#endif /* NETCONN */
		    /* Send the character that the user typed. */

		    if (ttoc(dopar(c)) > -1) {
		    	if (duplex) {	/* if half duplex, must echo */
			    if (debses)
			      conol(dbchr(c));
			    else
			      conoc(c);
			    if (seslog) { /* And maybe log it too */
				c2 = c;
				if (sessft == 0 && c == '\r')
				  c2 = '\n';
				if (zchout(ZSFILE,c2) < 0) seslog = 0;
			    }
			}
#ifdef SOSI
/* If this code ever gets used, we can make it smarter by remembering */
/* the shift state and only outputting the shift characters when necessary. */
/* Also, we should check for ttoc() returning -1...  */

			if (shift) {
			    ttoc(SI);
			    shift = 0;
			}
#endif /* SOSI */
    	    	    } else {
			perror("\r\nCan't send character");
			active = 0;
		    }
#ifdef SUNX25
                  } 
#endif /* SUNX25 */
		}
	      }
    	    }				/* Come here on death of child */
	    if (priv)
	      printf("?setuid error, sorry\n");
	    kill(pid,9);		/* Done, kill inferior fork. */
	    wait((int *)0);		/* Wait till gone. */
   	    if (sjval == 1) {		/* Read error on comm device */
		dohangup = 1;
#ifdef NETCONN
		if (network) ttclos();
#ifdef SUNX25
                if (network && nettype == NET_SX25) initpad();
#endif /* SUNX25 */
#endif /* NETCONN */
	    }
	    if (sjval == 2)		/* If it was a mode change, */
	      goto newfork;		/* go back & restart fork. */
	    conres();			/* Reset the console. */
	    if (quitnow) doexit(GOOD_EXIT); /* Exit now if requested. */
	    if (dohangup) {		/* If hangup requested, do that. */
		tthang();		/* And make sure we don't hang up */
		dohangup = 0;		/* again unless requested again. */
	    }
#ifdef SUNX25
            if (dox25clr) {
                x25clear();
                initpad();
            }
#endif /* SUNX25 */
	    printf("[Back at Local System]\n");
	    return(1);

	} else {			/* Inferior reads, prints port input */

/* Note: SO/SI code is not included here, because it is probable that this   */
/* function will be handled by the user's terminal or PC.  */

	    signal(SIGINT, SIG_IGN);	/* In case these haven't been */
	    signal(SIGQUIT, SIG_IGN);	/* inherited from above... */

	    sleep(1);			/* Wait for parent's handler setup.  */
	    while (1) {			/* Fresh read, wait for a character. */
#ifdef SUNX25
                if (network && (nettype == NET_SX25)) {
                    bzero (x25ibuf,sizeof(x25ibuf)) ;
                    if ((ibufl = ttxin(MAXIX25,x25ibuf)) < 0) {
                        if (ibufl == -2) {  /* PAD parms changes */
                            write(padpipe[1],padparms,MAXPADPARMS);
                            kill(parent_id,SIGUSR2);
                        } else {
                            printf ("\r\nCommunications disconnect ");
                            kill(parent_id,SIGUSR1);
                        }
                        pause();
                    }
                    if (debses) {
                        p = x25ibuf ;
                        while (ibufl--) { c = *p++; conol(dbchr(c)); }
                    } else {
                        for (i = 1; i < ibufl; i++) x25ibuf[i] &= cmask;
                        conxo(ibufl,x25ibuf) ;
                    }
                    if (seslog) zsoutx(ZSFILE,x25ibuf,ibufl);
                    continue;
                } else {
#endif /* SUNX25 */
		if ((c = ttinc(0)) < 0) { /* Get a character from comm line  */
		    printf("\r\nCommunications disconnect "); /* if failure  */
		    tthang();		/* hang up our side. */
 		    if (c == -3) perror("\r\nCan't read character");
		    kill(parent_id,SIGUSR1); /* notify parent. */
		    for (;;) pause();	     /* Wait to be killed by parent. */
		}
#ifdef NETCONN
		/* Handle telnet options */
		if (network && ((c & 0xff) == IAC)) {
		    if (tn_doop(c & 0xff) == -1) {
			printf("\r\nCommunications disconnect ");
			kill(parent_id,SIGUSR1); /* Notify parent. */
			for (;;) pause(); /* Wait to be killed. */
		    }
		    continue;		/* Negotiation OK, go get next char. */
		}
#endif /* NETCONN */
		if (debses) {		/* Output character to screen */
		    conol(dbchr(c));	/* debugging */
		} else {		/* or regular... */
		    c &= cmask;		/* Strip parity. */
		    conoc(c);		/* Put result on the screen. */
		}
		if (seslog) {		/* Take care of session log */
		    if ((sessft != 0) || 
			(c != '\r' && c != '\0' && c != XON && c != XOFF))
		      if (zchout(ZSFILE,c) < 0) seslog = 0;
		}
#ifdef NETCONN
/* The following code makes CONNECT mode a lot more efficient, */
/* especially on slow workstations.  But we can't use it if we're */
/* doing telnet protocol because we won't notice any in-band telnet */
/* commands.  So this code will always be used on non-network systems */
/* and it will be used on network systems except during a telnet session. */
		if (!network || (network && ttnproto != NP_TELNET)) {
#endif /* NETCONN */
		    while ((n = ttchk()) > 0) {	/* Any more left in buffer? */
			if (n > LBUFL) n = LBUFL;   /* Get them all at once. */
			if ((n = ttxin(n,lbuf)) > 0) {
			    if (debses) {
				p = lbuf;
				while (n--) { c = *p++; conol(dbchr(c)); }
			    } else {
				for (i = 0; i < n; i++) lbuf[i] &= cmask;
				conxo(n,lbuf); /* Output */
			    }
			    if (seslog) {           /* Session Log */
				if (sessft == 0) {  /* Text mode */
				    char cx;
				    p = lbuf;       /* Strip unwanted chars */
				    while (cx = *p++) {
					if (cx != '\r'
					    && cx != '\0'
					    && cx != XON
					    && cx != XOFF)
					  if (zchout(ZSFILE,cx) < 0)
					    seslog = 0;
				    }
				} else {            /* Binary mode */
				    if (zsoutx(ZSFILE,lbuf,n) < 0)
				      seslog = 0;
				}
			    }
			}
		    }
#ifdef NETCONN
		}
#endif /* NETCONN */
#ifdef SUNX25
                }
#endif /* SUNX25 */
	    }
    	}
}

/*  H C O N N E  --  Give help message for connect.  */

hconne() {
    int c;
    static char *hlpmsg[] = {"\
\r\n  C to return to the C-Kermit prompt, or:",
"\r\n  0 (zero) to send a null",
"\r\n  B to send a BREAK",
#ifdef SUNX25
"\r\n  I to send X.25 interrupt packet",
"\r\n  R to reset the virtual circuit",
"\r\n  H to hangup the connection (clear virtual circuit)",
#else
"\r\n  H to hangup the connection",
#endif /* SUNX25 */
"\r\n  Q to hangup and quit Kermit",
"\r\n  S for status",
"\r\n  ! to push to local shell",
"\r\n  Z to suspend",
"\r\n  \\ backslash escape:",
"\r\n    \\nnn decimal character code",
"\r\n    \\Onnn octal character code",
"\r\n    \\Xhh  hexadecimal character code",
"\r\n    terminate with carriage return.",
"\r\n  ? for help",
"\r\n escape character twice to send the escape character.\r\n\r\n",
"" };

    conola(hlpmsg);			/* Print the help message. */
    conol("Command>");			/* Prompt for command. */
    c = coninc(0) & 0177;		/* Get character, strip any parity. */
    if (c != CMDQ)
      conoll("");
    return(c);				/* Return it. */
}


/*  C H S T R  --  Make a printable string out of a character  */

char *
chstr(c) int c; {
    static char s[8];
    char *cp = s;

    if (c < SP) {
	sprintf(cp,"CTRL-%c",ctl(c));
    } else sprintf(cp,"'%c'\n",c);
    cp = s;
    return(cp);
}

char *					/* dbchr() for DEBUG SESSION */
dbchr(c) int c; {
    static char s[8];
    char *cp = s;

    c &= 0xff;
    if (c & 0x80) {			/* 8th bit on */
	sprintf(cp++,"~");
	c &= 0x7f;
    }
    if (c < SP) {			/* Control character */
	sprintf(cp,"^%c",ctl(c));
    } else if (c == DEL) {
	sprintf(cp,"^?");
    } else {				/* Printing character */
	sprintf(cp,"%c",c);
    }
    cp = s;				/* Return pointer to it */
    return(cp);
}

/*  D O E S C  --  Process an escape character argument  */

doesc(c) char c; {
    CHAR d;
  
    while (1) {
	if (c == escape) {		/* Send escape character */
	    d = dopar(c); ttoc(d); return;
    	} else				/* Or else look it up below. */
	    if (isupper(c)) c = tolower(c);

	switch(c) {

	case 'c':			/* Close connection */
	case '\03':
	    active = 0; conol("\r\n"); return;

	case 'b':			/* Send a BREAK signal */
	case '\02':
	    ttsndb(); return;

	case 'h':			/* Hangup */
	case '\010':
#ifdef SUNX25
            if (network && (nettype == NET_SX25)) dox25clr = 1;
            else
#endif /* SUNX25 */
	    dohangup = 1; active = 0; conol("\r\n"); return;

#ifdef SUNX25
        case 'i':                       /* Send a X.25 interrupt packet */
        case '\011':
            if (network && (nettype == NET_SX25)) (void) x25intr(0);
            conol("\r\n"); return;

        case 'r':                       /* Reset the X.25 virtual circuit */
        case '\022':
            if (network && (nettype == NET_SX25)) (void) x25reset();
            conol("\r\n"); return;
#endif /* SUNX25 */
 
	case 'q':
	    quitnow = 1; active = 0; conol("\r\n"); return;

	case 's':			/* Status */
	    conol("\r\nConnected thru ");
	    conol(ttname);
#ifdef SUNX25
            if (network && (nettype == NET_SX25))
                printf(", Link id %d, Logical channel number %d",linkid,lcn);
#endif /* SUNX25 */
	    if (speed >= 0L) {
		sprintf(temp,", speed %ld",speed); conol(temp);
	    }
	    sprintf(temp,", %d terminal bits",(cmask == 0177) ? 7 : 8);
	    conol(temp);
	    if (parity) {
		conol(", ");
		switch (parity) {
		    case 'e': conol("even");  break;
		    case 'o': conol("odd");   break;
		    case 's': conol("space"); break;
		    case 'm': conol("mark");  break;
		}
		conol(" parity");
	    }
	    if (seslog) {
		conol(", logging to "); conol(sesfil);
            }
	    conoll(""); return;

	case '?':			/* Help */
	    c = hconne(); continue;

	case '0':			/* Send a null */
	    c = '\0'; d = dopar(c); ttoc(d); return;

	case 'z': case '\032':
	    stptrap(0,0); return;

	case '!':
	    conres();			/* Put console back to normal */
	    zshcmd("");			/* Fork a shell. */
	    if (conbin(escape) < 0) {
		printf("Error returning to remote session\n");
		active = 0;
	    }
	    return;

	case SP:			/* Space, ignore */
	    return;

	default:			/* Other */
	    if (c == CMDQ) {		/* Backslash escape */
		int x;
		kbp = kbuf;
		*kbp++ = c;
		while (((c = coninc(0)) != '\r') && (c != '\n'))
		  *kbp++ = c;
		*kbp = NUL; kbp = kbuf;
		x = xxesc(&kbp);
		if (x >= 0) {
		    c = dopar(x);
		    ttoc(c);
		    return;
		} else {
		    conoc(BEL);
		    return;
		}
	    }
	    conoc(BEL); return; 	/* Invalid esc arg, beep */
    	}	    
    }
}    

#ifdef NETCONN

/* TCP/IP Telnet negotiation support code */

#ifndef TELCMDS
char *telcmds[] = {
    "SE", "NOP", "DMARK", "BRK",  "IP",   "AO", "AYT",  "EC",
    "EL", "GA",  "SB",    "WILL", "WONT", "DO", "DONT", "IAC",
};
#endif /* TELCMDS */

#ifndef TELOPTS
char *telopts[] = {
	"BINARY", "ECHO", "RCP", "SUPPRESS GO AHEAD", "NAME",
	"STATUS", "TIMING MARK", "RCTE", "NAOL", "NAOP",
	"NAOCRD", "NAOHTS", "NAOHTD", "NAOFFD", "NAOVTS",
	"NAOVTD", "NAOLFD", "EXTEND ASCII", "LOGOUT", "BYTE MACRO",
	"DATA ENTRY TERMINAL", "SUPDUP", "SUPDUP OUTPUT",
	"SEND LOCATION", "TERMINAL TYPE", "END OF RECORD",
};
#endif
int ntelopts = sizeof(telopts) / sizeof(char *);

/* Send a telnet option, avoid loops. */
/* Returns 1 if command was sent, 0 if not. */

tn_sopt(cmd,opt) int cmd, opt; {	/* TELNET SEND OPTION */
    ttoc(IAC);				/* Send Interpret As Command (IAC) */
    ttoc(cmd);				/* Command (WILL, WONT, DO, DONT) */
    ttoc(opt);				/* Option */
    debug(F111,"telnet cmd >",telcmds[cmd - SE],cmd);
    debug(F111,"telnet opt >",telopts[opt],opt);
    if (debses && cmd != SB)
      printf("[%s %s]",telcmds[cmd - SE],telopts[opt]);
    return(1);
}

/* Initialize a telnet connection. */

tn_ini() {				/* TELNET INITIALIZE */
    if (ttnproto != NP_TELNET)		/* Be sure we're talking telnet. */
      return;
    sgaflg = 0;				/* SGA flag starts out this way. */
    tn_sopt(WILL,TELOPT_TTYPE);		/* Will send terminal type. */
    tn_sopt(DO,TELOPT_SGA);		/* Please suppress go-ahead. */

/* The ECHO negotiations are not necessary for talking to full-duplex */
/* systems, and they don't seem to do any good when sent to half-duplex */
/* ones -- they still refuse to echo, and what's worse, they get into */
/* prolonged negotiation loops.  Real telnet sends only the two above */
/* at the beginning of a connection. */
    tn_sopt(WONT,TELOPT_ECHO);		/* I won't echo. */
    tn_sopt(DO,TELOPT_ECHO);		/* Please, you echo. */
}

/* Process in-band Telnet negotiation characters from the host. */
/* Call with the telnet IAC character. */
/* Return 0 on success, -1 on failure (= internal or i/o error) */

#define  TSBUFSIZ  41
char sb[TSBUFSIZ];			/* Buffer for subnegotiations */

tn_doop(z) CHAR z; {			/* TELNET DO OPTION */
    int c, x, y, n, flag;

    debug(F111,"telnet <",telcmds[z - SE],z);   /* Debug log */
    if (ttnproto != NP_TELNET) return(-2);      /* Check protocol */
    if (z != IAC) return(-2);                   /* Character should be IAC */

    c = ttinc(0) & 0xff;		/* Read command character */
    if (seslog) {			/* Copy to session log, if any. */
	if (zchout(ZSFILE,z) < 0) seslog = 0; /* Log the IAC. */
	else if (zchout(ZSFILE,c) < 0) seslog = 0; /* Log the command. */
    }
    debug(F111,"telnet cmd <",telcmds[c - SE],c); /* Debug log. */

    if ((x = ttinc(0)) < 0) return(-1); /* Get the option. */
    x &= 0xff;
    debug(F111,"telnet opt <",telopts[x],x); /* Debug to log */
    if (seslog)				     /* Session log */
      if (zchout(ZSFILE,x) < 0) seslog = 0;

    /* Now handle the command */

    if (debses && c != SB)		/* Debug to screen. */
      printf("<%s %s>",telcmds[c-SE],telopts[x]);

    switch (x) {
      case TELOPT_ECHO:			/* ECHO negotiation. */
	if (c == WILL)			/* Host says it will echo. */
	  break;			/* Fine, we already said DO echo. */
	if (c == WONT) {		/* Host says it won't echo. */
	    tn_sopt(DONT,x);		/* So don't. */
	    if (duplex != 1) {		/* But if we're in full duplex */
		kill(parent_id,SIGUSR2); /* we have to notify the parent. */
		for (;;) pause();
	    }
	}
	if (c == DO) {			/* Host wants me to echo */
	    tn_sopt(WONT,x);		/* I say I won't, */
	    tn_sopt(DO,x);		/* and tell it to. */
	    if (duplex != 0) {		/* But if we're in half duplex */
		kill(parent_id,SIGUSR2); /* must notify parent. */
		for (;;) pause();
	    }
	}
	if (c == DONT) {		/* Host wants me not to echo */
	    tn_sopt(WONT,x);		/* I say I won't. */
	    if (duplex != 0 && sgaflg == 0) { /* But if we're in half duplex */
		kill(parent_id,SIGUSR2); /* We have to notify the parent. */
		for (;;) pause();
	    }
	}
	return(0);

      case TELOPT_SGA:			/* Suppress Go-Ahead */
	if (c == WONT) {		/* Host says it won't. */
	    tn_sopt(DONT,x);		/* So don't. */
	    sgaflg = 1;			/* Remember. */
	    if (duplex != 1) {		/* But if we're in full duplex */
		kill(parent_id,SIGUSR2); /* We have to notify the parent. */
		for (;;) pause();
	    }
	}
	return(0);

#ifdef TELOPT_TTYPE
      case TELOPT_TTYPE:		/* Terminal Type */
	switch (c) {
	  case DO:			/* DO terminal type. */
	    tn_sopt(WILL,x);		/* Say I'll send it if asked. */
	    return(0);
	  case SB:
	    debug(F100,"telnet subnegotiation:","",0);
	    n = flag = 0;		/* Flag for when done reading SB */
	    while (n < TSBUFSIZ) {	/* Loop looking for IAC SE */
		if ((y = ttinc(0)) < 0)
		  return(-1);
		y &= 0xff;		/* Make sure it's just 8 bits. */
		sb[n++] = y;		/* Save what we got in buffer. */
		if (seslog)		/* Log it if logging. */
		  if (zchout(ZSFILE,y) < 0)
		    seslog = 0;
		if (y == IAC) {		/* If this is an IAC */
		    flag = 1;		/* set the flag. */
		} else {		/* Otherwise, */
		    if (flag && y == SE) /* if this is SE which immediately */
		      break;		/* follows IAC, we're done. */
		    else flag = 0;	/* Otherwise turn off flag. */
		}
		debug(F111,"telnet subopt <","",y);
		}
	    if (!flag) return(-1);	/* Make sure we got a valid SB */
	    if (debses) {		/* Debug to screen. */
		int i;
		printf("<SB %s ",telopts[x]);
		for (i = 0; i < n-2; i++) printf("%02x",sb[i]);
		printf(" IAC SE>");
	    }	    
	    debug(F101,"telnet suboption","",sb[0]);
	    if (sb[0] == 1) {		/* SEND terminal type? */
		tn_sttyp();		/* Yes, so send it. */
	    }
	  default:			/* Others, ignore */
	    return(0);
	}
#endif
      default:				/* Shouldn't get here */
	debug(F111,"telnet opt <","not handled",x);
	break;
    }
    return(0);
}

/* Telnet send terminal type */

extern char *getenv();

tn_sttyp() {				/* Send telnet terminal type. */
    char *ttn; int ttl;			/* Name & length of terminal type. */

    ttn = getenv("TERM");		/* Get it from the environment. */
    if ((ttn == ((char *)0)) || ((ttl = strlen(ttn)) >= TSBUFSIZ)) {
	ttn = "UNKNOWN";
	ttl = 7;
    }
    strcpy(sb,ttn);			/* Copy to subnegotiation buffer */
    ttn = sb;				/* Point back to beginning */
    tn_sopt(SB,TELOPT_TTYPE);		/* Send: Terminal Type */
    ttoc((char) 0);			/* IS... */
    while (*ttn) {			/* name of terminal */
	if (islower(*ttn)) *ttn = toupper(*ttn); /* converted to uppercase. */
	ttoc(*ttn++);
    }
    ttoc(IAC);				/* Terminate the subnegotiation. */
    ttoc(SE);
    debug(F111,"telnet SB sending ttype",sb,ttl);
    if (debses)				/* Debug to screen. */
      printf("[SB TERMINAL TYPE 00 %s IAC SE]",sb);
}
#ifdef SUNX25

/* PAD X.3, X.28 and X.29 support */

static CHAR x29err [MAXPADPARMS+3] = { X29_ERROR, INVALID_PAD_PARM, '\0' };


/* Initialize PAD */

initpad() {
  padparms[PAD_BREAK_CHARACTER]        = 0;  /* Break character */
  padparms[PAD_ESCAPE]                 = 1;  /* Escape permitted */
  padparms[PAD_ECHO]                   = 1;  /* Kermit PAD does echo */
  padparms[PAD_DATA_FORWARD_CHAR]      = 2;  /* forward character CR */
  padparms[PAD_DATA_FORWARD_TIMEOUT]   = 0;  /* no timeout forward condition */
  padparms[PAD_FLOW_CONTROL_BY_PAD]    = 0;  /* not used */
  padparms[PAD_SUPPRESSION_OF_SIGNALS] = 1;  /* allow PAD service signals */
  padparms[PAD_BREAK_ACTION]           = 21; /* brk action: INT pk + brk ind*/
  padparms[PAD_SUPPRESSION_OF_DATA]    = 0;  /* no supression of user data */
  padparms[PAD_PADDING_AFTER_CR]       = 0;  /* no padding after CR */
  padparms[PAD_LINE_FOLDING]           = 0;  /* no line fold */
  padparms[PAD_LINE_SPEED]             = 0;  /* line speed - don't care */
  padparms[PAD_FLOW_CONTROL_BY_USER]   = 0;  /* flow cont of PAD - not used */
  padparms[PAD_LF_AFTER_CR]            = 0;  /* no LF insertion after CR */
  padparms[PAD_PADDING_AFTER_LF]       = 0;  /* no padding after LF */
  padparms[PAD_EDITING]                = 1;  /* can edit */
  padparms[PAD_CHAR_DELETE_CHAR]       = 8;  /* character delete character */
  padparms[PAD_BUFFER_DELETE_CHAR]     = 21; /* buffer delete character */
  padparms[PAD_BUFFER_DISPLAY_CHAR]    = 18; /* buffer display character */
}


/* Set PAD parameters */

setpad (s,n) CHAR *s; int n; {
    int i;
    CHAR *ps = s;

    for (i = 0; i < n; i++, ps++)
        if (*ps > MAXPADPARMS)
            x29err[i+2] = *ps++;
        else
            padparms[*ps] = *(++ps);
}


/* Read PAD parameters */

readpad (s,n,r) CHAR *s; int n; CHAR *r; {
    int i;
    CHAR *ps = s;
    CHAR *pr = r;
    
    *pr++ = X29_PARAMETER_INDICATION;
    for (i = 0; i < n; i++, ps++) {
         if (*ps > MAXPADPARMS)
             x29err[i+2] = *ps++;
         else {
             *pr++ = *ps;
             *pr++ = padparms[*ps++];
         }
    }
}

qbitpkt (s,n) CHAR *s; int n; {
    CHAR *ps = s;
    int x29cmd = *ps;
    CHAR *psa = s+1; 
    CHAR x29resp[(MAXPADPARMS*2)+1];

    switch (x29cmd) {

        case X29_SET_PARMS:
            setpad (ps+1,n/2);
            if (strlen(x29err) > 2) {
                ttol (x29err,strlen(x29err));
                x29err[2] = '\0';
            } 
            return (-2);
        case X29_READ_PARMS:
            readpad (ps+1,n/2,x29resp);
            setqbit ();
            ttol (x29resp,n+1);
            if (strlen(x29err) > 2) {
                ttol (x29err,strlen(x29err));
                x29err[2] = '\0';
            } 
            resetqbit();
            break;
        case X29_SET_AND_READ_PARMS:
            setpad (ps+1,n/2);
            readpad (ps+1,n/2,x29resp);
            setqbit();
            ttol (x29resp,n+1);
            if (strlen(x29err) > 2) {
                ttol (x29err,strlen(x29err));
                x29err [2] = '\0';
            }
            resetqbit();
            return (-2);
        case X29_INVITATION_TO_CLEAR:
            (void) x25clear();
            return (-1) ;
        case X29_INDICATION_OF_BREAK:
            printf ("\nIndication of break\n");
    }
    return (0);
}

/* PAD break action processor */

breakact () {
    static CHAR indbrk[3] = {
	X29_INDICATION_OF_BREAK,
	PAD_SUPPRESSION_OF_DATA,
	1
    };
    CHAR intudat, cause, diag;

    if (x25stat() < 0) return(0);  /* ignore if no virtual call established */

    if (padparms[PAD_BREAK_ACTION] != 0)  /* forward condition */
        if (ttol(x25obuf,obufl) < 0) {
            perror ("\r\nCan't send characters");
            active = 0;
        } else {
            bzero (x25obuf,sizeof(x25obuf));
            obufl = 0;
            tosend = 0;
        };

    switch (padparms[PAD_BREAK_ACTION]) {

       case 0 : break;  /* do nothing */
       case 1 : intudat = 1;
                x25intr (intudat); /* send interrupt packet with interrupt 
                                      user data field = 1 */
                break;
       case 2 : cause = diag = 0;
                x25reset (cause,diag); /* send reset packet with
                                          cause and diag = 0 */
                break;
       case 5 : intudat = 0;
                x25intr (intudat) ; /* send interrupt packet with interrupt
                                       user data field = 0 */
                setqbit ();
                ttoc (X29_INDICATION_OF_BREAK); /* send indication of break
                                                   without a parameter field */
                resetqbit ();
                break;
       case 8 : active = 0;      /* leave data transfer */
                conol ("\r\n");
                break;
       case 21: intudat = 0;
                x25intr (intudat); /* send interrupt packet with interrupt 
                                user data field = 0 */
                setpad (indbrk+1,2);  /* set pad to discard input */
                setqbit ();
                ttol (indbrk,sizeof(indbrk)); /* send indication of break
                                                with parameter field */
                resetqbit ();
                break;
    }
}
#endif /* SUNX25 */
#endif /* NETCONN */
