/*********************************************************************

 CFC.C  -  a C source file style checker
 rev 1.0	- 	4-4-90
 Copyright 1990 Ron Mignery

***********************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define TRUE 1
#define FALSE 0

FILE *fp;
char line[128];
int blockdump, list_in_debug, in_debug, show_line, stop_on_error;
int last_index, last_linenum=0, error_disable[20];

void print(char *msg, int linenum, int first_char, int index);

void main (int argc, char *argv[]) {

	int i, j, k, l, first, itabs, otabs, ldone, incom, semi,
	 paren, squotes, quotes, lineno, lbrace, qcon, opts, add, xpos;
	int tab[40], outdent_after_rbrace, indent_before_lbrace,
	 no_indent_col_1, delay_itab=0;
	char *p;

   for (i=0; i<20; error_disable[i++] = FALSE);

	if (argc < 2) { /* no file specified - display help info	*/
		printf("\nCFC - C fixed format checker v1.0\n");
		printf
		("\nFormat is:  cfc [-blesiondxxdxx...] filename.c [tab] [tab...]\n\n");
		printf("\tb = show block comments\n");
		printf("\tl = list error lines\n");
		printf("\te = enable reporting in DEBUG lines\n");
		printf("\ts = stop on error\n");
		printf("\ti = indent before lbrace ({)\n");
		printf("\to = outdent after rbrace (})\n");
		printf("\tn = no indent on column 1\n");
		printf("\tdxx = disable error report #xx\n");
		exit(0);
	}

	blockdump = list_in_debug = show_line = stop_on_error =
	 outdent_after_rbrace = indent_before_lbrace = no_indent_col_1 = FALSE;
	if (argv[1][0] == '-') {		  /* parse command line options */
      opts = TRUE;
		if(strchr(argv[1],'b')) blockdump = TRUE;
		if(strchr(argv[1],'e')) list_in_debug = TRUE;
		if(strchr(argv[1],'l')) show_line = TRUE;
		if(strchr(argv[1],'s')) stop_on_error = TRUE;
		if(strchr(argv[1],'i')) indent_before_lbrace = TRUE;
		if(strchr(argv[1],'o')) outdent_after_rbrace = TRUE;
		if(strchr(argv[1],'n')) no_indent_col_1 = TRUE;
		while (strchr(argv[1],'d')) {
			p = strchr(argv[1],'d');
			*p = '0';
			j = 10*(*(p+1) - '0') + (*(p+2) - '0');
			if ((j >= 0) && (j < 20)) error_disable[j] = TRUE;
      }
	}
   else opts = FALSE;


	printf("\n");

	if ((fp = fopen(argv[1+opts],"r")) == NULL) {	 /* open input file */
		printf("File not found\n");
		exit(-1);
	}

	printf("C Format Check on %s\n\n", argv[1+opts]);

   tab[0] = 1;										/* set tab stops */
   for (i=1; i< argc-1-opts; i++) {
		tab[i] = atoi(argv[i+1+opts]);
      if (tab[i] <= tab[i-1]) {
		   printf("Tab sequence error\n");
		   exit(-1);
	   }
   }
   if (i>1) add = tab[i-1]-tab[i-2];
   else add = 3;

   for (;i < 40; i++) tab[i] = tab[i-1] + add;

	otabs = lineno = qcon = ldone = in_debug = FALSE;
	while (feof(fp) == FALSE) {
		incom = FALSE;
top:																 /* top of loop */
		if (fgets(line, 120, fp) == NULL) exit(0);	 /* read one line */

		lineno++;												 /* count the lines */
		l = strlen(line) - 1;
		while(l && ((line[l-1] == ' ') || (line[l-1] == '\t'))) {
			print("Trailing blanks or tabs in line ", lineno, 1, 0);
			line[l] = '\0';
			line[--l] = '\n';
		}
		if (l == 0) goto top;			/* ignore blank lines */

		j = first = k = 0;				/* set j to last char not in comment */
		for (i = 0; i < l; i++) {
			if ((line[i] == '/') && (line[i+1] == '*')) {
				if (j == 0) {
					first = i;
					k = 1;
				}
				break;
			}
			if ((line[i] != '\t') && (line[i] != ' ')) {
				j = i+1;
				if (first == 0) first = i;
			}
		}

		if (l > 80)
			print("More than 80 characters in line ",	lineno, first+1, 16);

		if (line[0] == '#') {
			if (strncmp(line,"#ifdef DEBUG",12) == 0) in_debug = TRUE;
			if (strncmp(line,"#endif",6) == 0) in_debug = FALSE;
         goto top;
      }
		if ((list_in_debug == FALSE) && in_debug) goto top;

		if (incom == FALSE) {
			if (k) incom = TRUE;
			if ((line[l-1] == '/') && (line[l-2] == '*')) {
				if (incom) {
					incom = FALSE;
					goto top;
				}
				incom = FALSE;
			}
			if (incom && blockdump) {
				printf(
				 " ____BEGIN_BLOCK_COMMENT____________________________\n");
				printf(
				 "/                                                   \\\n");
			}
		}
		if (incom && blockdump) printf("%s", line);
		if (incom) {
			if ((line[l-1] == '/') && (line[l-2] == '*')) {
				incom = FALSE;
				if (blockdump) printf(
					 "\\____END_BLOCK_COMMENT______________________________/\n");
         }
			goto top;
		}

		if ((j > 0) && (line[j-1] == ':')) goto top;

		first = paren = itabs = incom = semi = squotes
         = quotes = lbrace = FALSE;
      xpos = 1;

		for (i = 0; i < l; i++) {

			if (first == 0) {
				if (line[i] == ' ') {
               xpos++;
               j = 0;
					while (xpos > tab[j]) j++;
               if (xpos == tab[j]) itabs++;
            }

				else {
               if (line[i] == '\t') {
                  itabs++;
                  j = 0;
						while (xpos >= tab[j]) j++;
                  xpos = tab[j];
               }

					else {
						first = i+1;
						if (line[i] == '{') {
							ldone = TRUE;
							if (indent_before_lbrace) {
								if ((i > 0) || (no_indent_col_1 == FALSE)) otabs++;
							}
						}

                  j = 0;
						while (xpos > tab[j]) j++;
                  if ((xpos != tab[j]) && (ldone == TRUE))
							print("First Character not on tab stop in line ",
							lineno, first, 1);

						if (line[i] == '}') {
                     if (outdent_after_rbrace) delay_itab = TRUE;
                     else otabs--;
                  }

						if (qcon == FALSE) {
							if (ldone == TRUE) {
							   if (itabs < otabs)
							      print("Missing indent in line ", lineno, first,2);
							   if (itabs > otabs)
							      print("Extra indent in line ", lineno, first,3);
                        if (delay_itab) {
                           delay_itab = FALSE;
									otabs--;
								}
                     }
						}
						else quotes = TRUE;
						itabs = otabs;
						qcon = ldone = FALSE;
					}
            }
			} /* end of if first=0 */
			if (first != 0) {
				if (incom < 0)
				 print("Characters past comment in line ",
				  lineno, first,4);
				if ((line[i] == '/') && (line[i+1] == '*')) incom = TRUE;
				else {
					if (incom == TRUE) {
						if ((line[i] == '/') && (line[i-1] == '*'))
						 incom = -1;
						if (line[i] == ';')
						 print("Semicolon in comment line ",
						  lineno, first,5);
						if (line[i] == '"')
						 print("Quotes in comment line ",
						  lineno, first,6);
						if ((line[i] == '{')  || (line[i] == '}'))
						 print("Braces in comment line ",
						  lineno, first,7);
					}
					else {

						if ((line[i] != '\t') && (line[i] != ' ')) {
							if (semi)
							 print(
							  "Characters past semicolon in line ",
							  lineno, first,8);
							if (lbrace)
							 print("Characters past lbrace in line ",
							  lineno, first,9);
							if ((squotes == FALSE) && (quotes == FALSE)) {
								if (line[i] == '(') paren++;
								if (line[i] == ')') paren--;
								if ((line[i] == ';') && (paren == FALSE)){
									semi = TRUE;
									ldone = TRUE;
									if (quotes)
									 print("Semicolon in quotes in line ",
									 lineno, first,10);
								}
								if (line[i] == '{') {
									ldone = lbrace = TRUE;
									if (indent_before_lbrace == FALSE) {
										if ((i > 0) || (no_indent_col_1 == FALSE))
										 otabs++;
									}
									if (quotes)
									 print("Rbrace in quotes in line ",
									  lineno, first,11);
								}
								if (line[i] == '}') {
									if (i > first) otabs--;
									if (quotes)
									 print("Lbrace in quotes in line ",
									  lineno, first,12);
									if (i != (first -1 ))
									 print("Rbrace not first char in line ",
									  lineno, first,13);
								}
							}
							if ((squotes == FALSE) && (line[i] == 34)
							 && (line[i-1] != 92))
							  quotes = 1 - quotes;
							if ((quotes == FALSE) && (line[i] == 39)
							 && (line[i-1] != 92))
							  squotes = 1 - squotes;
						} /* end of not \t */
					} /* end of not in comment */
				} /* end of not start of comment */
			} /* end of if first!=0 */
		} /* end of for */
		if (line[j] == 92) qcon = TRUE;
		else if (quotes)
		 print("Odd quotes in line ", lineno, first,14);
		else if (incom > 0)
		 print("Comment not closed in line ", lineno, first,15);

	} /* end of while */
} /* end of main */

void print(char *msg, int linenum, int first_char, int index) {

	if (error_disable[index] == FALSE) {
		if ((last_index != index) || (last_linenum != linenum)) {
			last_index = index;
			last_linenum = linenum;
			if (in_debug) printf("D");
			printf("*%02i %s %i\n", index, msg, linenum);
			if (show_line) {
				printf("%02i>>  %s",first_char, &line[first_char-1]);
			}
		}
		if (stop_on_error) exit (-1);
   }
}

