/* C Easy Program Example: names.c */

/* DECLARE USER FIELD EDIT FUNCTIONS */

   int retrieve();                /* declare edit function for names.h */

/* DECLARE FUNCTION KEY EVENTS */

   int interrupt_form();
   int F4_Key();

#include "ceasy1.h"

#include "names.h"                /* Data Entry Form */

#include "ceasy2.h"

/* GLOBALS AND DEFINES */

   int EXISTS;
   int EXIT_NEXT_PREVIOUS;
   int INTERRUPTED;
   char *COMMAND;

#define BEGIN_NEXT     22         /* starting command for select_across() */
#define BEGIN_PREVIOUS 29         /* starting command for select_across() */
#define SELECT   (*COMMAND=='S')
#define QUERY    (*COMMAND=='Q')
#define NEXT     (*COMMAND=='N')
#define PREVIOUS (*COMMAND=='P')
#define ADD      (*COMMAND=='A')
#define UPDATE   (*COMMAND=='U')
#define DELETE   (*COMMAND=='D')
#define FIRST    (*COMMAND=='F')
#define EXIT     (*COMMAND=='E')

/* PROGRAM STARTS HERE */

   main()
    {
     start_program();

     if(GRAPHICS_MODE) set_graphics_mode(OFF);

     enable_time('C',SL,66);

  /* ALLOCATE LOGICAL RECORD FILE #3 */

     if((RECORD[3]=(char*)Malloc(300))==NULL)
      {
       display_error("Cannot Malloc record",NULL);
       stop_program(-1);
      }
     erase(RECORD[3],300);

  /* INITALIZE SCREEN AND VARIABLES */

     open_dbf(3,"_names");       /* load LOCAL names.dbf file header */

     initialize();

  /* OPEN names.dbf as LOGICAL FILE #3 */

/*   open_dbf(3,"names");        load LOCAL names.dbf file header */

     RPTR[3]=define_dbf_fields(3);     /* build RPTR TABLE */

  /* OPEN names.frm */

 if(read_form("names")<0)
   {
     display_message("Cannot read ","names");
     stop_program(-1);
   }

     define_fields(FPTR);              /* update FPTR TABLE */

     display_form();                   /* display form */

  /* PROCESS COMMAND LINE UNTIL 'EXIT' COMMAND IS SELECTED */

     while(NOT EXIT)
      {
       BEGIN_SELECT=1;
       if(NOT EXIT_NEXT_PREVIOUS) /* AND NOT INTERRUPTED */
        {
         while(1)
          {
           COMMAND=select_across(2,3);
           BEGIN_SELECT = --AC;
           if(NOT(UP OR DOWN)) break;
          }
        }
       EXIT_NEXT_PREVIOUS=NO;
       INTERRUPTED=NO;

       if(SELECT) continue;

       if(EXIT) break;

       if(FIRST)
        {
         first_record(3);
         get_fields(RECORD[3],RPTR[3],FPTR);
         display_fields(FPTR);
         continue;
        }
       if(NOT NEXT AND NOT PREVIOUS)
        {
         set_field("NAME",FPTR);
         if(UPDATE && *APTR!=SPACE) FPTR++;
         else
          {
           erase_fields(FPTR);
           display_fields(FPTR);
          }
         event_F[3].function=interrupt_form;
         event_F[4].function=F4_Key;

         enter_form(FPTR);

         FPTR=&FIELD[0];
         event_F[3].function=NULL;   /* temporarily inhibit F3 */
         event_F[4].function=NULL;
         if(INTERRUPTED) continue;
        }
       else
        {
         set_field("NAME",FPTR);
         if(*APTR == SPACE)
          {
           COMMAND="S";
           continue;
          }
        }
       if(ADD OR UPDATE)
        {
         erase(RECORD[3],300);
         put_fields(RECORD[3],RPTR[3],FPTR);
        }
       if(EXISTS AND UPDATE)
        {
         if(replace_record(3))
          {
           display_message("Record not replaced",NULL);
          }
        }
       if(NOT EXISTS AND ADD)
        {
         if(add_record(3))
           display_message("Record not added",NULL);
        }
       if(EXISTS AND DELETE)
        {
         if(delete_record(3))
           display_message("Record not deleted",NULL);
        }
       while(NEXT OR PREVIOUS)
        {
         if(NEXT)
          {
           if(next_record(3)==DBF_EOF)
            {
             first_record(3);
            }
          }
         if(PREVIOUS)
          {
           if(previous_record(3)==DBF_BOF)
            {
             last_record(3);
            }
          }
         get_fields(RECORD[3],RPTR[3],FPTR);
         display_fields(FPTR);
         if(NEXT) BEGIN_SELECT=BEGIN_NEXT;
         else BEGIN_SELECT=BEGIN_PREVIOUS;
         COMMAND=select_across(2,3);
         if(EXIT) break;
         if(FUNC) COMMAND="S";
         if(NOT NEXT AND NOT PREVIOUS)
          {
           EXIT_NEXT_PREVIOUS=YES;
           break;
          }
        }
      }
     stop_program(0);
     return(0);
    }

/* F3 KEY: ACCEPT A NEW COMMAND */

   int interrupt_form()
    {
     event_F[3].function=NULL;
     BEGIN_SELECT=1;
/*   COMMAND=select_across(4,3);  */
     EXIT_FORM_NOW=YES;
     INTERRUPTED=YES;
     event_F[3].function=interrupt_form;
     return(ENTRY_EXIT);
    }

/* F4 KEY: CONFIRM ADD OR UPDATE */
   F4_Key()
    {
     EXIT_FORM_NOW=YES;              /* terminate current form entry */
     return(ENTRY_EXIT);             /* terminate data entry form processing */
    }

   /* FIELD EDIT, INVOKED WHEN 'NAME' FIELD IS ENTERED */
   int retrieve()
    {
     while(HELP_KEY && !ADD)
      {
/* printf("1 SIZE=%d\n",SIZE); wait_key(NULL,0,0); */
       if(scroll_names())
        {
         beep();
         return(FIELD_REPEAT);
        }
/*   printf("2 SIZE=%d\n",SIZE); wait_key(NULL,0,0); */
      }
     if(EXIT)                      /* terminate form entry if EXIT selected */
    {
     EXIT_FORM_NOW=YES;
     return(FORM_EXIT);
    }
   if(*APTR==SPACE)                  /* repeat entry if entered key is blank */
    {
     display_message("Key cannot be blank",NULL);
     return(FIELD_REPEAT);
    }
   put_one_field("NAME",RECORD[3],RPTR[3],FPTR); /* move NAME to RECORD TABLE */   EXISTS=NO;
   if(get_record(3)==0)              /* retrieve record */
    {
     get_fields(RECORD[3],RPTR[3],FPTR);   /* populate fields in form */
     display_fields(FPTR);           /* display fields */
     EXISTS=YES;
    }
   if(ADD AND EXISTS)                /* invalid */
    {
     display_error("Record already exists",NULL);
     return(FORM_EXIT);
    }
   if(UPDATE OR QUERY OR DELETE)
    {
     if(NOT EXISTS)                  /* invalid */
      {
       if(QUERY)
        {
/*
         if(next_record(3)==DBF_EOF)
          {
           first_record(3);
          }
*/
         get_fields(RECORD[3],RPTR[3],FPTR);
         display_fields(FPTR);
         EXISTS=YES;
        }
       else
        {
         beep();
         return(FORM_EXIT);
        }
      }
    }
   if(QUERY OR DELETE OR NEXT OR PREVIOUS OR FIRST)
    {
     return(FORM_EXIT);              /* valid, no input required */
    }
   return(FORM_CONTINUE);            /* continue with UDATE or ADD */
  }

/* INITIALIZE */

   int initialize()
    {
     clear_screen(BKGND_GRAY,FGND_YELLOW);

     BKGND_FORM=BKGND_GRAY;

     BKGND_TIME=BKGND_BLUE;
     FGND_ENTRY=FGND_BLUE;
     BKGND_ENTRY=BKGND_BLUE;

     AUTO_COMMAND=OFF;                 /* select_across not automatic */
     WRAP_COMMAND=ON;

     BKGND_HELP=BKGND_CYAN;
     FGND_HELP=FGND_YELLOW;

     BKGND_BAR=BKGND_CYAN;
     FGND_BAR=FGND_BLUE;

     BKGND_FIRST=BKGND_WHITE;
     FGND_FIRST=FGND_BLACK;

     BKGND_ENTRY=BKGND_CYAN;   /* NOT WORKING */
     FGND_ENTRY=FGND_BLUE;
     BKGND_COMMAND=BKGND_WHITE;
     FGND_COMMAND=FGND_BLUE;

     BKGND_COLOR=BKGND_BLUE;
     EXIT_NEXT_PREVIOUS=NO;
     INTERRUPTED=NO;

     FPTR=&FIELD[0];

     event_F[3].function=interrupt_form;  /* enable F3 */
     event_F[4].function=F4_Key;          /* enable F4 */

     return(0);
    }

int scroll_names()
{
  unsigned char *names, *i;
  int w, h, l, c;
  int x;
  int keepsize;

  set_field("NAME",FPTR);

  w=SIZE;
  h=10;
  l=11; c=38;

  if((names=Malloc(50*SIZE))==NULL)
   {
    display_message("Cannot Malloc for names",NULL);
    return(FORM_EXIT);
   }
  erase(names,50*SIZE);
  erase(RECORD[3],SIZE);

/* put_one_field("NAME",RECORD[3],RPTR[3],FPTR);   move NAME to RECORD TABLE */

  move(APTR,RECORD[3],SIZE);
  get_record(3);

  get_fields(RECORD[3],RPTR[3],FPTR);

  if(*APTR==SPACE) first_record(3);

  for(i=names,x=0;x<50;i+=SIZE,x++)
   {
    move(RECORD[3],i,SIZE);
    if(next_record(3)==DBF_EOF) break; /*  first_record(3); */
   }

  keep_all(1);

  BKGND_WINDOW=BKGND_CYAN;
  FGND_WINDOW=FGND_YELLOW;
  FGND_FRAME=FGND_YELLOW;
  BKGND_FRAME=BKGND_BLUE;
  BKGND_BAR=BKGND_GRAY;
  FGND_BAR=FGND_YELLOW;

  keep_window(1,w,h,l,c);
  VERTICAL_ONLY=ON;
  x++;
  browse_select(names,x*SIZE,w,(x<h)?x:h,l,c);
  VERTICAL_ONLY=OFF;
  move(LAST_LINE_PTR,APTR,SIZE);
  restore_window(1,w,h,l,c);

  restore_all(1);
  free(names);
  return(FIELD_REPEAT);
}
