/*
 *  SERROR.C
 *
 *  This module contains error handling routines for SAMPLE.EXE.
 *
 *  Copyright (C) 1991 by Daytris.  All rights reserved.
 */

#include <windows.h>
#include <stdio.h>
#include "dbmgr.h"


/************************************************
 * Function Declarations
 ************************************************/

void DbError( HWND hWnd, DWORD dwError, PSTR pFile, WORD wLineNbr);


/***************************************************************************
 * Function : DbError
 *
 * Purpose  : This function handles CDB database errors.
 *
 * Returns  : n/a
 ***************************************************************************/
void DbError( HWND hWnd, DWORD dwError, PSTR pFile, WORD wLineNbr)
    {
    char szBuffer[512];

    if( LOWORD( dwError) == E_TESTDRIVE)
        {
        sprintf( szBuffer, "Error Code:   E_TESTDRIVE\n\n\n"
                           "This version of CDB For Windows is a\n"
                           "test drive version.  The number of\n"
                           "records added to a record type is\n"
                           "limited to 50.\n\n\n"
                           "See the document CDBW.WRI to obtain\n"
                           "a registered version of CDB For Windows\n");
        }
    else
        {
        sprintf( szBuffer, "Error Code:        %d\n"
                           "Extended Code:     %d\n\n"
                           "Source File Name:  %s\n"
                           "Line Number:       %u\n\n"
                           "Contact Technical Support\n",
            LOWORD( dwError), HIWORD( dwError), pFile, wLineNbr);
        }
    MessageBox( hWnd, szBuffer, "Database Error", MB_ICONEXCLAMATION | MB_OK);
    }
