/* ******************************************************************
 * Function name  : ad_ave(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  calculates a numeric average of its contents.
 *
 * Variables      : start - This pointer to a "double" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : ave = ad_ave(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "double". Additionally, the
 *                 calling program must define the function
 *                 ad_ave() and the function's return value as a
 *                 double.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : double a_array[50];
 *                 double out_average;
 *                 int a_size;
 *                 double ad_ave();
 *
 *                 a_size = 50;
 *                 out_average = ad_ave(a_array,a_size);
 *
 */

double ad_ave(start,size)
 double *start;
 int size;
{ int count;
  double sum = 0;
  double average = 0;
  for ( count=0; count < size; count++ )
    {   sum += (*start++);
    }
  average = sum / count;
  return(average);
}

/* ******************************************************************
 * Function name  : ai_ave(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  calculates a numeric average of its contents.
 *
 * Variables      : start - This pointer to an "int" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : ave = ai_ave(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "int". Additionally, the
 *                 calling program must define the function
 *                 ai_ave() and the function's return value as a
 *                 integer.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : int a_array[50];
 *                 int out_average;
 *                 int a_size;
 *                 int ai_ave();
 *
 *                 a_size = 50;
 *                 out_average = ai_ave(a_array,a_size);
 *
 *
 */

ai_ave(start,size)
 int *start, size;
{ int count;
  int sum = 0;
  int average = 0;
  for ( count=0; count < size; count++ )
    {   sum += (*start++);
    }
  average = sum / count;
  return(average);
}


/* ******************************************************************
 * Function name  : ad_found(start,size,value)
 *
 * Description    : This function receives an array starting location,
 *                  the number of elements in that array and the
 *                  appropriate search value and returns the number of
 *                  times that that value appears in the array.
 *
 * Variables      : start - This pointer to a "double" specifying
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 *                  value - This parameter contains the value to be
 *                          searched for within the array.
 *
 * Example       : ave = ad_found(d_array,50,20.0l)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "double". However, the
 *                 calling program must define the function
 *                 ad_found() and the function's return value as a
 *                 integer.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 *                 The value parameter must be defined as a
 *                 "double"
 *
 * Calling ex.   : double a_array[50];
 *                 double d_value;
 *                 int output;
 *                 int a_size;
 *                 int ad_found();
 *
 *                 a_size = 50;
 *                 d_value = 25.1;
 *                 output = ad_found(a_array,a_size);
 *
 */
ad_found(start,size,value)
 double *start, value;
 int size;
{ int count;
  int found = 0;
  for ( count=0; count < size; count++ )
    {   if ( (*start++) == value ) found++;
    }
  return(found);
}
/* ******************************************************************
 * Function name  : ai_found(start,size,value)
 *
 * Description    : This function receives an array starting location,
 *                  the number of elements in that array and the
 *                  appropriate search value and returns the number of
 *                  times that that value appears in the array.
 *
 * Variables      : start - This pointer to an "int" specifying
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 *                  value - This parameter contains the value to be
 *                          searched for within the array.
 *
 * Example       : ave = ai_found(d_array,50,20)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to an "int". Additionally, the
 *                 calling program must define the function
 *                 ai_found() and the function's return value as a
 *                 integer.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 *                 The value parameter must be defined as a
 *                 "int"
 *
 * Calling ex.   : int a_array[50];
 *                 int d_value;
 *                 int output;
 *                 int a_size;
 *                 int ai_found();
 *
 *                 a_size = 50;
 *                 d_value = 25.1;
 *                 output = ai_found(a_array,a_size);
 *
 */
ai_found(start,size,value)
 int *start, value;
 int size;
{ int count;
  int found = 0;
  for ( count=0; count < size; count++ )
    {   if ( (*start++) == value ) found++;
    }
  return(found);
}
/* ******************************************************************
 * Function name  : ad_max(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  returns the largest value contained within that array.
 *
 * Variables      : start - This pointer to a "double" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : maximum = ad_max(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "double". Additionally, the
 *                 calling program must define the function
 *                 ad_max() and the function's return value as a
 *                 double.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : double a_array[50];
 *                 double output;
 *                 int a_size;
 *                 double ad_max();
 *
 *                 a_size = 50;
 *                 output = ad_max(a_array,a_size);
 *
 */

double ad_max(start,size)
 double *start;
 int size;

{ int count;
  double max_value;

  max_value = (*start);
  for ( count=0; count < size; count++ )
    {   if ( (*start) > max_value ) max_value = (*start);
	start++;
    }
  return(max_value);
}

/* ******************************************************************
 * Function name  : ai_max(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  returns the largest value contained within that array.
 *
 * Variables      : start - This pointer to a "int" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : maximum = ai_max(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "int". Additionally, the
 *                 calling program must define the function
 *                 ai_max() and the function's return value as a
 *                 integer.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : int a_array[50];
 *                 int output;
 *                 int a_size;
 *                 int ai_max();
 *
 *                 a_size = 50;
 *                 output = ai_max(a_array,a_size);
 *
 */

ai_max(start,size)
 int *start, size;

{ int count;
  int max_value;

  max_value = (*start);
  for ( count=0; count < size; count++ )
    {   if ( (*start) > max_value ) max_value = (*start);
	start++;
    }
  return(max_value);
}

/* ******************************************************************
 * Function name  : ad_mean(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  calculates a numeric mean of its contents.
 *
 * Variables      : start - This pointer to a "double" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : mean = ad_mean(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "double". Additionally, the
 *                 calling program must define the function
 *                 ad_mean() and the function's return value as a
 *                 double.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : double a_array[50];
 *                 double output;
 *                 int a_size;
 *                 double ad_mean();
 *
 *                 a_size = 50;
 *                 output = ad_mean(a_array,a_size);
 *
 */

double ad_mean(start,size)
 double *start;
 int size;

{ int count;
  double max_value, min_value, mean_value;

  max_value = (*start);
  min_value = (*start);
  for ( count=0; count < size; count++ )
    {   if ( (*start) > max_value ) max_value = (*start);
	if ( (*start) < min_value ) min_value = (*start);
	start++;
    }
  mean_value = ( max_value + min_value ) / 2;
  return(mean_value);
}

/* ******************************************************************
 * Function name  : ai_mean(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  calculates a numeric mean of its contents.
 *
 * Variables      : start - This pointer to an "int" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : ave = ai_mean(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "int". Additionally, the
 *                 calling program must define the function
 *                 ai_mean() and the function's return value as a
 *                 integer.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : int a_array[50];
 *                 int output;
 *                 int a_size;
 *                 int ai_mean();
 *
 *                 a_size = 50;
 *                 output = ai_mean(a_array,a_size);
 *
 *
 */

ai_mean(start,size)
 int *start;
 int size;

{ int count;
  int max_value, min_value, mean_value;

  max_value = (*start);
  min_value = (*start);
  for ( count=0; count < size; count++ )
    {   if ( (*start) > max_value ) max_value = (*start);
	if ( (*start) < min_value ) min_value = (*start);
	start++;
    }
  mean_value = ( max_value + min_value ) / 2;
  return(mean_value);
}

/* ******************************************************************
 * Function name  : ad_min(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  return the minimum array value.
 *
 * Variables      : start - This pointer to a "double" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : minimum = ad_min(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "double". Additionally, the
 *                 calling program must define the function
 *                 ad_min() and the function's return value as a
 *                 double.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : double a_array[50];
 *                 double output;
 *                 int a_size;
 *                 double ad_min();
 *
 *                 a_size = 50;
 *                 output = ad_min(a_array,a_size);
 *
 */

double ad_min(start,size)
 double *start;
 int size;

{ int count;
  double min_value;

  min_value = (*start);
  for ( count=0; count < size; count++ )
    {   if ( (*start) < min_value ) min_value = (*start);
	start++;
    }
  return(min_value);
}


/* ******************************************************************
 * Function name  : ai_min(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  returns the smallest value contained within that array.
 *
 * Variables      : start - This pointer to a "int" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : minimum = ai_min(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "int". Additionally, the
 *                 calling program must define the function
 *                 ai_min() and the function's return value as a
 *                 integer.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : int a_array[50];
 *                 int output;
 *                 int a_size;
 *                 int ai_min();
 *
 *                 a_size = 50;
 *                 output = ai_min(a_array,a_size);
 *
 */

ai_min(start,size)
 int *start, size;

{ int count;
  int min_value;

  min_value = (*start);
  for ( count=0; count < size; count++ )
    {   if ( (*start) < min_value ) min_value = (*start);
	start++;
    }
  return(min_value);
}

/* ******************************************************************
 * Function name  : ad_search(start,size,value)
 *
 * Description    : This function receives an array starting location,
 *                  the number of elements in that array and the
 *                  appropriate search value and returns the location
 *                  of the first occurance of that value.
 *
 * Variables      : start - This pointer to a "double" specifying
 *                          the memory address of the first array element
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 *                  value - This parameter contains the value to be
 *                          searched for within the array.
 *
 * Example       : location = ad_search(d_array,50,20.0l)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "double". However, the
 *                 calling program must define the function
 *                 ad_search() and the function's return value as a
 *                 integer.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 *                 The value parameter must be defined as a "double"
 *
 * Calling ex.   : double a_array[50];
 *                 double d_value;
 *                 int a_size, output;
 *                 int ad_search();
 *
 *                 a_size = 50;
 *                 d_value = 25.1;
 *                 output = ad_search(a_array,a_size);
 */
ad_search(start,size,value)
 double *start;
 int size;
 double value;
{ int count;
  int location = -1;
  for ( count=0; count < size; count++ )
    {   if ( (*start++) == value )
	  { location = count;
	     break;
	  }
    }
  return(location);
}
/* ******************************************************************
 * Function name  : ai_search(start,size,value)
 *
 * Description    : This function receives an array starting location,
 *                  the number of elements in that array and the
 *                  appropriate search value and returns the location
 *                  of the first occurance of that value.
 *
 * Variables      : start - This pointer to a "int" specifying
 *                          the memory address of the first array element
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 *                  value - This parameter contains the value to be
 *                          searched for within the array.
 *
 * Example       : location = ai_search(d_array,50,20)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "int". However, the
 *                 calling program must define the function
 *                 ai_search() and the function's return value as a
 *                 integer.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 *                 Th value parameter must be defined as an "int".
 *
 * Calling ex.   : int a_array[50];
 *                 int d_value;
 *                 int a_size, output;
 *                 int ai_search();
 *
 *                 a_size = 50;
 *                 d_value = 25;
 *                 output = ai_search(a_array,a_size);
 */
ai_search(start,size,value)
 int *start;
 int size;
 int value;
{ int count;
  int location = -1;
  for ( count=0; count < size; count++ )
    {   if ( (*start++) == value )
	  { location = count;
	     break;
	  }
    }
  return(location);
}
/* ******************************************************************
 * Function name  : ad_sum(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  calculates the sum of its contents.
 *
 * Variables      : start - This pointer to a "double" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : sum = ad_sum(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "double". Additionally, the
 *                 calling program must define the function
 *                 ad_sum() and the function's return value as a
 *                 double.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : double a_array[50];
 *                 double output;
 *                 int a_size;
 *                 double ad_sum();
 *
 *                 a_size = 50;
 *                 output = ad_sum(a_array,a_size);
 *
 */

double ad_sum(start,size)
 double *start;
 int size;
{ int count;
  double sum = 0;
  for ( count=0; count < size; count++ )
    {   sum += (*start++);
    }
  return(sum);
}

/* ******************************************************************
 * Function name  : ai_sum(start,size)
 *
 * Description    : This function receives an array starting location
 *                  and the number of elements in that array and
 *                  calculates the sum of its contents.
 *
 * Variables      : start - This pointer to a "int" specifies
 *                          the memory address of the first array
 *                          element.
 *
 *                  size - This integer number specifies the number
 *                         of array members.
 *
 * Example       : sum = ai_sum(d_array,50)
 *
 * Rules         : This function must be passed a variable defined
 *                 as a pointer to a "int". Additionally, the
 *                 calling program must define the function
 *                 ai_sum() and the function's return value as a
 *                 int.
 *
 *                 The size parameter denoting the number of
 *                 elements contained within the array must be
 *                 defined as an integer.
 *
 * Calling ex.   : int a_array[50];
 *                 int output;
 *                 int a_size;
 *                 int ai_sum();
 *
 *                 a_size = 50;
 *                 output = ai_sum(a_array,a_size);
 *
 */

ai_sum(start,size)
 int *start, size;
{ int count;
  int sum = 0;
  for ( count=0; count < size; count++ )
    {   sum += (*start++);
    }
  return(sum);
}

