//**************************************************************************
//
//  Title: KEYLOOK
//
//  Purpose:  Display the keyboard input info for as many keys as possible.
//
//
//**************************************************************************
#include <STDIO.H>
#define  NOMINMAX
#include <WINDOWS.H>
#include <STRING.H>

//*------------------------------------------------------------------------
//| Global Variables
//*------------------------------------------------------------------------
HWND     hWnd1;
HANDLE   hInst;
char     StrBuff[40];
char     HexStr[16] = "0123456789ABCDEF";
char     HexWork[5] = "0000";

//*------------------------------------------------------------------------
//| Prototyping Statements
//*------------------------------------------------------------------------
LPSTR FAR PASCAL MessageName( LPSTR lpszMsgBuffer, WORD message);

long FAR PASCAL OverlappedWindowProc1 (HWND     hWnd,
                                       unsigned msgID,
                                       WORD     wParam,
                                       LONG     lParam);

//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         CmdShow       - Integer value specifying how to start app.,
//|                            (Iconic or Normal)
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    CmdShow)
{
WNDCLASS rClass;
MSG      msg;

    if (!hPrevInstance)
    {
        /*  Register Class for Main Window  */
        rClass.lpszClassName = "MSU:KEYLOOK:MAIN";
        rClass.hInstance     = hInstance;
        rClass.lpfnWndProc   = OverlappedWindowProc1;
        rClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
        rClass.hIcon         = LoadIcon(hInstance,"KEYLOOKICON");
        rClass.lpszMenuName  = NULL;
        rClass.hbrBackground = COLOR_WINDOW+1;
        rClass.style         = 0L;
        rClass.cbClsExtra    = 0;
        rClass.cbWndExtra    = 0;

        RegisterClass( &rClass);
    }

    hInst = hInstance;

    hWnd1 = CreateWindow("MSU:KEYLOOK:MAIN",
            "KEYLOOK",
            WS_CLIPCHILDREN |
            WS_OVERLAPPEDWINDOW,
            CW_USEDEFAULT,
            CW_USEDEFAULT,
            CW_USEDEFAULT,
            CW_USEDEFAULT,
            NULL,
            NULL,
            hInstance,
            NULL);

    ShowWindow(hWnd1,CmdShow);

    while (GetMessage(&msg, NULL, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    return(0);
}

//*------------------------------------------------------------------------
//| OverlappedWindowProc1
//|     Parameters:
//|         hWnd    - Handle to current Data Segment
//|         msgID   - Handle to previous Data Segment (NULL if none)
//|         wParam  - Long pointer to command line info
//|         lParam  - Integer value specifying how to start app.,
//|
//*------------------------------------------------------------------------
long FAR PASCAL OverlappedWindowProc1 (HWND     hWnd,
                                       unsigned msgID,
                                       WORD     wParam,
                                       LONG     lParam)
{
char szMsgBuffer[40];
RECT    rect;
HDC     hDC;
TEXTMETRIC  tm;
WORD    wTemp;
PAINTSTRUCT ps;
HFONT   hOldFont;

static HFONT hFont;
static char  szTempBuffer[80];
static HWND  hWndChild1,hWndChild2;
static RECT  rectClient;
static int   nTextHeight,nBottomLine;
static DWORD dwStyle = WS_CHILD | WS_VISIBLE | WS_BORDER | SS_LEFT;
static char  szTitleBar[] = "Message Name       Repeat    Scan     Context   Previous    Transition      Value";
static char  szFormat[]   = "%.14s %4dx   %4X     %2d      %2d        %2d    %4X '%c'";

    switch (msgID)
    {
    case WM_SYSKEYUP:
    case WM_SYSKEYDOWN:
    case WM_KEYDOWN:
    case WM_KEYUP:
    case WM_CHAR:
        ScrollWindow(hWnd,0,-nTextHeight,&rectClient,NULL);
        wTemp = HIWORD(lParam);
        MessageName(szMsgBuffer,msgID);
        wsprintf(szTempBuffer,szFormat,
                      (LPSTR) szMsgBuffer,
                      LOWORD(lParam),
                      LOBYTE(HIWORD(lParam)),
                      wTemp & 0x2000 ? 1 : 0,
                      wTemp & 0x4000 ? 1 : 0,
                      wTemp & 0x8000 ? 1 : 0,
                      wParam,
                      wParam);
        UpdateWindow(hWnd);
        break;
    }

    switch (msgID)
    {
    case WM_CREATE:
        SetRectEmpty(&rect);
        GetClientRect(hWnd,&rectClient);
        hDC = GetDC(hWnd);
        GetTextMetrics(hDC,&tm);
        nTextHeight = tm.tmHeight + tm.tmExternalLeading;
        ReleaseDC(hWnd,hDC);

        rect.right  = rectClient.right+2;
        rect.bottom = nTextHeight;
        AdjustWindowRect(&rect,dwStyle,FALSE);

        rect.right = rectClient.right+2;
        nBottomLine = rectClient.bottom - 2*nTextHeight;
        hWndChild1=CreateWindow("static",szTitleBar,dwStyle,
                    0,0,0,0,hWnd,100,hInst,NULL);
        hWndChild2=CreateWindow("static",szTitleBar,dwStyle,
                    0,0,0,0,
                    hWnd,101,hInst,NULL);
        rectClient.bottom -= rect.bottom;
        rectClient.top    += rect.bottom;
        hFont = CreateFont(10,0,0,0,0,0,0,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
                    CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
                    FIXED_PITCH | FF_DONTCARE,"Courier");
        if (hFont == NULL)
            MessageBox(hWnd,"Font creation failed!","ERROR!",MB_OK);
        break;

    case WM_SIZE:
        rectClient.right = LOWORD(lParam);
        rectClient.bottom = HIWORD(lParam);
        nBottomLine = rectClient.bottom - 2*nTextHeight;
        MoveWindow(hWndChild1,-1,-1,rectClient.right+2,nTextHeight,TRUE);
        MoveWindow(hWndChild2,-1,rectClient.bottom - nTextHeight + 1,
                                 rectClient.right+2,nTextHeight,TRUE);
        break;

    case WM_PAINT:
        BeginPaint(hWnd,&ps);
        hOldFont = SelectObject(ps.hdc,hFont);
        TextOut(ps.hdc,0,nBottomLine,szTempBuffer,strlen(szTempBuffer));
        SelectObject(ps.hdc,hOldFont);
        EndPaint(hWnd,&ps);
        break;

    case WM_DESTROY:
        PostQuitMessage(0);
        break;

    default:
        return(DefWindowProc(hWnd, msgID, wParam, lParam));
    }
    return(0);
}

LPSTR FAR PASCAL MessageName( LPSTR lpszMsgBuffer, WORD message)
{

    if (!LoadString(hInst,message,StrBuff,40))
    {
        HexWork[0] = HexStr[message >> 12];
        HexWork[1] = HexStr[(message & 0x0F00) >> 8];
        HexWork[2] = HexStr[(message & 0x00F0) >> 4];
        HexWork[3] = HexStr[(message & 0x000F)];
        lstrcpy(StrBuff,"Unknown message 0x");
        lstrcat(StrBuff,HexWork);
    }
    lstrcpy(lpszMsgBuffer,StrBuff);
    return(lpszMsgBuffer);
}
