	PAGE	,132
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;       LIBENTRY.ASM
;
;       Windows dynamic link library entry routine
;
;   This module generates a code segment called INIT_TEXT.
;   It initialises the local heap if one exists and then calls
;   the C routine LibMain() which should have the form:
;   BOOL FAR PASCAL LibMain(HANDLE hModule,
;                           WORD   wDataSeg,
;                           WORD   cbHeap,
;                           LPSTR  lpszCmdLine);
;        
;   The result of the call to LibMain is returned to Windows.
;   The C routine should return TRUE if it completes initialisation
;   successfully, FALSE if some error occurs.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        extrn LibMain:far           ; the C routine to be called
	extrn LocalInit:far	    ; Windows heap init routine

        public LibEntry             ; entry point for the DLL

INIT_TEXT segment byte public 'CODE'
        assume cs:INIT_TEXT

LibEntry proc far
        
	push	di		 ; handle of the module instance
        push    ds               ; library data segment
	push	cx		 ; heap size
	push	es		 ; command line segment
	push	si		 ; command line offset

	call	LibMain		 ; invoke the 'C' routine (result in AX)

exit:
	ret			 ; return the result

LibEntry endp

INIT_TEXT       ends

        end LibEntry
