//**************************************************************************
//
//  Title:  Generic Demo Library
//
//  Author: Jim Cash
//  Version: 1.2
//  Revision History:
//    Original version: 28-Dec-1989
//    v1.1: February 13, 1991
//    v1.2: June 21, 1991
//
//  Purpose:
//           1) To handle all of the work needed to create a Rubber Rectangle
//              on the screen.
//           2) To converts a MsgId into a string.
//           3) To scan a string for a character, and return the offset
//              of the character.
//**************************************************************************
#include "SWITCHES.H"
#include <WINDOWS.H>
#include "GENLIB.H"

static char StrBuff[40];
static char HexStr[16] = "0123456789ABCDEF";
static char HexWork[5] = "0000";
HANDLE  LIBINST;

//*------------------------------------------------------------------------
//| Routines used internally by the library
//*------------------------------------------------------------------------
unsigned inchr(LPSTR String, unsigned Len, char Chr);

//*------------------------------------------------------------------------
//| GetVersion: returns version info for this DLL
//*------------------------------------------------------------------------
LONG FAR PASCAL GetVersion(LPSTR lpszBuffer, int nBuffSize)
{
    return;
}

//*------------------------------------------------------------------------
//| WEP  (Window Exit Procedure)
//*------------------------------------------------------------------------
VOID FAR PASCAL WEP (int bSystemExit)
{
    return;
}

//*------------------------------------------------------------------------
//| LibMain
//|     Entry point for library
//*------------------------------------------------------------------------
BOOL FAR PASCAL LibMain(HANDLE hModule,
                        WORD   wLibDataSeg,
                        WORD   cbHeap,
                        LPSTR  lpszCmdLine)
{
        LIBINST = hModule;
        LocalInit(wLibDataSeg,0,cbHeap);
        UnlockSegment(wLibDataSeg);
        return TRUE;
}

//*------------------------------------------------------------------------
//| BeginRubberRect
//|     1)  Allocate Local Heap space for the data needed for the Rubber
//|         Rectangle.
//|     2)  Initialize the array of POINTS
//|     3)  Draw the initial point
//|
//*------------------------------------------------------------------------
HANDLE FAR PASCAL BeginRubberRect(HDC   hDC,       POINT ptStartPos,
                                  short nDrawMode, short nPenStyle)
{
RRSTRUCT *pMem;
HANDLE   hMem;
int      i;
short    nOldROP;
WORD     wRSize;
HANDLE   hOldPen;

    wRSize = sizeof(RRSTRUCT);
    if(hMem = LocalAlloc(LMEM_MOVEABLE | LMEM_ZEROINIT, wRSize))
    {
        pMem = (RRSTRUCT*)LocalLock(hMem);
        for (i=0; i<5; i++)
        {
            pMem->rgPoints[i] = ptStartPos;
        }
        pMem->nDrawMode = nDrawMode;
        pMem->hPen = CreatePen(nPenStyle,1,RGB(0,0,0));

        nOldROP = SetROP2(hDC,nDrawMode);
        hOldPen = SelectObject(hDC,pMem->hPen);
        Polyline(hDC, pMem->rgPoints, 5);
        SelectObject(hDC,hOldPen);
        SetROP2(hDC,nOldROP);
        LocalUnlock(hMem);
    }
    return(hMem);
}

//*------------------------------------------------------------------------
//| SizeRubberRect
//|     1)  Erase previous Rubber Rectangle
//|     2)  Update Array
//|     3)  Draw new Rubber Rectangle
//|
//*------------------------------------------------------------------------
BOOL FAR PASCAL SizeRubberRect(HDC hDC, HANDLE hMem, POINT ptNewPos)
{
RRSTRUCT *pMem;
short    nOldROP;
HPEN     hOldPen;

    if (pMem = (RRSTRUCT*) LocalLock(hMem))
    {
        nOldROP = SetROP2(hDC,pMem->nDrawMode);
        hOldPen = SelectObject(hDC,pMem->hPen);
        Polyline(hDC, pMem->rgPoints, 5);

        pMem->rgPoints[1].x = pMem->rgPoints[2].x = ptNewPos.x;
        pMem->rgPoints[2].y = pMem->rgPoints[3].y = ptNewPos.y;

        Polyline(hDC, pMem->rgPoints, 5);
        SelectObject(hDC,hOldPen);
        SetROP2(hDC,nOldROP);
        LocalUnlock(hMem);
    }
    return((BOOL)pMem);
}


//*------------------------------------------------------------------------
//| EndRubberRect
//|     1)  Erase old Rubber Rectangle
//|     2)  Update array of POINT's
//|     3)  Copy data into RECT structure
//|
//*------------------------------------------------------------------------
BOOL FAR PASCAL EndRubberRect(HDC   hDC,      HANDLE hMem,
                              POINT ptEndPos, LPRECT lpRect)
{
RRSTRUCT *pMem;
short    nOldROP;
HPEN     hOldPen;

    if (pMem = (RRSTRUCT*) LocalLock(hMem))
    {
        nOldROP = SetROP2(hDC,pMem->nDrawMode);
        hOldPen = SelectObject(hDC,pMem->hPen);
        Polyline(hDC, pMem->rgPoints, 5);

        pMem->rgPoints[1].x = pMem->rgPoints[2].x = ptEndPos.x;
        pMem->rgPoints[2].y = pMem->rgPoints[3].y = ptEndPos.y;

        lpRect->left   = min(pMem->rgPoints[0].x,pMem->rgPoints[2].x);
        lpRect->right  = max(pMem->rgPoints[0].x,pMem->rgPoints[2].x) + 1;
        lpRect->top    = min(pMem->rgPoints[0].y,pMem->rgPoints[2].y);
        lpRect->bottom = max(pMem->rgPoints[0].y,pMem->rgPoints[2].y) + 1;

        SelectObject(hDC,hOldPen);
        SetROP2(hDC,nOldROP);
        LocalUnlock(hMem);
    }
    LocalFree(hMem);
    return((BOOL)pMem);
}

//*------------------------------------------------------------------------
//| MessageName
//|     Converts a Message ID value to a string, and places the result in
//|     the buffer pointed to by lpszMsgBuffer.
//|
//*------------------------------------------------------------------------
LPSTR FAR PASCAL MessageName( LPSTR lpszMsgBuffer, unsigned uMsgID)
{
HANDLE hLibrary;
    if (!LoadString(LIBINST,uMsgID,StrBuff,40))
    {
        HexWork[0] = HexStr[uMsgID >> 12];
        HexWork[1] = HexStr[(uMsgID & 0x0F00) >> 8];
        HexWork[2] = HexStr[(uMsgID & 0x00F0) >> 4];
        HexWork[3] = HexStr[(uMsgID & 0x000F)];
        lstrcpy(StrBuff,"Unknown message 0x");
        lstrcat(StrBuff,HexWork);
    }
    lstrcpy(lpszMsgBuffer,StrBuff);
    return(lpszMsgBuffer);
}

//*------------------------------------------------------------------------
//| FindChr:
//|     Scans a string for a character, and returns the offset of
//|     the character if found.  If not found, it returns a 0.
//|
//*------------------------------------------------------------------------
unsigned FAR PASCAL FindChr(LPSTR String, char Chr)
{
    if (*String)
        return inchr(String,lstrlen(String),Chr);
    else
        return 0;
}
