//**************************************************************************
//
//  Title: ARGS.C
//
//  Purpose: To display the contents of the WinMain and the standard C
//           input parameters.
//
//**************************************************************************
#define DEBUGGING
#define _WINDOWS
#include <WINDOWS.H>
#include "ARGS.H"

//*------------------------------------------------------------------------
//|                 Global Variables
//*------------------------------------------------------------------------
int __argc;
char **__argv;
char **environ;

//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         CmdShow       - Integer value specifying how to start app.,
//|                            (Iconic or Normal)
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    nCmdShow)
{
int nReturn;

    if (Init(hInstance, hPrevInstance,lpszCmdLine,nCmdShow))
    {
        nReturn = DoMain(hInstance);
        CleanUp();
    }
    return nReturn;
}

//*------------------------------------------------------------------------
//| Init
//|     Initialization for the program is done here:
//|     1)  Register the window class (if this is the first instance)
//|     2)  Create the desktop window for the app.
//|     3)  Show the desktop window in the manner requested by the User.
//|
//*------------------------------------------------------------------------
BOOL Init(HANDLE hInstance,   HANDLE hPrevInstance,
          LPSTR  lpszCmdLine, int    nCmdShow)
{
int     i;
char   *pStr;

    DEBUG("\n\rARGS: Display WinMain and standard C arguments\n\r",0)
    DEBUG("----  Application Initiated  ----\n\r",0)
    DEBUG("hInstance = %04x\n\r",hInstance)
    DEBUG("hPrevInstance = %04x\n\r",hPrevInstance)
    DEBUG("lpszCmdLine = %s\n\r",lpszCmdLine)
    DEBUG("nCmdShow = %04x\n\r",nCmdShow)
    DEBUG("__argc = %d\n\r",__argc)

    DEBUG("__argv = %04x\n\r",__argv);
    for (i=0; i<__argc; i++)
    {
        wsprintf(szDebugBuffer,"__argv[%d] = %04x: \"%s\"\n\r",i,__argv[i],(LPSTR)__argv[i]);
        OutputDebugString(szDebugBuffer);
    }

    pStr = *environ;
    while (*pStr)
    {
        DEBUG("%s\n\r",(LPSTR)pStr);
        pStr = pStr + lstrlen(pStr)+1;
    }

    return TRUE;
}

//*------------------------------------------------------------------------
//| DoMain:
//|     This is the main loop for the application:
//*------------------------------------------------------------------------
int  DoMain(HANDLE hInstance)
{
    return 0;
}

//*------------------------------------------------------------------------
//| CleanUp:
//|     Any last-minute application cleanup activities are done here:
//*------------------------------------------------------------------------
void CleanUp(void)
{
    DEBUG("----  Application Terminated ----\n\r",0)
}
