                .model  small,c
                PUBLIC  StartWinAux
                PUBLIC  EndWinAux
                PUBLIC  GetWinAuxInfo

                .data
CmdBuffer   db  1
SegPtr      dw  0
DriverName  db  'AUX',0

		.code


StartWinAux  PROC
            push    ds
            push    bx
            push    cx
            push    dx
            push    di

            mov     ax,@data
            mov     ds,ax

            mov     ax,3d02h                ;open file
            mov     dx,offset DriverName
            int     21h

            mov     bx,ax                   ; write to Device Driver
            mov     ax,4403h
            mov     byte ptr CmdBuffer,1    ; code to switch to internal buffer
            mov     dx, offset CmdBuffer
            mov     cx,1
            int     21h

            mov     ax,3E00h                ;close file
            int     21h

            pop     di
            pop     dx
            pop     cx
            pop     bx
            pop     ds
            ret
StartWinAux  endp

GetWinAuxInfo   PROC
            push    bp
            mov     bp,sp
            push    ds
            push    bx
            push    cx

            mov     ax,@data
            mov     ds,ax

            mov     ax,3d02h
            mov     dx,offset DriverName
            int     21h

            mov     bx,ax
            lds     dx,[bp+4]
            mov     cx,[bp+8]
            mov     ax,4402h
            int     21h

            push    ax
            mov     ax,3E00h                ;close file
            int     21h
            pop     ax

            pop     cx
            pop     bx
            pop     ds
            mov     sp,bp
            pop     bp
            ret
GetWinAuxInfo   endp

EndWinAux  PROC
            push    ds
            push    bx
            push    cx

            mov     ax,@data
            mov     ds,ax

            mov     ax,3d02h
            mov     dx,offset DriverName
            int     21h

            mov     bx,ax
            mov     byte ptr CmdBuffer,0    ; code to switch to mono monitor
            mov     dx,offset CmdBuffer
            mov     ax,4403h
            mov     cx,1
            int     21h

            mov     ax,3E00h                ;close file
            int     21h

            pop     cx
            pop     bx
            pop     ds
            ret

EndWinAux  endp

		end
