/*******************************************************************************
**	Program Name..	Winbtrv.lib
**	Module Name...	Btreng.h
**	Programmer....	Jeffrey K Regan
**	Creation Date.	01/10/94
********************************************************************************
**	Copyright (c) 1994, Jeffrey K Regan                                        **
*******************************************************************************/
#ifndef __BTRENG_H
#define __BTRENG_H

#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <mem.h>
#include <iostream.h>

#ifdef _Windows
#include <windows.h>
#include <wbtrintf.h>
#endif

#include <btrenv.h>
#include <btrobj.h>
#include <btrtable.h>

struct btrTableNode
	{
   btrTable		*tbl;
   btrTableNode	*next;
   };
   
class btrEngine : public btrObject
	{
public:
	btrEngine ();
	~btrEngine ();

	retCode getVersion (btrVerStruct &Ver);
   retCode getReturn () { return btrObject::lastError; };
      
	retCode abortTransaction ();
   retCode beginTransaction (int Lock = 0);
   retCode endTransaction ();

   retCode Stop ();
      
	btrTable *openTable (char *company, char *filename, char *aname, int reclen, char *databuf = 0, char *keybuf = 0, int mode = bxOpenNormal, int lock = bxNone);
	btrTable *openTable (char *filename, char *aname, int reclen, char *databuf = 0, char *keybuf = 0, char *ownername = "", int mode = bxOpenNormal, int lock = bxNone);
	void closeTables ();
      
	char *nameOf () const;
	void printOn (ostream& os);
	friend ostream& operator << (ostream& out, const btrEngine& obj);
private:
	btrTableNode *tableList;   
	};

inline ostream& operator << (ostream& out, btrEngine& obj)
	{
	obj.printOn (out);
	return (out);
	}

#endif
