/*******************************************************************************
**	Program Name..	Winbtrv.lib
**	Module Name...	Btrenv.h
**	Programmer....	Jeffrey K Regan
**	Creation Date.	01/10/94
********************************************************************************
**	Copyright (c) 1994, Jeffrey K Regan                                        **
*******************************************************************************/
#ifndef __BTRENV_H
#define __BTRENV_H

#if !defined(___DEFS_H)
#include <_defs.h>
#endif

#include <string.h>
#include <mem.h>

#ifndef BOOL
typedef int BOOL;
enum Boolean {False, True};
#endif

#ifndef INT16
typedef int INT16;
#endif

#ifndef WORD
typedef unsigned short WORD;
#endif

#ifndef INT32
typedef long INT32;
#endif

#ifndef DWORD
typedef unsigned long DWORD;
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

typedef int retCode;

void fldcpy (char *to, char *from, int len, Boolean trim = False);
char *trim (char *str);

enum btrEngineType { bxUndefined, bxDOS, bxNet, bxWin, bxReq, bxOS2 };

enum btrCursorStat { atRecord = 0, atBegin, atEnd, atCrack };

enum btrLock { bxLockNone, bGetKey = 50, bxLockWait = 100, bxLockNoWait = 200, bxMLockWait = 300, bxMLockNoWait = 400 };

enum btrLockType { bxNone, bxSingle, bxMultiple };

enum btrOwnership { bxOwnerRequired, bxOwnerNotRequired };

enum btrEncryption { bxNotEncrypted, bxEncrypted = 2 };

enum btrOpenMode { bxOpenNormal, bxOpenAccel = -1, bxOpenRDOnly = -2, bxOpenVerify = -3, bxOpenExcl = -4 };

enum btrFieldType { bxString, bxInteger, bxFloat, bxDate, bxTime, bxDecimal,
						  bxMoney, bxLogical, bxNumeric, bxBfloat, bxLString, bxZString,
						  bxNote, bxLVar };

enum btrKeyType { bxDuplicates = 1, bxModifiable = 2, bxBinary = 4,
					   bxNullValue = 8, bxSegmented = 16, bxAltSequence = 32,
					   bxDescending = 64, bxSupplemental = 128, bxExtended = 256,
					   bxManual = 512 };

enum btrExKeyType { bxxString, bxxInteger, bxxFloat, bxxDate, bxxTime,
						  bxxDecimal, bxxMoney, bxxLogical, bxxNumeric, bxxBfloat,
						  bxxLString, bxxZString, bxxUBinary, bxxAutoIncrement };

enum btrOperations { bOpen, bClose, bInsert, bUpdate, bDelete, bGetEqual,
						   bGetNext, bGetPrevious, bGetGT, bGetGE, bGetLT, bGetLE, 
                     bGetFirst, bGetLast, bCreate, bStat, bExtend, bSetDir, 
                     bGetDir, bBeginTR, bEndTR, bAbortTR, bGetPosition, 
                     bGetDirect, bStepNext, bStop, bVersion, bUnlock, bReset,
                     bSetOwner, bClearOwner, bCreateSIndex, bDropSIndex, 
                     bStepFirst, bStepLast, bStepPrevious, bGetNextEX,
                     bGetPrevEX, bStepNextEX, bStepPreviousEX, bInsertEX };

const beOpenfileNotFound	= 100;
const beRecordNotFound		= 101;

/* from btr_clone	*/
const beGetStatFailed		= 102;
const beCreateFileFailed	= 103;	

/* from btr_get_direct */
const beGetPositionFailed	= 104;
const beGetDirectFailed		= 105;
const beGetOldRecFailed		= 106;

struct err_specs
	{
	int	err_number;
	char	*err_text;
	};

extern err_specs local_errors [];
extern err_specs requester_errors [];
extern err_specs toolbox_errors [];
extern char *btr_errs [];

struct btrFileSpecs
	{
	int	RecLen;
	int	PageSize;
	int	NumIndices;
	long	res1;
	int	FileFlags;
	int	res2;
	int	PreAllocation;
	};

struct btrKeySpecs
	{
	int	KeyPos;
	int	KeyLen;
	int	KeyFlags;
	long	res1;
	char	EXKeyType;
	char	NullValue;
	long	res2;
	};

struct btrStatStruct
	{
	btrFileSpecs	fs;
	btrKeySpecs		ks [24];
	char	AltBuf [265];
	};

struct btrVerData
	{
	int	versionNumber;
	int	revisionNumber;
	char	osType;
	};
   
struct btrVerStruct
	{
	btrVerData	Major;
	btrVerData	Minor;
	};

struct openFileStruct
	{
	char	CompanyNumber [3];
	char	FileName [8];
	char	Location [80];
	char	OwnerName [8];
	};
   
#if defined(_Windows)
#include <wbtrintf.h>
#else
extern "C" int BTRV (int operation, char *posblk, char *databuf, unsigned *datalen, char *keyP, int keyNumber);
#endif

struct LVarStruct
	{
   int	Lines;
   char	**Text;
   int	*Lengths;

	LVarStruct ();
	LVarStruct (char *);
	~LVarStruct ();
   
   void Clear ();
   int Get (char *buffer);
   char *Put ();
   };
   
#endif
