#include <string.h>
#include "comdef.h"
#include "bpslave.h"
#include "handlerr.h"
#include "bplus.h"

/*
 * Contents:
 */
private WORD Receive_File (BYTE *, struct APDBstruct *);
private WORD Send_File (BYTE *, struct APDBstruct *);
private BYTE *cnvLtoA (BYTE *, ULONG);
private ULONG cnvAtoL (BYTE *);
private void Send_Abort(WORD Data_File, Application_PDB *apdb);
private void Send_Unexpected_Packet(Application_PDB *apdb);

#define ETX	0x03
#define ESC	0x1b
#define ENQ	0x05
#define DLE	0x10
#define XON	0x11
#define XOFF	0x13
#define NAK	0x15

#define S_Buffer	pdb->Send_Buffer
#define R_Buffer	pdb->Read_Buffer
#define Show_Msg	(*apdb->Display_Msg)
#define Show_File	(*apdb->Display_File)
#define Show_Size	(*apdb->Display_Size)
#define Show_Trans_Mode	(*apdb->Show_Transfer_Mode)
#define Create_File	(*apdb->Create)
#define Open_File	(*apdb->Open)
#define Close_File	(*apdb->Close)
#define Read_File	(*apdb->Read)
#define Write_File	(*apdb->Write)
#define File_Size	(*apdb->Size)
#define Move_To_EOF	(*apdb->MoveToEnd)


/*$page*/
private ULONG cnvAtoL (ptr)
    BYTE *ptr;
    {
    BOOL sign = FALSE;
    BYTE ch;
    ULONG result = 0;

    ch = *ptr++;

    if (ch == '-')
    then
	{
	sign = TRUE;
	ch = *ptr++;
	}

    while (ch >= '0' && ch <= '9')
	{
	result = result * 10l + (ULONG) (ch - '0');
	ch = *ptr++;
	}

    if (sign)
    then
	return -result;
    else
	return result;
    }

private BYTE *cnvLtoA (ptr, n)
    BYTE *ptr;
    ULONG n;
    {
    BYTE tmp1[11];
    BYTE *tmp2 = tmp1;

    if (n == 0)
	{
	*ptr++ = '0';
	return ptr;
	}

    *tmp2++ = 0;
    do
	{
	*tmp2 = ((BYTE) (n mod 10l)) + '0';
	*tmp2++;
	n /= 10l;
	}
    while (n > 0);

    tmp2--;
    while (*tmp2)
	*ptr++ = *tmp2--;

    return ptr;
    }
/*$page*/
private void Send_Abort(Data_File, apdb)
WORD Data_File;
Application_PDB *apdb;
{
    Show_Msg ("Transfer abort acknowledged");
    BP_Send_Failure('A', "Transfer cancelled", apdb->Packet);
    Close_File(Data_File);
}

private void Send_Unexpected_Packet(apdb)
Application_PDB *apdb;
{
    Show_Msg ("Unexpected packet type");
    BP_Send_Failure ('N', "Unexpected packet type", apdb->Packet);
}

/*$page*/
private WORD Receive_File(Name, apdb)
/*
 * Function:
 *	Download the specified file from the master.
 *
 * Inputs:
 *	Name -- ptr to the file name string
 *
 * Outputs:
 *
 * Returns:
 *	success/failure
 */
    BYTE *Name;
    Application_PDB *apdb;
    {
    Protocol_Desc_Block *pdb;
    LONG FSize;
    UWORD CRC;
    BYTE *ptr;
    BYTE Line[70];
    WORD Result = Overwrite;
    WORD Len;
    WORD Data_File;			/* file descriptor */
    WORD N;
    WORD i;
    BOOL Request_Resume;

    pdb = apdb->Packet;

    if (pdb->Valid_To_Resume_Download == 2)
	Request_Resume = Resume_Allowed;
    else
	Request_Resume = Resume_Not_Allowed;

    Show_File (Name);

    if ( (Data_File = Create_File(Name, 0, Request_Resume, &Result)) < 0)
    then
	{
	if (Result == Abort)
	    {
	    Send_Abort(Data_File, apdb);
	    }
	else
	    {
	    strcpy(Line, "Cannot create file ");
	    BP_Send_Failure('C', Line, pdb);
	    strcat(Line, Name);
	    Show_Msg(Line);
	    }
	return Failure;
	}

    Show_File (Name);

    if (Result == Resume)
	{
	/*
	 * resume file transfer option
	 *
	 * file is open for RW, so first, read to end, building checksum
	 * Next, send resume packet (Tr) as response to TD packet.
	 */

	Show_Trans_Mode ( ((R_Buffer[2] == 'A') ? ASCII_Data : Binary_Data),
	    Resume_Receive_Attempt, pdb->Actual_Check);

	CRC = 0xFFFF;

	do
	    {
	    S_Buffer[0] = 'N';
	    N = Read_File (Data_File, &S_Buffer[0], pdb->Packet_Size - 1);

	    if (N > 0) then
		{
		for (i = 0; i < N; i++)
		    BP_Do_CRC (S_Buffer[i], (WORD *) &CRC);

		if ( (*apdb->Wants_to_Abort) ()) then
		    {
		    Send_Abort(Data_File, apdb);
		    return Failure;
		    }

		(*apdb->Data_Read) (N);
		}
	    }
	while (N > 0);

	ptr = &S_Buffer [0];

	*ptr++ = 'T';
	*ptr++ = 'r';

	FSize = File_Size (Data_File);
	ptr = cnvLtoA (ptr, (ULONG) FSize);

	*ptr++ = ' ';
	ptr = cnvLtoA (ptr, (ULONG) CRC);

	if ((BP_Send_Packet (ptr - &S_Buffer [0], pdb) == Failure)
		|| (BP_Flush_Pending (pdb) == Failure))
	then
	    {
	    Close_File (Data_File);
	    Show_Msg ("Can not resume transfer");
	    return Failure;
	    }

	Move_To_EOF (Data_File);

	Show_Trans_Mode (((R_Buffer[2] == 'A') ? ASCII_Data : Binary_Data),
	    Resume_Receive, pdb->Actual_Check);
	}
    else
	{
	BP_Send_ACK (pdb);
	Show_Trans_Mode ( ((R_Buffer[2] == 'A') ? ASCII_Data : Binary_Data),
	    Receiving_File, pdb->Actual_Check);
	}

    for (;;)
	{
	if ( (*apdb->Wants_to_Abort) () ) then
	    {
	    /* The user wants to kill the transfer */

	    Send_Abort(Data_File, apdb);
	    return Failure;
	    }

	if (BP_Read_Packet (FALSE, TRUE, TRUE, pdb) == Success)
	then
	    switch (R_Buffer[0])
		{
		case 'N':		/* Data packet */
		    Len = pdb->R_Buffer_Len - 1;

		    if (Write_File (Data_File, &R_Buffer[1], Len) != Len) then
			{
			/* Disk write error */

			Show_Msg ("Disk write error");
			BP_Send_Failure ('I', "Disk write error", pdb);
			Close_File (Data_File);
			return Failure;
			}

		    (*apdb->Data_Read) (Len);
		    break;

		case 'T':		/* Transfer packet */
		    switch (R_Buffer [1])
			{
			case 'I':
			    /*
			     * file information... 
			     * Only the 'file size' estimate value is
			     * used presently.  First, search for NUL
			     * then take next value, and record it.
			     */
			    ptr = &R_Buffer [3];
			    while (*ptr++);
			    Show_Size (cnvAtoL (ptr));
			    break;

			case 'C':
			    /*
			     * terminate transfer successfully
			     */
			    Close_File (Data_File);
			    return Success;

			case 'f':
			    /*
			     * failed resume...
			     * close file, then attempt reopen.
			     */
			    Close_File (Data_File);

			    if ((Data_File =
				Create_File(Name, 0, FALSE, &Result))
				< 0)
			    then
				{
				ptr = "Cannot create file";
				BP_Send_Failure('C', ptr, pdb);
				Show_Msg (ptr);
				return Failure;
				}

			    /* otherwise, restart normally */
			    Show_Trans_Mode ( ((R_Buffer[2] == 'A')
				? ASCII_Data : Binary_Data),
				Receiving_File, pdb->Actual_Check);
			    break;

			default:
			    /* Unexpected "T" packet.  Something is rotten on
			     * the other end.  Send a failure packet to kill
			     * the transfer cleanly.
			     */
			    Send_Unexpected_Packet(apdb);
			    Close_File (Data_File);
			    return Failure;
			}
		    break;

		case 'F':		/* Failure packet */
		    Close_File (Data_File);
		    R_Buffer [pdb->R_Buffer_Len] = 0;

		    if (Result == Resume)
		    then
			strcpy (Line, "Can not resume transfer: ");
		    else
			strcpy (Line, "B protocol Failure: ");

		    strcat (Line, &R_Buffer [3]);

		    Show_Msg (Line);

		    return Failure;

		default:
		    Send_Unexpected_Packet(apdb);
		    Close_File (Data_File);
		    return Failure;
		}
	else
	    {
	    Close_File (Data_File);
	    return Failure;
	    }
	}
    }
/*$page*/

private WORD Send_File (Name, apdb)
/*
 * Function:
 *	Send the specified file to the host.
 *
 * Inputs:
 *	Name -- ptr to the file name string
 *
 * Outputs:
 *
 * Returns:
 *	success/failure
 */
    BYTE *Name;
    Application_PDB *apdb;
    {
    BYTE *ptr;
#if 0
    LONG FSize;
#endif
    BYTE Line[70];

    Protocol_Desc_Block *pdb;

    WORD
	Data_File,			/* file descriptor */
	Status,
	N;

    pdb = apdb->Packet;

    Show_Trans_Mode ( ((R_Buffer[2] == 'A') ? ASCII_Data : Binary_Data), 
	Sending_File, pdb->Actual_Check);
    Show_File (Name);

    if ((Data_File = Open_File (Name, 0)) < 0) then
	{
	strcpy (Line, "Cannot access file ");
	BP_Send_Failure ('M', Line, pdb);
	strcat (Line, Name);
	Show_Msg (Line);
	return Failure;
	}

    Show_File (Name);
    Show_Size (File_Size (Data_File));

#if 0
    if (pdb->Send_File_Information > 0)
	{
	ptr = &S_Buffer [0];

	*ptr++ = 'T';
	*ptr++ = 'I';
	*ptr++ = R_Buffer[2];
	*ptr++ = 0;

	FSize = File_Size (Data_File);
	ptr = cnvLtoA (ptr, (ULONG) FSize);

	if ((BP_Send_Packet (ptr - &S_Buffer [0], pdb) == Failure)
	    || (BP_Flush_Pending (pdb) == Failure))
	then
	    {
	    Close_File (Data_File);
	    Show_Msg ("File Information send Failed");
	    return Failure;
	    }
	}
#endif
    do
	{
	S_Buffer[0] = 'N';
	N = Read_File (Data_File, &S_Buffer[1], pdb->Packet_Size - 1);

	if (N > 0) then
	    {
	    Status = BP_Send_Packet (N + 1, pdb);

	    if (Status != (WORD) Success) then
		{
		Close_File(Data_File);
		Show_Msg (Handle_Send_Failure (Status, pdb));
		return Failure;
		}

	    if ( (*apdb->Wants_to_Abort) ()) then
		{
		Send_Abort(Data_File, apdb);
		return Failure;
		}

	    (*apdb->Data_Sent)(N);
	    }
	}
    while (N > 0);

    if (N == 0) then			/* end of file */
	{
	Close_File (Data_File);
	S_Buffer [0] = 'T';
	S_Buffer [1] = 'C';

	if ((Status = BP_Send_Packet (2, pdb)) != (WORD) Success)
	    {
	    Show_Msg (Handle_Send_Failure (Status, pdb));
	    return Failure;
	    }

	return BP_Flush_Pending (pdb);
	}
    else
	{
	ptr = "Disk read error";
	Show_Msg (ptr);
	BP_Send_Failure ('I', ptr, pdb);
	return Failure;
	}
    }
/*$page*/

public WORD BP_Handle_Slave_BP (Application_Block)
/*
 * Function:
 *	Process a "B" protocol session from the remote (master).
 *
 * Inputs:
 *
 * Outputs:
 *
 * Returns:
 *	Success/Failure
 */
    Application_PDB *Application_Block;
    {
    UWORD Status;
    WORD I, N;
    Application_PDB *apdb;
    BYTE Name[64];			/* holds the file name */
    Protocol_Desc_Block *pdb;
    BOOL Done = FALSE;

    pdb = Application_Block->Packet;
    apdb = Application_Block;

    /*
     * initialize parameters for BPPACKET
     */
    pdb->Use_Transport = 0;


    /*
     * perform transfer until it completes
     */

    if  ( (BP_Read_Packet (TRUE, TRUE, FALSE, pdb)) == Success) then
	{
	if (R_Buffer[0] == 'T') then	/* transfer packet */
	    {
	    Done = TRUE;
	    /* Check the direction */
	    if (R_Buffer [1] != 'D' and R_Buffer [1] != 'U')
	    then
		{
		BP_Send_Failure('N', "Not implemented", pdb);
		Show_Msg ("Invalid transfer direction");
		return Failure;
		}

	    /* Check the file type */

	    if (R_Buffer[2] != 'A' and R_Buffer[2] != 'B')
	    then
		{
		BP_Send_Failure('N', "Not implemented", pdb);
		Show_Msg ("Invalid transfer type");
		return Failure;
		}

	    /* Collect the file name */

	    N = (pdb->R_Buffer_Len - 3 > 63) ? (63) : (pdb->R_Buffer_Len - 3);

	    for (I = 0; I < N; I++)
		Name[I] = R_Buffer[I + 3];

	    Name[I] = 0;

	    /* Do the transfer */

	    if (R_Buffer[1] == 'U')
	    then
		{
		BP_Send_ACK (pdb);
		Status = Send_File(Name, apdb);
		}
	    else
		Status = Receive_File(Name, apdb);

	    BP_Init_PDB (TRUE, 0, pdb);
	    }
	else if (R_Buffer[0] == '+') then
	    {
	    if (not BP_Plus_Respond (pdb))
		Done = TRUE;
	    }
	else
	    {
	    Send_Unexpected_Packet(apdb);
	    return Failure;
	    }
	}
    else
	{
	Show_Msg ("Remote is not responding");
	return Failure;
	}

    return Status;
    }
