******************************************************************************

The Window BOSS and Turbo C++ Version 1.0 

The Turbo C small model library and support files provided with release 
07.01.90 of The Window BOSS are compatible with both Turbo C 2.X and 
the Turbo C++ ANSI compiler.  The following notes apply to Turbo C++ 
ANSI compiler only.

IDE (Integrated Development Environment) NOTES:

  Window BOSS users who prefer the IDE over the command line compiler 
  *MAY* have to disable source level debugging when attempting to run 
  their applications from within the IDE via ^F9.  There are also 
  problems with running Window BOSS applications from within the IDE 
  when Sidekick (1.56A) is loaded.  Borland has been notified of 
  these problems (7/19/90).  PLEASE KEEP IN MIND THAT THESE PROBLEMS
  ONLY APPLY WHEN USING THE IDE - THEY DO NOT IMPACT THE FINAL 
  APPLICATION.

  To disable source level debugging from within the IDE, select 
  Options, then Debugger, then set "Source Debugging" to NONE.  It may 
  also help to disable debugging information from being placed in the 
  OBJ files.  This is done by selecting Options, then Compiler, 
  then Code Generation, then More - then disable "Debug info in OBJs".

  The project files distributed with the 07.01.90 release of The Window 
  BOSS can not be used with Turbo C++.  You must either recreate them
  or convert them using the PRJCNVT utility provided with Turbo C++.
  We suggest they be recreated.

REGISTERED (Source Code) User Notes:
 
  Compatible Compact, Medium, Large, and Huge libraries can not be 
  created with the source code from revision 07.01.90 or earlier of
  The Window BOSS.  There are two reasons for this: (1) The TC++ ANSI 
  compiler does not allow K&R function calling conventions to be used 
  when declaring a function with a variable number of arguments and 
  (2) the linker supplied with TC++ can not resolve CONST and BSS 
  segment declarations. The first problem can be resolved by 
  editing "WN_PRINT.C" and changing the code for to look like:

        #if MSC
        #if MSC4                                /* MSC VER 4.0 */
        #if BORLAND | MIXPC
        wn_printf(WINDOWPTR wn, char *cs, ...)  /* Borland C & MIX Power C */
        #else
        wn_printf(wn, cs,...)                   /* Microsoft */
        WINDOWPTR wn;                           /* and everyone else */
        char *cs;
        #endif
        {
        char work[256];
        va_list arg_ptr;

          if(!wn_activate(wn)) return(NULL);    /* bring window to top */
          wns_err(wn,"wn_printf");              /* avoid fatal mistakes */
          ....
          ....

  The linker problem can be solved by using TLINK from Version 2.X of
  Turbo C.  All linking will have to be done from the command line.

  To make the source level changes to resolve the linker problem start by
  copying MSVLIB.ASM to TSVLIB.ASM then edit TCVLIB.ASM as follows:

    Add the HUGE equate at the top of the file (after LPROG and LDATA)

        LPROG   EQU     FALSE           ; TRUE for LARGE, FALSE for SMALL
        LDATA   EQU     FALSE           ; "" ditto ......................
        HUGE    EQU     FALSE           ; TRUE for HUGE

    Remove the following four lines (they are all together):
        
        CONST   SEGMENT  WORD PUBLIC 'CONST'
        CONST   ENDS
        _BSS    SEGMENT  WORD PUBLIC 'BSS'
        _BSS    ENDS

    Change the ASSUME statement to look like:

	ASSUME	CS:_TEXT, DS:_DATA

    Change the code of _vidblt to look like:

        if      LPROG
        __vidblt proc   far
        else
        __vidblt proc   near
        endif
                push    bp
                mov     bp,sp
                push    si
                push    di
                push    cx
                push    ds
                push    es
        if      HUGE
        	mov	ax,seg _wn_sbit         ; retrace test bit 
        	mov	es,ax
        	mov	ah,byte ptr es:_wn_sbit
        else
                mov     ah,ds:_wn_sbit          ; retrace test bit 
        endif
                mov     ds,[bp].ssgm            ; source segment
                mov     si,[bp].soff            ; source offset
                mov     es,[bp].dsgm            ; destination segment
                mov     di,[bp].doff            ; destination offset

  Edit "MAKELIB.CMD" replacing "msvlib" with "tcvlib".

  You can now REBUILD the libraries by using the batch files supplied
  with The Window BOSS.  Remember, you will need to edit TSVLIB.ASM and
  set the LPROG, LDATA, and HUGE equates at the top of the file to 
  correspond to the memory model library you are building.  The
  equates as set as follows:

            Memory Model      LDATA   LPROG   HUGE
 
              SMALL           FALSE   FALSE   FALSE
              MEDIUM          FALSE   TRUE    FALSE
              COMPACT         TRUE    FALSE   FALSE
              LARGE           TRUE    TRUE    FALSE
              HUGE            TRUE    TRUE    TRUE

  If you prefer, you can obtain special interim update, directly from
  Star Guidance, that implements the above work-arounds. Preconfigured 
  libraries for the small, compact, medium, large, and huge memory 
  models are also included.

  Our phone number is (203)-574-2449.  The best time to call is
  from 1:00 PM to 5:00 PM EST.

******************************************************************************
