/*
    inst.c

    dynamic structure instantiation and de-allocation subroutines
*/

#include    "defs.h"

key_t    *inst_key()
{
key_t    *k;

    if(( k = CALLOC(1, key_t)) == NULL)
        {
        error("Can't instantiate key");
        return(NULL);
        }
    else
        return(k);
}

point_t    *inst_point(x, y)
int    x, y;
{
point_t    *p;

    if(( p = MALLOC(point_t)) == NULL)
        {
        error("Can't instantiate Point");
        return(NULL);
        }
    else
        {
        p->x = x;
        p->y = y;
        return(p);
        }
}

void    point(x, y)
int    x, y;
{
point_t    *p, *inst_point();

    p = inst_point(x, y);
    add_point(p);
}

rect_t    *inst_rect(left, bottom, right, top)
int    left, bottom, right, top;
{
rect_t    *r;

    if(( r = MALLOC(rect_t)) == NULL)
        {
        error("Can't instantiate Rectangle");
        return(NULL);
        }
    else
        {
        r->left = left;
        r->bottom = bottom;
        r->right = right;
        r->top = top;
        return(r);
        }
}

void    rect(left, bottom, right, top)
int    left, bottom, right, top;
{
rect_t    *r, *inst_rect();

    r = inst_rect(left, bottom, right, top);
    add_rect(r);
}

void    oval(left, bottom, right, top)
int    left, bottom, right, top;
{
rect_t    *r, *inst_rect();

    r = inst_rect(left, bottom, right, top);
    add_oval(r);
}


text_t  *inst_text(text, x, y, jh, jv)
char    *text;
int     x, y;
char    jh, jv;
{
text_t    *t;

    if(( t = MALLOC(text_t)) == NULL)
        {
        error("Can't instantiate Text");
        return(NULL);
        }
    else
        {
        strncpy(t->text, text, TXTSZE);
        t->origin.x = x;
        t->origin.y = y;
        t->just[0] = jh;
        t->just[1] = jv;
        t->bbox = NULL;
        return(t);
        }
}

void    text(text, x, y, jh, jv)
char    *text;
int     x, y;
char    jh, jv;
{
text_t    *t, *inst_text();

    t = inst_text(text, x, y, jh, jv);
    add_text(t);
}


ref_t   *inst_ref(name, x, y, seg)
char    *name;
int      x, y;
seg_t    *seg;
{
ref_t    *r;

    if(( r = CALLOC(1,ref_t)) == NULL)
        {
        error("Can't instantiate reference");
        return(NULL);
        }
    else
        {
        strncpy(r->name, name, TXTSZE);
        r->origin.x = x;
        r->origin.y = y;

        if(seg != NULL)
            {
            r->instance = seg;
            instance(seg);
            }

        return(r);
        }
}

void    ref(name, x, y, seg)
char    *name;
int      x, y;
seg_t    *seg;
{
ref_t   *r, *inst_ref();

    r = inst_ref(name, x, y, seg);
    add_ref(r);
}

seg_t   *inst_seg(name)
char    *name;
{
seg_t   *s;

    /* use calloc to clear memory */

    if(( s = CALLOC(1,seg_t)) == NULL)
        {
        error("Can't instantiate segment");
        return(NULL);
        }
    else
        {
        s->name = name;
        return(s);
        }
}
