/*
 * bar - print barcode, 3-of-9, external printer interface
 * written 1987 David J. Rodman
 * Paradise Technology, Inc.
 * Compuserve 70007,1545
 * (808) 326-9556
 * This code is placed into the public domain.  Have at it.
 */
#include <stdio.h>

int res = 2;  			/* resolution, horizontal */
int depth = 4;			/* lines deep to print pattern */
int lineno;
#define BFSIZ 512

extern prbar();			/* print thick or thin line or space */
extern prinit(), prfini(), prdown();	/* initialize, finish, move down */


/*
 * These codes represent the 3-of-9 encoding.  Note that there are exactly
 *	three 1-bits in each code.  Those are the "thick" lines/spaces.  
 *	The barcode alternates between lines and spaces - the codes below
 *	determine the width of each line or space, not whether it's a line
 *	or a space.
 */
static unsigned codes[] = 
{	0xc4, 0, 0, 0, 0xa8, 0x2a, 0, 0, 0, 0, 0, 0x8a, 0, 0x85, 0x184, 0xa2,
	0x34, 0x121, 0x61, 0x160, 0x31, 0x130, 0x70, 0x25, 0x124, 0x64, 0, 0, 0, 0, 0, 0, 0,
	0x109, 0x49, 0x148, 0x19, 0x118, 0x58, 0x0d, 0x10c, 0x4c, 0x1c,
	0x103, 0x43, 0x142, 0x13, 0x112, 0x52, 7, 0x106, 0x46, 0x16, 0x181, 0x0c1,
	0x1c0, 0x91, 0x190, 0x0d0
};

/*
 * text[0] is printed on the bottom line of the label, after the barcode.
 * text[1-10] is printed at the right of the barcode on each line 1-depth
 */
char *text[] = {"", "", "", "", "", "", "", "", "", "", ""};

bar(str)
	char *str;			/* string to be printed */
{
	int i;
	char *s;

	lineno = 1;
	for(i = depth; i--; prdown())
	{	prinit(s = str);
		barc(0x94);			/* start code */
		while(*s)
			barc(codes[*s++ - ' ']);
		barc(0x94);			/* stop code */
	}
	prfini();
}

static barc(c)
{
	int line;			/* BOOL line/space */
	unsigned mask;

	for(line = 1, mask = 0x100; mask; mask >>= 1, line = 1 - line)
		prbar(c & mask, line);
	prbar(0, 0);		/* finish each char with a thin space */
}

