*-------------------------------------------------------------------------
* show.prg -- FORCE FAQ sample code for the XMS library
*-------------------------------------------------------------------------
#include io.hdr
#include keys.hdr
#include data.hdr
#include colors.hdr

#include defs.hdr
#include xms.hdr
#include alloc.hdr

#pragma W_FUNC_PROC-
#pragma W_INDIRECT-
*-------------------------------------------------------------------------
PROCEDURE get_screen PROTOTYPE
   PARAMETERS CONST CHAR filename, VALUE LONG buffer, VALUE UINT b_size
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header:$"
   LONG                 video_address = 0xb8000000
   INT                  help_handle       && XMS handle for help screen
   INT                  background        && XMS handle for background...
   INT                  screen_size
ENDDEF
*-------------------------------------------------------------------------
* function: help_screen()
*
* description: If the user presses F1 for help, this procedure saves the
*     current screen into an XMS buffer, and writes the help screen from
*     the XMS handle directly to video memory.  When the user is done
*     perusing the help screen, the original screen is returned from
*     XMS memory directly to video memory.
*
* Note: CGA memory starts at b800:0000.  Monochrome starts at b000:0000.
*     If you have a monochrome card, set video_address equal to 0xb0000000.
*     If you need a function to do this during runtime, let me know and
*     I'll send you one.
*-------------------------------------------------------------------------
FUNCTION INT help_screen

   VARDEF
      INT            cur_screen        && Another XMS handle...
   ENDDEF

   if lastkey() <> &K_F1
      return lastkey()
   endif

   if .not. xms_alloc( cur_screen, screen_size / 1024 + 1)
      ? "xms_alloc() failed!"
   endif

   *---
   * Save the current screen to XMS
   *---
   xms_copy( &NULL, video_address, cur_screen, 0, 4000 )

   *---
   * Write the help screen to video memory
   *---
   xms_copy( help_handle, 0, &NULL, video_address, screen_size )

   wait ""
   *---
   * Restore the screen and free the handle...
   *---
   xms_copy( cur_screen, 0, &NULL, video_address, screen_size )
   xms_free( cur_screen )

   return 0

ENDPRO
*-------------------------------------------------------------------------
PROCEDURE force_main

   VARDEF
      &POINTER          f_buffer        && DOS memory buffer
      UINT              men_id
      INT               dos_screen      && XMS handle for user's screen
   ENDDEF

   cursor_off()

   if .not. xms_installed()
      ? "XMS driver is not installed, aborting..."
      quit
   endif

   if xms_get_version() < 200
      ? "Old XMS driver, aborting..."
      quit
   endif
   *---
   * First, we figure out the size of the screen, should be 4000 bytes.
   * 80 columns, 25 lines, and 2 bytes (one for the character, and the
   * other for attribute.  Knowing that, we allocate a buffer that we
   * can read into from a file.
   *---
   screen_size = 80 * 25 * 2
   f_buffer = malloc( screen_size )

   *---
   * But, before we write anything to the screen, let's save the current
   * user screen to XMS.
   *---
   if .not. xms_alloc( dos_screen, screen_size / 1024 + 1 )
      ? "xms_alloc() failed!"
      quit
   endif

   xms_copy( &NULL, video_address, dos_screen, 0, screen_size )

   *---
   * Now we read the screen into the conventional memory buffer.
   *---
   get_screen( "help.scr", f_buffer, screen_size )

   *---
   * Now we copy the buffer into XMS.  First, we'll need an EMB large
   * enough, so we allocate one.  Remember to convert to kilobytes...
   *---
   if .not. xms_alloc( help_handle, screen_size / 1024 + 1)
      ? "xms_alloc() failed!"
      quit
   endif

   *---
   * Copy the buffer into XMS for later use.  Free the conventional
   * memory buffer back to the system memory pool.
   *---
   if .not. xms_copy( &NULL, f_buffer, help_handle, 0, screen_size )
      ? "xms_copy() has failed!"
      quit
   endif

   free( f_buffer )

   *---
   * Get the background screen and write it directly to video memory
   *---

   get_screen( "back.scr", video_address, screen_size )

   __color_std = &WHITE_BLACK
   __color_enhcd = &BLUE_YELLOW

   @ 1, 3 prompt "File"
   @ 1,10 prompt "Edit"
   @ 1,17 prompt "Format"
   @ 1,26 prompt "Window"
   @ 1,35 prompt "Zeist"
   @ 1,43 prompt "Help"
   @ 1,52 prompt "Quit"

   on key do help_screen
   menu to men_id

   xms_free( help_handle )
   free( f_buffer )

   *---
   * Finally, restore the user's screen
   *---
   xms_copy( dos_screen, 0, &NULL, video_address, screen_size )

   xms_free( dos_screen )
   @ 24,0
   cursor_on()

ENDPRO
*-- EOF: show.prg --------------------------------------------------------
