/*

  The Wipeout Library v1.2 for Clipper - 5.01 Demonstration

  Program   : DEMO5.PRG
  Author    : Mark Lussier
  Copyright : (c) 1991 by Mark Lussier
	    : All Rights Reserved
  Compile   : Clipper DEMO5.PRG /N

  Comments  : This demo is nothing fancy is regards to coding. It's
	      purpose is to demonstrate the Functions in this LIB.
	      It in NO WAY reflects the coding styles used in the
	      creation of the LIB. The Clipper 5.01 is written in
	      COMPLETELY OPTIMZED 5.01 code and not just recompiled
	      Summer '87.

  History   : 11/15/91 - Complete Rewrite of Demo < MTL >

*/

#command CENTER <c> ON <val> [COLOR <color>];
	 =>;
	 mCenter( <c>, <val> [,<color>] )

#include "setcurs.ch"

Static ssPoint         // PRG wide static holding the Screen Stack Pointer

Function Main()
Local temp_scr, getlist, t, click, Ebox, OldColor, lScp
setcursor( SC_NONE )
OldColor := Setcolor( "W+/N" )
CLEA

*************
 Wipe_Init()     // Required call if Library is to Function
*************
Dispbegin()
  Intro()
  vsave()
  SETCOLOR( "W+/R" )
  CLEA
  Center "Presenting..." On 12  COLOR "GR+/R"
Dispend()

Inkey(1)

blindl( "W+/B",, .T. )
vrel()
Inkey( 10 )
setcolor( "w+/BG" )
Clea
@ 00,02 SAY "Wipeout Library"+space(7)+""+space(7)+"Wipeout Library"+space(7)+""+space(8)+"Wipeout Library"
@ 03,09 SAY ""+space(7)+"Wipeout Library"+space(7)+""+space(7)+"Wipeout Library"+space(8)+""
@ 06,02 SAY "Wipeout Library"+space(7)+""+space(7)+"Wipeout Library"+space(7)+""+space(8)+"Wipeout Library"
@ 09,09 SAY ""+space(7)+"Wipeout Library"+space(7)+""+space(7)+"Wipeout Library"+space(8)+""
@ 12,02 SAY "Wipeout Library"+space(7)+""+space(7)+"Wipeout Library"+space(7)+""+space(8)+"Wipeout Library"
@ 15,09 SAY ""+space(7)+"Wipeout Library"+space(7)+""+space(7)+"Wipeout Library"+space(8)+""
@ 18,02 SAY "Wipeout Library"+space(7)+""+space(7)+"Wipeout Library"+space(7)+""+space(8)+"Wipeout Library"
@ 21,09 SAY ""+space(7)+"Wipeout Library"+space(7)+""+space(7)+"Wipeout Library"+space(8)+""
@ 24,02 SAY "Wipeout Library"+space(7)+""+space(7)+"Wipeout Library"+space(7)+""+space(8)+"Wipeout Library"
inkey(1)
ssPoint := Push_Scr( 00, 00, 24, 79 )
SETCOLOR( "+GR/BR" )
@ 03, 13, 21, 64 BOX "Ŀ "
shadow( 03, 13, 21, 64 )
SETCOLOR( "+W/BR" )
@ 05,16 SAY "Welcome to"
@ 07,15 SAY "This library is a collection of screen routines"
@ 08,15 SAY "that provide a developer with a plethora of very"
@ 09,15 SAY "useful and useless functions regarding screen &"
@ 10,15 SAY "video control. From fancy wipes to exploding &"
@ 11,15 SAY "imploding things, it's designed to add the bells"
@ 12,15 SAY "and whisltes left out. Often considered to be of"
@ 13,15 SAY "annoyance to programmers, it often adds flare and"
@ 14,15 SAY "pizzazz to a user that he or she usually will be"
@ 15,15 SAY "very fond of.                 has been released"
@ 16,15 SAY "under the           concept for a meager ammount"
@ 17,15 SAY "of $19.95 (USD). Thanks for your support"
@ 19,41 SAY "                Author"
SETCOLOR( "+BG/R" )
@ 03,13 SAY space(11)+"Wipeout Library Demonstration"+space(12)
SETCOLOR( "+GR/BR" )
@ 05,27 SAY "The Wipeout Library"
SETCOLOR( "+G/BR" )
@ 05,47 SAY "for Clipper(tm)"
@ 15,29 SAY "Wipeout Library"
SETCOLOR( "B/BR" )
@ 16,25 SAY "Shareware"
SETCOLOR( "+BG/BR" )
@ 18,41 SAY "Mark Lussier"
SETCOLOR( "+G/BR" )
@ 19,41 SAY "Wipeout Library "
inkey( 30 )
ThreshLR( "W+/N" )

/*

   Demonstration of the SHADOW() Function

*/

Pop_Scr( ssPoint )       // Retrieve Wipeout Logo Background from the Stack
SETCOLOR( "+GR/R" )
@ 07, 13, 16, 65 BOX "         "
shadow( 07, 13, 16, 65 )
@ 08,16 SAY "For the first demonstration, notice the shadow"
@ 09,17 SAY "that has been applied to this box. Using the"
@ 10,16 SAY "Wipeout function SHADOW(), you can create true"
@ 11,16 SAY "box shadows with incredible ease. No longer do"
@ 12,17 SAY "you need to calculate positions, simply feed"
@ 13,17 SAY "SHADOW() the same positions as your @....BOX"
@ 14,18 SAY "statement and it will automaticaly add the"
@ 15,25 SAY "shadow where it needs to be."
inkey( 20 )         // Wait for keypress, 20 Second Timeout

/*

   Demonstration of the BoxIn() and BoxOut() Functions

*/

Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
SETCOLOR( "+GR/B" )
@ 06, 14, 17, 65 BOX "Ŀ "
shadow( 06, 14, 17, 65 )
SETCOLOR( "+W/B" )
@ 07,16 SAY "                provides a multitude of screen"
@ 08,16 SAY "clearing functions. Of course including the now"
@ 09,16 SAY "infamous 'Venetian Blind' wipes to our own BOXIN"
@ 10,16 SAY "and BOXOUT functions which I would like to start"
@ 11,16 SAY "the demonstration with."
@ 13,16 SAY "So without further delay, I present"
@ 14,16 SAY "which as you shall see preforms a spiral squared"
@ 15,16 SAY "wipe in a spiral fashion."
SETCOLOR( "+BG/B" )
@ 17,28 SAY " Press any key to begin "
SETCOLOR( "+G/B" )
@ 07,16 SAY "Wipeout Library"
SETCOLOR( "+BR/B" )
@ 13,52 SAY "BOXOUT()"
inkey( 20 )
Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
SETCOLOR( "to w/n" )
Boxout( "W+/N" )
inkey( 1 )
Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
setcursor( SC_NONE )
inkey( .4 )
SETCOLOR( "+GR/B" )
@ 08, 19, 13, 59 BOX "Ŀ "
shadow( 08, 19, 13, 59 )
SETCOLOR( "+W/B" )
@ 10, 24 SAY "And of of course the reverse..."
SETCOLOR( "+BG/B" )
@ 13,32 SAY " Press any key "
SETCOLOR( "+BR/B" )
@ 11,35 SAY "BOXIN()"
inkey( 20 )
Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
SETCOLOR( "w/n" )
Boxin( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Venitian Blind Wipes

*/

Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
inkey( .4 )
SETCOLOR( "+GR/B" )
@ 08, 13, 16, 65 BOX "Ŀ "
shadow( 08, 13, 16, 65 )
SETCOLOR( "+W/B" )
@ 10,15 SAY "But what screen Library would be complete without"
@ 11,17 SAY "those '              ' wipes. Here for their"
@ 12,19 SAY "umpteenth apearance in a function library."
@ 14,29 SAY "         and"
SETCOLOR( "+GR/B" )
@ 11,24 SAY "Venetian Blind"
SETCOLOR( "+BR/B" )
@ 14,29 SAY "BLINDL()"
@ 14,42 SAY "BLINDR()"
inkey( 20 )
setcolor( "w/n" )
Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
inkey( .2 )
BLINDL( "W+/N" )
inkey( 1 )
Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
BLINDR( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Left and Right plain wipes

*/

Pop_Scr( 1 )          // Retrieve Wipeout Logo Background from the Stack
inkey( .4 )
SETCOLOR( "+GR/R" )
@ 06, 11, 17, 67 BOX "Ŀ "
shadow( 06, 11, 17, 67 )
SETCOLOR( "+W/R" )
@ 08,13 SAY "But of course some people are old fashioned and like"
@ 09,13 SAY "to be a bit conservative in their flair. In fact some"
@ 10,13 SAY "of those people work for us!. But to please them all"
@ 11,13 SAY "we added the ever drab and boring standard left and"
@ 12,13 SAY "right plain wipes         and        . So without any"
@ 13,13 SAY "further ado and no hype, heck how can you hype such"
@ 14,13 SAY "an amazing display of video magic any more than has"
@ 15,13 SAY "already been done."
SETCOLOR( "+BG/R" )
@ 17,26 SAY " Press any key to continue "
SETCOLOR( "+G/R" )
@ 12,31 SAY "WIPEL()"
@ 12,43 SAY "WIPER()"
inkey( 20 )
Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
SETCOLOR( "w/n" )
WIPEL( "W+/N" )
inkey( 1 )
Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
inkey( .4 )
WIPER( "W+/N" )
inkey( 1 )


/*

   Demonstration of the Bells and Whistles

*/

Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
inkey( .4 )
SETCOLOR( "+GR/BR" )
@ 03, 14, 21, 66 BOX "Ŀ "
shadow( 03, 14, 21, 66 )
SETCOLOR( "+W/BR" )
@ 04,16 SAY "What Library would be complete without a few"
@ 05,16 SAY "tones to fulfill the claim of Bells and Whistles."
@ 07,16 SAY "For this we have borrowed a few of our favorite"
@ 08,16 SAY "routines from Greg Lief's Public Domain Library."
@ 10,16 SAY "I present to you the WHISTLE() function and it's"
@ 11,16 SAY "gathering of sounds. Which by chance sound like"
@ 12,16 SAY "these"
SETCOLOR( "+BG/BR" )
@ 05,46 SAY "Bells and Whistles"
SETCOLOR( "+GR/BR" )
@ 08,30 SAY "Greg Lief's"
SETCOLOR( "+G/BR" )
@ 10,37 SAY "WHISTLE()"
SETCOLOR( "+bg/br" )
@ 21,27 SAY " Press any key to continue "
inkey( 10 )
setcolor( "w+/br" )
@ 14,18 SAY "The Sound"+space(21)+"The Commands"
@ 15,16 SAY "------------------------------------------------"
@ 16,16 SAY "The      whistle"
SETCOLOR( "+GR/BR" )
@ 16,20 SAY "ATTN"
SETCOLOR( "+G/BR" )
@ 16,47 SAY "WHISTLE('ATTN')"
whistle( "attn" )
inkey( 1 )
setcolor( "w+/br" )
@ 17,16 SAY "The      whislte"
SETCOLOR( "+GR/BR" )
@ 17,20 SAY "DONE"
SETCOLOR( "+G/BR" )
@ 17,47 SAY "WHISTLE('DONE') "
whistle( "done" )
inkey( 1 )
setcolor( "w+/br" )
@ 18,16 SAY "The       whistle"
SETCOLOR( "+GR/BR" )
@ 18,20 SAY "ERROR"
SETCOLOR( "+G/BR" )
@ 18,47 SAY "WHISTLE('ERROR')"
whistle( "error" )
inkey( 1 )
setcolor( "w+/br" )
@ 19,16 SAY "The        whistle"
SETCOLOR( "+GR/BR" )
@ 19,20 SAY "CHARGE"
SETCOLOR( "+G/BR" )
@ 19,47 SAY "WHISTLE('CHARGE')"
whistle( "charge" )
inkey( 3 )

/*

   Demonstration of the Exploding and Imploding Box Routines

*/

SETCOLOR( "+BG/BR" )
Pop_Scr( ssPoint )    // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+GR/R" )
@ 06, 9, 17, 69 BOX "Ŀ "
shadow( 06, 09, 17, 69 )
SETCOLOR( "+W/R" )
@ 08,13 SAY "Ah yes we haven't forgotten our own implementation of"
@ 09,11 SAY "the           and           box routines. However we have"
@ 10,14 SAY "taken it one step beyond the norm. Instead of that"
@ 11,11 SAY "explode from the center stuff, we explode up from a line"
@ 12,11 SAY "specified on the function command line. You will see the"
@ 13,12 SAY "effect of the box '               ' as it explodes. In"
@ 14,12 SAY "reverse, we have the ability to Implode that very same"
@ 15,11 SAY "box utilizing a '                   ' effect. Just watch!"
SETCOLOR( "+BG/R" )
@ 17,26 SAY " Press any key to continue "
SETCOLOR( "+G/R" )
@ 09,15 SAY "EXPLODE()"
@ 09,29 SAY "IMPLODE()"
SETCOLOR( "+BG/R" )
@ 13,31 SAY "Growing Upwards"
@ 15,28 SAY "Shrinking Downwards"
inkey( 20 )
Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
setcolor( "bg+/br" )
inkey( .4 )
Ebox := Explode( 09, 19, 13, 59,"ͻȺ ", 23, 39)
inkey( 1 )
center( 11, "And now we shall 'IMPLODE()' it", "W+/BR" )
inkey( 2 )
implode( 09, 19, 13, 59, "ͻȺ ", 23, 39, Ebox )


/*

   Demonstration of the Crazy Box Wipe!

*/

Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
inkey( 4 )
whistle( "attn" )
SETCOLOR( "+GR/B" )
@ 04, 15, 20, 64 BOX "Ŀ "
shadow( 04, 15, 20, 64 )
SETCOLOR( "+W/B" )
@ 05,17 SAY "wait a minute I forgot one...."
@ 07,17 SAY "Yes thats true, in all my excitement I forgot"
@ 08,17 SAY "to demonstrate my favorite screen wipe routine"
@ 09,17 SAY "of them all,         . What is it? Well we"
@ 10,17 SAY "have to protect some secrets now don't we!."
@ 12,17 SAY "But I am a weak hearted soul and have decided"
@ 13,17 SAY "that since you have been patient enough to"
@ 14,17 SAY "have come this far with the demonstration that"
@ 15,17 SAY "I will show....Oh my god, the radio TV News"
@ 16,17 SAY "persons just announced that their are incoming"
@ 17,17 SAY "space aliens from     . Everybody run and take"
@ 18,17 SAY "cover. Women and............."
SETCOLOR( "+GR/B" )
@ 09,30 SAY "CRAZYB()"
SETCOLOR( "+G/B" )
@ 17,35 SAY "Mars"
inkey( 20 )
whistle( "charge" )
crazyb( "W+/N" )
inkey( 1 )
SETCOLOR( "+W/N" )
@ 12,20 SAY " ...and only silence remains  "
inkey( 4 )

/*

   Demonstration of the Horizontal Stripes

*/

Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
inkey( .4 )
SETCOLOR( "+GR/R" )
@ 07, 12, 17, 66 BOX "Ŀ  "
shadow( 07, 12, 17, 66 )
SETCOLOR( "+W/R" )
@ 08,14 SAY "Well I am no            , but I am sure I had you"
@ 09,14 SAY "going their for a moment. Oh, for those who are"
@ 10,14 SAY "still piling canned foods into the cellar, you"
@ 11,14 SAY "may stop now it was a joke. A rather good one huh!"
@ 13,14 SAY "During that mad invasion I had a vision. A vision"
@ 14,14 SAY "of Stripes!!. No, no ANSI pictures of Bill Murray,"
@ 15,14 SAY "just this. Our function HSTRIPE()"
SETCOLOR( "+B/R" )
@ 17,26 SAY " Press any key to continue "
SETCOLOR( "+BG/R" )
@ 08,27 SAY "Orson Wells"
SETCOLOR( "+G/R" )
@ 15,38 SAY "HSTRIPE()"
inkey( 20 )
hStripe( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Vertical Stripes

*/

Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+GR/R" )
@ 07, 17, 15, 61 BOX "Ŀ "
shadow( 07, 17, 15, 61 )
SETCOLOR( "+W/R" )
@ 09,24 SAY "What goes up must come across!"
@ 11,19 SAY "So ladies and gentlemen I present to you"
SETCOLOR( "+BG/R" )
@ 13,35 SAY "VSTRIPE()"
SETCOLOR( "+G/R" )
@ 15,32 SAY " Press any key "
inkey( 10 )
vStripe( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Dual L->R R->L Vertical Stripes

*/

Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+GR/B" )
@ 07, 17, 16, 61 BOX "Ŀ "
shadow( 07, 17, 16, 61 )
SETCOLOR( "+W/B" )
@ 09,19 SAY "But wouldn't it be neat if it could wipe"
@ 10,19 SAY "left to right and right to left verticaly"
@ 11,19 SAY "all at the same time? It would. So by the"
@ 12,19 SAY "power invested in me by the sacred State"
@ 13,19 SAY "of <fill state in here> I present you"
@ 14,19 SAY "DSTRIPE()! (loud cheers from all around)"
SETCOLOR( "+G/B" )
@ 16,32 SAY " Press any key "
SETCOLOR( "+BG/B" )
@ 13,23 SAY "fill state in here"
SETCOLOR( "+BR/B" )
@ 14,19 SAY "DSTRIPE()"
SETCOLOR( "+GR/B" )
@ 14,31 SAY "loud cheers from all around"
inkey( 10 )
dStripe( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Throw Up Wipe

*/

SETCOLOR( "+G/B" )
@ 04, 12, 18, 66 BOX "Ŀ "
shadow( 04, 12, 18, 66 )
SETCOLOR( "+W/B" )
@ 06,14 SAY "End now? Are you crazy, we are just getting started"
@ 08,14 SAY "Ever wonder what would happen to your screen if you"
@ 09,14 SAY "ran a vacumn cleaner over the top of your monitor?"
@ 11,14 SAY "Ever wonder what would happen if while using your"
@ 12,14 SAY "laptop on an Airplane the window next to your seat"
@ 13,14 SAY "suddenly shattered?"
@ 15,14 SAY "Well let us call upon our THROWUP() function to"
@ 16,14 SAY "demonstrate shall we!"
SETCOLOR( "R/B" )
@ 18,26 SAY " Press any key to continue "
SETCOLOR( "+GR/B" )
@ 15,40 SAY "THROWUP()"
inkey( 20 )
ThrowUp( "W+/N" )
inkey( 2 )

/*

   Demonstration of the Throw Down wipe

*/

SETCOLOR( "+G/B" )
@ 04, 12, 18, 66 BOX "Ŀ "
shadow( 04, 12, 18, 66 )
SETCOLOR( "+W/B" )
@ 06,14 SAY "Wait don't fret! We have thought of it all when it"
@ 07,14 SAY "comes to the extreme variations in the individual"
@ 08,14 SAY "computing enviornment!"
@ 10,14 SAY "For all of you who for some unknown reason, in my"
@ 11,14 SAY "opinion it's all the oatmeal you eat, use your very"
@ 12,14 SAY "own monitors upside down on a daily basis we know"
@ 13,14 SAY "that the last demonstration didn't fit it's descri-"
@ 14,14 SAY "ption. Well here's what it would have looked like,"
@ 15,14 SAY "and people with regular monitors we apoligize for"
@ 16,14 SAY "this little detour. Now, on with THROWDN()."
SETCOLOR( "R/B" )
@ 18,26 SAY " Press any key to continue "
SETCOLOR( "+GR/B" )
@ 16,47 SAY "THROWDN()"
inkey( 20 )
ThrowDn( "W+/N" )
inkey( 1 )

/*

   Demonstration of the 4 Basic Wipes

*/

Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+G/BR" )
@ 04, 11, 19, 67 BOX "Ŀ "
shadow( 04, 11, 19, 67 )
SETCOLOR( "+W/BR" )
@ 06,13 SAY "No, we didn't forget about you conservative types out"
@ 07,13 SAY "there in programmers land."
@ 09,13 SAY "We didn't forget to go back to the basics of screen"
@ 10,13 SAY "wipes to bring the 4 grandaddy's of'em all, those"
@ 11,13 SAY "ever CLOSEIN(), OPENUP(), BLINDUP(), BLINDDN()."
@ 13,13 SAY "What? You don't remember them by there god given"
@ 14,13 SAY "names? Well heck actions speek louder than words so"
@ 15,13 SAY "I'll show'em to ya one by one."
SETCOLOR( "+GR/BR" )
@ 11,18 SAY "CLOSEIN()"
@ 11,29 SAY "OPENUP()"
@ 11,39 SAY "BLINDUP()"
@ 11,50 SAY "BLINDDN()."
SETCOLOR( "BG+/BR" )
inkey( 7 )
@ 17,15 SAY "CLOSEIN()"
temp_scr := Push_Scr( 00, 00, 24, 79 )
inkey( 4 )
CloseIn()
inkey( 1 )
Pop_Scr( temp_scr )   // Retrieve Wipeout Logo Background from the Stack
SETCOLOR( "BG+/BR" )
@ 17,28 SAY "OPENUP()"
temp_scr := Push_Scr( 00, 00, 24, 79 )
inkey( 4 )
OpenUp( "W+/N" )
inkey( 1 )
Pop_Scr( temp_scr )   // Retrieve Wipeout Logo Background from the Stack
SETCOLOR( "BG+/BR" )
@ 17,40 SAY "BLINDUP()"
temp_scr := Push_Scr( 00, 00, 24, 79 )
inkey( 4 )
BlindUp( "W+/N" )
inkey( 1 )
Pop_Scr( temp_scr )   // Retrieve Wipeout Logo Background from the Stack
SETCOLOR( "BG+/BR" )
@ 17,53 SAY "BLINDDN()"
temp_scr := Push_Scr( 00, 00, 24, 79 )
inkey( 4 )
BlindDn( "W+/N" )
inkey( 1 )

/*

   Demonstration of the All Sides to Center Wipe

*/

Pop_Scr( ssPoint )  // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+GR/B" )
@ 06, 08, 18, 71 BOX "Ŀ "
shadow( 06, 08, 18, 71 )
SETCOLOR( "+W/B" )
@ 07,10 SAY "The nice little old lady down there in the frontrow just"
@ 08,10 SAY 'handed me a note that says.."Could you make all 4 sides'
@ 09,10 SAY 'close in at one time". Could I? Of course I can.'
@ 11,10 SAY "This next trick goes out to the little old lady in the front"
@ 12,10 SAY "row, for without her dedication we here tonight we would"
@ 13,10 SAY "never have seen this next illusion!"
@ 14,10 SAY "(Hey I have to be nice, I sell life insurance as a side job)"
@ 16,10 SAY "For your entertainment, I present ALLIN()"
SETCOLOR( "+BR/B" )
@ 16,44 SAY "ALLIN()"
inkey( 17 )
AllIn( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Center to 4 Corner wipe

*/

Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+GR/B" )
@ 06, 10, 15, 68 BOX "Ŀ "
shadow( 06, 10, 15, 68 )
SETCOLOR( "+W/B" )
@ 08,12 SAY "The next wipe I want to show you is called CORNEROUT()."
@ 10,12 SAY "This is actually an accident, kind of like FoxPro, that"
@ 11,12 SAY "came about while trying to reverse ALLIN()."
@ 13,12 SAY "And it goes something like this...."
SETCOLOR( "GR+/B" )
@ 08,55 say "CORNEROUT()"
@ 11,47 say "ALLIN()"
SETCOLOR( "+BG/B" )
@ 15,26 SAY " Press any key to continue "
inkey( 10 )
CornerOut( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Split Personality Wipes

*/

Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+GR/R" )
@ 07, 10, 16, 68 BOX "Ŀ "
shadow( 07, 10, 16, 68 )
SETCOLOR( "+W/R" )
@ 09,12 SAY "Sometime when developing Applications I can't figure out"
@ 10,12 SAY "which way is Up. Kind of a Split Personality so to"
@ 11,12 SAY "speak. In fact if my brain waves could be mapped, which"
@ 12,12 SAY "by the way is totally impossible due to their complex"
@ 13,12 SAY "advanced state over that of a human genious, they just"
@ 14,12 SAY "might look like this, played by Wipeout function UpDn()"
SETCOLOR( "+BG/R" )
@ 16,26 SAY " Press any key to continue "
SETCOLOR( "+BR/R" )
@ 10,39 SAY "Split Personality"
SETCOLOR( "+G/R" )
@ 14,44 SAY "Wipeout"
SETCOLOR( "B/R" )
@ 14,61 SAY "UpDn()"
inkey( 15 )
UpDn( "W+/N" )
inkey( 1 )
Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
LnR( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Roman Column Wipe

*/

Pop_Scr( ssPoint )  // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+GR/B" )
@ 06, 10, 18, 69 BOX "Ŀ "
shadow( 06, 10, 18, 69 )
SETCOLOR( "+W/B" )
@ 08,12 SAY "Since I was a child I was always told by my parents that"
@ 09,12 SAY "'When in Rome do as the Romans' and I am sure you've"
@ 10,12 SAY "heard it to."
@ 12,12 SAY "Well since this isn't Rome, I decided not to let this"
@ 13,12 SAY "wonderful bit of philisophical jargon go to waste so I"
@ 14,12 SAY "brought Rome here to you!"
@ 16,12 SAY "Vino, Vini, Vici. I present the all might COLUMN() wipe."
SETCOLOR( "+BG/B" )
@ 18,26 SAY " Press any key to continue "
SETCOLOR( "+BR/B" )
@ 09,13 SAY "When in Rome do as the Romans"
SETCOLOR( "+GR/B" )
@ 16,54 SAY "COLUMN()"
inkey( 10 )
Column( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Thresher < Farm Machinery > Wipe

*/


Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+GR/R" )
@ 06, 9, 17, 70 BOX "Ŀ "
shadow( 06, 9, 17, 70 )
SETCOLOR( "+W/R" )
@ 08,11 SAY "What? You say your cross-eyed? Well no worry, would you"
@ 09,11 SAY "believe I thought of that one also!."
@ 11,11 SAY "Just to make it all look the same to everyone, I present"
@ 12,11 SAY "you THRESHER(). Why Thresher? I don't know, to me it looks"
@ 13,11 SAY "like the screen is being run over by heavy farm machinery."
@ 15,11 SAY "So..."
SETCOLOR( "+BG/R" )
@ 17,26 SAY " Press any key to continue "
SETCOLOR( "+G/R" )
@ 12,15 SAY "THRESHER()"
inkey( 10 )
Thresher( "W+/N" )
inkey( 1 )

/*

   Demonstration of the Wipeon Effects

*/

Mesh( "B/N" )    // Load mesh background ( Wipeout Internal Call )
vSave()          // Preform Vertical Capture
hSave()          // Preform Horizontal Capture
inkey( 1 )
SETCOLOR( "+W/R" )
@ 05, 10, 19, 69 BOX "Ŀ "
Shadow( 05, 10, 19, 69 )
@ 07,12 SAY "To demonstrate our next two functions, we are going to"
@ 08,12 SAY "go back and request the assistance of our           and"
@ 09,12 SAY "          functions. Often it is nice to wipe a screen"
@ 10,12 SAY "and reveal one at the same time. The Wipeout Library has"
@ 11,12 SAY "a few functions that make this quit painless. Some of"
@ 12,12 SAY "our functions have a parameter that specifies if or if"
@ 13,12 SAY "not to display a screen while wiping one. By name they"
@ 14,12 SAY "are called         and      . For our example we will"
@ 15,12 SAY "use this blue mesh background as a 'wipeon' screen. So"
@ 16,12 SAY "without further ado I present           as shown by our"
@ 17,12 SAY '                    function and syntax.'
SETCOLOR( "+BG/R" )
@ 19,26 SAY " Press any key to continue "
SETCOLOR( "+GR/R" )
@ 08,54 SAY "DSTRIPE()"
@ 09,12 SAY "HSTRIPE()"
SETCOLOR( "+BG/R" )
@ 14,23 SAY "HSAVE()"
@ 14,35 SAY "VSAVE"
SETCOLOR( "+G/R" )
@ 16,42 SAY "VSTRIPE()"
SETCOLOR( "+GR/R" )
@ 17,12 SAY 'DSTRIPE("B+/N",.T.)'
inkey( 10 )
Pop_Scr( ssPoint )   // Retrieve Wipeout Logo Background from the Stack
DSTRIPE( "B+/N",, .T. )
inkey( 2 )
Pop_Scr( ssPoint )  // Retrieve Wipeout Logo Background from the Stack
inkey( 1 )
SETCOLOR( "+W/BR" )
@ 08, 17, 14, 60 BOX "Ŀ "
shadow( 08, 17, 14, 60 )
@ 10,19 SAY "And of course we should be able to do it"
@ 11,19 SAY "Horizontally, so with HSTRIPE() you see"
@ 12,19 SAY "an effect that looks like....."
SETCOLOR( "+BG/BR" )
@ 14,31 SAY " Press a Key "
SETCOLOR( "+GR/BR" )
@ 11,41 SAY "HSTRIPE()"
inkey( 10 )
hstripe( "B+/N", .T. )
lScp := SAVESCREEN( 0, 0, 24, 79 )
inkey( 1 )

/*

   Goodbye!

*/
DispBegin()
SETCOLOR( "W/N" )
CLEA
SETCOLOR( "+G/N" )
@ 04, 00, 19, 79 BOX "Ŀ "
SETCOLOR( "+W/N" )
@ 06,06 SAY "I hope you enjoyed this little demonstration of"
@ 07,16 SAY "If you have any questions, feel free to contact"
SETCOLOR( "+R/N" )
@ 19,26 SAY " Press any key to Continue "
SETCOLOR( "+BR/N" )
@ 06,54 SAY "The Wipeout Library!"
@ 09,05 SAY "In the USA"
@ 09,45 SAY "In Europe"
SETCOLOR( "+BG/N" )
@ 10,5 SAY "Mark Lussier             "
@ 10,45 SAY "INFO-WARE G. Kellinghuson"
SETCOLOR( "+G/N" )
@ 10,38 SAY ""
@ 11,38 SAY ""
@ 12,38 SAY ""
@ 13,38 SAY ""
@ 14,38 SAY ""
@ 15,38 SAY ""
@ 16,38 SAY ""
SETCOLOR( "+GR/N" )
@ 11,05 SAY "2700 Del Medio Court"
@ 11,45 SAY "Gasstrae 18"
@ 12,05 SAY "Suite 307          "
@ 12,45 SAY "D-2000, Hamburg 50"
@ 13,05 SAY "Mtn. View, CA  94040"
@ 13,45 SAY "Germany "
@ 15,45 SAY "+49 40 89094161  (Voice Sales)"
@ 16,45 SAY "+49 40 89094111  (Fax Line)"
@ 15,5 SAY "(415) 949-4478  ( Voice )"
cSave()
Restscreen( 0, 0, 24, 79, lScp )
Dispend()
CrazyB( "W+/N", .T. )
cRel()
inkey( 20 )
setcolor( "w/n" )
ThrowAll( "W+/N" )
clea
setcursor( SC_NORMAL )
setcolor( "w/n" )
@ 21,0 say ""
Return( NIL )

Function Intro()
Local GetList := {}, key
CLEAR
SETCOLOR( "+W/B" )
@ 5, 0 SAY replicate('',35) COLOR "GR+/N"
@ 6, 0 SAY replicate('',5)+""+replicate('',7)+""+replicate('',7)+""+replicate('',7)+""+replicate('',5)
@ 7, 0 SAY replicate('',5)+""+space(7)+""+replicate('',7)+""+space(7)+""+replicate('',5)
@ 8, 0 SAY replicate('',5)+"Ŀ   "+replicate('',7)+"Ŀ   "+replicate('',5)
@ 9, 0 SAY replicate('',7)+"   "+replicate('',2)+""+replicate('',5)+""+replicate('',2)+"   "+replicate('',7)
@ 10, 0 SAY replicate('',7)+"        ܳ   "+replicate('',7)
@ 11, 0 SAY replicate('',7)+"     Ŀ     "+replicate('',7)
@ 12, 0 SAY replicate('',7)+"          "+replicate('',7)
@ 13, 0 SAY replicate('',7)+""+space(6)+""+replicate('',3)+""+space(6)+""+replicate('',7)
@ 14, 0 SAY replicate('',8)+""+replicate('',6)+""+replicate('',3)+""+replicate('',6)+""+replicate('',8)
@ 15, 0 SAY replicate('',35)
@ 16, 0 SAY replicate('',35)

SETCOLOR( "W+/N" )
@ 23, 8 SAY "The Wipeout Library is being issued under the SHAREWARE concept"
@ 24, 15 SAY "This library is NOT Public Domain and is NOT Free"

SETCOLOR( "+R/N" )
@ 4,0 SAY replicate('',80)
@ 18,0 SAY replicate('',80)

SETCOLOR( "+BR/N" )
@ 6,0 SAY replicate('',5)
@ 6,14 SAY replicate('',7)
@ 6,30 SAY replicate('',5)+" "

SETCOLOR( "+R/N" )
@ 7,0 SAY replicate('',4)
@ 7,14 SAY replicate('',6)
@ 7,30 SAY replicate('',5)+" "
@ 14,0 SAY replicate('',6)
@ 14,16 SAY replicate('',2)
@ 14,27 SAY replicate('',8)
SETCOLOR( "+N/N" )
@ 7,4 SAY ""
@ 7,20 SAY ""
@ 8,4 SAY ""
@ 8,20 SAY ""
@ 9,4 SAY replicate('',3)
@ 9,21 SAY replicate('',2)
@ 10,6 SAY ""
@ 10,12 SAY ""
@ 10,22 SAY ""
@ 11,6 SAY ""
@ 12,6 SAY ""
@ 12,17 SAY ""
@ 13,6 SAY ""
@ 13,18 SAY ""
@ 14,6 SAY replicate('',2)
@ 14,18 SAY ""
@ 15,7 SAY replicate('',8)
@ 15,18 SAY replicate('',8)

SETCOLOR( "+BG/N" )
@ 8,0 SAY replicate('',4)
@ 8,14 SAY replicate('',6)
@ 8,30 SAY replicate('',5)
@ 15,0 SAY replicate('',7)
@ 15,15 SAY replicate('',3)
@ 15,26 SAY replicate('',9)

SETCOLOR( "+G/N" )
@ 9,0 SAY replicate('',4)
@ 9,12 SAY replicate('',2)
@ 9,28 SAY replicate('',7)+" "
@ 16,0 SAY replicate('',35)+" "


SETCOLOR( "+B/N" )
@ 10,0 SAY replicate('',6)
@ 10,28 SAY replicate('',7)

SETCOLOR( "+GR/N" )
@ 12,0 SAY replicate('',6)
@ 12,28 SAY replicate('',7)

SETCOLOR( "+BR/N" )
@ 13,0 SAY replicate('',6)
@ 13,16 SAY replicate('',2)
@ 13,28 SAY replicate('',7)



SETCOLOR( "+W/BG" )
@ 6,38,8,77 BOX "         "
@ 6, 45 SAY "The Wipeout Library v1.12"
SETCOLOR( "+N/BG" )
@ 7,42 SAY "Copyright (c) 1991 Mark Lussier"
@ 8,48 SAY "All Rights Reserved"
SETCOLOR( "+W/N" )
@ 10,38,16,77 BOX "         "
@ 12, 45 SAY "Dazzling Effects & Sounds"
@ 13, 41 SAY "for you Clipper 5.01 Applications"
SETCOLOR( "+GR/N" )
@ 10,45 SAY " Demonstration Program "
SETCOLOR( "+BG/N" )
@ 12,54 SAY "Effects"
@ 12,64 SAY "Sounds"
SETCOLOR( "+G/N" )
@ 13,49 SAY "Clipper 5.01"
SETCOLOR( "+BR/N" )
@ 15,39 SAY '"Adding Presentation to the Solution!" '
Return( NIL )

Function mCenter( cString, nLine, cColor )
Local nLen := ( ( 80 - Len( cString ) ) / 2 )
DEVPOS( nLine, nLen )
DEVOUT( cString, cColor )
Return( NIL )